/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.asn1.x509;

import cn.com.infosec.netsign.asn1.x509.CertificateParameters;
import cn.com.infosec.netsign.asn1.x509.DERObjectGenerate;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import java.io.IOException;

public class CertificateGenerater
extends DERObjectGenerate {
    private CertificateParameters para;
    private byte[] version;
    private byte[] serialNumber;
    private byte[] signatureAlg;
    private byte[] issuer;
    private byte[] validity;
    private byte[] subject;
    private byte[] publicKeyInfo;
    private byte[] extensions;
    private byte[] tbs;
    private byte[] signature;

    public CertificateGenerater(CertificateParameters para) {
        this.para = para;
    }

    public byte[] generateTBSCertificate() throws IOException {
        this.tbs = new byte[0];
        this.version = CryptoUtil.generateDERCode(2, new byte[]{3});
        this.version = CryptoUtil.generateDERCode(160, this.version);
        this.tbs = CryptoUtil.connect(this.tbs, this.version);
        this.serialNumber = this.para.getSerailNumber().toByteArray();
        this.serialNumber = CryptoUtil.generateDERCode(2, this.serialNumber);
        this.tbs = CryptoUtil.connect(this.tbs, this.serialNumber);
        this.signatureAlg = this.generateSignatureAlg(this.para.getSignatureAlgOid());
        this.tbs = CryptoUtil.connect(this.tbs, this.signatureAlg);
        this.issuer = this.generateDN(this.para.getIssuer());
        this.tbs = CryptoUtil.connect(this.tbs, this.issuer);
        this.validity = this.generateValidity();
        this.tbs = CryptoUtil.connect(this.tbs, this.validity);
        this.subject = this.generateDN(this.para.getSubject());
        this.tbs = CryptoUtil.connect(this.tbs, this.subject);
        this.publicKeyInfo = this.generatePublickeyInfo();
        this.tbs = CryptoUtil.connect(this.tbs, this.publicKeyInfo);
        if (this.para.getExtensions() != null && this.para.getExtensions().size() > 0) {
            this.extensions = this.generateExtensions(this.para.getExtensions());
            this.tbs = CryptoUtil.connect(this.tbs, this.extensions);
        }
        this.tbs = CryptoUtil.generateDERCode(48, this.tbs);
        return this.tbs;
    }

    public byte[] generateCertificate() {
        byte[] cert = this.tbs;
        cert = CryptoUtil.connect(cert, this.signatureAlg);
        cert = CryptoUtil.connect(cert, this.signature);
        return CryptoUtil.generateDERCode(48, cert);
    }

    public CertificateParameters getPara() {
        return this.para;
    }

    public void setPara(CertificateParameters para) {
        this.para = para;
    }

    public byte[] getVersion() {
        return this.version;
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }

    public byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(byte[] serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte[] getSignatureAlg() {
        return this.signatureAlg;
    }

    public void setSignatureAlg(byte[] signatureAlg) {
        this.signatureAlg = signatureAlg;
    }

    public byte[] getIssuer() {
        return this.issuer;
    }

    public void setIssuer(byte[] issuer) {
        this.issuer = issuer;
    }

    public byte[] getValidity() {
        return this.validity;
    }

    public void setValidity(byte[] validity) {
        this.validity = validity;
    }

    public byte[] getSubject() {
        return this.subject;
    }

    public void setSubject(byte[] subject) {
        this.subject = subject;
    }

    public byte[] getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public void setPublicKeyInfo(byte[] publicKeyInfo) {
        this.publicKeyInfo = publicKeyInfo;
    }

    public byte[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(byte[] extensions) {
        this.extensions = extensions;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        byte[] tmp = new byte[signature.length + 1];
        System.arraycopy(signature, 0, tmp, 1, signature.length);
        signature = tmp;
        this.signature = CryptoUtil.generateDERCode(3, signature);
    }

    public byte[] getTBSCert() {
        return this.tbs;
    }

    public void setTBSCert(byte[] tbs) {
        this.tbs = tbs;
    }

    private byte[] generateValidity() {
        byte[] notBeforebs = CryptoUtil.date2ASN1(this.para.getNotBefore());
        byte[] notAfterbs = CryptoUtil.date2ASN1(this.para.getNotAfter());
        byte[] all = CryptoUtil.connect(notBeforebs, notAfterbs);
        return CryptoUtil.generateDERCode(48, all);
    }

    private byte[] generatePublickeyInfo() {
        byte[] oid = CryptoUtil.oid2ASN1(this.para.getSubjectKeyInfo().getKeyAlgOid());
        oid = CryptoUtil.generateDERCode(6, oid);
        byte[] keyLength = CryptoUtil.DERNULL;
        if (this.para.getSubjectKeyInfo().getKeyLength() > 0) {
            keyLength = CryptoUtil.generateDERCode(2, new byte[]{(byte)this.para.getSubjectKeyInfo().getKeyLength()});
        }
        byte[] keyh = CryptoUtil.connect(oid, keyLength);
        keyh = CryptoUtil.generateDERCode(48, keyh);
        byte[] key = CryptoUtil.generateDERCode(3, this.para.getSubjectKeyInfo().getKey());
        key = CryptoUtil.connect(keyh, key);
        return CryptoUtil.generateDERCode(48, key);
    }
}

