/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.asn1.util;

import cn.com.infosec.pkcs.Item;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DerUtil {
    public static boolean debug = false;
    private static final long DATE_2050 = 2524579200000L;
    public static final byte[] DERNULL;
    public static final byte[] DERTRUE;
    public static final byte[] OID_PKCS7;
    public static final byte[] OID_Data;
    public static final byte[] OID_SignedData;
    public static final byte[] OID_EnvelopedData;
    public static final byte[] OID_SignedAndEnvelopedData;
    public static final byte[] OID_DigestedData;
    public static final byte[] OID_EncryptedData;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 5;
        DERNULL = byArray;
        DERTRUE = new byte[]{1, 1, -1};
        OID_PKCS7 = new byte[]{42, -122, 72, -122, -9, 13, 1, 7};
        OID_Data = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
        OID_SignedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 2};
        OID_EnvelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 3};
        OID_SignedAndEnvelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 4};
        OID_DigestedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 5};
        OID_EncryptedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 6};
    }

    public static int toInt(byte[] input, int start, int length) {
        int value = 0;
        int i = 0;
        while (i < length) {
            value *= 256;
            value += input[i + start] & 0xFF;
            ++i;
        }
        return value;
    }

    public static void computeOffset(byte[] input, Item item, int offset, int pos) {
        int size = 0;
        int length = 0;
        int noffset = 0;
        if (pos + offset > input.length - 2) {
            return;
        }
        byte first = input[pos + 1 + offset];
        if ((input[pos + offset] & 0xFF) == 0 && (first & 0xFF) == 0) {
            item.offset = 2 + pos;
            item.length = 0;
            item.tagsize = 2;
            return;
        }
        if ((input[pos + offset] & 0xFF) == 0 && (first & 0xFF) != 0) {
            noffset = 1;
        }
        if (((first = input[pos + 1 + offset + noffset]) & 0x80) == 128 || (first & 0xFF) == 0) {
            size = input[pos + offset + 1 + noffset] & 0xF;
            length = size == 0 && (first & 0xFF) != 0 ? input.length - pos - 1 - noffset : DerUtil.toInt(input, 2 + pos + offset + noffset, size);
        } else {
            size = 0;
            length = input[pos + offset + 1 + noffset] & 0xFF;
        }
        item.offset = 2 + size + pos + noffset;
        if (length < 0 || length > input.length - item.offset) {
            if (debug) {
                System.out.println("length error! length=" + length);
            }
            length = input.length - item.offset - noffset;
        }
        item.length = length;
        item.tagsize = 2 + size;
        if (debug) {
            System.out.println("@computeOffset offset=" + item.offset + " ,length=" + item.length + ",tagsize=" + item.tagsize);
        }
    }

    public static boolean isEqual(byte[] src, int srcstart, byte[] dst, int dststart, int length) {
        if (src.length < srcstart + length || dst.length < dststart + length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (src[i + srcstart] != dst[dststart + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void parseSequence(byte[] input, int offset, int length, List list) {
        int position = 0;
        Item tmpitem = new Item();
        if (debug) {
            System.out.println("=========parseSequence============");
            DerUtil.printBytes(input, offset, length, 16);
            System.out.println("==================================");
        }
        while (position < input.length - offset && position < length) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position += tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            list.add(new Item(tmpitem));
            if (!debug) continue;
            System.out.println("Parsed sequence " + list.size());
            DerUtil.printItemAndTag(input, tmpitem);
        }
    }

    public static void parseSequence(byte[] input, Item it, List list) {
        int position = 0;
        Item tmpitem = new Item();
        while (position < input.length - it.offset && position < it.length) {
            DerUtil.computeOffset(input, tmpitem, it.offset, position);
            position += tmpitem.offset + tmpitem.length;
            tmpitem.offset += it.offset - tmpitem.tagsize;
            tmpitem.length += tmpitem.tagsize;
            list.add(new Item(tmpitem));
            if (!debug) continue;
            System.out.println("Parsed sequence " + list.size());
            DerUtil.printItemAndTag(input, tmpitem);
        }
    }

    public static int getContentType(byte[] input, int offset) {
        int code = 0;
        if (offset + OID_PKCS7.length > input.length - 2) {
            return code;
        }
        if (debug) {
            DerUtil.printBytes(input, offset, OID_PKCS7.length + 1, 16);
        }
        int i = 0;
        while (i < OID_PKCS7.length) {
            if (input[i + offset] != OID_PKCS7[i]) {
                return code;
            }
            ++i;
        }
        code = input[OID_PKCS7.length + offset] & 0xF;
        return code;
    }

    public static int getContentType(byte[] input, int offset, int f) {
        int code = 0;
        int oidLength = input[offset - 1] & 0xFF;
        if (offset + oidLength > input.length - 1) {
            return code;
        }
        code = input[oidLength + offset - 1] & 0xF;
        if (debug) {
            System.out.println("oidLength=" + oidLength);
            DerUtil.printBytes(input, offset, oidLength, 16);
            System.out.println("code=" + code);
        }
        return code;
    }

    public static String toDERObjectIdentifier(byte[] bytes, int offset, int length) {
        Item tmpitem = new Item();
        DerUtil.computeOffset(bytes, tmpitem, offset, 0);
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        int i = 0;
        while (i != tmpitem.length && i + offset + tmpitem.offset < bytes.length) {
            int tmpbyte = bytes[i + offset + tmpitem.offset] & 0xFF;
            if (value < 0x80000000000000L) {
                value = value * 128L + (long)(tmpbyte & 0x7F);
                if ((tmpbyte & 0x80) == 0) {
                    if (first) {
                        switch ((int)value / 40) {
                            case 0: {
                                objId.append('0');
                                break;
                            }
                            case 1: {
                                objId.append('1');
                                value -= 40L;
                                break;
                            }
                            default: {
                                objId.append('2');
                                value -= 80L;
                            }
                        }
                        first = false;
                    }
                    objId.append('.');
                    objId.append(value);
                    value = 0L;
                }
            } else {
                if (bigValue == null) {
                    bigValue = BigInteger.valueOf(value);
                }
                bigValue = bigValue.shiftLeft(7);
                bigValue = bigValue.or(BigInteger.valueOf(tmpbyte & 0x7F));
                if ((tmpbyte & 0x80) == 0) {
                    objId.append('.');
                    objId.append(bigValue);
                    bigValue = null;
                    value = 0L;
                }
            }
            ++i;
        }
        return objId.toString();
    }

    public static void printBytes(String title, byte[] input) {
        System.out.print("@printBytes " + title + "(" + input.length + ")\n");
        int i = 0;
        int length = input.length;
        while (i < length) {
            int b = input[i] & 0xFF;
            System.out.print(String.valueOf(b < 16 ? "0" : "") + Integer.toString(b, 16).toUpperCase() + " ");
            if ((i + 1) % 16 == 0) {
                System.out.println();
            }
            ++i;
        }
        System.out.println();
    }

    public static void printBytes(byte[] input, int start, int length, int radix) {
        System.out.print("@printBytes\n[");
        int i = 0;
        while (start + i < input.length && i < length) {
            int b;
            if ((i + 1) % 17 == 0) {
                System.out.println();
            }
            System.out.print(String.valueOf((b = input[start + i] & 0xFF) < radix ? "0" : "") + Integer.toString(b, radix).toUpperCase() + " ");
            ++i;
        }
        System.out.println(']');
    }

    public static void printItem(byte[] input, Item it) {
        if (it == null) {
            return;
        }
        System.out.println("printItem with offset=" + Integer.toHexString(it.offset) + ",length=" + Integer.toHexString(it.length));
        DerUtil.printBytes(input, it.offset, it.length, 16);
    }

    public static void printItemAndTag(byte[] input, Item it) {
        System.out.println("printItemAndTag with offset=" + Integer.toHexString(it.offset) + ",length=" + Integer.toHexString(it.length) + ",tagsize=" + it.tagsize);
        DerUtil.printBytes(input, it.offset, it.length, 16);
    }

    public static String getCRLDPURI(byte[] CRLDistributionPoints) {
        byte[] data = DerUtil.getDERInnerData(CRLDistributionPoints);
        data = DerUtil.getDERInnerData(data);
        data = DerUtil.getDERInnerData(data);
        data = DerUtil.getDERInnerData(data);
        data = DerUtil.getDERInnerData(data);
        data = DerUtil.getDERInnerData(data);
        return new String(data);
    }

    public static byte[] getDERInnerData(byte[] der) {
        int ab = der[1] & 0xFF;
        int length = 0;
        int dataIndex = 0;
        if (ab >= 128) {
            int lengthOfLength = ab - 128;
            byte[] lengthBytes = new byte[lengthOfLength];
            System.arraycopy(der, 2, lengthBytes, 0, lengthOfLength);
            length = DerUtil.generateInt(lengthBytes);
            dataIndex = 2 + lengthOfLength;
        } else {
            length = ab;
            dataIndex = 2;
        }
        byte[] data = new byte[length];
        System.arraycopy(der, dataIndex, data, 0, length);
        return data;
    }

    public static byte[] getDERInnerData(byte[] der, int index) {
        int derStart = 0;
        int length = 0;
        int headLength = 2;
        int i = 0;
        while (i < index) {
            int ab = der[derStart + 1] & 0xFF;
            if (ab >= 128) {
                int lengthOfLength = ab - 128;
                headLength = 2 + lengthOfLength;
                byte[] lengthBytes = new byte[lengthOfLength];
                System.arraycopy(der, derStart + 2, lengthBytes, 0, lengthOfLength);
                length = DerUtil.generateInt(lengthBytes);
            } else {
                length = ab;
            }
            if (i != index - 1) {
                derStart = derStart + length + headLength;
            }
            ++i;
        }
        byte[] bs = new byte[length];
        System.arraycopy(der, derStart + headLength, bs, 0, length);
        return bs;
    }

    public static byte[] getFirstDerItem(byte[] der) {
        int ab = der[1] & 0xFF;
        int length = 0;
        int headLength = 2;
        if (ab >= 128) {
            int lengthOfLength = ab - 128;
            headLength = 2 + lengthOfLength;
            byte[] lengthBytes = new byte[lengthOfLength];
            System.arraycopy(der, 2, lengthBytes, 0, lengthOfLength);
            length = DerUtil.generateInt(lengthBytes);
        } else {
            length = ab;
        }
        byte[] data = new byte[headLength + length];
        System.arraycopy(der, 0, data, 0, data.length);
        return data;
    }

    public static byte[] generateDERCode(int type, byte[] content) {
        int length = content.length;
        byte[] lengthBs = null;
        if (length >= 128) {
            byte[] intBs = DerUtil.int2Bytes(length);
            lengthBs = new byte[1 + intBs.length];
            lengthBs[0] = (byte)(128 + intBs.length);
            System.arraycopy(intBs, 0, lengthBs, 1, intBs.length);
        } else {
            lengthBs = new byte[]{(byte)length};
        }
        byte[] all = new byte[1 + lengthBs.length + content.length];
        all[0] = (byte)type;
        System.arraycopy(lengthBs, 0, all, 1, lengthBs.length);
        System.arraycopy(content, 0, all, 1 + lengthBs.length, content.length);
        return all;
    }

    public static byte[] int2Bytes(int i) {
        int l = 0;
        l = i <= 255 ? 1 : (i <= 65535 ? 2 : (i <= 0xFFFFFF ? 3 : 4));
        byte[] bs = new byte[l];
        int x = 0;
        while (x < l) {
            bs[x] = (byte)(i >> (l - 1 - x) * 8);
            ++x;
        }
        return bs;
    }

    public static int generateInt(byte[] bytes) {
        int tr = 0;
        int i = bytes.length - 1;
        while (i > -1) {
            int x = (bytes[bytes.length - 1 - i] & 0xFF) << i * 8;
            tr += x;
            --i;
        }
        return tr;
    }

    public static byte[] oid2ASN1(String oid) {
        String[] pieces = oid.split("\\.");
        byte[] oidbs = null;
        byte b = (byte)(Integer.parseInt(pieces[0]) * 40 + Integer.parseInt(pieces[1]));
        oidbs = new byte[]{b};
        int i = 2;
        while (i < pieces.length) {
            int num = Integer.parseInt(pieces[i]);
            int pow = DerUtil.maxPow128(num, 0);
            byte[] id = new byte[pow + 1];
            DerUtil.genid(pow, num, id);
            byte[] tmp = new byte[oidbs.length + id.length];
            System.arraycopy(oidbs, 0, tmp, 0, oidbs.length);
            System.arraycopy(id, 0, tmp, oidbs.length, id.length);
            oidbs = tmp;
            ++i;
        }
        return oidbs;
    }

    private static int maxPow128(int num, int pow) {
        double d = (double)num % Math.pow(128.0, pow);
        int n = pow - 1 > 0 ? pow - 1 : 1;
        if (d > Math.pow(128.0, n)) {
            return DerUtil.maxPow128(num, pow + 1);
        }
        if (pow == 0 && num / 128 > 0) {
            return 1;
        }
        return pow;
    }

    private static void genid(int pow, int num, byte[] id) {
        if (pow == 0) {
            id[id.length - 1] = (byte)num;
        } else {
            id[id.length - 1 - pow] = (byte)(128.0 + (double)num / Math.pow(128.0, pow));
        }
        if (pow - 1 >= 0) {
            DerUtil.genid(pow - 1, (int)((double)num % Math.pow(128.0, pow)), id);
        }
    }

    public static byte[] connect(byte[] a, byte[] b) {
        byte[] tmp = new byte[a.length + b.length];
        System.arraycopy(a, 0, tmp, 0, a.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }

    public static byte[] date2ASN1(Date date) {
        if (date.getTime() < 2524579200000L) {
            SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
            String time = String.valueOf(format.format(date)) + "Z";
            return DerUtil.generateDERCode(23, time.getBytes());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = String.valueOf(format.format(date)) + "Z";
        return DerUtil.generateDERCode(24, time.getBytes());
    }
}

