/*
 * Decompiled with CFR 0.152.
 */
package ideabank.common.security;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import ideabank.common.security.IBCrypto;
import ideabank.service.eseal.PersonCertArray;
import ideabank.service.eseal.Service;
import ideabank.service.eseal.ServicePortType;
import ideabank.service.eseal.UserLoginInfo;
import ideabank.service.eseal.UserLoginInfo2;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.xml.ws.Holder;

public class IBUtilities {
    private static Service trusServer = new Service();
    private static ServicePortType trusAccess = trusServer.getService();
    private static String LOCATION;

    static {
        try {
            LOCATION = URLDecoder.decode(IBUtilities.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOCATION = "";
        }
    }

    public static String getProjectPath() throws UnsupportedEncodingException {
        URL url = IBCrypto.class.getProtectionDomain().getCodeSource().getLocation();
        String filePath = URLDecoder.decode(url.getPath(), "utf-8");
        if (filePath.endsWith(".jar")) {
            filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        File file = new File(filePath);
        filePath = file.getAbsolutePath();
        return filePath;
    }

    public static String getRealPath() {
        String realPath = IBCrypto.class.getClassLoader().getResource("").getFile();
        File file = new File(realPath);
        realPath = file.getAbsolutePath();
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realPath;
    }

    private static byte uniteBytes(String src0, String src1) {
        byte b0 = Byte.decode("0x" + src0);
        b0 = (byte)(b0 << 4);
        byte b1 = Byte.decode("0x" + src1);
        byte ret = (byte)(b0 | b1);
        return ret;
    }

    public static byte[] hexStr2Bytes(String src) {
        int m = 0;
        int n = 0;
        int l = src.length() / 2;
        byte[] ret = new byte[l];
        int i = 0;
        while (i < l) {
            m = i * 2 + 1;
            n = m + 1;
            ret[i] = IBUtilities.uniteBytes(src.substring(i * 2, m), src.substring(m, n));
            ++i;
        }
        return ret;
    }

    public static String byte2HexStr(byte[] b) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    public static String md5Alg(byte[] oriArr) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(oriArr);
            byte[] byteArray = messageDigest.digest();
            StringBuffer buf = new StringBuffer("");
            int offset = 0;
            while (offset < byteArray.length) {
                int i = byteArray[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
                ++offset;
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
            System.exit(-1);
            return null;
        }
    }

    public static byte[] md5AlgToByte(byte[] oriArr) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(oriArr);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
            System.exit(-1);
        }
        byte[] byteArray = messageDigest.digest();
        return byteArray;
    }

    protected void checkCertLogin(String accessCode, Holder<String> cn, Holder<String> uid, Holder<String> name, Holder<String> trusdataou, Holder<String> trusdatao, Holder<String> telephoneNumber, Holder<String> mail, Holder<String> trusdataCertDN, Holder<String> trusdataCertSN) throws Exception {
        trusAccess.checkLogin(accessCode, cn, uid, name, trusdataou, trusdatao, telephoneNumber, mail, trusdataCertDN, trusdataCertSN);
    }

    protected void checkCertLoginEx(String accessCode, byte[] random, byte[] signature, Holder<String> cn, Holder<String> uid, Holder<String> name, Holder<String> trusdataou, Holder<String> trusdatao, Holder<String> telephoneNumber, Holder<String> mail, Holder<String> trusdataCertDN, Holder<String> trusdataCertSN) throws Exception {
        Holder<UserLoginInfo> userLoginInfo = new Holder<UserLoginInfo>();
        Holder<Integer> errorCode = new Holder<Integer>();
        trusAccess.checkLoginEx(accessCode, random, signature, userLoginInfo, errorCode);
        if ((Integer)errorCode.value != 0) {
            return;
        }
        cn.value = ((UserLoginInfo)userLoginInfo.value).getCn().getValue();
        uid.value = ((UserLoginInfo)userLoginInfo.value).getUid().getValue();
        name.value = ((UserLoginInfo)userLoginInfo.value).getName().getValue();
        trusdataou.value = ((UserLoginInfo)userLoginInfo.value).getTrusdataou().getValue();
        trusdatao.value = ((UserLoginInfo)userLoginInfo.value).getTrusdatao().getValue();
        telephoneNumber.value = ((UserLoginInfo)userLoginInfo.value).getTelephoneNumber().getValue();
        mail.value = ((UserLoginInfo)userLoginInfo.value).getMail().getValue();
        trusdataCertDN.value = ((UserLoginInfo)userLoginInfo.value).getTrusdataCertDN().getValue();
        trusdataCertSN.value = ((UserLoginInfo)userLoginInfo.value).getTrusdataCertSN().getValue();
    }

    protected void checkCertLoginEx2(String accessCode, byte[] random, byte[] signature, String appId, Holder<String> cn, Holder<String> uid, Holder<String> name, Holder<String> trusdataou, Holder<String> trusdatao, Holder<String> telephoneNumber, Holder<String> mail, Holder<String> trusdataCertDN, Holder<String> trusdataCertSN, Holder<String> appusername, Holder<String> appuserpwd) throws Exception {
        Holder<UserLoginInfo2> userLoginInfo2 = new Holder<UserLoginInfo2>();
        Holder<Integer> errorCode = new Holder<Integer>();
        trusAccess.checkLoginEx2(accessCode, random, signature, appId, userLoginInfo2, errorCode);
        if ((Integer)errorCode.value != 0) {
            return;
        }
        cn.value = ((UserLoginInfo2)userLoginInfo2.value).getCn().getValue();
        uid.value = ((UserLoginInfo2)userLoginInfo2.value).getUid().getValue();
        name.value = ((UserLoginInfo2)userLoginInfo2.value).getName().getValue();
        trusdataou.value = ((UserLoginInfo2)userLoginInfo2.value).getTrusdataou().getValue();
        trusdatao.value = ((UserLoginInfo2)userLoginInfo2.value).getTrusdatao().getValue();
        telephoneNumber.value = ((UserLoginInfo2)userLoginInfo2.value).getTelephoneNumber().getValue();
        mail.value = ((UserLoginInfo2)userLoginInfo2.value).getMail().getValue();
        trusdataCertDN.value = ((UserLoginInfo2)userLoginInfo2.value).getTrusdataCertDN().getValue();
        trusdataCertSN.value = ((UserLoginInfo2)userLoginInfo2.value).getTrusdataCertSN().getValue();
        appusername.value = ((UserLoginInfo2)userLoginInfo2.value).getAppusername().getValue();
        appuserpwd.value = ((UserLoginInfo2)userLoginInfo2.value).getAppuserpwd().getValue();
    }

    protected byte[] getUserCert(String accessCode, String uid) throws Exception {
        PersonCertArray userCert = new PersonCertArray();
        userCert = trusAccess.handleQueryPersonReq(accessCode, 6, uid);
        return userCert.getItem().get(0);
    }

    public String calcAccessCode(byte[] cert) throws Exception {
        byte[] pubN;
        ByteArrayInputStream bais = new ByteArrayInputStream(cert);
        CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509 = (X509Certificate)certificatefactory.generateCertificate(bais);
        PublicKey pubKey = x509.getPublicKey();
        byte[] enkey = pubKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(enkey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKey rsakey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        BigInteger N = rsakey.getModulus();
        byte[] n = N.toByteArray();
        if (n[0] == 0) {
            pubN = new byte[n.length - 1];
            System.arraycopy(n, 1, pubN, 0, pubN.length);
        } else {
            pubN = new byte[n.length];
            System.arraycopy(n, 0, pubN, 0, pubN.length);
        }
        String strMD5 = IBUtilities.byte2HexStr(IBUtilities.md5AlgToByte(pubN)).toLowerCase();
        String strAccessCode = Base64.encode(strMD5.getBytes());
        return strAccessCode;
    }

    public static void main(String[] args) throws Exception {
        IBUtilities temp = new IBUtilities();
        FileInputStream file_inputstream = new FileInputStream("idea196.cer");
        DataInputStream data_inputstream = new DataInputStream(file_inputstream);
        byte[] certdata = new byte[data_inputstream.available()];
        data_inputstream.readFully(certdata);
        file_inputstream.close();
        data_inputstream.close();
        String strAccessCode = temp.calcAccessCode(certdata);
        System.out.println(strAccessCode);
        byte[] cert = temp.getUserCert(strAccessCode, "idea196");
        System.out.println(IBUtilities.byte2HexStr(cert));
        Holder<String> cn = new Holder<String>();
        Holder<String> uid = new Holder<String>();
        Holder<String> name = new Holder<String>();
        Holder<String> trusdataou = new Holder<String>();
        Holder<String> trusdatao = new Holder<String>();
        Holder<String> telephoneNumber = new Holder<String>();
        Holder<String> mail = new Holder<String>();
        Holder<String> trusdataCertDN = new Holder<String>();
        Holder<String> trusdataCertSN = new Holder<String>();
        temp.checkCertLogin(strAccessCode, cn, uid, name, trusdataou, trusdatao, telephoneNumber, mail, trusdataCertDN, trusdataCertSN);
        System.out.println((String)uid.value);
    }
}

