/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509IssuerSerialResolver == null ? (class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509IssuerSerialResolver = X509IssuerSerialResolver.class$("com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509IssuerSerialResolver")) : class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509IssuerSerialResolver).getName());
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509IssuerSerialResolver;

    public boolean engineCanResolve(Element element, String string2, StorageResolver storageResolver) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        }
        X509Data x509Data = null;
        try {
            x509Data = new X509Data(element, string2);
        }
        catch (XMLSignatureException xMLSignatureException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return false;
        }
        catch (XMLSecurityException xMLSecurityException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return false;
        }
        if (x509Data == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return false;
        }
        if (x509Data.containsIssuerSerial()) {
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I can't");
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string2, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509IssuerSerial"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "", keyResolverException);
                }
                throw keyResolverException;
            }
            X509Data x509Data = new X509Data(element, string2);
            int n = x509Data.lengthIssuerSerial();
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509IssuerSerial xMLX509IssuerSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), x509Certificate);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Found Certificate Issuer: " + xMLX509IssuerSerial.getIssuerName());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Found Certificate Serial: " + xMLX509IssuerSerial.getSerialNumber().toString());
                }
                for (int i = 0; i < n; ++i) {
                    XMLX509IssuerSerial xMLX509IssuerSerial2 = x509Data.itemIssuerSerial(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Found Element Issuer:     " + xMLX509IssuerSerial2.getIssuerName());
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Found Element Serial:     " + xMLX509IssuerSerial2.getSerialNumber().toString());
                    }
                    if (xMLX509IssuerSerial.equals(xMLX509IssuerSerial2)) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "match !!! ");
                        }
                        return x509Certificate;
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            }
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string2, StorageResolver storageResolver) {
        return null;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

