/*
 * Decompiled with CFR 0.152.
 */
package com.fr.mobile.service;

import com.fr.base.ConfigManager;
import com.fr.fs.FSConfig;
import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.fs.base.entity.UserDeviceInfo;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.UserDeviceControl;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.FSLoadLoginAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.LicUtils;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMobileLoginAction
extends FSLoadLoginAction {
    public String getCMD() {
        return "login";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = FSConfig.getProviderInstance().isMobileDeviceBinding();
        if (!bl) {
            super.actionCMD(httpServletRequest, httpServletResponse);
        } else {
            String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"macaddress");
            String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"oldmacaddress");
            String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"devname");
            String string4 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fr_username");
            if (!UserDeviceControl.getInstance().containCache(string4)) {
                super.actionCMD(httpServletRequest, httpServletResponse);
                FSAuthentication fSAuthentication = FSAuthenticationManager.exAuth4FineServer(httpServletRequest);
                if (fSAuthentication == null) {
                    return;
                }
                UserDeviceControl.getInstance().addUserDeviceInfo(new UserDeviceInfo(string4, string, string3, true));
                return;
            }
            UserDeviceControl.getInstance().dealWithOldMacAddress(string4, string2, string);
            if (UserDeviceControl.getInstance().checkDeviceAuth(string4, string)) {
                super.actionCMD(httpServletRequest, httpServletResponse);
                return;
            }
            UserDeviceControl.getInstance().addUserDeviceInfo(new UserDeviceInfo(string4, string, string3, false));
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            printWriter.print("{\"devunsupport\" : true}");
            printWriter.flush();
            printWriter.close();
        }
    }

    protected void signOnSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string) throws IOException {
        JSONObject jSONObject = null;
        try {
            jSONObject = this.getFSParaMap(httpServletRequest, ServiceUtils.getCurrentUserID(httpServletRequest));
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        printWriter.print(jSONObject);
    }

    protected PrintWriter createWriter(HttpServletResponse httpServletResponse) throws Exception {
        return WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse, (String)"GBK");
    }

    protected JSONObject getFSParaMap(HttpServletRequest httpServletRequest, long l) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("homePageUrl", (Object)UserControl.getInstance().getHomePageURL(l, this.getCheckTimestamp(httpServletRequest), WebUtils.getDevice((HttpServletRequest)httpServletRequest)));
        jSONObject.put("encoding", (Object)ConfigManager.getProviderInstance().getServerCharset());
        jSONObject.put("macaddress", (Object)GeneralUtils.getMacAddress());
        jSONObject.put("isTableDataUser", FSConfig.getProviderInstance().getControl().getControlType() == 1);
        AuthenticateObjectType authenticateObjectType = FSConfig.getProviderInstance().getAuthenticateObjectType();
        jSONObject.put("authType", (Object)authenticateObjectType.markType());
        jSONObject.put("isAdmin", ServiceUtils.getCurrentUserID(httpServletRequest) == -999L);
        JSONObject jSONObject2 = LicUtils.getJsonFromLic();
        if (jSONObject2 != null) {
            jSONObject.put("projectname", (Object)jSONObject2.optString("PROJECTNAME"));
            jSONObject.put("companyname", (Object)jSONObject2.optString("COMPANYNAME"));
            jSONObject.put("licmac", (Object)jSONObject2.optString("MACADDRESS"));
        }
        return jSONObject;
    }

    protected String getCheckTimestamp(HttpServletRequest httpServletRequest) {
        String string = Calendar.getInstance().getTime().toString();
        httpServletRequest.getSession().setAttribute(string, (Object)string);
        boolean bl = Boolean.valueOf(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"notchecked"));
        if (bl) {
            string = "";
        }
        return string;
    }

    protected boolean dealLoginInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, boolean bl) throws Exception {
        return AbstractFSAuthService.dealMobileLoginInfo(httpServletRequest, httpServletResponse, string, string2) || AbstractFSAuthService.dealMobileLoginInfo(httpServletRequest, httpServletResponse, string, CodeUtils.customPasswordEncode((String)string2));
    }
}

