/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.auth.LdapAuthenticateObjectType;
import com.fr.general.GeneralUtils;
import com.fr.privilege.Authentication;
import com.fr.stable.StringUtils;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationProvider {
    private String url = "ldap://ip:389";
    private LdapContext ctx;
    private Control[] connCtls = null;

    private LdapAuthenticationProvider() {
    }

    public static LdapAuthenticationProvider getInstance() {
        return LdapAuthenticationProviderHelper.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ldapAuthentication(Authentication authentication) {
        boolean bl = false;
        try {
            this.connectLdap();
            bl = this.authenticate(GeneralUtils.objectToString((Object)authentication.getPrincipal()), GeneralUtils.objectToString((Object)authentication.getCredentials()));
        }
        catch (Exception exception) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this.closeContext(this.ctx);
        }
        return bl;
    }

    private void connectLdap() {
        Properties properties = new Properties();
        LdapAuthenticateObjectType ldapAuthenticateObjectType = FSConfig.getProviderInstance().getAuthenticateObjectType(LdapAuthenticateObjectType.class);
        if (ldapAuthenticateObjectType == null) {
            return;
        }
        properties.put("java.naming.factory.initial", ldapAuthenticateObjectType.getContextFactory());
        String string = ldapAuthenticateObjectType.getLdapUrl();
        if (StringUtils.isNotBlank((String)string) && !string.endsWith("/")) {
            string = string + "/";
        }
        if (ldapAuthenticateObjectType.isRetrieveLocAsBaseDN()) {
            string = string + ldapAuthenticateObjectType.getLdapSearchBase();
        }
        properties.put("java.naming.provider.url", string);
        properties.put("java.naming.security.authentication", ldapAuthenticateObjectType.getAuthentication());
        properties.put("java.naming.referral", ldapAuthenticateObjectType.getReferral());
        if (StringUtils.isNotBlank((String)ldapAuthenticateObjectType.getLdapSystemName()) && StringUtils.isNotBlank((String)ldapAuthenticateObjectType.getLdapSystemPassword())) {
            properties.put("java.naming.security.principal", ldapAuthenticateObjectType.getLdapSystemName());
            properties.put("java.naming.security.credentials", ldapAuthenticateObjectType.getLdapSystemPassword());
        }
        try {
            this.ctx = new InitialLdapContext(properties, this.connCtls);
        }
        catch (AuthenticationException authenticationException) {
            FRContext.getLogger().error("AuthenticationException\uff0cAuthentication faild: " + authenticationException.toString());
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Exception,Something wrong while authenticating: " + exception.toString());
        }
    }

    private String recurseGetUserDN(String string) {
        String string2 = "";
        String[] stringArray = new String[]{"sAMAccountName", "cn", "userPrincipalName", "uid", "displayName", "name", "sn"};
        for (int i = 0; i < stringArray.length && !StringUtils.isNotBlank((String)(string2 = this.getUserDN(string, stringArray[i]))); ++i) {
        }
        return string2;
    }

    private String getUserDN(String string, String string2) {
        String string3 = "";
        try {
            SearchResult searchResult;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string4 = "(&(" + string2 + "=" + string + "))";
            String string5 = "";
            LdapAuthenticateObjectType ldapAuthenticateObjectType = FSConfig.getProviderInstance().getAuthenticateObjectType(LdapAuthenticateObjectType.class);
            if (ldapAuthenticateObjectType != null && !ldapAuthenticateObjectType.isRetrieveLocAsBaseDN()) {
                string5 = ldapAuthenticateObjectType.getLdapSearchBase();
            }
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search(string5, string4, searchControls);
            while (!(namingEnumeration == null || !namingEnumeration.hasMoreElements() || namingEnumeration.hasMoreElements() && StringUtils.isNotBlank((String)(string3 = (searchResult = (SearchResult)namingEnumeration.nextElement()).getNameInNamespace())) && string3.contains(string))) {
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return string3;
    }

    private boolean authenticate(String string, String string2) {
        boolean bl = true;
        String string3 = this.recurseGetUserDN(string);
        if (StringUtils.isEmpty((String)string3)) {
            string3 = string;
        }
        try {
            this.ctx.addToEnvironment("java.naming.security.principal", string3);
            this.ctx.addToEnvironment("java.naming.security.credentials", string2);
            this.ctx.reconnect(this.connCtls);
        }
        catch (AuthenticationException authenticationException) {
            FRContext.getLogger().error(authenticationException.getMessage());
            bl = false;
        }
        catch (NamingException namingException) {
            FRContext.getLogger().error(namingException.getMessage());
            bl = false;
        }
        return bl;
    }

    private void closeContext(LdapContext ldapContext) {
        try {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        catch (NamingException namingException) {
            FRContext.getLogger().error(namingException.getMessage());
        }
    }

    private static class LdapAuthenticationProviderHelper {
        public static LdapAuthenticationProvider helper = new LdapAuthenticationProvider();

        private LdapAuthenticationProviderHelper() {
        }
    }
}

