/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DatabaseAction;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.web.platform.entry.FileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryDAO
extends EntryDAO<FileEntry> {
    private static final FileEntryDAO SC = new FileEntryDAO();

    public static FileEntryDAO getInstance() {
        return SC;
    }

    private FileEntryDAO() {
    }

    public void save(FileEntry fileEntry) throws Exception {
        this.createSession().save((Object)fileEntry);
    }

    public void transfer(FileEntry fileEntry) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)fileEntry);
    }

    public boolean delete(FileEntry fileEntry) throws Exception {
        long l = fileEntry.getId();
        if (l < 0L) {
            throw new DAOException("The object is not a persistent Object. Can not find a right id.");
        }
        return this.deleteByID(l);
    }

    public FileEntry findByID(long l) throws Exception {
        return (FileEntry)this.createSession().load(FileEntry.class, l);
    }

    @Override
    protected Class getEntryClass() {
        return FileEntry.class;
    }

    @Override
    protected int getEntryType() {
        return 1;
    }
}

