/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.RoleCacheInfo;
import com.fr.fs.cache.RoleCacheUtils;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.json.JSONException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRoleCache {
    private static final Map<Long, RoleCacheInfo> ROLE_MAP = new Hashtable<Long, RoleCacheInfo>(128);
    private static final IDLockCreator CUSTOM_ROLE_ID_LOCK_CREATOR = new IDLockCreator();

    public static boolean containCache(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ROLE_MAP.containsKey(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCache() throws Exception {
        Map<Long, RoleCacheInfo> map = ROLE_MAP;
        synchronized (map) {
            if (ROLE_MAP.isEmpty()) {
                try {
                    List list = FSConfig.getProviderInstance().getControl().getCustomRoleDAO().findAll();
                    if (list != null) {
                        for (CustomRole customRole : list) {
                            CustomRoleCache.cache(customRole);
                        }
                    }
                }
                catch (Exception exception) {
                    ROLE_MAP.clear();
                    throw exception;
                }
            }
        }
    }

    public static List<CustomRole> getAllCustomRole() {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<CustomRole> arrayList = new ArrayList<CustomRole>();
        Set<Long> set = ROLE_MAP.keySet();
        for (Long l : set) {
            CustomRole customRole = new CustomRole(l);
            RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
            customRole.setRolename(roleCacheInfo.name);
            customRole.setSortindex(roleCacheInfo.getSortIndex());
            arrayList.add(customRole);
        }
        return arrayList;
    }

    private static void cache(CustomRole customRole) throws Exception {
        if (customRole != null) {
            RoleCacheInfo roleCacheInfo = CustomRoleCache.createSRoleCacheInfo(customRole);
            ROLE_MAP.put(customRole.getId(), roleCacheInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheNew(CustomRole customRole) throws Exception {
        if (customRole != null) {
            Object object = CUSTOM_ROLE_ID_LOCK_CREATOR.getIDLock(customRole.getId());
            try {
                Object object2 = object;
                synchronized (object2) {
                    block9: {
                        if (!ROLE_MAP.containsKey(customRole.getId())) break block9;
                        return;
                    }
                    RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
                    roleCacheInfo.name = customRole.getRolename();
                    ROLE_MAP.put(customRole.getId(), roleCacheInfo);
                }
            }
            finally {
                CUSTOM_ROLE_ID_LOCK_CREATOR.releaseIDLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheUpdate(CustomRole customRole) throws Exception {
        if (customRole != null) {
            Object object = CUSTOM_ROLE_ID_LOCK_CREATOR.getIDLock(customRole.getId());
            try {
                Object object2 = object;
                synchronized (object2) {
                    RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
                    roleCacheInfo.name = customRole.getRolename();
                    roleCacheInfo.setSortIndex(customRole.getSortindex());
                    ROLE_MAP.put(customRole.getId(), roleCacheInfo);
                }
            }
            finally {
                CUSTOM_ROLE_ID_LOCK_CREATOR.releaseIDLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSRoleName(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                return roleCacheInfo.name;
            }
        }
        return null;
    }

    private static RoleCacheInfo createSRoleCacheInfo(CustomRole customRole) throws Exception {
        RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
        roleCacheInfo.name = customRole.getRolename();
        roleCacheInfo.setSortIndex(customRole.getSortindex());
        CustomRoleCache.cacheCustomRoleEntryPrivileges(customRole, roleCacheInfo);
        CustomRoleCache.cacheCustomRoleESPrivileges(customRole, roleCacheInfo);
        CustomRoleCache.cacheCustomRoleModulePrivileges(customRole, roleCacheInfo);
        CustomRoleCache.cacheCustomRoleHomePagePrivileges(customRole, roleCacheInfo);
        CustomRoleCache.cacheCustomRoleDeptAndCustomRolePrivileges(customRole, roleCacheInfo);
        CustomRoleCache.cacheCustomRoleTemplatePrivileges(customRole, roleCacheInfo);
        CustomRoleCache.cacheCustomRoleDataConnectionPrivileges(customRole, roleCacheInfo);
        roleCacheInfo.addPrivileges4Plates(customRole.getId(), false);
        return roleCacheInfo;
    }

    private static void cacheCustomRoleEntryPrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleEntryPrivilege> set;
        Set<RoleEntryPrivilege> set2 = set = customRole.getId() <= -1000L ? TableDataCustomRoleDAO.getInstance().getEntryPrivileges(customRole.getRolename()) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getEntryPrivileges(customRole.getId());
        if (set != null) {
            for (RoleEntryPrivilege roleEntryPrivilege : set) {
                roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit()));
            }
        }
    }

    private static void cacheCustomRoleESPrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleESPrivilege> set = FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getESPrivileges(customRole.getId());
        if (set != null) {
            for (RoleESPrivilege roleESPrivilege : set) {
                roleCacheInfo.ESPrivilegeSet.add(EntryTypeAndID.getInstance(roleESPrivilege.getType(), roleESPrivilege.getEntryID()));
            }
        }
    }

    private static void cacheCustomRoleModulePrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleModulePrivilege> set;
        Set<RoleModulePrivilege> set2 = set = customRole.getId() <= -1000L ? TableDataCustomRoleDAO.getInstance().getModulePrivileges(customRole.getRolename()) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getModulePrivileges(customRole.getId());
        if (set != null) {
            for (RoleModulePrivilege roleModulePrivilege : set) {
                roleCacheInfo.moduleSet.add(roleModulePrivilege);
            }
        }
    }

    private static void cacheCustomRoleHomePagePrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleHomePagePrivilege> set;
        Set<RoleHomePagePrivilege> set2 = set = customRole.getId() <= -1000L ? TableDataCustomRoleDAO.getInstance().getHomePagePrivileges(customRole.getRolename()) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getHomePagePrivileges(customRole.getId());
        if (set != null) {
            for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                roleCacheInfo.homePagePrivilegeSet.add(roleHomePagePrivilege);
            }
        }
    }

    private static void cacheCustomRoleDeptAndCustomRolePrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleDepAndCRolePrivilege> set;
        Set<RoleDepAndCRolePrivilege> set2 = set = customRole.getId() <= -1000L ? TableDataCustomRoleDAO.getInstance().getDepAndCrolePrivileges(customRole.getRolename()) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getDepAndCrolePrivileges(customRole.getId());
        if (set != null) {
            for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                roleCacheInfo.deptAndCustomRolePrivilegeSet.add(roleDepAndCRolePrivilege);
            }
        }
    }

    private static void cacheCustomRoleTemplatePrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleTemplatePrivilege> set;
        Set<RoleTemplatePrivilege> set2 = set = customRole.getId() <= -1000L ? TableDataCustomRoleDAO.getInstance().getTemplatePrivileges(customRole.getRolename()) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getTemplatePrivileges(customRole.getId());
        if (set != null) {
            for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                roleCacheInfo.templateSet.add(roleTemplatePrivilege);
            }
        }
    }

    private static void cacheCustomRoleDataConnectionPrivileges(CustomRole customRole, RoleCacheInfo roleCacheInfo) throws Exception {
        Set<RoleDataConnectionPrivilege> set;
        Set<RoleDataConnectionPrivilege> set2 = set = customRole.getId() <= -1000L ? TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges(customRole.getRolename()) : FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getDataConnectionPrivileges(customRole.getId());
        if (set != null) {
            for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
                roleCacheInfo.dataConnectionSet.add(roleDataConnectionPrivilege);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInitCache() throws Exception {
        Map<Long, RoleCacheInfo> map = ROLE_MAP;
        synchronized (map) {
            ROLE_MAP.clear();
            CustomRoleCache.initCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Long, RoleCacheInfo> map = ROLE_MAP;
        synchronized (map) {
            ROLE_MAP.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(long l) {
        Object object = CUSTOM_ROLE_ID_LOCK_CREATOR.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ROLE_MAP.remove(l);
            }
        }
        finally {
            CUSTOM_ROLE_ID_LOCK_CREATOR.releaseIDLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<EntryTypeAndID> set = roleCacheInfo.entryPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    arrayList.add(EntryTypeAndID.getInstance(entryTypeAndID.getType(), entryTypeAndID.getId(), entryTypeAndID.getView(), entryTypeAndID.getAuthorized(), entryTypeAndID.getEdit()));
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        Set<RoleDataConnectionPrivilege> set = new HashSet<RoleDataConnectionPrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                set = roleCacheInfo.dataConnectionSet;
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleTemplatePrivilege> set = roleCacheInfo.templateSet;
                for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                    arrayList.add(roleTemplatePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleDepAndCRolePrivilege> arrayList = new ArrayList<RoleDepAndCRolePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleDepAndCRolePrivilege> set = roleCacheInfo.deptAndCustomRolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    arrayList.add(roleDepAndCRolePrivilege);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllDepAndCRolePrivilegeDescriptions(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleDepAndCRolePrivilege> set = roleCacheInfo.deptAndCustomRolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    arrayList.add(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllDepAndCRolePrivileges(long l, boolean bl) throws JSONException {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleDepAndCRolePrivilege> set = roleCacheInfo.deptAndCustomRolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (bl) {
                        arrayList.add((Object)roleDepAndCRolePrivilege);
                        continue;
                    }
                    arrayList.add(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllESPrivilegeDescriptions(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<EntryTypeAndID> set = roleCacheInfo.ESPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    arrayList.add(entryTypeAndID.getType() + "" + entryTypeAndID.getId());
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleModulePrivilege> set = roleCacheInfo.moduleSet;
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    arrayList.add(roleModulePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleHomePagePrivilege> set = roleCacheInfo.homePagePrivilegeSet;
                for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                    if (roleHomePagePrivilege.getView() <= 0L) continue;
                    arrayList.add(roleHomePagePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllPrivilegesWithPlateName(long l, String string) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<String> set = roleCacheInfo.getPlatePrivilege(string);
                if (set == null) {
                    return null;
                }
                for (String string2 : set) {
                    arrayList.add(string2);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshCustomRoleName(long l, String string) {
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.name = string;
            }
        }
    }

    public static void refreshModulePrivileges(long l, Set<RoleModulePrivilege> set) {
        RoleCacheUtils.refreshModulePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshModulePrivileges(String string, Set<RoleModulePrivilege> set) {
        RoleCacheUtils.refreshModulePrivileges(ROLE_MAP, string, set);
    }

    public static void refreshHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set) {
        RoleCacheUtils.refreshHomePagePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshHomePagePrivileges(String string, Set<RoleHomePagePrivilege> set) {
        RoleCacheUtils.refreshHomePagePrivileges(ROLE_MAP, string, set);
    }

    public static void refreshPrivilegesWithPlateName(long l, Set<RelationObject> set, String string) {
        RoleCacheUtils.refreshPlatePrivileges(ROLE_MAP, l, set, string);
    }

    public static void refreshEntryPrivileges(long l, Set<RoleEntryPrivilege> set) {
        RoleCacheUtils.refreshEntryPrivileges(ROLE_MAP, l, set);
    }

    public static void refreshEntryPrivileges(String string, Set<RoleEntryPrivilege> set) {
        RoleCacheUtils.refreshEntryPrivileges(ROLE_MAP, string, set);
    }

    public static void refreshTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set) {
        RoleCacheUtils.refreshTemplatePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshTemplatePrivileges(String string, Set<RoleTemplatePrivilege> set) {
        RoleCacheUtils.refreshTemplatePrivileges(ROLE_MAP, string, set);
    }

    public static void refreshDepAndCRolePrivileges(long l, Set<RoleDepAndCRolePrivilege> set) {
        RoleCacheUtils.refreshDepAndCRolePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshDepAndCRolePrivileges(String string, Set<RoleDepAndCRolePrivilege> set) {
        RoleCacheUtils.refreshDepAndCRolePrivileges(ROLE_MAP, string, set);
    }

    public static void refreshDataConnectionPrivileges(long l, Set<RoleDataConnectionPrivilege> set) {
        RoleCacheUtils.refreshDataConnectionPrivileges(ROLE_MAP, l, set);
    }

    public static void refreshDataConnectionPrivileges(String string, Set<RoleDataConnectionPrivilege> set) {
        RoleCacheUtils.refreshDataConnectionPrivileges(ROLE_MAP, string, set);
    }

    public static void refreshESPrivileges(long l, Set<RoleESPrivilege> set) {
        RoleCacheUtils.refreshESPrivileges(ROLE_MAP, l, set);
    }

    public static boolean containModulePrivilege(long l, long l2) {
        return RoleCacheUtils.containModulePrivilege(ROLE_MAP, l, l2);
    }

    public static boolean containHomePagePrivilege(long l, long l2) {
        return RoleCacheUtils.containHomePagePrivilege(ROLE_MAP, l, l2);
    }

    public static boolean containPlatePrivilege(long l, long l2, String string) {
        return RoleCacheUtils.containPlatePrivilege(ROLE_MAP, l, l2, string);
    }

    public static boolean containEntryPrivilege(long l, int n, long l2) {
        return RoleCacheUtils.containEntryPrivilege(ROLE_MAP, l, n, l2);
    }

    public static void refreshEntryPrivileges(long l, int n, long l2, long l3) {
        RoleCacheUtils.refreshEntryPrivileges(ROLE_MAP, l, n, l2, l3);
    }

    public static void resetSortIndex() {
        Collection<RoleCacheInfo> collection = ROLE_MAP.values();
        for (RoleCacheInfo roleCacheInfo : collection) {
            roleCacheInfo.setSortIndex(0L);
        }
    }
}

