/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process;

import com.fr.base.platform.PlatformProvider;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.fun.ResolveUsernameProcessor;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;

public class ProcessUtils {
    private static PlatformProvider P = null;
    public static final String FLAG = "123456789";
    public static final String SHORT_FLAG = "00000";

    public static PlatformProvider P() {
        if (P == null) {
            P = (PlatformProvider)StableFactory.getMarkedObject((String)"PlatformProvider", PlatformProvider.class);
        }
        return P;
    }

    public static long getCurrentUserId(HttpServletRequest httpServletRequest) {
        return ProcessUtils.P().getCurrentUserID(httpServletRequest);
    }

    public static String getCurrentUserName(HttpServletRequest httpServletRequest) {
        return ProcessUtils.P().getCurrentUserName(httpServletRequest);
    }

    public static String getUserEmail(long l2) {
        JSONObject jSONObject = ProcessUtils.P().getUserInfoById(l2);
        if (jSONObject.has("email")) {
            return jSONObject.optString("email");
        }
        return "";
    }

    public static String getUserName(long l2) {
        return ProcessUtils.getUserName(l2, true);
    }

    public static String getUserName(long l2, boolean bl) {
        if (ProcessUtils.isRoot(l2)) {
            return "admin";
        }
        JSONObject jSONObject = ProcessUtils.P().getUserInfoById(l2);
        return bl ? jSONObject.optString("realname") + "(" + jSONObject.optString("username") + ")" : jSONObject.optString("username");
    }

    public static String getUserNameText(String string, boolean bl) {
        if (ProcessUtils.isRoot(string)) {
            return "admin";
        }
        JSONObject jSONObject = ProcessUtils.P().getUserInfoByName(string);
        return bl ? jSONObject.optString("realname") + "(" + jSONObject.optString("username") + ")" : jSONObject.optString("username");
    }

    public static String getUserNameById(String string) {
        try {
            if (ProcessUtils.P().getUserIdByName(string) != -1L) {
                return string;
            }
            return ProcessUtils.getUserNameById(Long.valueOf(string));
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getUserNameById(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return "admin";
        }
        JSONObject jSONObject = ProcessUtils.P().getUserInfoById(l2);
        return jSONObject.optString("username");
    }

    public static String getCompanyRoleName(long l2) {
        JSONObject jSONObject = ProcessUtils.P().getCompanyRoleInfoById(l2);
        return jSONObject.optString("departmentname") + jSONObject.optString("postname");
    }

    public static String getCustomRoleName(long l2) {
        JSONObject jSONObject = ProcessUtils.P().getCustomRoleInfoById(l2);
        return jSONObject.optString("text");
    }

    public static JSONArray getUserDepartmentInfo(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return new JSONArray();
        }
        long[] lArray = ProcessUtils.P().getCompanyRolesByUserId(l2);
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            jSONArray.put((Object)ProcessUtils.P().getCompanyRoleInfoById(lArray[i2]));
        }
        return jSONArray;
    }

    public static String getUserDepartmentName(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return "admin";
        }
        long[] lArray = ProcessUtils.P().getCompanyRolesByUserId(l2);
        String string = "";
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            JSONObject jSONObject = ProcessUtils.P().getCompanyRoleInfoById(lArray[i2]);
            string = string + jSONObject.optString("departmentname");
            if (i2 >= lArray.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public static long[] getUserDepartmentIds(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return new long[0];
        }
        long[] lArray = ProcessUtils.P().getCompanyRolesByUserId(l2);
        long[] lArray2 = new long[]{};
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            JSONObject jSONObject = ProcessUtils.P().getCompanyRoleInfoById(lArray[i2]);
            lArray2 = ArrayUtils.add((long[])lArray2, (long)ProcessUtils.getIdFromStr(jSONObject.optString("departmentid")));
        }
        return lArray2;
    }

    public static String[] unique(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static long[] unique(long[] lArray) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (long l2 : lArray) {
            hashSet.add(l2);
        }
        return ArrayUtils.toPrimitive((Long[])hashSet.toArray(new Long[hashSet.size()]));
    }

    public static long getIdFromStr(String string) {
        return ProcessUtils.getIdFromStr(string, -1L);
    }

    public static long getIdFromStr(String string, long l2) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            long l3 = ProcessUtils.P().getUserIdByName(string);
            return l3 == -1L ? l2 : l3;
        }
    }

    public static long getUserIdFromStr(String string) {
        return ProcessUtils.getUserIdFromStr(string, -1L);
    }

    public static long getUserIdFromStr(String string, long l2) {
        ResolveUsernameProcessor resolveUsernameProcessor = (ResolveUsernameProcessor)ExtraReportClassManager.getInstance().getSingle("ResolveUsernameProcessor");
        if (resolveUsernameProcessor != null) {
            return resolveUsernameProcessor.resolveUsername(string);
        }
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            long l3 = ProcessUtils.P().getUserIdByName(string);
            return l3 == -1L ? l2 : l3;
        }
    }

    public static int getIntFromStr(String string) {
        return ProcessUtils.getIntFromStr(string, -1);
    }

    public static int getIntFromStr(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static boolean invalidUser(long l2) {
        return l2 < 0L && l2 != -999L;
    }

    public static boolean isRoot(long l2) {
        return l2 == -999L;
    }

    public static boolean isRoot(String string) {
        return ComparatorUtils.equals((String)string, (String)PrivilegeManager.getProviderInstance().getRootManagerName());
    }

    public static long getTreatedTaskId(long l2) {
        String string = String.valueOf(l2);
        int n2 = string.lastIndexOf(SHORT_FLAG);
        return n2 == -1 ? l2 : Long.parseLong(string.substring(0, n2));
    }
}

