/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.io.exporter.AbstractAppExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.report.core.ReportUtils;
import com.fr.stable.bridge.StableFactory;
import java.awt.Graphics2D;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGExporter
extends AbstractAppExporter {
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        this.export(outputStream, pageSetProvider);
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        ReportPageProvider reportPageProvider;
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        int n2 = 0;
        for (int i2 = 0; i2 < pageSetProvider.size() && (reportPageProvider = pageSetProvider.getPage(i2)) != null; ++i2) {
            int n3 = reportPageProvider.getPaperWidth().toPixI(96);
            int n4 = reportPageProvider.getPaperHeight().toPixI(96);
            Graphics2D graphics2D = (Graphics2D)sVGGraphics2D.create(0, n2, n3, n4);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = (PagePainterProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"PagePainter", (Object[])new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(96)), false}, hashMap, PagePainterProvider.class);
            pagePainterProvider.convert();
            n2 += n4;
            graphics2D.dispose();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        sVGGraphics2D.stream((Writer)outputStreamWriter, true);
        outputStream.flush();
    }
}

