/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.io.exporter.AbstractAppExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.core.ReportUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.FunctionProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ImageExporter
extends AbstractAppExporter {
    private String suffix = "jpg";
    private int resolution = 96;

    public ImageExporter() {
    }

    public ImageExporter(String string) {
        this();
        this.setSuffix(string);
    }

    public ImageExporter(String string, int n2) {
        this();
        this.resolution = n2;
        this.setSuffix(string);
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        this.export(outputStream, pageSetProvider);
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        Object object;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < pageSetProvider.size() && (object = pageSetProvider.getPage(i2)) != null; ++i2) {
            n2 = Math.max(n2, object.getPaperWidth().toPixI(this.resolution));
            n3 += object.getPaperHeight().toPixI(this.resolution);
            arrayList.add(object);
        }
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n2, (int)n3, (int)1);
        object = bufferedImage.createGraphics();
        int n4 = 0;
        int n5 = arrayList.size();
        for (int i3 = 0; i3 < n5; ++i3) {
            ReportPageProvider reportPageProvider = (ReportPageProvider)arrayList.get(i3);
            ((Graphics2D)object).translate(0, n4);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = (PagePainterProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"PagePainter", (Object[])new Object[]{reportPageProvider, object, Integer.valueOf(String.valueOf(this.resolution)), false}, hashMap, PagePainterProvider.class);
            pagePainterProvider.convert();
            int n6 = reportPageProvider.getPaperWidth().toPixI(this.resolution);
            if (n6 < n2) {
                int n7 = reportPageProvider.getPaperHeight().toPixI(this.resolution);
                Color color = ((Graphics)object).getColor();
                ((Graphics)object).setColor(Color.WHITE);
                ((Graphics)object).fillRect(reportPageProvider.getPaperWidth().toPixI(this.resolution), 0, n2 - n6, n7);
                ((Graphics)object).setColor(color);
            }
            ((Graphics2D)object).translate(0, -n4);
            n4 += reportPageProvider.getPaperHeight().toPixI(this.resolution);
        }
        ImageIO.write((RenderedImage)bufferedImage, this.suffix == null ? "jpg" : this.suffix, outputStream);
        outputStream.flush();
        outputStream.close();
        this.recordFunction();
    }

    public void export(OutputStream outputStream, ReportPageProvider reportPageProvider) throws Exception {
        int n2 = 0;
        float f2 = 0.0f;
        n2 = Math.max(n2, reportPageProvider.getPaperWidth().toPixI(this.resolution));
        f2 = reportPageProvider.getPaperHeight().toPixF(this.resolution);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n2, (int)((int)f2), (int)1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        float f3 = 0.0f;
        graphics2D.translate(0, (int)f3);
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("0", ReportPageProvider.class);
        hashMap.put("1", Graphics2D.class);
        PagePainterProvider pagePainterProvider = (PagePainterProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"PagePainter", (Object[])new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(this.resolution)), false}, hashMap, PagePainterProvider.class);
        pagePainterProvider.convert();
        graphics2D.translate(0, (int)(-f3));
        ImageIO.write((RenderedImage)bufferedImage, this.suffix == null ? "jpg" : this.suffix, outputStream);
        outputStream.flush();
        outputStream.close();
        this.recordFunction();
    }

    private void recordFunction() {
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor == null) {
            return;
        }
        functionProcessor.recordFunction(ReportFunctionProcessor.IMAGE_EXPORT);
    }
}

