/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;
import javax.crypto.Cipher;

public class TestRAWVerify {
    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\netsign\\IAFW_NetSignAgent\\netsignagent.properties");
            PropertyResourceBundle res = new PropertyResourceBundle(in);
            NetSignAgent.initialize(res);
            TestRAWVerify.verify(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testSM2PublicKeyVerify() throws Exception {
        byte[] plainText = "11111111".getBytes();
        byte[] signed = Base64.decode((String)"MEUCIQCSlJFkQLNbkPnb2AYBIOzJzQ1s+ehL6Qm9w9vh9xNm/QIgUccJYtgs2RbaUF47EtHjRf/vwKZKUlVn6Th9cJNuNlY=");
        byte[] certbs = Base64.decode((String)"MIICIDCCAcWgAwIBAgICASMwDAYIKoEcz1UBg3UFADAkMRAwDgYDVQQDEwdzbTJyb290MRAwDgYDVQQKEwdpbmZvc2VjMB4XDTEzMDUxNjE0NTcyNVoXDTE0MDUxNjE0NTcyNVowJTERMA8GA1UEAxMIc20yY2VydDExEDAOBgNVBAoTB2luZm9zZWMwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARVCUZPz4mmliRIju3ueoo3nbyPfjyJykSiO/K0IFR6dlvxMnW7EUmKJy7zGIQt8IO2JqddRKjM9XLkBPq2Q5T9o4HjMIHgMAsGA1UdDwQEAwIGwDAdBgNVHQ4EFgQUyTUxZL1SsNhz5aYxZU+vC++FINcwVQYDVR0fBE4wTDBKoEigRqREMEIxDTALBgNVBAMMBGNybDExDDAKBgNVBAsMA2NybDEWMBQGA1UECgwNSW5mb3NlY1Rlc3RDQTELMAkGA1UEBhMCQ04wHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMAkGA1UdEwQCMAAwEAYIYIZIAfhCAQEEBAMCBaAwHwYDVR0jBBgwFoAUg+RlNe1bApz2BDtAt7NdEi4MQqYwDAYIKoEcz1UBg3UFAANHADBEAiBrN4U7NhE0NN/9JkqHSZ3+W9EM1tApRQbJjIcx48nR2QIgQ9lYU56S7xSJ7ZhmZ7bjEgFhbiJFuLytNLy7TmaiCA8=");
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certbs));
        NetSignAgent.rawVerify(plainText, signed, null, cert.getPublicKey());
        System.out.println("verify ok");
    }

    private static void testDetached() throws Exception {
        byte[] plainText = "11111111".getBytes();
        NetSignResult result = NetSignAgent.detachedSignature(plainText, "CN=5year,O=syn080924,C=cn", null, false);
        String signed = result.getStringResult("Base64_Signed_Text");
        ConsoleLogger.logString((String)signed);
        result = NetSignAgent.detachedVerify(plainText, signed, null, false);
        System.out.println("subject:" + result.getStringResult("Sign_Subject"));
    }

    private static void verify(String signed) throws Exception {
        signed = "lD4D7Wr9GFNg8yhdDofq3QXj6DooLag/xeRBARunUvZuIq2QIlIHpS3hyJpRtvv1bB+kh0YwUeKbThGGhumO2vkTpwlH0QFQq2RzXXB8Io2AOXITfJDxgoKoDD7LCEfmsy1K5xTL84Q3z+MgQtPRlj1DpvjQBo6M1JU5JiXF6GvFHCTBZBgmEV5vPGp3hXx8VSGH9eXd9HqFpaaVboTJ3rOxxK1N/2s8Y334u1BAh4Rq52wN1Ue6YoIrbBIuuLfmu4hi4Ts1rvN8v2gaSCMvYAu6sFJgjybT5wM+Dsx43wtBeFloAX7P/vYsvegholjB2t183txapP919GZBJbuscA==";
        String certStr = "MIID+TCCAuGgAwIBAgIFEAAyBXkwDQYJKoZIhvcNAQEFBQAwGzELMAkGA1UEBhMCQ04xDDAKBgNVBAoTA0JPQzAeFw0xMzA5MjkwOTE3MDRaFw0xNDA5MjkwOTE3MDRaMF8xCzAJBgNVBAYTAkNOMQ0wCwYDVQQKEwRPQ0ExMQ8wDQYDVQQLEwZUUEMtUzMxFTATBgNVBAsTDEluZGl2aWR1YWwtMTEZMBcGA1UEAxMQOTYzMTIwMzIwMDAwMDA0MjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALZA5aGT3KJdYWukqEmsZcQP0UTZFDRBEBhd6R7ey1eIBG3FG/NDNstx6U9T06S1/Gq0YDdKgbaYRjcrAx/iD6OZRkT06EhRd7f3eAogJOZIK3G1Fq2HTwRxaJ8KL19/T9eE0SM9ywT4dzcGeU90BvS/qRzIh9CY0WI57fZ0Cc/h3oLt+80r/AWYhavfVw5BTmbBol2AC93CtOh+3CH3/Mm/HsNNBOIA22rI+ldcnlr/RwAWcZ4KzIWu/ba9Y+HqGxzDR/TYSsvBjEBFQ21FxtZLPVrLCaN3C/FsDJ2mBGl2/Ayni68phmAJnb27OMSo+lb7tt8Y2QyhUP5iKwpRw20CAwEAAaOB/zCB/DAfBgNVHSMEGDAWgBTPcJ1h6518Lrj3ywJA9wmd/jN0gDBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDcGA1UdHwQwMC4wLKAqoCiGJmh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1JTQS9jcmw0NzkuY3JsMAsGA1UdDwQEAwID6DAVBgkqgRyGoSAEAQcECAwGVFBDMi4wMB0GA1UdDgQWBBTELd5quCQXdPxzLSnCij7c7z6+uDATBgNVHSUEDDAKBggrBgEFBQcDAjANBgkqhkiG9w0BAQUFAAOCAQEAqewlzWc99UYGbCOwig8wQHSkEOjsjbGWfjiew81Z69VQpUj+8garVTXeSYgVnAAR54+SmvPHSvJCvIG/r/QmRCnWLeVh0dOPn1Ep96AFUWSw9A7ZtQc3MhCbM04RAnn6OKHmMHLhcISLnsUjzF6aEsINsDpEGor4CZU/NSmksqJn3hiCs+6lDYJ9VgczgG8pIBIIlFF0D4bz6dYYW1gWEMeLFCce5x7mTKL5bDhmr/JjmWTPAY4K33UyQJEWGs2DmodmoYhF7L4Z4PBRCi5U/G/76lm7HTc6+RIOooZFwnQ2vqsh+8dgcr3v+vbsj/qVAz+9kPnEpFjVmlvKdPRT4g==";
        String plainStr = "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";
        byte[] plain = Base64.decode((String)plainStr);
        X509Certificate cert = NetSignAgent.generateCertificate(certStr.getBytes());
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(2, cert.getPublicKey());
        byte[] dersa = c.doFinal(Base64.decode((String)signed));
        ConsoleLogger.logBinary((String)"decode rsa", (byte[])dersa);
        MessageDigest md = MessageDigest.getInstance("SHA256");
        byte[] dig = md.digest(plain);
        ConsoleLogger.logBinary((String)"dig", (byte[])dig);
        NetSignAgent.rawVerify(plain, signed, "SHA256", null, cert);
        System.out.println("verify ok");
    }

    private static String testSign() throws Exception {
        NetSignResult nsr = NetSignAgent.rawSignature("1234567890".getBytes(), null, false);
        String signed = nsr.getStringResult("Base64_Signed_Text");
        ConsoleLogger.logString((String)signed);
        return signed;
    }

    private static void testAPIVerify(String signed) throws Exception {
        String certstr = "MIIC8jCCAdqgAwIBAgIES5IBfTANBgkqhkiG9w0BAQUFADA2MQswCQYDVQQGEwJjbjESMBAGA1UEChMJc3luMDgwOTI0MRMwEQYDVQQDEwpyb290MDgwOTI0MB4XDTEyMDYwNzA5MDczMVoXDTEzMDYwNzA5MDczMVowIDEOMAwGA1UECgwFaG9hcnkxDjAMBgNVBAMMBWluQ1JMMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDfXkX8Hv7h0BO3KZkCyV7RulabRluCk8DZwzTr3EqTiUovsy7amwvzYTLUjuDsTSl1kYe3xnBIUWETwEjlwo4+fGIDhlkvLtf5x1r8MP1GiAmiOW1yNGH66ued+cKs7F8YqNtjovmtTdPRADpE9cKMRN4SJ/ZFM7gN9suQe87KNwIDAQABo4GhMIGeMBEGCWCGSAGG+EIBAQQEAwIFoDAJBgNVHRMEAjAAMFIGA1UdHwRLMEkwR6BFoEOkQTA/MQswCQYDVQQGEwJjbjESMBAGA1UECgwJc3luMDgwOTI0MQwwCgYDVQQLDANjcmwxDjAMBgNVBAMMBWNybDM5MAsGA1UdDwQEAwIGwDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwQwDQYJKoZIhvcNAQEFBQADggEBAH2+W7wOLHhD1VExaLMv6n0Z3y/1cs73MCrPjiDPhNMmKeDFmU6FnPJq1kUEJg2fpMydppD+fApN2ioFC7lVSAaCYwFW6fU/6kYFC5b7ABjoXBIVu0FGZFb+meWUv+dIxCq6qqwmgH81FM5FvggfUiN2q6Ic5U8OM3NH3fIkT64yesV41hB+zJciO/9CdhrN0yfp1ToTuGMChy8SrrIhAb8fEArSfNiG+UighyAe8GNPwpdrd5rhUwJU60K2HPL6vkcPDhP3rENtDOCTSNr8JNqszvI+FAffJWjMRwRXU+Q2CnihOeF+873QpLCYka+5SKKR7LurZZ0gjXbNLV+NQYY=";
        NetSignAgent.rawVerify("1234567891".getBytes(), signed, null, NetSignAgent.generateCertificate(certstr.getBytes()));
    }
}

