/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;

public class TestQLBKB {
    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\netsign\\IAFW_NetSignAgent\\netsignagent.properties");
        PropertyResourceBundle prb = new PropertyResourceBundle(in);
        NetSignAgent.initialize(prb);
        TestQLBKB.test3();
    }

    private static void test3() throws Exception {
        FileInputStream in = new FileInputStream("D:\\TEMP\\luojia\\20130522\\2hash.p7b");
        byte[] signed = new byte[in.available()];
        in.read(signed);
        NetSignResult result = NetSignAgent.attachedVerify4UKey2G(new String(signed), null, false, "VerifyQLBKeyBusinessProcessor");
        System.out.println(new String(result.getByteArrayResult("Byte_Array_Plain_Text"), "UTF-8"));
    }

    private static void test2() throws Exception {
        FileInputStream in = new FileInputStream("D:\\TEMP\\luojia\\20130522\\plain.txt");
        byte[] p = new byte[in.available()];
        in.read(p);
        p = new String(p).getBytes("UTF-8");
        in = new FileInputStream("D:\\TEMP\\luojia\\20130522\\signed.txt");
        byte[] c = new byte[in.available()];
        in.read(c);
        in = new FileInputStream("D:\\TEMP\\luojia\\20130522\\1.cer");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
        try {
            NetSignAgent.rawVerify4QLBKB(p, Base64.encode((byte[])c), null, cert);
            System.out.println("verify ok");
        }
        catch (NetSignAgentException e) {
            System.out.println(e.getErrorCode());
            e.printStackTrace();
        }
        catch (ServerProcessException e) {
            System.out.println(e.getErrorCode());
            e.printStackTrace();
        }
    }

    private static void test() throws Exception {
        String plainText = "03C3F786D6C2076657273696F6E3D22312E302220656E636F64696E67203D20227574662D38223F3E0D0A3C5369676E446174613E0D0A3C4669656C64733E0D0A3C4163636F756E74206E616D653D22E8B4A6E688B7EFBC9A223E363232373838313030303938373C2F4163636F756E743E0D0A3C416D6F756E74206E616D653D22E98791E9A29DEFBC9A223E313030302E353C2F416D6F756E743E0D0A3C5265636569766572206E616D653D22E694B6E6ACBEE4BABAEFBC9A223EE5BCA0E4B8893C2F52656365697665723E0D0A3C54696D655374616D703E323031302D30382D30352032313A31333A31323C2F54696D655374616D703E0D0A3C4C696E653E303030303130313C2F4C696E653E0D0A3C2F4669656C64733E0D0A3C2F5369676E446174613E";
        String signedText = "984BA76E22968E8A8B75701C073869FFC9700C86872DABA4E253BEF10412B71B273066A5127BEE0D4FD289108D013BF98F3085C4A5BE6BF31CCAF772B9BF894EA4B16B856D0C24292563C250E3F0B85BDF6B812463CDDC9BB3654FBF97D677B13A20BE66D74D7BA4CE9E2C542F5CC38CA95E9EBB0BBEADCD922B3EEC7049DFCF";
        byte[] p = new BigInteger(plainText, 16).toByteArray();
        ConsoleLogger.logBinary((String)"plain text", (byte[])p);
        byte[] s = new BigInteger(signedText, 16).toByteArray();
        byte[] signed = new byte[128];
        System.arraycopy(s, 1, signed, 0, 128);
        ConsoleLogger.logBinary((String)"signed text", (byte[])signed);
        FileInputStream in = new FileInputStream("D:\\WORK\\docs\\infosec\\operation\\netsign\\NetSignServer5.2\\5.2.30_QL1.0\\userCert.cer");
        byte[] cert = new byte[in.available()];
        in.read(cert);
        NetSignAgent.rawVerify4QLBKB(p, Base64.encode((byte[])signed), null, NetSignAgent.generateCertificate(cert));
    }
}

