/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.util.PublicKeyFactory;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.PBCAgent;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class TestPBC {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        TestPBC.testConnectionPool();
    }

    public static void testConnectionPool() throws Exception {
        NetSignService nss = NetSignService.getInstance("192.168.3.248", 10007, "11111111");
        NetSignService nss2 = NetSignService.getInstance("192.168.3.248", 11111, "11111111");
        PBCAgent.initialize(new NetSignService[]{nss});
        TestPBC tpbc = new TestPBC();
        int i = 0;
        while (i < 50) {
            TestConnectionPool tcp = tpbc.getTestConnectionPool();
            Thread t = new Thread(tcp);
            t.start();
            ++i;
        }
    }

    public TestConnectionPool getTestConnectionPool() throws Exception {
        return new TestConnectionPool();
    }

    private static void testGenAndVerifyBrondMsg() {
        try {
            NetSignService s = NetSignService.getInstance("192.168.2.248", 40019, "11111111");
            PBCAgent.initialize(new NetSignService[]{s});
            PBCAgent.setConnectionMode(1);
            NetSignResult res = PBCAgent.generateBondMsg("1".getBytes(), "CN=5year,O=syn080924,C=cn");
            String signed = res.getStringResult("Base64_Signed_Text");
            ConsoleLogger.logString((String)signed);
            NetSignResult result = PBCAgent.verifyBondMsg("1".getBytes(), signed);
            System.out.println(result.getSignCert().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testGenBrondMsg() {
        try {
            NetSignService s = NetSignService.getInstance("192.168.2.248", 40019, "11111111");
            NetSignService s2 = NetSignService.getInstance("192.168.2.248", 5555, "11111111");
            PBCAgent.initialize(new NetSignService[]{s, s2});
            PBCAgent.setConnectionMode(2);
            NetSignResult res = PBCAgent.generateBondMsg("1".getBytes(), "5year");
            System.out.println(res.getStringResult("Base64_Signed_Text"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testRAWVerify() {
        try {
            NetSignService s = NetSignService.getInstance("192.168.2.150", 40020, null);
            PBCAgent.initialize(new NetSignService[]{s});
            byte[] plain = "BankId=9999~|~CifNo=501000000468~|~UserId=USER2~|~LoginType=C~|~_PESignTimestamp=1302159869785".getBytes();
            String signed = "V3dKo9sfjMZug27YV1EOVtlmaQCdUSBQxI0gSI902DdH9dUiXTZPhxWzesEPlt20DrqU/9NFTE9acox2epGKg+3Y9AeDsnQ7wLffSYI+NcJ87LUedCQ7/eFwzM8fgX2tEbv0qzTOLALQg7c1NTeuNM0y/Yz9Klx/LPokBhSSAlQ=";
            FileInputStream in = new FileInputStream("D:\\TEMP\\cfca\\user1.cer");
            byte[] bs = new byte[in.available()];
            in.read(bs);
            X509Certificate cert = NetSignAgent.generateCertificate(bs);
            NetSignAgent.rawVerify(plain, signed, null, cert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testCQNS2() {
        try {
            FileInputStream in = new FileInputStream("D:\\TEMP\\cqnsh\\public.cer");
            byte[] pubkbs = new byte[in.available()];
            in.read(pubkbs);
            ConsoleLogger.logBinary((String)"pubk", (byte[])pubkbs);
            RSAKeyParameters kp = (RSAKeyParameters)PublicKeyFactory.createKey((byte[])pubkbs);
            RSAPublicKeySpec pks = new RSAPublicKeySpec(kp.getModulus(), kp.getExponent());
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey pk = kf.generatePublic(pks);
            in = new FileInputStream("D:\\TEMP\\cqnsh\\\u4e8c\u8fdb\u5236\u539f\u6587.txt");
            byte[] all = new byte[in.available()];
            in.read(all);
            String str = new String(all);
            String[] pieces = str.split(" ");
            byte[] signed = new byte[128];
            int i = 0;
            while (i < 128) {
                int x = Integer.parseInt(pieces[pieces.length - 1 - i], 16) & 0xFF;
                signed[127 - i] = (byte)x;
                ++i;
            }
            ConsoleLogger.logBinary((String)"signed", (byte[])signed);
            byte[] plain = new byte[pieces.length - 4 - 128];
            int i2 = 4;
            int length = pieces.length - 128;
            while (i2 < length) {
                int x = Integer.parseInt(pieces[i2], 16) & 0xFF;
                plain[i2 - 4] = (byte)x;
                ++i2;
            }
            ConsoleLogger.logBinary((String)"plain", (byte[])plain);
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(2, pk);
            byte[] ds = c.doFinal(signed);
            ConsoleLogger.logBinary((String)"decrypt rsa", (byte[])ds);
            MessageDigest md = MessageDigest.getInstance("sha1");
            byte[] sha1 = md.digest(plain);
            ConsoleLogger.logBinary((String)"digest", (byte[])sha1);
            NetSignService s = NetSignService.getInstance("192.168.2.150", 40019, null);
            PBCAgent.initialize(new NetSignService[]{s});
            NetSignAgent.rawVerify(plain, signed, null, pk);
            System.out.println("verify successed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testCQNS() {
        try {
            FileInputStream in = new FileInputStream("D:\\TEMP\\cqnsh\\public.cer");
            byte[] pubkbs = new byte[in.available()];
            in.read(pubkbs);
            ConsoleLogger.logBinary((String)"pubk", (byte[])pubkbs);
            RSAKeyParameters kp = (RSAKeyParameters)PublicKeyFactory.createKey((byte[])pubkbs);
            RSAPublicKeySpec pks = new RSAPublicKeySpec(kp.getModulus(), kp.getExponent());
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey pk = kf.generatePublic(pks);
            in = new FileInputStream("D:\\TEMP\\cqnsh\\signed.txt");
            byte[] bs = new byte[in.available()];
            in.read(bs);
            byte[] signed = Base64.decode((byte[])bs);
            ConsoleLogger.logBinary((String)"signed", (byte[])signed);
            in = new FileInputStream("D:\\TEMP\\cqnsh\\plain.txt");
            byte[] plain = new byte[in.available()];
            in.read(plain);
            ConsoleLogger.logBinary((String)"plain", (byte[])plain);
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(2, pk);
            byte[] ds = c.doFinal(signed);
            ConsoleLogger.logBinary((String)"decrypt rsa", (byte[])ds);
            MessageDigest md = MessageDigest.getInstance("sha1");
            byte[] sha1 = md.digest(plain);
            ConsoleLogger.logBinary((String)"digest", (byte[])sha1);
            NetSignService s = NetSignService.getInstance("192.168.2.150", 40019, null);
            PBCAgent.initialize(new NetSignService[]{s});
            NetSignAgent.rawVerify(plain, signed, null, pk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testDetachedSign() {
        try {
            NetSignAgentRes.initConnections("192.168.2.150", 40019, 10, 0);
            NetSignResult result = NetSignAgent.detachedSignature("1111".getBytes(), null, null, false);
            ConsoleLogger.logBinary((String)"result", (byte[])result.getByteArrayResult("Base64_Signed_Text"));
            System.out.println(result.getStringResult("Base64_Signed_Text"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testGenCert() {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream("d:/TEMP/5year.cer");
                byte[] bs = new byte[in.available()];
                in.read(bs);
                X509Certificate cert = PBCAgent.generateCert(bs);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class TestConnectionPool
    implements Runnable {
        public void run() {
            try {
                while (true) {
                    PBCAgent.PBCRAWSignature("11111111".getBytes(), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

