/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.newcommunitor;

import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.logger.ConnectionLogger;
import cn.com.infosec.netsign.agent.newcommunitor.AgentCommunitor;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.agent.service.NSService;
import cn.com.infosec.netsign.agent.service.ServiceSelector;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.communication.multiple.MultiCommunicator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ThinCommunitor
implements AgentCommunitor {
    private NSService s;
    private Communicator conn;

    public ThinCommunitor(NSService s) throws NetSignAgentException {
        this.s = s;
        ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent connecting to ", "$SERVICE", "."}, s);
        this.openConnection();
    }

    public ThinCommunitor() {
    }

    public static void createThinCommunitor(ServiceSelector selector, ThinCommunitor tc) throws NetSignAgentException {
        NSService s = null;
        while ((s = selector.nextService()) != null) {
            try {
                tc.setService(s);
                return;
            }
            catch (NetSignAgentException e) {
                ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", e.toString(), "]."}, s);
            }
        }
        throw new NetSignAgentException(-1006, "all service are inavailable");
    }

    public NSService getService() {
        return this.s;
    }

    public void setService(NSService s) throws NetSignAgentException {
        this.s = s;
        ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent connecting to ", "$SERVICE", "."}, s);
        this.openConnection();
    }

    private void setPassword(NSMessage msg, NSService s) {
        if (s instanceof NSPSService) {
            NSPSService pss = (NSPSService)s;
            msg.setApiPasswd(pss.getApiPasswd());
        }
    }

    public synchronized NSMessageOpt sendMessage(NSMessage msg) throws NetSignAgentException {
        this.s.setLastTestTime(System.currentTimeMillis());
        this.setPassword(msg, this.s);
        NSMessageOpt res = null;
        try {
            this.conn.send((AbstractMessage)msg);
        }
        catch (IOException ioEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", ioEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-1003, ioEx.getMessage());
        }
        try {
            res = (NSMessageOpt)this.conn.recv();
        }
        catch (IOException ioEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent receive message failed from ", "$SERVICE", " caused by [", ioEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-1004, ioEx.getMessage());
        }
        catch (ClassNotFoundException clsEx) {
            throw new NetSignAgentException(-1005, clsEx.getMessage());
        }
        this.s.setStatus(true);
        return res;
    }

    public void openConnection() throws NetSignAgentException {
        this.s.addConnCount();
        try {
            InetSocketAddress isa = new InetSocketAddress(this.s.getIp(), this.s.getPort());
            Socket socket = new Socket();
            socket.setSoTimeout(this.s.getTimeout());
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 0);
            socket.connect(isa, this.s.getTimeout());
            this.conn = new MultiCommunicator(socket);
            ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent connecting to ", "$SERVICE", " successed."}, this.s);
        }
        catch (Exception ioEx) {
            this.s.reduceConnCount();
            this.s.setLastTestTime(System.currentTimeMillis());
            this.s.setStatus(false);
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", ioEx.toString(), "]."}, this.s);
            if (ioEx instanceof UnknownHostException) {
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            throw new NetSignAgentException(-1001, ioEx.getMessage());
        }
    }

    public void close() {
        try {
            if (!this.conn.isClosed()) {
                this.s.reduceConnCount();
            }
            ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent disconnect from ", "$SERVICE", "."}, this.s);
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

