/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.newcommunitor;

import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorPool;
import cn.com.infosec.netsign.agent.newcommunitor.ThinCommunitor;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.agent.service.NSService;
import cn.com.infosec.netsign.agent.service.ServiceList;
import cn.com.infosec.netsign.agent.service.ServiceManager;
import cn.com.infosec.netsign.agent.service.ServiceSelector;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;

public class CommunitorManager {
    private ThinCommunitor conn;
    private CommunitorPool pool;
    private static long lastCheck = 0L;
    private ServiceManager sm;

    public CommunitorManager(boolean isUsingCommonServicemanager) {
        if (NetSignAgentRes.isUseConnectionPool()) {
            this.pool = new CommunitorPool();
        }
        this.conn = new ThinCommunitor();
        this.sm = new ServiceManager(isUsingCommonServicemanager);
    }

    public void buildCommunitorPool() {
        if (this.pool != null && NetSignAgentRes.isUseConnectionPool()) {
            this.pool = new CommunitorPool();
        }
    }

    public void addService(NSService s) {
        this.sm.addService(s);
    }

    public void addService(NetSignService s) {
        this.sm.addService(s);
    }

    private void setPassword(NSMessage msg, NSService s) {
        if (s instanceof NSPSService) {
            NSPSService pss = (NSPSService)s;
            msg.setApiPasswd(pss.getApiPasswd());
        }
    }

    public NSMessageOpt[] sendAll(NSMessage msg) {
        ServiceList sl = this.sm.getInnerAllService();
        if (sl == null) {
            return new NSMessageOpt[0];
        }
        int size = sl.size();
        NSMessageOpt[] results = new NSMessageOpt[size];
        int i = 0;
        while (i < size) {
            block19: {
                NSService s = sl.getService(i);
                this.setPassword(msg, s);
                ThinCommunitor tc = null;
                try {
                    tc = new ThinCommunitor(s);
                    results[i] = tc.sendMessage(msg);
                }
                catch (NetSignAgentException e) {
                    NSMessageOpt tmpMsg;
                    if (tc != null) {
                        tc.close();
                    }
                    try {
                        Thread.sleep(50L);
                        if (tc == null) {
                            tc = new ThinCommunitor(s);
                        } else {
                            tc.openConnection();
                        }
                        results[i] = tc.sendMessage(msg);
                    }
                    catch (NetSignAgentException nsae) {
                        tmpMsg = new NSMessageOpt();
                        tmpMsg.setResult(e.getErrorCode());
                        tmpMsg.setErrMsg(e.getMessage());
                        results[i] = tmpMsg;
                    }
                    catch (Exception oe) {
                        tmpMsg = new NSMessageOpt();
                        tmpMsg.setResult(-9999);
                        tmpMsg.setErrMsg(oe.toString());
                        results[i] = tmpMsg;
                        e.printStackTrace();
                    }
                    if (tc != null) {
                        tc.close();
                    }
                    break block19;
                }
                catch (Exception e) {
                    try {
                        NSMessageOpt tmpMsg = new NSMessageOpt();
                        tmpMsg.setResult(-9999);
                        tmpMsg.setErrMsg(e.toString());
                        results[i] = tmpMsg;
                        e.printStackTrace();
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (tc != null) {
                            tc.close();
                        }
                    }
                }
                if (tc != null) {
                    tc.close();
                }
            }
            ++i;
        }
        return results;
    }

    public NSMessageOpt sendMessageUsingShrotConnection(NSMessage msg) throws NetSignAgentException {
        this.checkAllServices();
        NSMessageOpt resp = null;
        ServiceSelector selector = this.sm.select();
        ThinCommunitor tc = this.createNewThinCommunitor(selector);
        try {
            try {
                resp = tc.sendMessage(msg);
            }
            catch (Exception e) {
                tc.close();
                try {
                    tc.openConnection();
                    resp = tc.sendMessage(msg);
                }
                catch (Exception e2) {
                    tc.close();
                    selector = this.sm.select();
                    NSMessageOpt nSMessageOpt = this.sendMsgFailedHandle(msg, tc, selector);
                    tc.close();
                    return nSMessageOpt;
                }
                tc.close();
            }
        }
        finally {
            tc.close();
        }
        return resp;
    }

    public NSMessageOpt sendMessageUsingShrotConnection(NSMessage msg, int serviceIndex) throws NetSignAgentException {
        this.checkAllServices();
        NSMessageOpt resp = null;
        ThinCommunitor tc = new ThinCommunitor(this.sm.getAllService().getService(serviceIndex));
        try {
            try {
                resp = tc.sendMessage(msg);
            }
            catch (Exception e) {
                tc.close();
                tc.openConnection();
                resp = tc.sendMessage(msg);
                tc.close();
            }
        }
        finally {
            tc.close();
        }
        return resp;
    }

    public NSMessageOpt sendMessageUsingLongConnection(NSMessage msg) throws NetSignAgentException {
        this.checkAllServices();
        NSMessageOpt resp = null;
        ServiceSelector selector = this.sm.select();
        ThinCommunitor tc = this.getCommunitor(selector);
        try {
            try {
                resp = tc.sendMessage(msg);
            }
            catch (Exception e) {
                tc.close();
                try {
                    tc.openConnection();
                    resp = tc.sendMessage(msg);
                }
                catch (Exception e2) {
                    tc.close();
                    selector = this.sm.select();
                    NSMessageOpt nSMessageOpt = this.sendMsgFailedHandle(msg, tc, selector);
                    if (NetSignAgentRes.isUseConnectionPool()) {
                        this.pool.freeCommunitor(tc);
                    }
                    return nSMessageOpt;
                }
                if (NetSignAgentRes.isUseConnectionPool()) {
                    this.pool.freeCommunitor(tc);
                }
            }
        }
        finally {
            if (NetSignAgentRes.isUseConnectionPool()) {
                this.pool.freeCommunitor(tc);
            }
        }
        return resp;
    }

    private NSMessageOpt sendMsgFailedHandle(NSMessage msg, ThinCommunitor tc, ServiceSelector selector) throws NetSignAgentException {
        NSService s = null;
        while ((s = selector.nextService()) != null) {
            try {
                tc.setService(s);
                return tc.sendMessage(msg);
            }
            catch (Exception e) {
                tc.close();
            }
        }
        throw new NetSignAgentException(-1006, "all service are inavailable");
    }

    private ThinCommunitor getCommunitor(ServiceSelector selector) throws NetSignAgentException {
        if (NetSignAgentRes.isUseConnectionPool()) {
            return this.getPoolCommunitor(selector);
        }
        this.getThinCommunitor(selector);
        return this.conn;
    }

    private ThinCommunitor getPoolCommunitor(ServiceSelector selector) throws NetSignAgentException {
        int connMode = NetSignAgentRes.getConnectionMode();
        ThinCommunitor tc = this.pool.getCommunitor();
        if (tc.getService() != null) {
            NSService nss;
            if (connMode == 1 && (nss = selector.nextService()) != null && !nss.equals(tc.getService())) {
                tc.close();
                selector.reset();
                ThinCommunitor.createThinCommunitor(selector, tc);
            }
        } else {
            ThinCommunitor.createThinCommunitor(selector, tc);
        }
        return tc;
    }

    private void getThinCommunitor(ServiceSelector selector) throws NetSignAgentException {
        int connMode = NetSignAgentRes.getConnectionMode();
        if (this.conn != null && this.conn.getService() != null) {
            NSService nss;
            if (connMode == 1 && (nss = (selector = this.sm.select()).nextService()) != null && !nss.equals(this.conn.getService())) {
                this.conn.close();
                selector.reset();
                ThinCommunitor.createThinCommunitor(selector, this.conn);
            }
        } else {
            ThinCommunitor.createThinCommunitor(selector, this.conn);
        }
    }

    private ThinCommunitor createNewThinCommunitor(ServiceSelector selector) throws NetSignAgentException {
        int connMode = NetSignAgentRes.getConnectionMode();
        ThinCommunitor tc = new ThinCommunitor();
        ThinCommunitor.createThinCommunitor(selector, tc);
        return tc;
    }

    private synchronized void checkAllServices() {
        if (NetSignAgentRes.isAutoTest()) {
            long x = System.currentTimeMillis() - lastCheck;
            if (x < 0L) {
                x = 0L;
            }
            if (x >= NetSignAgentRes.getTestInterval()) {
                Thread t = new Thread(new ServiceTester());
                t.start();
                lastCheck = System.currentTimeMillis();
            }
        }
    }

    public void closeCommunitor() {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    class ServiceTester
    implements Runnable {
        ServiceTester() {
        }

        public void run() {
            NSMessage msg = NetSignAgentUtil.createMessage("HeartbeatProcessor");
            CommunitorManager.this.sendAll(msg);
        }
    }
}

