/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.communication;

import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.communication.APIToServer;
import cn.com.infosec.netsign.agent.communication.ConnectionPool;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Date;

class APIToServerPooledImpl
extends APIToServer {
    APIToServerPooledImpl() {
    }

    private ConnectionPool.PoolCommunicator getConnection() throws NetSignAgentException {
        try {
            return ConnectionPool.getInstance().getConnection();
        }
        catch (IOException ioEx) {
            ConsoleLogger.logException((Throwable)ioEx);
            if (ioEx instanceof UnknownHostException) {
                NetSignAgentUtil.debug(new Date() + " Get connection failed, " + "the error code is " + -1000 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            NetSignAgentUtil.debug(new Date() + " Get connection failed, " + "the error code is " + -1002 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1002, ioEx.getMessage());
        }
        catch (InterruptedException interEx) {
            NetSignAgentUtil.debug(new Date() + " Get connection failed, " + "the error code is " + -1002 + ", the error is " + interEx.getMessage(), null);
            throw new NetSignAgentException(-1002, interEx.getMessage());
        }
    }

    private ConnectionPool.PoolCommunicator newConnection() throws NetSignAgentException {
        try {
            return ConnectionPool.getInstance().newConnection();
        }
        catch (IOException ioEx) {
            if (ioEx instanceof UnknownHostException) {
                NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1000 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1001 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1001, ioEx.getMessage());
        }
    }

    private ConnectionPool.PoolCommunicator sendNew(AbstractMessage req) throws NetSignAgentException {
        ConnectionPool.PoolCommunicator comm = this.newConnection();
        try {
            comm.send(req);
            return comm;
        }
        catch (IOException ioEx) {
            NetSignAgentUtil.debug(new Date() + " Send message failed, " + "the error code is " + -1003 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1003, ioEx.getMessage());
        }
    }

    private AbstractMessage recv(ConnectionPool.PoolCommunicator comm) throws NetSignAgentException {
        try {
            return comm.recv();
        }
        catch (IOException ioEx) {
            ConsoleLogger.logException((Throwable)ioEx);
            NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1004 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1004, ioEx.getMessage());
        }
        catch (ClassNotFoundException clsEx) {
            NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1005 + ", the error is " + clsEx.getMessage(), null);
            throw new NetSignAgentException(-1005, clsEx.getMessage());
        }
    }

    public AbstractMessage sendAndRecv(AbstractMessage req) throws NetSignAgentException, ServerProcessException {
        ConnectionPool.PoolCommunicator comm = null;
        Object res = null;
        try {
            AbstractMessage msg;
            comm = this.getConnection();
            if (comm == null) {
                throw new NetSignAgentException(-1002, "Connection is null whitch created from the pool");
            }
            AbstractMessage abstractMessage = msg = this.sendAndRecv(req, comm);
            return abstractMessage;
        }
        finally {
            try {
                comm.close();
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
        }
    }

    public AbstractMessage sendAndRecv(AbstractMessage req, ConnectionPool.PoolCommunicator comm) throws NetSignAgentException, ServerProcessException {
        AbstractMessage res = null;
        NetSignAgentUtil.debug("Before Send message, the message content is ", req);
        try {
            comm.send(req);
        }
        catch (IOException ioEx1) {
            NetSignAgentUtil.debug(new Date() + " Send message failed, " + "it may be cause the socket " + "closed, we'll try it again.", null);
            comm.realyClose();
            comm = this.sendNew(req);
        }
        try {
            res = comm.recv();
        }
        catch (IOException ioEx3) {
            NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "it may be cause the socket " + "closed, we'll try it again.", null);
            comm.realyClose();
            comm = this.sendNew(req);
            res = this.recv(comm);
        }
        catch (ClassNotFoundException clsEx) {
            NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1005 + ", the error is " + clsEx.getMessage(), null);
            throw new NetSignAgentException(-1005, clsEx.getMessage());
        }
        NetSignAgentUtil.debug("After recieve message, the message content is ", res);
        this.checkResult(res);
        return res;
    }
}

