/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.communication;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.communication.APIToServerNonePoolImpl;
import cn.com.infosec.netsign.agent.communication.APIToServerPooledImpl;
import cn.com.infosec.netsign.agent.communication.ConnectionPool;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public abstract class APIToServer {
    public static final String SERVER_IP = "ip";
    public static final String SERVER_PORT = "port";
    public static final String WAIT_TIMEOUT = "timeout";
    public static final String CONNECT_TIMEOUT = "connecttimeout";
    public static final String MAX_CONN_NUMBER = "maxconn";
    public static final String IS_POOLED = "pooled";
    private static Properties connItem = null;
    private static String host = null;
    private static int port = 0;
    public static int timeout = 0;
    private static int connectTimeout = 0;
    private static int maxConnections = 50;
    private static boolean pooled = true;

    static String getHost() {
        return host;
    }

    static int getPort() {
        return port;
    }

    static int getTimeout() {
        return timeout;
    }

    static int getMaxConnectons() {
        return maxConnections;
    }

    static boolean isPooled() {
        return pooled;
    }

    static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void initConnections(Properties prop) throws NetSignAgentException {
        if (prop.containsKey(SERVER_IP)) {
            host = prop.getProperty(SERVER_IP);
        }
        pooled = new Boolean(prop.getProperty(IS_POOLED));
        try {
            if (prop.containsKey(SERVER_PORT)) {
                port = Integer.parseInt(prop.getProperty(SERVER_PORT));
            }
        }
        catch (NumberFormatException numEx) {
            throw new NetSignAgentException("Invalid ServerPort value: " + prop.getProperty(SERVER_PORT));
        }
        try {
            if (prop.containsKey(WAIT_TIMEOUT)) {
                timeout = Integer.parseInt(prop.getProperty(WAIT_TIMEOUT));
            }
        }
        catch (NumberFormatException numEx) {
            throw new NetSignAgentException("Invalid Timeout value: " + prop.getProperty(WAIT_TIMEOUT));
        }
        try {
            if (prop.containsKey(CONNECT_TIMEOUT)) {
                connectTimeout = Integer.parseInt(prop.getProperty(CONNECT_TIMEOUT));
            }
        }
        catch (NumberFormatException numEx) {
            throw new NetSignAgentException("Invalid Connect Timeout value: " + prop.getProperty(CONNECT_TIMEOUT));
        }
        if (APIToServer.isPooled()) {
            try {
                if (prop.containsKey(MAX_CONN_NUMBER)) {
                    maxConnections = Integer.parseInt(prop.getProperty(MAX_CONN_NUMBER));
                }
            }
            catch (NumberFormatException numEx) {
                throw new NetSignAgentException("Invalid MaxConnection number: " + prop.getProperty(MAX_CONN_NUMBER));
            }
        }
    }

    public static APIToServer getInstance() {
        if (APIToServer.isPooled()) {
            return new APIToServerPooledImpl();
        }
        return new APIToServerNonePoolImpl();
    }

    void checkResult(AbstractMessage res) throws ServerProcessException {
        if (res.getResult() < 0) {
            if (NetSignAgent.getDebugWriter() != null) {
                NetSignAgent.getDebugWriter().println(new Date() + " Server process failed, " + "the error code is " + res.getResult() + ", the error is " + res.getErrMsg());
            }
            throw new ServerProcessException(res.getResult(), res.getErrMsg());
        }
    }

    void close(Communicator comm) {
        if (comm != null) {
            try {
                comm.close();
            }
            catch (IOException eio) {
                ConsoleLogger.logException((Throwable)eio);
            }
        }
    }

    public abstract AbstractMessage sendAndRecv(AbstractMessage var1) throws NetSignAgentException, ServerProcessException;

    public abstract AbstractMessage sendAndRecv(AbstractMessage var1, ConnectionPool.PoolCommunicator var2) throws NetSignAgentException, ServerProcessException;
}

