/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.GenericCertificate;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.crypto.util.Base64;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RBCAgent {
    public boolean isDebug = false;
    private static Date now = null;
    private static SimpleDateFormat format = null;
    private byte[] pwd;
    private String ip;
    private int port;
    private Socket connection;
    private int timeout = 60000;
    private int returnCode = 1;
    private CommunitorManager cm = new CommunitorManager(false);

    static {
        now = new Date();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private void resetReturnCode() {
        this.returnCode = 1;
    }

    public void setOrderdn(int orderdn) {
        NetSignAgentRes.setOrderDN(orderdn);
    }

    public void setEncoding(String encoding) {
        NetSignAgentRes.setEncoding(encoding);
    }

    public void isDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static void setConnectionMode(int mode) {
        NetSignAgentRes.setConnectionMode(mode);
    }

    public static void setIsAutoTestServices(boolean on) {
        NetSignAgentRes.setAutoTest(on);
    }

    public static void setServiceTestInterval(long interval) {
        NetSignAgentRes.setTestInterval(interval);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void logString(String msg) {
        if (!this.isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    public void logException(Throwable e) {
        if (!this.isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println("An Exception catched:" + e.toString());
        System.out.println("Full stacktrace as below:");
        e.printStackTrace(System.out);
        System.out.flush();
        System.out.println("----------------------------------------------------------");
    }

    public void Connect(String ip, String port, String password) {
        if (ip.indexOf(",") < 0) {
            this.openSignServer(ip, Integer.parseInt(port), password);
        } else {
            String[] ips = ip.split(",");
            String[] ports = port.split(",");
            String[] passwords = password.split(",");
            int i = 0;
            int length = ips.length;
            while (i < length) {
                this.openSignServer(ips[i], Integer.parseInt(ports[i]), passwords[i]);
                ++i;
            }
        }
    }

    public boolean openSignServer(String ip, int port, String password) {
        this.logString("openSignServer{ip:" + ip + ";port:" + port + "}");
        this.ip = ip;
        this.port = port;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            this.pwd = md.digest(password.getBytes("GBK"));
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
        return this.openConnection();
    }

    private boolean openConnection() {
        this.resetReturnCode();
        this.logString("openConnection{}");
        try {
            try {
                InetSocketAddress ia = new InetSocketAddress(this.ip, this.port);
                this.connection = new Socket();
                this.connection.connect(ia, this.timeout);
                this.connection.setTcpNoDelay(true);
                this.connection.setSoTimeout(this.timeout);
                this.connection.setSoLinger(true, 0);
                this.connection.getOutputStream();
            }
            catch (Exception e) {
                this.returnCode = -1002;
                this.logException(e);
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception exception) {}
        }
        NSPSService s = new NSPSService();
        s.setIp(this.ip);
        s.setPort(this.port);
        s.setTimeout(this.timeout);
        s.setApiPasswd(this.pwd);
        this.cm.addService(s);
        return true;
    }

    public void Disconnect() {
        this.closeSignServer();
    }

    public boolean closeSignServer() {
        this.resetReturnCode();
        this.logString("closeSignServer{}");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cm.closeCommunitor();
        return true;
    }

    public GenericCertificate[] getGenericCertificate(String bankcode) {
        this.logString("getGenericCertificate{bankcode:" + bankcode + "}");
        this.resetReturnCode();
        NSMessage req = NetSignAgentUtil.createMessage("DownloadRAWCertProcessor");
        req.setSignCertDN(bankcode);
        NSMessageOpt result = this.sendMsg(req);
        if (result != null) {
            this.returnCode = result.getResult();
            this.logString("getGenericCertificate{returncode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = result.getCert();
                if (cert != null) {
                    return new GenericCertificate[]{new GenericCertificate(cert)};
                }
                this.logString("getGenericCertificate{no certificate found}");
            }
        } else {
            this.logString("getGenericCertificate{connect to server failed}");
        }
        return null;
    }

    public int IsCertExist(String dn) {
        if (this.getGenericCertificate(dn) != null) {
            return 1;
        }
        if (this.returnCode == -100205 || this.returnCode == -100224) {
            return 0;
        }
        return this.returnCode;
    }

    public Map getGenericCertificate() {
        this.logString("getGenericCertificate{}");
        this.resetReturnCode();
        HashMap<String, GenericCertificate[]> map = new HashMap<String, GenericCertificate[]>();
        NSMessage req = NetSignAgentUtil.createMessage("GetRAWCertListProcessor");
        req.setSignCertDN("all");
        NSMessageOpt result = this.sendMsg(req);
        if (result != null) {
            this.returnCode = result.getResult();
            this.logString("getGenericCertificate.getCertDNList{returncode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                String dns = result.getSignCertDN();
                if (dns == null || dns.equals("")) {
                    this.logString("getGenericCertificate.getCertDNList{no cert found}");
                    return null;
                }
                String[] pieces = dns.split("\\|");
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    GenericCertificate[] certs = this.getGenericCertificate(pieces[i]);
                    if (certs != null) {
                        map.put(certs[0].getBankcode(), certs);
                    }
                    ++i;
                }
                return map;
            }
            return null;
        }
        this.logString("getGenericCertificate.getCertDNList{connect to server failed}");
        return null;
    }

    public String rawSign(byte[] origBytes, String dn) {
        this.logString("rawSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        this.resetReturnCode();
        if (origBytes == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[] signed = res.getCryptoText();
                return Base64.encode((byte[])signed);
            }
            return null;
        }
        this.logString("rawSign{connect to server failed}");
        return null;
    }

    public String RawSign(String msg, String dn) {
        byte[] plain = null;
        if (NetSignAgentRes.getEncoding() != null && !"".equals(NetSignAgentRes.getEncoding())) {
            try {
                plain = msg.getBytes(NetSignAgentRes.getEncoding());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            plain = msg.getBytes();
        }
        return this.rawSign(plain, dn);
    }

    public boolean rawVerify(byte[] origBytes, String signedStr, String dn) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        this.resetReturnCode();
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("PBCRAWVerifyProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    public boolean RawVerify(String msg, String signData, String dn) {
        byte[] plain = null;
        if (NetSignAgentRes.getEncoding() != null && !"".equals(NetSignAgentRes.getEncoding())) {
            try {
                plain = msg.getBytes(NetSignAgentRes.getEncoding());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        } else {
            plain = msg.getBytes();
        }
        return this.rawVerify(plain, signData, dn);
    }

    public boolean rawVerifySimple(byte[] origBytes, String signedStr, String dn) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        this.resetReturnCode();
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("VerifyRawSignedValueProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    private String dettachedSign(byte[] origBytes, String dn) {
        this.logString("dettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        this.resetReturnCode();
        if (origBytes == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("dettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode((byte[])res.getCryptoText());
            }
            return null;
        }
        this.logString("dettachedSign{connect to server failed}");
        return null;
    }

    public String detachedSign(byte[] origBytes, String dn) {
        return this.dettachedSign(origBytes, dn);
    }

    public String DetachedSign(String msg, String dn) {
        byte[] plain = null;
        if (NetSignAgentRes.getEncoding() != null && !"".equals(NetSignAgentRes.getEncoding())) {
            try {
                plain = msg.getBytes(NetSignAgentRes.getEncoding());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            plain = msg.getBytes();
        }
        return this.dettachedSign(plain, dn);
    }

    private GenericCertificate dettachedVerify(byte[] origBytes, String signedStr) {
        this.logString("dettachedVerify{origBytes:" + origBytes + ";certStr:" + signedStr + "}");
        this.resetReturnCode();
        if (origBytes == null || signedStr == null || "".equals(signedStr)) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("dettachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = res.getCert();
                return new GenericCertificate(cert);
            }
            return null;
        }
        this.logString("dettachedVerify{connect to server failed}");
        return null;
    }

    public GenericCertificate detachedVerify(byte[] origBytes, String signedStr) {
        return this.dettachedVerify(origBytes, signedStr);
    }

    public GenericCertificate detachedVerify(String msg, String signedStr) {
        byte[] plain = null;
        if (NetSignAgentRes.getEncoding() != null && !"".equals(NetSignAgentRes.getEncoding())) {
            try {
                plain = msg.getBytes(NetSignAgentRes.getEncoding());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            plain = msg.getBytes();
        }
        return this.dettachedVerify(plain, signedStr);
    }

    private GenericCertificate dettachedVerifySimple(byte[] origBytes, String certStr) {
        this.logString("uploadCert{origBytes:" + origBytes + ";certStr:" + certStr + "}");
        this.resetReturnCode();
        NSMessage req = NetSignAgentUtil.createMessage("VerifyDetachedSignedValueProcessor");
        req.setPlainText(origBytes);
        req.setCryptoText(Base64.decode((String)certStr));
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return null;
        }
        this.returnCode = res.getResult();
        this.logString("dettachedVerifySimple{returnCode:" + this.returnCode + "}");
        if (this.returnCode < 0) {
            return null;
        }
        return new GenericCertificate(res.getCert());
    }

    public GenericCertificate detachedVerifySimple(byte[] origBytes, String certStr) {
        return this.dettachedVerifySimple(origBytes, certStr);
    }

    public int uploadCert(String bankcode, X509Certificate cert) {
        try {
            this.logString("uploadCert{bankcode:" + bankcode + ";cert:" + cert + "}");
        }
        catch (Exception e) {
            this.logString("uploadCert{bankcode:" + bankcode + ")");
        }
        this.resetReturnCode();
        if (cert == null) {
            return -1026;
        }
        String searchCode = bankcode == null || "".equals(bankcode) ? cert.getSubjectDN().getName() : bankcode;
        GenericCertificate[] certs = this.getGenericCertificate(searchCode);
        if (certs != null) {
            int i = 0;
            while (i < certs.length) {
                X509Certificate tmp = certs[i].getCert();
                if (Arrays.equals(tmp.getSignature(), cert.getSignature())) {
                    return 1;
                }
                ++i;
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankID(bankcode);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("uploadCert{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return 0;
            }
            return this.returnCode;
        }
        this.logString("uploadCert{connect to server failed}");
        return this.returnCode;
    }

    public int[] uploadCert2AllServices(String bankcode, X509Certificate cert) {
        try {
            this.logString("uploadCert{bankcode:" + bankcode + ";cert:" + cert + "}");
        }
        catch (Exception e) {
            this.logString("uploadCert{bankcode:" + bankcode + ")");
        }
        if (cert == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankID(bankcode);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public boolean checkCertChain(String dn) {
        this.logString("checkCertChain{certdn:" + dn + "}");
        this.resetReturnCode();
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertChainProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertChain{connect to server failed}");
            return false;
        }
        this.returnCode = res.getResult();
        this.logString("checkCertChain{returnCode:" + this.returnCode + "}");
        return this.returnCode >= 0;
    }

    public boolean checkCertCRL(String dn) {
        this.logString("checkCertCRL{certdn:" + dn + "}");
        this.resetReturnCode();
        NSMessage req = NetSignAgentUtil.createMessage("IsCertRevokedProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return false;
        }
        this.returnCode = res.getResult();
        this.logString("checkCertCRL{returnCode:" + this.returnCode + "}");
        return this.returnCode >= 0;
    }

    public int verifyCert(String dn) {
        this.logString("verifyCert{dn:" + dn + "}");
        this.resetReturnCode();
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("verifyCert{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return 0;
            }
            switch (this.returnCode) {
                case -100106: {
                    return 1;
                }
                case -100124: {
                    return 2;
                }
                case -100105: {
                    return 2;
                }
                case -100108: {
                    return 3;
                }
                case -100126: {
                    return 3;
                }
                case -100125: {
                    return 3;
                }
                case -100224: {
                    return 4;
                }
                case -100280: {
                    return 4;
                }
            }
            return this.returnCode;
        }
        this.logString("verifyCert{connect to server failed " + this.returnCode + " }");
        return this.returnCode;
    }

    public boolean deleteCert(String dn) {
        this.logString("deleteCert{dn:" + dn + "}");
        this.resetReturnCode();
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        req.setAPIPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("deleteCert{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("deleteCert{connect to server failed}");
        return false;
    }

    public int[] deleteCertFromAllServices(String dn) {
        this.logString("deleteCertFromAllServices{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    private NSMessageOpt sendMsg(NSMessage req) {
        try {
            return this.cm.sendMessageUsingLongConnection(req);
        }
        catch (NetSignAgentException e) {
            this.returnCode = e.getErrorCode();
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            this.returnCode = -9999;
            e.printStackTrace(System.out);
        }
        return null;
    }
}

