/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.GenericCertificate;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.crypto.util.Base64;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PBCAgent2G {
    public boolean isDebug = false;
    private static Date now = null;
    private static SimpleDateFormat format = null;
    private byte[] pwd;
    private String ip;
    private int port;
    private Socket connection;
    private int timeout = 60000;
    private int returnCode;
    private String encoding = null;
    private CommunitorManager cm = null;

    static {
        now = new Date();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static void setConnectionMode(int mode) {
        NetSignAgentRes.setConnectionMode(mode);
    }

    public static void setIsAutoTestServices(boolean on) {
        NetSignAgentRes.setAutoTest(on);
    }

    public static void setServiceTestInterval(long interval) {
        NetSignAgentRes.setTestInterval(interval);
    }

    public PBCAgent2G() {
        this.cm = new CommunitorManager(true);
    }

    public PBCAgent2G(boolean usingSingleServiceList) {
        this.cm = new CommunitorManager(usingSingleServiceList);
    }

    public boolean checkCertChain(String dn) {
        this.logString("checkCertChain{certdn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertChainProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return false;
        }
        this.returnCode = res.getResult();
        this.logString("checkCertChain{returnCode:" + this.returnCode + "}");
        return this.returnCode >= 0;
    }

    public boolean checkCertCRL(String dn) {
        this.logString("checkCertCRL{certdn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("IsCertRevokedProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return false;
        }
        this.returnCode = res.getResult();
        this.logString("checkCertCRL{returnCode:" + this.returnCode + "}");
        return this.returnCode >= 0;
    }

    public boolean closeSignServer() {
        this.logString("closeSignServer{}");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cm.closeCommunitor();
        return true;
    }

    public boolean deleteCert(String dn) {
        this.logString("deleteCert{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        req.setAPIPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("deleteCert{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("deleteCert{connect to server failed}");
        return false;
    }

    public int[] deleteCertFromAllServices(String dn) {
        this.logString("deleteCertFromAllServices{dn:" + dn + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(dn);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public String dettachedSign(byte[] origBytes, String dn) {
        this.logString("dettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("dettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode((byte[])res.getCryptoText());
            }
            return null;
        }
        this.logString("dettachedSign{connect to server failed}");
        return null;
    }

    public GenericCertificate dettachedVerify(byte[] origBytes, String signedStr) {
        this.logString("dettachedVerify{origBytes:" + origBytes + ";certStr:" + signedStr + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr)) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("dettachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = res.getCert();
                return new GenericCertificate(cert);
            }
            return null;
        }
        this.logString("dettachedVerify{connect to server failed}");
        return null;
    }

    public GenericCertificate dettachedVerifySimple(byte[] origBytes, String certStr) {
        this.logString("uploadCert{origBytes:" + origBytes + ";certStr:" + certStr + "}");
        NSMessage req = NetSignAgentUtil.createMessage("VerifyDetachedSignedValueProcessor");
        req.setPlainText(origBytes);
        req.setCryptoText(Base64.decode((String)certStr));
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res == null) {
            this.logString("checkCertCRL{connect to server failed}");
            return null;
        }
        this.returnCode = res.getResult();
        this.logString("dettachedVerifySimple{returnCode:" + this.returnCode + "}");
        if (this.returnCode < 0) {
            return null;
        }
        return new GenericCertificate(res.getCert());
    }

    public Map getGenericCertificate() {
        this.logString("getGenericCertificate{}");
        HashMap<String, GenericCertificate[]> map = new HashMap<String, GenericCertificate[]>();
        NSMessage req = NetSignAgentUtil.createMessage("GetRAWCertListProcessor");
        req.setSignCertDN("all");
        NSMessageOpt result = this.sendMsg(req);
        if (result != null) {
            this.returnCode = result.getResult();
            this.logString("getGenericCertificate.getCertDNList{returncode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                String dns = result.getSignCertDN();
                if (dns == null || dns.equals("")) {
                    this.logString("getGenericCertificate.getCertDNList{no cert found}");
                    return null;
                }
                String[] pieces = dns.split("\\|");
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    GenericCertificate[] certs = this.getGenericCertificate(pieces[i]);
                    if (certs != null) {
                        map.put(certs[0].getBankcode(), certs);
                    }
                    ++i;
                }
                return map;
            }
            return null;
        }
        this.logString("getGenericCertificate.getCertDNList{connect to server failed}");
        return null;
    }

    public GenericCertificate[] getGenericCertificate(String bankcode) {
        this.logString("getGenericCertificate{bankcode:" + bankcode + "}");
        NSMessage req = NetSignAgentUtil.createMessage("DownloadRAWCertProcessor");
        req.setSignCertDN(bankcode);
        NSMessageOpt result = this.sendMsg(req);
        if (result != null) {
            this.returnCode = result.getResult();
            this.logString("getGenericCertificate{returncode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = result.getCert();
                if (cert != null) {
                    return new GenericCertificate[]{new GenericCertificate(cert)};
                }
                this.logString("getGenericCertificate{no certificate found}");
            }
        } else {
            this.logString("getGenericCertificate{connect to server failed}");
        }
        return null;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void isDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void logException(Throwable e) {
        if (!this.isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println("An Exception catched:" + e.toString());
        System.out.println("Full stacktrace as below:");
        e.printStackTrace(System.out);
        System.out.flush();
        System.out.println("----------------------------------------------------------");
    }

    public void logString(String msg) {
        if (!this.isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    private boolean openConnection() {
        boolean connectionok;
        block11: {
            this.logString("openConnection{}");
            connectionok = true;
            try {
                try {
                    InetSocketAddress ia = new InetSocketAddress(this.ip, this.port);
                    this.connection = new Socket();
                    this.connection.connect(ia, this.timeout);
                    this.connection.setTcpNoDelay(true);
                    this.connection.setSoTimeout(this.timeout);
                    this.connection.setSoLinger(true, 0);
                }
                catch (Exception e) {
                    this.logException(e);
                    connectionok = false;
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NSPSService s = new NSPSService();
        s.setIp(this.ip);
        s.setPort(this.port);
        s.setTimeout(this.timeout);
        s.setApiPasswd(this.pwd);
        this.cm.addService(s);
        return connectionok;
    }

    public boolean openSignServer(String ip, int port, String password) {
        this.logString("openSignServer{ip:" + ip + ";port:" + port + "}");
        if (ip == null || "".equals(ip) || port < 0) {
            this.returnCode = -1025;
            return false;
        }
        this.ip = ip;
        this.port = port;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            this.pwd = md.digest(password.getBytes("GBK"));
        }
        catch (Exception e) {
            this.logException(e);
            return false;
        }
        return this.openConnection();
    }

    public boolean[] openSignServer(String ip, String port, String password) {
        this.logString("openSignServer{ip:" + ip + ";port:" + port + "}");
        if (ip == null || "".equals(ip) || port == null || "".equals(port)) {
            this.returnCode = -1025;
            return new boolean[1];
        }
        if (ip.indexOf(",") < 0) {
            boolean result = this.openSignServer(ip, Integer.parseInt(port), password);
            return new boolean[]{result};
        }
        String[] ips = ip.split(",");
        String[] ports = port.split(",");
        String[] passwords = password.split(",");
        boolean[] results = new boolean[ips.length];
        int i = 0;
        int length = ips.length;
        while (i < length) {
            boolean result;
            results[i] = result = this.openSignServer(ips[i], Integer.parseInt(ports[i]), passwords[i]);
            ++i;
        }
        return results;
    }

    public String rawSign(byte[] origBytes, String dn) {
        this.logString("rawSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                byte[] signed = res.getCryptoText();
                return Base64.encode((byte[])signed);
            }
            return null;
        }
        this.logString("rawSign{connect to server failed}");
        return null;
    }

    public boolean rawVerify(byte[] origBytes, String signedStr, String dn) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("PBCRAWVerifyProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    public boolean rawVerifySimple(byte[] origBytes, String signedStr, String dn) {
        this.logString("rawVerify{origBytes:" + origBytes + ";signedStr:" + signedStr + ";dn:" + dn + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr) || dn == null || "".equals(dn)) {
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("VerifyRawSignedValueProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("rawVerify{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("rawSign{connect to server failed}");
        return false;
    }

    private NSMessageOpt sendMsg(NSMessage req) {
        try {
            return this.cm.sendMessageUsingLongConnection(req);
        }
        catch (NetSignAgentException e) {
            this.returnCode = e.getErrorCode();
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            this.returnCode = -9999;
            e.printStackTrace(System.out);
        }
        return null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOrderdn(int orderdn) {
        NetSignAgentRes.setOrderDN(orderdn);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String unstandardDettachedSign(byte[] origBytes, String dn, String standard) {
        this.logString("unstandardDettachedSign{origBytes:" + origBytes + ";dn:" + dn + "}");
        if (origBytes == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedSignProcessor");
        req.setPlainText(origBytes);
        req.setSignCertDN(dn);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("unstandardDettachedSign{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode((byte[])res.getCryptoText());
            }
            return null;
        }
        this.logString("unstandardDettachedSign{connect to server failed}");
        return null;
    }

    public GenericCertificate unstandardDettachedVerify(byte[] origBytes, String signedStr, String standard) {
        this.logString("unstandardDettachedVerify{origBytes:" + origBytes + ";certStr:" + signedStr + "}");
        if (origBytes == null || signedStr == null || "".equals(signedStr)) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedVerifyProcessor");
        req.setCryptoText(Base64.decode((String)signedStr));
        req.setPlainText(origBytes);
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("unstandardDettachedVerify{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                X509Certificate cert = res.getCert();
                return new GenericCertificate(cert);
            }
            return null;
        }
        this.logString("unstandardDettachedVerify{connect to server failed}");
        return null;
    }

    public boolean uploadCert(String bankcode, X509Certificate cert) {
        try {
            this.logString("uploadCert{bankcode:" + bankcode + ";cert:" + cert + "}");
        }
        catch (Exception e) {
            this.logString("uploadCert{bankcode:" + bankcode + ")");
        }
        if (cert == null) {
            return false;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankID(bankcode);
        req.setApiPasswd(this.pwd);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("uploadCert{returnCode:" + this.returnCode + "}");
            return this.returnCode >= 0;
        }
        this.logString("uploadCert{connect to server failed}");
        return false;
    }

    public int[] uploadCert2AllServices(String bankcode, X509Certificate cert) {
        try {
            this.logString("uploadCert{bankcode:" + bankcode + ";cert:" + cert + "}");
        }
        catch (Exception e) {
            this.logString("uploadCert{bankcode:" + bankcode + ")");
        }
        if (cert == null) {
            return null;
        }
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankID(bankcode);
        NSMessageOpt[] resps = this.cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public String makeEnvelope(X509Certificate encCert, String sAlg, byte[] plainText) {
        NSMessage req = NetSignAgentUtil.createMessage("MakeEnvelopedMSGProcessor");
        req.setPlainText(plainText);
        req.setTransCert(true);
        try {
            req.setCert(NetSignAgentUtil.transcertificate(encCert));
        }
        catch (NetSignAgentException e) {
            req.setCert(encCert);
        }
        req.setSymmetricalAlg(sAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makeEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode((byte[])res.getCryptoText());
            }
            return null;
        }
        this.logString("makeEnvelope {connect to server failed}");
        return null;
    }

    public String makeEnvelope(byte[] plainText, String subject, String sAlg) {
        GenericCertificate[] certs = this.getGenericCertificate(subject);
        if (certs != null) {
            return this.makeEnvelope(certs[0].getCert(), sAlg, plainText);
        }
        return null;
    }

    public String makeMSEnvelope(String signSubject, X509Certificate encCert, String digestAlg, String sAlg, byte[] plainText) {
        NSMessage req = NetSignAgentUtil.createMessage("MakeMSEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        req.setPlainText(plainBytes);
        req.setTransCert(true);
        try {
            req.setCert(NetSignAgentUtil.transcertificate(encCert));
        }
        catch (NetSignAgentException e) {
            req.setCert(encCert);
        }
        req.setSignCertDN(signSubject);
        req.setSymmetricalAlg(sAlg);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("makeMSEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                return Base64.encode((byte[])res.getCryptoText());
            }
            return null;
        }
        this.logString("makeMSEnvelope {connect to server failed}");
        return null;
    }

    public String makeMSEnvelope(byte[] plainText, String signSubject, String encSubject, String digestAlg, String sAlg) {
        GenericCertificate[] certs = this.getGenericCertificate(encSubject);
        if (certs != null) {
            return this.makeMSEnvelope(signSubject, certs[0].getCert(), digestAlg, sAlg, plainText);
        }
        return null;
    }

    public Object[] decryptEnvelope(String encText, String subject) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoEnvelopedMSGProcessor");
        byte[] encBytes = null;
        encBytes = Base64.decode((String)encText);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                GenericCertificate genCert = new GenericCertificate();
                genCert.setSubject(res.getEncSubject());
                genCert.setSer_number(res.getEncSerNumber());
                genCert.setIssuer_subject(res.getEncIssuerSubject());
                genCert.setStart_time(res.getEncStartTime());
                genCert.setEnd_time(res.getEncEndtime());
                return new Object[]{Base64.encode((byte[])res.getPlainText()), genCert};
            }
            return null;
        }
        this.logString("decryptEnvelope {connect to server failed}");
        return null;
    }

    public Object[] decryptMSEnvelope(String encText, String subject) {
        return this.decryptMSEnvelope(encText, subject, null);
    }

    public Object[] decryptMSEnvelope(String encText, String subject, String digestAlg) {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoMSEnvelopedMSGProcessor");
        byte[] encBytes = Base64.decode((String)encText);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsg(req);
        if (res != null) {
            this.returnCode = res.getResult();
            this.logString("decryptMSEnvelope{returnCode:" + this.returnCode + "}");
            if (this.returnCode >= 0) {
                GenericCertificate genCertEnc = new GenericCertificate();
                genCertEnc.setSubject(res.getEncSubject());
                genCertEnc.setSer_number(res.getEncSerNumber());
                genCertEnc.setIssuer_subject(res.getEncIssuerSubject());
                genCertEnc.setStart_time(res.getEncStartTime());
                genCertEnc.setEnd_time(res.getEncEndtime());
                GenericCertificate genCertSign = new GenericCertificate();
                genCertSign.setSubject(res.getSignSubject());
                genCertSign.setSer_number(res.getSignSerNumber());
                genCertSign.setIssuer_subject(res.getSignIssuerSubject());
                genCertSign.setStart_time(res.getSignStartTime());
                genCertSign.setEnd_time(res.getSignEndtime());
                return new Object[]{Base64.encode((byte[])res.getPlainText()), genCertEnc, genCertSign};
            }
            return null;
        }
        this.logString("decryptMSEnvelope {connect to server failed}");
        return null;
    }
}

