/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.util.encoders.Base64;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class PBCAgent {
    private static CommunitorManager cm;
    public static final int BOND_OPTION_ADDITIONCERT = 1;
    public static final int BOND_OPTION_REVOKECERT = 2;
    public static final int DNORDER_NATIVE = 0;
    public static final int DNORDER_POSITIVE = 1;
    public static final int DNORDER_HTONL = 2;

    static {
        Security.insertProviderAt((Provider)new InfosecProvider(), 100);
        String prop = System.getProperty("cn.com.infosec.netsign.agent.servicetest.isautotest");
        if (prop != null) {
            if (prop.equals("yes")) {
                NetSignAgentRes.setAutoTest(true);
            } else {
                NetSignAgentRes.setAutoTest(false);
            }
        }
        if ((prop = System.getProperty("cn.com.infosec.netsign.agent.servicetest.interval")) != null) {
            try {
                long interval = Long.parseLong(prop);
                if (interval >= 0L) {
                    NetSignAgentRes.setTestInterval(interval);
                }
            }
            catch (Exception interval) {
                // empty catch block
            }
        }
        if ((prop = System.getProperty("cn.com.infosec.netsign.agent.connection.mode")) != null) {
            try {
                int mode = Integer.parseInt(prop);
                if (mode >= 0 && 4 - mode > 0) {
                    NetSignAgentRes.setConnectionMode(mode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setServiceTestInterval(long interval) {
        if (interval >= 0L) {
            NetSignAgentRes.setTestInterval(interval);
        }
    }

    public static void setServiceTestIsTest(boolean on) {
        NetSignAgentRes.setAutoTest(on);
    }

    public static void setConnectionMode(int mode) {
        NetSignAgentRes.setConnectionMode(mode);
    }

    public static int initialize(NetSignService[] services) {
        if (services == null || services.length == 0) {
            return -1026;
        }
        NetSignAgentRes.setUseConnectionPool(true);
        NetSignAgentRes.setMaxPoolSize(services[0].getPoolSize());
        cm = new CommunitorManager(false);
        int i = 0;
        int length = services.length;
        while (i < length) {
            cm.addService(services[i]);
            ++i;
        }
        NetSignAgent.cm = cm;
        ExtendedConfig.setEncoding((String)"GBK");
        return 1;
    }

    public static X509Certificate generateCert(byte[] cert) throws Exception {
        return NetSignAgent.generateCertificate(cert);
    }

    public static int[] uploadCert(String bankName, X509Certificate cert) {
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankName(bankName);
        NSMessageOpt[] resps = cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public static int[] uploadCert(String bankName, String bankID, X509Certificate cert) {
        NSMessage req = NetSignAgentUtil.createMessage("UploadRAWCertProcessor");
        req.setCert(cert);
        req.setBankName(bankName);
        req.setBankID(bankID);
        NSMessageOpt[] resps = cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public static int[] deleteCert(String certID) {
        NSMessage req = NetSignAgentUtil.createMessage("DeleteRAWCertProcessor");
        req.setSignCertDN(certID);
        NSMessageOpt[] resps = cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
            }
            ++i;
        }
        return results;
    }

    public static X509Certificate downloadCert(String certID) {
        NSMessage req = NetSignAgentUtil.createMessage("DownloadRAWCertProcessor");
        req.setSignCertDN(certID);
        try {
            NSMessageOpt result = PBCAgent.sendMsgAndCheck(req);
            return result.getCert();
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            return null;
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NetSignResult generateBondMsg(byte[] plainText, String signCertDN) {
        NetSignResult result = new NetSignResult();
        try {
            result = PBCAgent.PBCDetachedSignature(plainText, signCertDN);
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        return result;
    }

    public static NetSignResult PBCDetachedSignature(byte[] plainText, String subject) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        NSMessageOpt res = PBCAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        return result;
    }

    public static NetSignResult generateUnstandardBondMsg(byte[] plainText, String subject, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        NSMessageOpt res = PBCAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        return result;
    }

    public static NetSignResult verifyBondMsg(byte[] plainText, byte[] bondMsg) {
        NetSignResult result = new NetSignResult();
        try {
            result = NetSignAgent.detachedVerify(plainText, bondMsg, null, true);
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        return result;
    }

    public static NetSignResult verifyBondMsg(byte[] plainText, String bondMsgB64) {
        NetSignResult result = new NetSignResult();
        try {
            result = NetSignAgent.detachedVerify(plainText, bondMsgB64, null, true);
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        return result;
    }

    public static NetSignResult verifyUnstandardBondMsg(byte[] plainText, String bondMsgB64, String standard) {
        NetSignResult result = new NetSignResult();
        try {
            result = NetSignAgent.unstandardDetachedVerify(plainText, bondMsgB64, null, true, standard);
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        return result;
    }

    public static NetSignResult verifyBondMsg(byte[] plainText, String bondMsgB64, String bankName, String bankID, int option) {
        NetSignResult r;
        block4: {
            block5: {
                r = PBCAgent.verifyBondMsg(plainText, bondMsgB64);
                if (r.getResult() <= -1) break block4;
                if (option != 1) break block5;
                int[] results = PBCAgent.uploadCert(bankName, bankID, r.getSignCert());
                int i = 0;
                int length = results.length;
                while (i < length) {
                    if (results[i] < 0) {
                        r.setResult(results[i]);
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (option != 2) break block4;
            int[] results = PBCAgent.deleteCert(r.getSignCert().getSubjectDN().getName());
            int i = 0;
            int length = results.length;
            while (i < length) {
                if (results[i] < 0) {
                    r.setResult(results[i]);
                    break;
                }
                ++i;
            }
        }
        return r;
    }

    public static NetSignResult signMsg(byte[] plainText, String signCertDN) {
        NetSignResult result = new NetSignResult();
        try {
            result = PBCAgent.PBCRAWSignature(plainText, signCertDN);
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        return result;
    }

    public static NetSignResult PBCRAWSignature(byte[] plainText, String subject) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        NSMessageOpt res = PBCAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        return result;
    }

    public static NetSignResult verifyMsg(byte[] plainText, byte[] signedMsg, String signCertID) {
        NetSignResult result = new NetSignResult();
        NSMessage req = NetSignAgentUtil.createMessage("PBCRAWVerifyProcessor");
        try {
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            req.setCryptoText(signedMsg);
            req.setPlainText(plainText);
            req.setSignCertDN(signCertID);
            NSMessageOpt res = PBCAgent.sendMsgAndCheck(req);
            result = NetSignAgentUtil.rawVerifyResult(res);
            res = null;
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        req = null;
        return result;
    }

    public static NetSignResult verifyMsg(byte[] plainText, String signedMsgB64, String signCertID) {
        NetSignResult result = new NetSignResult();
        NSMessage req = NetSignAgentUtil.createMessage("PBCRAWVerifyProcessor");
        try {
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            req.setCryptoText(Base64.decode((byte[])signedMsgB64.getBytes()));
            req.setPlainText(plainText);
            req.setSignCertDN(signCertID);
            NSMessageOpt res = PBCAgent.sendMsgAndCheck(req);
            result = NetSignAgentUtil.rawVerifyResult(res);
            res = null;
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            result.setResult(e.getErrorCode());
        }
        req = null;
        return result;
    }

    public static int verifyMsg(byte[] plainText, byte[] sig, X509Certificate cert) {
        try {
            NetSignAgent.rawVerify(plainText, sig, null, cert);
            return 0;
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            return e.getErrorCode();
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            return e.getErrorCode();
        }
    }

    public static int verifyMsg(byte[] plainText, String sig, X509Certificate cert) {
        try {
            NetSignAgent.rawVerify(plainText, sig, null, cert);
            return 0;
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            return e.getErrorCode();
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            return e.getErrorCode();
        }
    }

    public static byte[] messageDigest(byte[] msg, String alg) {
        block4: {
            try {
                if (msg != null) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (alg == null || alg.equals("")) {
            alg = "SHA1";
        }
        MessageDigest md = MessageDigest.getInstance(alg, "INFOSEC");
        return md.digest(msg);
    }

    public static boolean verifyMessageDigest(byte[] msg, byte[] digest, String alg) {
        block4: {
            try {
                if (msg != null && digest != null) break block4;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (alg == null || alg.equals("")) {
            alg = "SHA1";
        }
        MessageDigest md = MessageDigest.getInstance(alg, "INFOSEC");
        byte[] dig = md.digest(msg);
        return Arrays.equals(dig, digest);
    }

    public static List getCertList(int service) {
        String dns;
        block7: {
            if (service < 0) {
                service = 0;
            }
            NSMessage req = NetSignAgentUtil.createMessage("GetRAWCertListProcessor");
            req.setSignCertDN("all");
            NSMessageOpt res = PBCAgent.sendMsgAndCheck(req, service);
            dns = res.getSignCertDN();
            if (dns != null && !dns.equals("")) break block7;
            return null;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            String[] pieces = dns.split("\\|");
            int i = 0;
            int length = pieces.length;
            while (i < length) {
                if (!pieces[i].trim().equals("")) {
                    list.add(pieces[i].trim());
                }
                ++i;
            }
            return list;
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            return null;
        }
        catch (ServerProcessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decodeBase64(String b64) {
        return Base64.decode((String)b64);
    }

    public static String encodeBase64(byte[] bs) {
        return new String(Base64.encode((byte[])bs));
    }

    public static void setDNOrder(int order) {
        NetSignAgentRes.setOrderDN(order);
    }

    static NSMessageOpt sendMsgAndCheck(NSMessage req, int serviceIndex) throws NetSignAgentException, ServerProcessException {
        NSMessageOpt resp = null;
        resp = cm.sendMessageUsingShrotConnection(req, serviceIndex);
        PBCAgent.checkResult((AbstractMessage)resp);
        return resp;
    }

    static NSMessageOpt sendMsgAndCheck(NSMessage req) throws NetSignAgentException, ServerProcessException {
        NSMessageOpt resp = null;
        resp = NetSignAgentRes.isUseConnectionPool() ? cm.sendMessageUsingLongConnection(req) : cm.sendMessageUsingShrotConnection(req);
        PBCAgent.checkResult((AbstractMessage)resp);
        return resp;
    }

    static void checkResult(AbstractMessage res) throws ServerProcessException {
        if (res.getResult() < 0) {
            if (NetSignAgent.getDebugWriter() != null) {
                NetSignAgent.getDebugWriter().println(new Date() + " Server process failed, " + "the error code is " + res.getResult() + ", the error is " + res.getErrMsg());
            }
            throw new ServerProcessException(res.getResult(), res.getErrMsg());
        }
    }
}

