/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCERSAPublicKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.jce.provider.X509CertificateObject;
import cn.com.infosec.jce.provider.X509CertificateObjectFX;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.FastPkcs7;
import cn.com.infosec.jce.provider.fastparser.Item;
import cn.com.infosec.netsign.agent.DNItemReverseUtil;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.processors.util.GZipUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class NetSignAgentUtil {
    static {
        if (Security.getProvider("INFOSEC") == null) {
            Security.addProvider((Provider)new InfosecProvider());
        }
    }

    public static X509Certificate getCertificateFromP7(String p7b) {
        return NetSignAgentUtil.getCertificateFromP7(Base64.decode((String)p7b));
    }

    public static X509Certificate getCertificateFromP7(byte[] p7b) {
        try {
            FastPkcs7 fxPKCS7 = new FastPkcs7();
            fxPKCS7.pkcs7SignedData(p7b);
            Item signCertItem = fxPKCS7.getSignCert();
            byte[] bsCert = DerUtil.getItemDataAndTag((byte[])p7b, (Item)signCertItem);
            return new X509CertificateObjectFX(bsCert);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public static byte[] xmlCanonical(byte[] xml) throws Exception {
        ByteArrayInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new ByteArrayInputStream(xml);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            DOMSource domSource = new DOMSource(doc.getDocumentElement());
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.transform(domSource, result);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static String encode(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }

    static byte[] decode(String text) throws NetSignAgentException {
        try {
            return Base64.decode((String)text);
        }
        catch (Exception e) {
            throw new NetSignAgentException(-1011, e.getMessage());
        }
    }

    public static NSMessage createMessage(String processor) {
        NSMessage req = new NSMessage();
        req.setType("request");
        req.setProcessor(processor);
        req.setClientId(NetSignAgentRes.getClientId());
        return req;
    }

    static byte[] checkOrZip(byte[] bytes, NSMessage req) throws NetSignAgentException {
        try {
            new GZIPInputStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            if (!e.getMessage().toLowerCase().startsWith("not in gzip format")) {
                throw new NetSignAgentException(-1014, e.getMessage());
            }
            return NetSignAgentUtil.checkAndZip(bytes, req);
        }
        req.setZipMode(true);
        return bytes;
    }

    static byte[] checkAndZip(byte[] bytes, NSMessage req) throws NetSignAgentException {
        if (NetSignAgentRes.isZipMode() && bytes.length >= NetSignAgentRes.getMinZipSize()) {
            req.setZipMode(true);
            try {
                return GZipUtil.zip((byte[])bytes);
            }
            catch (IOException e) {
                if (NetSignAgent.getDebugWriter() != null) {
                    NetSignAgent.getDebugWriter().println(new Date() + " Zip message failed, " + "the error code is " + -1012 + ", the error is " + e.getMessage());
                }
                throw new NetSignAgentException(-1012, e.getMessage());
            }
        }
        req.setZipMode(false);
        return bytes;
    }

    static byte[] checkAndEncrypt(byte[] bytes, NSMessage req) throws NetSignAgentException {
        if (NetSignAgentRes.getCommunicateMode() == 0) {
            req.setCommunicateMode(0);
            req.setEncKey(NetSignAgentRes.getEncSecKey());
            req.setKeyHash(NetSignAgentRes.getKeyHash());
            try {
                return SoftCryptoImpl.encrypt((int)SoftCryptoImpl.RC4, (byte[])NetSignAgentRes.getSecKey(), (byte[])bytes, null);
            }
            catch (Exception e) {
                if (NetSignAgent.getDebugWriter() != null) {
                    NetSignAgent.getDebugWriter().println(new Date() + " Encrypt message failed, " + "the error code is " + -1015 + ", the error is " + e.getMessage());
                }
                throw new NetSignAgentException(-1015, e.getMessage());
            }
        }
        req.setCommunicateMode(1);
        return bytes;
    }

    static byte[] checkAndDecrypt(byte[] bytes, int commMode) throws NetSignAgentException {
        if (commMode == 0) {
            try {
                return SoftCryptoImpl.decrypt((int)SoftCryptoImpl.RC4, (byte[])NetSignAgentRes.getSecKey(), (byte[])bytes, (byte[])"12345678".getBytes());
            }
            catch (Exception e) {
                if (NetSignAgent.getDebugWriter() != null) {
                    NetSignAgent.getDebugWriter().println(new Date() + " Decrypt message failed, " + "the error code is " + -1016 + ", the error is " + e.getMessage());
                }
                throw new NetSignAgentException(-1016, e.getMessage());
            }
        }
        return bytes;
    }

    static byte[] checkAndUnzip(byte[] bytes, boolean isZipped) throws NetSignAgentException {
        if (!isZipped) {
            return bytes;
        }
        try {
            return GZipUtil.unzip((byte[])bytes);
        }
        catch (IOException e) {
            if (NetSignAgent.getDebugWriter() != null) {
                NetSignAgent.getDebugWriter().println(new Date() + " Unzip message failed, " + "the error code is " + -1013 + ", the error is " + e.getMessage());
            }
            throw new NetSignAgentException(-1013, e.getMessage());
        }
    }

    static void checkAndSetTSA(String tsaText, NSMessage req) throws NetSignAgentException {
        if (tsaText == null) {
            req.setUsedTSA(false);
        } else {
            req.setUsedTSA(true);
            req.setTSAText(NetSignAgentUtil.decode(tsaText));
        }
    }

    static NetSignResult attachedVerifyResult(NSMessageOpt res) throws NetSignAgentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] plainText = NetSignAgentUtil.checkAndDecrypt(res.getPlainText(), res.getCommunicateMode());
        plainText = NetSignAgentUtil.checkAndUnzip(plainText, res.isZipMode());
        map.put("Result_Num", String.valueOf(res.getResult()));
        map.put("Byte_Array_Plain_Text", plainText);
        if (res.isTransCert()) {
            map.put("X509Certificate_Sign_Cert", res.getCert());
        }
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        map.put("Sign_Subject", res.getSignSubject());
        map.put("Sign_Ser_Number", res.getSignSerNumber());
        map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
        map.put("Sign_Start_Time", res.getSignStartTime());
        map.put("Sign_End_Time", res.getSignEndtime());
        if (res.getUsedTSA()) {
            map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        }
        return new NetSignResult(map);
    }

    static ArrayList pdfVerifyResult(NSMessageOpt res) {
        return res.getPDFVerifyResults();
    }

    static ArrayList xmlVerifyResult(NSMessageOpt res) {
        return res.getXmlVerifyResults();
    }

    static NetSignResult detachedVerifyResult(NSMessageOpt res) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (res.isTransCert()) {
            map.put("X509Certificate_Sign_Cert", res.getCert());
        }
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        map.put("Sign_Subject", res.getSignSubject());
        map.put("Sign_Ser_Number", res.getSignSerNumber());
        map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
        map.put("Sign_Start_Time", res.getSignStartTime());
        map.put("Sign_End_Time", res.getSignEndtime());
        if (res.getUsedTSA()) {
            map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        }
        return new NetSignResult(map);
    }

    static NetSignResult TSASigVerifyResult(NSMessageOpt res) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        return new NetSignResult(map);
    }

    static NetSignResult rawVerifyResult(NSMessageOpt res) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (res.getUsedTSA()) {
            map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        }
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        if (res.getProcessor().equals("PBCRAWVerifyProcessor")) {
            map.put("Sign_Subject", res.getSignSubject());
            map.put("Sign_Ser_Number", res.getSignSerNumber());
            map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
            map.put("Sign_Start_Time", res.getSignStartTime());
            map.put("Sign_End_Time", res.getSignEndtime());
        }
        return new NetSignResult(map);
    }

    static NetSignResult signatureResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        byte[] signText = NetSignAgentUtil.checkAndDecrypt(res.getCryptoText(), res.getCommunicateMode());
        signText = NetSignAgentUtil.checkAndUnzip(signText, res.isZipMode());
        map.put("Base64_Signed_Text", signText);
        if (res.getUsedTSA()) {
            map.put("Base64_TSA_Text", res.getTSAText());
        }
        return new NetSignResult(map);
    }

    static NetSignResult xmlSignatureResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] signText = NetSignAgentUtil.checkAndDecrypt(res.getCryptoText(), res.getCommunicateMode());
        signText = NetSignAgentUtil.checkAndUnzip(signText, res.isZipMode());
        map.put("Base64_Signed_Text", signText);
        map.put("Signature_Id", res.getXmlSigID());
        if (res.getUsedTSA()) {
            map.put("Base64_TSA_Text", res.getTSAText());
        }
        return new NetSignResult(map);
    }

    static NetSignResult pdfEncryptResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("Pdf_Encrypt_Text", res.getCryptoText());
        return new NetSignResult(map);
    }

    static NetSignResult pdfSignatureResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("Base64_Signed_Text", res.getCryptoText());
        return new NetSignResult(map);
    }

    static NetSignResult envelopeResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        byte[] cryptoText = NetSignAgentUtil.checkAndUnzip(res.getCryptoText(), res.isZipMode());
        map.put("Base64_Enveloped_Text", cryptoText);
        return new NetSignResult(map);
    }

    static NetSignResult decryptEnvelopeResult(NSMessageOpt res) throws NetSignAgentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] plainText = NetSignAgentUtil.checkAndDecrypt(res.getPlainText(), res.getCommunicateMode());
        plainText = NetSignAgentUtil.checkAndUnzip(plainText, res.isZipMode());
        map.put("Byte_Array_Plain_Text", plainText);
        map.put("Enc_Subject", res.getEncSubject());
        map.put("Enc_Ser_Number", res.getEncSerNumber());
        map.put("Enc_Issuer_Subject", res.getEncIssuerSubject());
        map.put("Enc_Start_Time", res.getEncStartTime());
        map.put("Enc_End_Time", res.getEncEndtime());
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        if (res.getSymmetricalAlg() != null) {
            map.put("Enc_Alg", res.getSymmetricalAlg());
        }
        if (res.getSignSubject() != null) {
            map.put("Sign_Subject", res.getSignSubject());
            map.put("Sign_Ser_Number", res.getSignSerNumber());
            map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
            map.put("Sign_Start_Time", res.getSignStartTime());
            map.put("Sign_End_Time", res.getSignEndtime());
        }
        return new NetSignResult(map);
    }

    static PublicKey transpublickey(PublicKey pubkey) throws NetSignAgentException {
        try {
            if (pubkey instanceof JCERSAPublicKey || pubkey instanceof JCESM2PublicKey || pubkey instanceof SM2PublicKey) {
                return pubkey;
            }
            RSAPublicKey rsapbkey = (RSAPublicKey)pubkey;
            return KeyFactory.getInstance("RSA", "INFOSEC").generatePublic(new RSAPublicKeySpec(rsapbkey.getModulus(), rsapbkey.getPublicExponent()));
        }
        catch (Exception ex) {
            throw new NetSignAgentException(ex.getMessage());
        }
    }

    static X509Certificate transcertificate(X509Certificate cert) throws NetSignAgentException {
        try {
            if (cert instanceof X509CertificateObject) {
                return cert;
            }
            ByteArrayInputStream binput = new ByteArrayInputStream(cert.getEncoded());
            return (X509Certificate)CertificateFactory.getInstance("X.509", "INFOSEC").generateCertificate(binput);
        }
        catch (Exception ex) {
            throw new NetSignAgentException(ex.getMessage());
        }
    }

    public static void debug(String msg, AbstractMessage am) {
        if (NetSignAgent.getDebugWriter() != null) {
            NetSignAgent.getDebugWriter().println(String.valueOf(msg) + (am != null ? am.getString() : ""));
        }
    }

    static String getDN(String dn) {
        if (dn == null || dn.equals("")) {
            return dn;
        }
        switch (NetSignAgentRes.getOrderDN()) {
            case 0: {
                return dn;
            }
            case 1: {
                if (DNItemReverseUtil.isDNReversed(dn)) {
                    return DNItemReverseUtil.reverse(dn);
                }
                return dn;
            }
            case 2: {
                if (dn.startsWith("CN=") || dn.startsWith("cn=")) {
                    return NetSignAgentUtil.turnDNString(dn);
                }
                return dn;
            }
        }
        return dn;
    }

    private static String turnDNString(String dn) {
        if (dn.indexOf(",") < 0) {
            return dn;
        }
        String split = dn.indexOf(", ") > -1 ? ", " : ",";
        String[] pieces = dn.split(split);
        String tmp = "";
        int i = pieces.length - 1;
        while (i >= 0) {
            tmp = String.valueOf(tmp) + pieces[i];
            if (i != 0) {
                tmp = String.valueOf(tmp) + split;
            }
            --i;
        }
        return tmp;
    }

    static NetSignResult barcodeResult(NSMessageOpt res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("BarCode_Symbology", res.getBcSymbology());
        return new NetSignResult(map);
    }

    public static byte[] digest(byte[] msg, String alg) {
        try {
            MessageDigest md = MessageDigest.getInstance(alg, "INFOSEC");
            return md.digest(msg);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    static byte[] getSignatureInPKCS7(byte[] p7, X509Certificate cert) {
        PublicKey k = cert.getPublicKey();
        if (k instanceof RSAPublicKey) {
            RSAPublicKey rsaK = (RSAPublicKey)k;
            int keyLength = rsaK.getModulus().bitLength() / 8;
            byte[] signed = new byte[keyLength];
            System.arraycopy(p7, p7.length - keyLength, signed, 0, keyLength);
            return signed;
        }
        int i = p7.length - 64;
        byte[] signed = null;
        boolean matched = false;
        while (i > 0) {
            if (p7[i] == 4) {
                int l = 0;
                if (p7[i + 1] == 81) {
                    l = 0xFF & p7[i + 2];
                    if (i + 2 + l == p7.length) {
                        matched = true;
                    }
                } else {
                    l = 0xFF & p7[i + 1];
                    if (i + 1 + l == p7.length) {
                        matched = true;
                    }
                }
                if (matched) {
                    signed = new byte[l];
                    System.arraycopy(p7, p7.length - l, signed, 0, l);
                    return signed;
                }
            }
            --i;
        }
        return null;
    }

    static void setVerifyResult(byte[] plainText, X509Certificate cert, boolean needCert, NetSignResult result) {
        if (plainText != null && plainText.length > 0) {
            result.setResult("Byte_Array_Plain_Text", plainText);
        }
        if (cert != null) {
            result.setResult("Sign_Subject", cert.getSubjectDN().getName());
            result.setResult("Sign_Ser_Number", cert.getSerialNumber().toString(16).toUpperCase());
            result.setResult("Sign_Issuer_Subject", cert.getIssuerDN().getName());
            result.setResult("Sign_Start_Time", String.valueOf(cert.getNotBefore().getTime()));
            result.setResult("Sign_End_Time", String.valueOf(cert.getNotAfter().getTime()));
            if (needCert) {
                result.setResult("X509Certificate_Sign_Cert", cert);
            }
        }
    }

    public static String dealSN(String sn) {
        switch (NetSignAgentRes.getSNMode()) {
            case 1: {
                sn = sn.length() % 2 == 0 ? sn : "0" + sn;
                return sn;
            }
            case 2: {
                BigInteger snbi = new BigInteger(sn, 16);
                return snbi.toString(10);
            }
        }
        return sn;
    }
}

