/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.AutoGC;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.communication.APIToServer;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.agent.service.NSService;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class NetSignAgentRes {
    private static ResourceBundle resBundle = null;
    static boolean hasDone = false;
    private static int communicateMode = 1;
    private static boolean zipMode = false;
    private static int minZipSize = 200;
    private static byte[] secKey = null;
    private static byte[] keyHash = null;
    private static byte[] encSecKey = null;
    private static String clientId = null;
    private static int seq = 0;
    private static String encoding;
    private static int orderDN;
    private static int snmode;
    public static final int CONNECTION_MODE_CONCENTRATE = 1;
    public static final int CONNECTION_MODE_HASH = 2;
    public static final int CONNECTION_MODE_ORDER = 3;
    public static final int CONNECTION_MODE_POLLING = 4;
    private static int connectionMode;
    private static boolean autoTest;
    private static long testInterval;
    private static boolean logConnection;
    private static boolean poolFlag;
    private static int maxPoolSize;
    private static int retryTimes;
    private static int retryInterval;

    static {
        orderDN = 0;
        snmode = 1;
        connectionMode = 1;
        autoTest = false;
        testInterval = 30000L;
        logConnection = false;
        poolFlag = false;
        maxPoolSize = 20;
        retryTimes = 1;
        retryInterval = 500;
        NetSignAgentRes.initNewConnectionParameters();
    }

    public static void initNewConnectionParameters() {
        String str = System.getProperty("cn.com.infosec.netsign.agent.servicetest.interval");
        if (str != null) {
            try {
                testInterval = Long.parseLong(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((str = System.getProperty("cn.com.infosec.netsign.agent.servicetest.isautotest")) != null) {
            autoTest = str.equals("yes");
        }
        if ((str = System.getProperty("cn.com.infosec.netsign.agent.connection.mode")) != null) {
            try {
                connectionMode = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static synchronized void initialize(ResourceBundle res) throws NetSignAgentException {
        if (!hasDone) {
            long gc;
            System.out.println("NetSignServerAPI initialize start...");
            if (resBundle == null) {
                resBundle = NetSignAgentRes.getResourceBundle(res);
            }
            NetSignAgentRes.initConnections();
            if (NetSignAgentRes.initPooledFlag().equals("true") && NetSignAgentRes.initHeartBeat()) {
                int n;
                int n2 = n = APIToServer.timeout == 0 ? 10000 : APIToServer.timeout / 2;
            }
            if ((gc = NetSignAgentRes.initGC()) != 0L) {
                AutoGC tgc = new AutoGC(gc);
                tgc.start();
            }
            clientId = NetSignAgentRes.initClientId();
            communicateMode = NetSignAgentRes.initCommunicateMode();
            zipMode = NetSignAgentRes.initZipMode();
            if (zipMode) {
                minZipSize = NetSignAgentRes.initMinZipSize();
            }
            if (communicateMode == 0) {
                NetSignAgentRes.initSecKey();
            }
            String string = encoding = NetSignAgentRes.initEncoding() != null && !"".equals(NetSignAgentRes.initEncoding()) ? NetSignAgentRes.initEncoding() : encoding;
            if (encoding == null || "".equals(encoding)) {
                ExtendedConfig.setEncoding((String)"GBK");
            } else {
                ExtendedConfig.setEncoding((String)encoding);
            }
            orderDN = NetSignAgentRes.initOrderDN();
            snmode = NetSignAgentRes.initSNMode();
            hasDone = true;
            System.out.println("NetSignServerAPI initialize finished...");
        }
    }

    static synchronized void initialize(NetSignService service) throws NetSignAgentException {
        if (!hasDone) {
            System.out.println("NetSignServerAPI initialize start...");
            NetSignAgentRes.initConnections(service.getHost(), service.getPort(), service.getPoolSize(), service.getTimeout());
            hasDone = true;
            System.out.println("NetSignServerAPI initialize finished...");
        }
    }

    private static String initServerIP() throws NetSignAgentException {
        try {
            return resBundle.getString("ServerIP").trim();
        }
        catch (MissingResourceException ex) {
            throw new NetSignAgentException("ServerIP can not be null");
        }
    }

    private static String initTimeout() throws NetSignAgentException {
        try {
            return resBundle.getString("Timeout").trim();
        }
        catch (Exception e) {
            return "30000";
        }
    }

    private static String initConnectTimeout() throws NetSignAgentException {
        try {
            return resBundle.getString("ConnectTimeout").trim();
        }
        catch (Exception e) {
            return "30000";
        }
    }

    private static String initServerPort() throws NetSignAgentException {
        try {
            return resBundle.getString("ServerPort").trim();
        }
        catch (MissingResourceException missEx) {
            throw new NetSignAgentException("ServerPort can not be null");
        }
    }

    private static int initCommunicateMode() throws NetSignAgentException {
        try {
            return Integer.parseInt(resBundle.getString("CommunicateMode").trim());
        }
        catch (MissingResourceException missEx) {
            throw new NetSignAgentException("CommunicateMode can not be null");
        }
        catch (NumberFormatException numEx) {
            throw new NetSignAgentException("Invalid CommunicateMode value");
        }
    }

    private static String initMaxConnections() throws NetSignAgentException {
        try {
            String max = resBundle.getString("MaxConnections").trim();
            maxPoolSize = Integer.parseInt(max);
            return max;
        }
        catch (MissingResourceException missEx) {
            maxPoolSize = 20;
            return "20";
        }
    }

    private static boolean initZipMode() throws NetSignAgentException {
        try {
            return Boolean.valueOf(resBundle.getString("ZipMode").trim());
        }
        catch (MissingResourceException missEx) {
            throw new NetSignAgentException("ZipMode can not be null");
        }
    }

    private static int initMinZipSize() throws NetSignAgentException {
        try {
            return 1024 * Integer.parseInt(resBundle.getString("MinZipSize").trim());
        }
        catch (MissingResourceException missEx) {
            throw new NetSignAgentException("MinZipSize can not be null");
        }
        catch (NumberFormatException numEx) {
            throw new NetSignAgentException("Invalid MinZipSize value");
        }
    }

    private static void initSecKey() throws NetSignAgentException {
        String certFile = null;
        try {
            certFile = resBundle.getString("ServerEncCert").trim();
        }
        catch (MissingResourceException missEx) {
            throw new NetSignAgentException("ServerEncCert can not be null");
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "INFOSEC");
            File file = new File(certFile);
            System.out.println("comm cert:" + certFile + " length:" + file.length());
            FileInputStream in = new FileInputStream(certFile);
            X509Certificate cert = (X509Certificate)factory.generateCertificate(in);
            in.close();
            secKey = SoftCryptoImpl.genSecretKey((int)SoftCryptoImpl.RC4, (int)128);
            keyHash = SoftCryptoImpl.hash((String)"SHA1", (byte[])secKey);
            encSecKey = SoftCryptoImpl.encryptWithRSAPubkey((PublicKey)cert.getPublicKey(), (byte[])secKey);
        }
        catch (FileNotFoundException fileEx) {
            throw new NetSignAgentException("Can not found cert file: " + certFile);
        }
        catch (Exception ex) {
            ConsoleLogger.logException((Throwable)ex);
            throw new NetSignAgentException("Generate SecKey Error: " + ex.getMessage());
        }
    }

    private static String initClientId() {
        try {
            return resBundle.getString("ClientID").trim();
        }
        catch (MissingResourceException missEx) {
            return null;
        }
    }

    private static String initPooledFlag() {
        try {
            String flag = resBundle.getString("UsedConnectionPool").trim();
            poolFlag = Boolean.valueOf(flag);
            return flag;
        }
        catch (Exception e) {
            poolFlag = false;
            return "false";
        }
    }

    private static void initConnections() throws NetSignAgentException {
        NetSignAgentRes.initPooledFlag();
        NetSignAgentRes.initMaxConnections();
        NetSignAgentRes.initConnectTimeout();
        NetSignAgentRes.initServiceTestIsTest();
        NetSignAgentRes.initConnectionMode();
        NetSignAgentRes.initConnectionLog();
        NetSignAgentRes.initServiceTestInterval();
        NetSignAgentRes.initRetryTimes();
        NetSignAgentRes.initRetryInerval();
        NetSignAgent.cm = new CommunitorManager(false);
        String ip = NetSignAgentRes.initServerIP();
        String port = NetSignAgentRes.initServerPort();
        String timeout = NetSignAgentRes.initTimeout();
        String[] ips = ip.split(",");
        String[] ports = port.split(",");
        String[] timeouts = timeout.split(",");
        int i = 0;
        while (i < ips.length) {
            NSService s = new NSService();
            s.setIp(ips[i].trim());
            s.setPort(Integer.parseInt(ports[i].trim()));
            s.setTimeout(Integer.parseInt(timeouts[i].trim()));
            NetSignAgent.cm.addService(s);
            ++i;
        }
    }

    private static void initConnectionLog() {
        try {
            String str = resBundle.getString("logconnection");
            if (str != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes"))) {
                logConnection = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initRetryTimes() {
        try {
            String str = resBundle.getString("retrytimes");
            if (str != null) {
                retryTimes = Integer.parseInt(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initRetryInerval() {
        try {
            String str = resBundle.getString("retryinterval");
            if (str != null) {
                retryInterval = Integer.parseInt(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initServiceTestIsTest() {
        try {
            String str = resBundle.getString("servicetestistest");
            if (str != null) {
                autoTest = "yes".equals(str.toLowerCase()) || "true".equals(str.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initServiceTestInterval() {
        try {
            String str = resBundle.getString("servicetestinterval");
            if (str != null) {
                try {
                    testInterval = Integer.parseInt(str);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initConnectionMode() {
        try {
            String str = resBundle.getString("connectionmode");
            connectionMode = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (connectionMode <= 0) {
            connectionMode = 3;
        }
    }

    private static boolean initHeartBeat() {
        try {
            String start = resBundle.getString("heartbeat").trim();
            return start.equals("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static long initGC() {
        try {
            String gc = resBundle.getString("gc").trim();
            return Long.parseLong(gc);
        }
        catch (Exception e) {
            return 60L;
        }
    }

    private static String initEncoding() {
        try {
            return resBundle.getString("encoding").trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int initOrderDN() {
        try {
            return Integer.parseInt(resBundle.getString("orderdn"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int initSNMode() {
        try {
            return Integer.parseInt(resBundle.getString("snmode"));
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static void initConnections(String ip, int port, int maxConns, int timeout) throws NetSignAgentException {
        if (!hasDone) {
            Properties p = new Properties();
            p.setProperty("ip", ip);
            p.setProperty("port", String.valueOf(port));
            p.setProperty("pooled", "true");
            if (maxConns < 1) {
                maxConns = 50;
            }
            p.setProperty("maxconn", String.valueOf(maxConns));
            if (timeout < 1) {
                timeout = 0;
            }
            p.setProperty("timeout", String.valueOf(timeout));
            APIToServer.initConnections(p);
            hasDone = true;
        }
    }

    public static void setClientId(String id) {
        clientId = id;
    }

    public static void setEncryptMode(String encCertFile) throws NetSignAgentException {
        communicateMode = 0;
        String certFile = encCertFile;
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "INFOSEC");
            File file = new File(certFile);
            FileInputStream in = new FileInputStream(certFile);
            X509Certificate cert = (X509Certificate)factory.generateCertificate(in);
            in.close();
            secKey = SoftCryptoImpl.genSecretKey((int)SoftCryptoImpl.RC4, (int)128);
            keyHash = SoftCryptoImpl.hash((String)"SHA1", (byte[])secKey);
            encSecKey = SoftCryptoImpl.encryptWithRSAPubkey((PublicKey)cert.getPublicKey(), (byte[])secKey);
        }
        catch (FileNotFoundException fileEx) {
            fileEx.printStackTrace();
            throw new NetSignAgentException("Can not found cert file: " + certFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NetSignAgentException("Generate SecKey Error: " + ex.getMessage());
        }
    }

    public static void setZipMode(int zipSize) {
        zipMode = true;
        if (zipSize > 1) {
            minZipSize = zipSize * 1024;
        }
    }

    static String getClientId() {
        return clientId;
    }

    static int getCommunicateMode() {
        return communicateMode;
    }

    static boolean isZipMode() {
        return zipMode;
    }

    static int getMinZipSize() {
        return minZipSize;
    }

    static byte[] getSecKey() {
        return secKey;
    }

    static byte[] getKeyHash() {
        return keyHash;
    }

    static byte[] getEncSecKey() {
        return encSecKey;
    }

    static int getOrderDN() {
        return orderDN;
    }

    static int getSNMode() {
        return snmode;
    }

    public static void setLogConnection(boolean on) {
        logConnection = on;
    }

    public static boolean isLogConnection() {
        return logConnection;
    }

    public static int getRetryTimes() {
        return retryTimes;
    }

    public static int getRetryInterval() {
        return retryInterval;
    }

    public static void setEncoding(String encoding) {
        NetSignAgentRes.encoding = encoding;
    }

    public static boolean isUseConnectionPool() {
        return poolFlag;
    }

    public static void setUseConnectionPool(boolean ispool) {
        poolFlag = ispool;
    }

    public static int getMaxPoolSize() {
        return maxPoolSize;
    }

    public static void setMaxPoolSize(int poolsize) {
        maxPoolSize = poolsize;
    }

    public static void setAutoTest(boolean isautotest) {
        autoTest = isautotest;
    }

    public static boolean isAutoTest() {
        return autoTest;
    }

    public static void setConnectionMode(int mode) {
        connectionMode = mode;
    }

    public static int getConnectionMode() {
        return connectionMode;
    }

    public static void setTestInterval(long interval) {
        testInterval = interval;
    }

    public static long getTestInterval() {
        return testInterval;
    }

    static void setOrderDN(int orderdn) {
        orderDN = orderdn;
    }

    static String getSeq() {
        ++seq;
        return String.valueOf((seq &= Integer.MAX_VALUE) % 100000 + 100000).substring(1);
    }

    public static String getEncoding() {
        return encoding;
    }

    private static ResourceBundle getResourceBundle(ResourceBundle res) throws NetSignAgentException {
        ResourceBundle bundle = null;
        System.out.println("vvvvvvvvvvvvvvvv NetSignAgent ENV vvvvvvvvvvvvvvvvv");
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL[] urls = ((URLClassLoader)cl).getURLs();
            if (urls != null) {
                int i = 0;
                int length = urls.length;
                while (i < length) {
                    System.out.println(urls[i].getFile());
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        System.out.println("^^^^^^^^^^^^^^^^^ NetSignAgent ENV ^^^^^^^^^^^^^^^^");
        try {
            bundle = res != null ? res : ResourceBundle.getBundle("netsignagent");
        }
        catch (Exception miss1ex) {
            miss1ex.printStackTrace(System.out);
            throw new NetSignAgentException("Can not Found Config File netsignagent.properties");
        }
        return bundle;
    }
}

