/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.frame.util.PBCUtil;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;

public class GenericCertificate {
    private String bankcode;
    private String subject;
    private String ser_number;
    private String issuer_subject;
    private String start_time;
    private String end_time;
    private X509Certificate cert;

    public GenericCertificate() {
    }

    public GenericCertificate(X509Certificate cert) {
        this.setCert(cert);
    }

    public String getBankcode() {
        return this.bankcode;
    }

    public void setBankcode(String bankcode) {
        this.bankcode = bankcode;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSer_number() {
        return this.ser_number;
    }

    public void setSer_number(String ser_number) {
        this.ser_number = ser_number;
    }

    public String getIssuer_subject() {
        return this.issuer_subject;
    }

    public void setIssuer_subject(String issuer_subject) {
        this.issuer_subject = issuer_subject;
    }

    public String getStart_time() {
        return this.start_time;
    }

    public void setStart_time(String start_time) {
        this.start_time = start_time;
    }

    public String getEnd_time() {
        return this.end_time;
    }

    public void setEnd_time(String end_time) {
        this.end_time = end_time;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public String getBase64Cert() {
        if (this.cert == null) {
            return null;
        }
        try {
            return Base64.encode((byte[])this.cert.getEncoded());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
        this.subject = NetSignAgentUtil.getDN(cert.getSubjectDN().toString());
        this.ser_number = NetSignAgentUtil.dealSN(cert.getSerialNumber().toString(16).toUpperCase());
        this.issuer_subject = NetSignAgentUtil.getDN(cert.getIssuerDN().toString());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.start_time = sdf.format(cert.getNotBefore());
        this.end_time = sdf.format(cert.getNotAfter());
        this.bankcode = PBCUtil.getBankID((String)this.subject);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("=============BEGIN GenericCertificate===================\n");
        s.append("bankCode:").append(this.bankcode).append("\n");
        s.append("issuerSubject:").append(this.issuer_subject).append("\n");
        s.append("serialNumber:").append(this.ser_number).append("\n");
        s.append("subject:").append(this.subject).append("\n");
        s.append("startTime:").append(this.start_time).append("\n");
        s.append("endTime:").append(this.end_time).append("\n");
        if (this.cert != null) {
            try {
                s.append("cert:").append(Base64.encode((byte[])this.cert.getEncoded())).append("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        s.append("=============END GenericCertificate=====================\n");
        return s.toString();
    }
}

