/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.asn1.x509.X509NameTokenizer;
import java.util.Stack;
import java.util.StringTokenizer;

public class DNItemReverseUtil {
    private static final String[] dNObjectsForward = new String[]{"1.2.840.113549.1.9.8", "1.2.840.113549.1.9.2", "emailaddress", "e", "email", "uid", "cn", "sn", "serialnumber", "gn", "givenname", "initials", "surname", "t", "ou", "o", "l", "st", "dc", "c"};
    private static final String[] dNObjectsReverse = new String[]{"c", "dc", "st", "l", "o", "ou", "t", "surname", "initials", "givenname", "gn", "serialnumber", "sn", "cn", "uid", "email", "e", "emailaddress", "1.2.840.113549.1.9.2", "1.2.840.113549.1.9.8"};
    private static final String[] dNObjects = dNObjectsForward;

    public static String reverse(String dn) {
        StringTokenizer st = new StringTokenizer(dn, ",");
        Stack<String> s = new Stack<String>();
        while (st.hasMoreTokens()) {
            s.push(st.nextToken());
        }
        int len = s.size();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append((String)s.pop());
            ++i;
        }
        return buffer.toString();
    }

    public static String reverseDN(String dn) {
        String ret = null;
        if (dn != null) {
            BasicX509NameTokenizer xt = new BasicX509NameTokenizer(dn);
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken();
                if (!first) {
                    buf.insert(0, ",");
                } else {
                    first = false;
                }
                buf.insert(0, o);
            }
            if (buf.length() > 0) {
                ret = buf.toString();
            }
        }
        return ret;
    }

    public static String reverseDN2(String dn) {
        if (dn == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String[] tmp = dn.split("(?<!\\\\)[,;]");
        int i = tmp.length - 1;
        while (i >= 0) {
            sb.append(tmp[i]);
            if (i > 0) {
                sb.append(",");
            }
            --i;
        }
        return sb.toString();
    }

    public static boolean isDNReversed(String dn) {
        boolean ret = false;
        if (dn != null) {
            String first = null;
            String last = null;
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            if (xt.hasMoreTokens()) {
                first = xt.nextToken();
            }
            while (xt.hasMoreTokens()) {
                last = xt.nextToken();
            }
            if (first != null && last != null) {
                first = first.substring(0, first.indexOf(61));
                last = last.substring(0, last.indexOf(61));
                int firsti = 0;
                int lasti = 0;
                int i = 0;
                while (i < dNObjects.length) {
                    if (first.toLowerCase().equals(dNObjectsForward[i])) {
                        firsti = i;
                    }
                    if (last.toLowerCase().equals(dNObjectsForward[i])) {
                        lasti = i;
                    }
                    ++i;
                }
                if (lasti < firsti) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        String dn = "e=god@613.com,o=infosec,cn=aa";
        System.out.println(DNItemReverseUtil.reverseDN(dn));
        System.out.println(DNItemReverseUtil.reverseDN2(dn));
    }

    private static class BasicX509NameTokenizer {
        private String oid;
        private int index;
        private StringBuffer buf = new StringBuffer();

        public BasicX509NameTokenizer(String oid) {
            this.oid = oid;
            this.index = -1;
        }

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            if (this.index == this.oid.length()) {
                return null;
            }
            int end = this.index + 1;
            boolean quoted = false;
            boolean escaped = false;
            this.buf.setLength(0);
            while (end != this.oid.length()) {
                char c = this.oid.charAt(end);
                if (c == '\"') {
                    if (!escaped) {
                        this.buf.append(c);
                        quoted = !quoted;
                    } else {
                        this.buf.append(c);
                    }
                    escaped = false;
                } else if (escaped || quoted) {
                    this.buf.append(c);
                    escaped = false;
                } else if (c == '\\') {
                    this.buf.append(c);
                    escaped = true;
                } else {
                    if (c == ',' && !escaped) break;
                    this.buf.append(c);
                }
                ++end;
            }
            this.index = end;
            return this.buf.toString().trim();
        }
    }
}

