/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import org.apache.commons.lang3.StringUtils;

public abstract class RangeValidatorSupport<T extends Comparable>
extends FieldValidatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RangeValidatorSupport.class);
    private final Class<T> type;
    private T min;
    private String minExpression;
    private T max;
    private String maxExpression;

    protected RangeValidatorSupport(Class<T> type) {
        this.type = type;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        T maxComparatorValue;
        Object obj = this.getFieldValue(this.getFieldName(), object);
        Comparable value = (Comparable)obj;
        if (value == null) {
            return;
        }
        T minComparatorValue = this.getMin();
        if (minComparatorValue != null && value.compareTo(minComparatorValue) < 0) {
            this.addFieldError(this.getFieldName(), object);
        }
        if ((maxComparatorValue = this.getMax()) != null && value.compareTo(maxComparatorValue) > 0) {
            this.addFieldError(this.getFieldName(), object);
        }
    }

    public void setMin(T min) {
        this.min = min;
    }

    public T getMin() {
        if (this.min != null) {
            return this.min;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.minExpression)) {
            return (T)((Comparable)this.parse(this.minExpression, this.type));
        }
        return null;
    }

    public void setMinExpression(String minExpression) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("${minExpression} was defined as [#0]", minExpression);
        }
        this.minExpression = minExpression;
    }

    public void setMax(T max) {
        this.max = max;
    }

    public T getMax() {
        if (this.max != null) {
            return this.max;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.maxExpression)) {
            return (T)((Comparable)this.parse(this.maxExpression, this.type));
        }
        return null;
    }

    public void setMaxExpression(String maxExpression) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("${maxExpression} was defined as [#0]", maxExpression);
        }
        this.maxExpression = maxExpression;
    }
}

