/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.classloader;

import com.opensymphony.xwork2.util.classloader.ResourceStore;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarResourceStore
implements ResourceStore {
    private static final Logger LOG = LoggerFactory.getLogger(JarResourceStore.class);
    private final File file;

    public JarResourceStore(File file) {
        this.file = file;
    }

    @Override
    public void write(String pResourceName, byte[] pResourceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(String pResourceName) {
        InputStream in = null;
        try {
            ZipFile jarFile = new ZipFile(this.file);
            ZipEntry entry = jarFile.getEntry(pResourceName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            in = jarFile.getInputStream(entry);
            JarResourceStore.copy(in, out);
            byte[] byArray = out.toByteArray();
            this.closeQuietly(in);
            return byArray;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to read file [#0] from [#1]", e, pResourceName, this.file.getName());
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.closeQuietly(in);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private void closeQuietly(InputStream is) {
        block3: {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unable to close input stream", e, new String[0]);
            }
        }
    }
}

