/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;

public class IntervalYM
extends Interval {
    protected long months;
    protected static final int MonthsPerYear = 12;

    public IntervalYM() throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
    }

    public IntervalYM(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
        this.set(timestamp, timestamp2);
    }

    public IntervalYM(int n, int n2) throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
        this.set(n, n2);
    }

    public IntervalYM(int n, short s) throws SQLException {
        this.setQualifier(s);
        this.months = n;
    }

    public IntervalYM(String string) throws SQLException {
        this.setQualifier((byte)6, (byte)0, (byte)2);
        this.set(string);
    }

    public IntervalYM(String string, short s) throws SQLException {
        this.setQualifier(s);
        this.set(string);
    }

    public IntervalYM(String string, int n, byte by, byte by2) throws SQLException {
        this.setQualifier((byte)n, by, by2);
        this.set(string);
    }

    public void set(Timestamp timestamp, Timestamp timestamp2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        gregorianCalendar2.setTime(timestamp2);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar2.get(1);
        int n3 = gregorianCalendar.get(2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = n - n2;
        int n6 = n3 - n4;
        this.set(n5, n6);
    }

    public void set(int n, int n2) {
        if (n < 0) {
            if (n2 > 0) {
                ++n;
                n2 -= 12;
            }
        } else if (n2 < 0 && n > 0) {
            --n;
            n2 += 12;
        }
        this.months = n2 + n * 12;
    }

    public void set(String string) throws SQLException {
        this.fromString(string);
    }

    public String toString() {
        String string;
        short s = this.getQualifier();
        byte by = Interval.getEndCode(s);
        byte by2 = Interval.getStartCode(s);
        long l = this.months;
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        if (by2 == 0 && by == 2) {
            String string2 = String.valueOf(l / 12L);
            String string3 = "";
            if (l % 12L < 10L) {
                string3 = "0";
            }
            string3 = String.valueOf(string3) + String.valueOf(l % 12L);
            string = String.valueOf(string2) + Interval.dtdelim[0] + string3;
        } else if (by2 == 0) {
            string = String.valueOf(l / 12L);
        } else if (by2 == 2) {
            string = String.valueOf(l);
        } else {
            throw new NumberFormatException("Invalid qualifier for IntervalYM");
        }
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            return;
        }
        short s = this.getQualifier();
        string = string.trim();
        boolean bl = false;
        if (string.length() > 0 && string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw IfxErrMsg.getSQLException(-79706, null);
            }
            bl = true;
            string = string.substring(1);
        }
        int[] nArray = this.stringToUnits(string, s);
        this.months = nArray[0] * 12 + nArray[1];
        if (bl) {
            this.months = -this.months;
        }
    }

    public long getMonths() {
        return this.months;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IntervalYM && object != null) {
            bl = this.months == ((IntervalYM)object).getMonths();
        }
        return bl;
    }

    public boolean greaterThan(IntervalYM intervalYM) {
        return intervalYM != null && this.months > intervalYM.getMonths();
    }

    public boolean lessThan(IntervalYM intervalYM) {
        return intervalYM != null && this.months < intervalYM.getMonths();
    }

    public void setQualifier(byte by, byte by2, byte by3) throws SQLException {
        if (by2 > 2 || by3 > 2 || by2 > by3) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = (short)(by3 - by2 + by << 8 | by2 << 4 | by3);
    }

    public void setQualifier(short s) throws SQLException {
        byte by = Interval.getStartCode(s);
        byte by2 = Interval.getEndCode(s);
        if (by > 2 || by2 > 2 || by > by2) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = s;
    }
}

