/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfmxSQLInput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

abstract class IfxSQLInput
implements IfmxSQLInput {
    protected IfxConnection conn;
    ByteArrayInputStream bStream;
    IfxDataInputStream is;
    private IfxMap map;
    protected boolean isNull = false;
    protected byte[] buf;
    protected int totalLength;
    protected int unreadLength;
    protected int currentPos;
    private int startPos;
    protected Trace trace;

    IfxSQLInput(IfxConnection ifxConnection, byte[] byArray, int n, int n2) throws SQLException {
        this.setConnection(ifxConnection);
        this.bStream = new ByteArrayInputStream(byArray, n, n2);
        this.is = new IfxDataInputStream(this.bStream);
        this.unreadLength = this.totalLength = n2;
        this.buf = byArray;
        this.startPos = n;
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
    }

    void setTypeMap(IfxMap ifxMap) {
        this.map = ifxMap;
    }

    byte[] toByteArray() throws SQLException {
        byte[] byArray = new byte[this.totalLength];
        System.arraycopy(this.buf, this.startPos, byArray, 0, this.totalLength);
        return byArray;
    }

    protected void skipBytes(int n) throws SQLException {
        try {
            this.is.skipBytes(n);
            return;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    protected int currentPosition() {
        return this.totalLength - this.bStream.available();
    }

    public int length() {
        return this.totalLength;
    }

    protected void reset() {
        this.bStream.reset();
        this.currentPos = 0;
    }

    protected void checkLength(int n) throws SQLException {
        if (this.unreadLength < n) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.unreadLength -= n;
    }

    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readString().", this.conn);
    }

    public boolean readBoolean() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBoolean().", this.conn);
    }

    public byte readByte() throws SQLException {
        return (byte)this.readShort();
    }

    public short readShort() throws SQLException {
        this.checkLength(2);
        this.isNull = false;
        try {
            short s = this.is.readShort();
            if (s == Short.MIN_VALUE) {
                this.isNull = true;
                s = 0;
            }
            this.currentPos += 2;
            return s;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public int readInt() throws SQLException {
        this.checkLength(4);
        this.isNull = false;
        try {
            int n = this.is.readInt();
            if (n == Integer.MIN_VALUE) {
                this.isNull = true;
                n = 0;
            }
            this.currentPos += 4;
            return n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public long readLong() throws SQLException {
        this.checkLength(10);
        this.isNull = false;
        try {
            long l = this.is.readLongInt();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 10;
            return l;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public float readFloat() throws SQLException {
        this.checkLength(4);
        byte[] byArray = new byte[4];
        this.isNull = true;
        try {
            this.bStream.read(byArray, 0, 4);
            this.currentPos += 4;
            this.isNull = IfxSmallFloat.isIfxNull(byArray);
            if (this.isNull) {
                return 0.0f;
            }
            return IfxToJavaType.IfxToJavaReal(byArray, (short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public double readDouble() throws SQLException {
        this.checkLength(8);
        byte[] byArray = new byte[8];
        this.isNull = true;
        try {
            this.bStream.read(byArray, 0, 8);
            this.isNull = IfxFloat.isIfxNull(byArray);
            if (this.isNull) {
                return 0.0;
            }
            return IfxToJavaType.IfxToJavaDouble(byArray, (short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public BigDecimal readBigDecimal() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBigDecimal().", this.conn);
    }

    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int n) throws SQLException {
        byte[] byArray;
        if (this.unreadLength < n) {
            n = this.unreadLength;
        }
        this.checkLength(n);
        try {
            byArray = new byte[n];
            this.is.readFully(byArray, 0, n);
            this.currentPos += n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return byArray;
    }

    public Date readDate() throws SQLException {
        this.checkLength(4);
        try {
            Date date = this.is.readDate();
            this.currentPos += 4;
            if (date == null) {
                this.isNull = true;
                return null;
            }
            return date;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public Time readTime() throws SQLException {
        try {
            Timestamp timestamp = this.readTimestamp();
            if (timestamp == null) {
                this.isNull = true;
                return null;
            }
            return new Time(((java.util.Date)timestamp).getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public Timestamp readTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readTimestamp().", this.conn);
    }

    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readCharacterStream().", this.conn);
    }

    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readAsciiStream().", this.conn);
    }

    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBinaryStream().", this.conn);
    }

    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readObject().", this.conn);
    }

    public boolean wasNull() {
        return this.isNull;
    }
}

