/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class IfxLobInputStream
extends InputStream {
    IfxConnection conn;
    IfxLocator locator;
    long lobSize;
    private int loFd;
    private IfxLocator loPtr;
    private IfxSmartBlob smb;
    byte[] buffer;
    int pos;
    int count;

    public IfxLobInputStream(IfxConnection ifxConnection, IfxLocator ifxLocator) throws IOException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        try {
            this.smb = new IfxSmartBlob(this.conn);
            this.loFd = this.smb.IfxLoOpen(this.locator, 4);
            this.lobSize = this.smb.IfxLoSize(this.loFd);
            return;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read() throws IOException {
        if (this.buffer == null || this.pos == this.count) {
            this.buffer = new byte[4096];
            this.count = this.readLob(this.buffer, 4096);
            if (this.count == -1) {
                return -1;
            }
            this.pos = 0;
        }
        if (this.pos < this.count) {
            return this.buffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.readLob(byArray, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, n, 0);
            return this.readLob(byArray, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public long skip(long l) throws IOException {
        try {
            return this.smb.IfxLoSeek(this.loFd, l, 1);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void reset() throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, 0L, 0);
            return;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return (int)this.lobSize;
    }

    public void close() throws IOException {
        try {
            this.smb.IfxLoClose(this.loFd);
            this.smb.IfxLoRelease(this.locator);
            return;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    protected void finalize() throws IOException {
    }

    private int readLob(byte[] byArray, int n) throws IOException {
        try {
            int n2 = this.smb.IfxLoRead(this.loFd, byArray, n);
            if (n2 == 0) {
                return -1;
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    protected InputStream getStream() throws SQLException {
        if (this.lobSize == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            this.reset();
        }
        catch (IOException iOException) {}
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.smb.IfxLoRead(this.loFd, (int)this.lobSize));
        return byteArrayInputStream;
    }
}

