/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.isag.util;

import cn.com.jshx.isag.EndReason;
import cn.com.jshx.isag.NotifySOAPHeader;
import cn.com.jshx.isag.RequestSOAPHeader;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.types.URI;

public class DecodeSoapHeader {
    private MessageContext context = null;
    private SOAPEnvelope requestEnvelope = null;
    private SOAPEnvelope responseEnvelope = null;
    private String namespace = "http://www.chinatelecom.com.cn/schema/ctcc/common/v2_1";

    public DecodeSoapHeader(MessageContext context) {
        try {
            this.context = context;
            this.requestEnvelope = context.getRequestMessage().getSOAPEnvelope();
            this.responseEnvelope = context.getResponseMessage().getSOAPEnvelope();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DecodeSoapHeader(Call call) {
        try {
            Message msg = call.getResponseMessage();
            this.requestEnvelope = msg.getSOAPEnvelope();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RequestSOAPHeader DecodeDownSoapHeader() {
        RequestSOAPHeader soapHeader = new RequestSOAPHeader();
        try {
            SOAPHeaderElement requestSequenceIdHeader = this.requestEnvelope.getHeaderByName("http://www.chinatelecom.com.cn/schema/ctcc/common/v2_1", "RequestSOAPHeader");
            Iterator iterator = requestSequenceIdHeader.getChildElements();
            while (iterator.hasNext()) {
                SOAPElement element = (SOAPElement)iterator.next();
                String elementName = element.getElementName().getLocalName();
                if (elementName.equals("spId")) {
                    soapHeader.setSpId(element.getValue());
                    continue;
                }
                if (elementName.equals("spPassword")) {
                    soapHeader.setSpPassword(element.getValue());
                    continue;
                }
                if (elementName.equals("productId")) {
                    soapHeader.setProductId(element.getValue());
                    continue;
                }
                if (elementName.equals("timeStamp")) {
                    soapHeader.setTimeStamp(element.getValue());
                    continue;
                }
                if (elementName.equals("SAN")) {
                    soapHeader.setSAN(element.getValue());
                    continue;
                }
                if (elementName.equals("FA")) {
                    soapHeader.setFA(new URI(element.getValue()));
                    continue;
                }
                if (elementName.equals("linkId")) {
                    soapHeader.setLinkId(element.getValue());
                    continue;
                }
                if (elementName.equals("OA")) {
                    soapHeader.setOA(new URI(element.getValue()));
                    continue;
                }
                if (elementName.equals("transactionId")) {
                    soapHeader.setTransactionId(element.getValue());
                    continue;
                }
                if (elementName.equals("multicastMessaging")) {
                    soapHeader.setMulticastMessaging(Boolean.valueOf(element.getValue()));
                    continue;
                }
                if (!elementName.equals("transEnd")) continue;
                soapHeader.setTransEnd(EndReason.fromString(element.getValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return soapHeader;
    }

    public NotifySOAPHeader DecodeUpSoapHeader() {
        NotifySOAPHeader soapHeader = new NotifySOAPHeader();
        try {
            SOAPHeaderElement requestSequenceIdHeader = this.requestEnvelope.getHeaderByName("http://www.chinatelecom.com.cn/schema/ctcc/common/v2_1", "NotifySOAPHeader");
            Iterator iterator = requestSequenceIdHeader.getChildElements();
            while (iterator.hasNext()) {
                SOAPElement element = (SOAPElement)iterator.next();
                String elementName = element.getElementName().getLocalName();
                if (elementName.equals("spRevId")) {
                    soapHeader.setSpRevId(element.getValue());
                    continue;
                }
                if (elementName.equals("spRevpassword")) {
                    soapHeader.setSpRevpassword(element.getValue());
                    continue;
                }
                if (elementName.equals("spId")) {
                    soapHeader.setSpId(element.getValue());
                    continue;
                }
                if (elementName.equals("SAN")) {
                    soapHeader.setSAN(element.getValue());
                    continue;
                }
                if (elementName.equals("linkId")) {
                    soapHeader.setLinkId(element.getValue());
                    continue;
                }
                if (!elementName.equals("transactionId")) continue;
                soapHeader.setTransactionId(element.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return soapHeader;
    }
}

