/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.isag.receive;

import cn.com.jshx.isag.DeliveryInformation;
import cn.com.jshx.isag.NotifySOAPHeader;
import cn.com.jshx.isag.SmsMessage;
import cn.com.jshx.isag.receive.interfaces.SmsNotification;
import cn.com.jshx.isag.util.DecodeSoapHeader;
import cn.com.jshx.isag.util.SmsStatus;
import cn.com.jshx.util.ISAGSenderMemory;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsNotificationBindingImpl
implements SmsNotification {
    private static final String notifySmsMsg = "=========\u8c03\u7528notifySmsReception\u63a5\u53e3===SpId = {0}; LinkId = {1}; Message = {2}; \u624b\u673a\u53f7 = {3}; \u63a5\u5165\u53f7 = {4}";
    private static final String notifySmsDeliveryMsg = "=========\u8c03\u7528notifySmsDeliveryStatus\u63a5\u53e3===correlator = {0}; Address = {1}; deliveryStatus = {2}";
    private static final Log logger = LogFactory.getLog(SmsNotificationBindingImpl.class);

    @Override
    public void notifySmsReception(String registrationIdentifier, SmsMessage message) throws RemoteException {
        MessageContext context = MessageContext.getCurrentContext();
        DecodeSoapHeader soapHeader = new DecodeSoapHeader(context);
        NotifySOAPHeader header = soapHeader.DecodeUpSoapHeader();
        String phoneNo = message.getSenderAddress().getSchemeSpecificPart();
        logger.info((Object)MessageFormat.format(notifySmsMsg, header.getSpId(), header.getLinkId(), message.getMessage(), message.getSenderAddress(), message.getSmsServiceActivationNumber()));
    }

    @Override
    public void notifySmsDeliveryReceipt(String correlator, DeliveryInformation deliveryStatus) throws RemoteException {
        String status = deliveryStatus.getDeliveryStatus().getValue();
        logger.info((Object)MessageFormat.format(notifySmsDeliveryMsg, correlator, deliveryStatus.getAddress(), status));
        int smsStatus = SmsStatus.getByDeliveryStatus(status).getSmsStatus();
        ISAGSenderMemory.getInstance().setResult(correlator, smsStatus);
    }
}

