package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.jshx.zzhxm.dao.ZzhxmJktzsHistoryDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmJktzsHistory;
import com.jshx.zzhxm.service.ZzhxmJktzsHistoryService;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmJktzsHistoryService")
public class ZzhxmJktzsHistoryServiceImpl extends BaseServiceImpl implements ZzhxmJktzsHistoryService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhxmJktzsHistoryDao")
	private ZzhxmJktzsHistoryDao zzhxmJktzsHistoryDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmJktzsHistoryDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmJktzsHistory getById(String id)
	{
		return zzhxmJktzsHistoryDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxmJktzs 信息
	 */
	@Transactional
	public void save(ZzhxmJktzsHistory zzhxmJktzsHistory)
	{
		zzhxmJktzsHistoryDao.save(zzhxmJktzsHistory);
	}

	/**
	 * 修改信息
	 * @param zzhxmJktzs 信息
	 */
	@Transactional
	public void update(ZzhxmJktzsHistory zzhxmJktzs)
	{
		zzhxmJktzsHistoryDao.update(zzhxmJktzs);
	}
	@Transactional
	@Override
	public void updateNotSave(ZzhxmJktzsHistory zzhxmJktzs)
	{
		zzhxmJktzsHistoryDao.update(zzhxmJktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmJktzsHistoryDao.findZzhxmJktzsHistory(paraMap);

		zzhxmJktzsHistoryDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmJktzsHistoryDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<ZzhxmJktzsHistory> findZzhxmJktzsHistory(Map<String, Object> paraMap) {

		return zzhxmJktzsHistoryDao.findZzhxmJktzsHistory(paraMap);

	}

	@Override
	public ZzhxmJktzsHistory getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		ZzhxmJktzsHistory zzhxmJktzsHistory = (ZzhxmJktzsHistory) zzhxmJktzsHistoryDao.findObjectByFieldsMap(ZzhxmJktzsHistory.class,paramMap);
		return zzhxmJktzsHistory;
	}

	@Override
	public ZzhxmJktzsHistory getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		ZzhxmJktzsHistory zzhxmJktzsHistory = (ZzhxmJktzsHistory) zzhxmJktzsHistoryDao.findObjectByFieldsMap(ZzhxmJktzsHistory.class,paramMap);
		return zzhxmJktzsHistory;
	}

	/**
	 * 根据缴款通知编号查询信息
	 * @param jktzsbh
	 */
	public ZzhxmJktzsHistory getByJktzsbh(String jktzsbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jktzsbh",jktzsbh);
		ZzhxmJktzsHistory zzhqfdz = (ZzhxmJktzsHistory) zzhxmJktzsHistoryDao.findObjectByFieldsMap(ZzhxmJktzsHistory.class,paramMap);
		return zzhqfdz;
	};
}
