package com.jshx.zzhqfdz.web;

import com.jshx.account.paymentVoucher.service.PaymentVoucherService;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.billManager.dao.BillManagerDao;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;
import com.jshx.billlq.entity.Billlq;
import com.jshx.billlq.service.BilllqService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.yzsjfhc.service.PaymentVerificationService;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhkppj.service.ZzhkppjService;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import com.neusoft.egov.utils.billendnumber;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.security.cert.CollectionCertStoreParameters;
import java.text.SimpleDateFormat;
import java.util.*;

public class ZzhkpAction extends BaseAction
{
	private static Logger logger = LoggerFactory.getLogger(ZzhkpAction.class);

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String jktzsbhVal;
	private String printNo;
	private List<Zzhqfdz> zzhqfdzsList = new ArrayList<>();
	List<ZzhxmSfxx> zzhxmsfxxList = new ArrayList<>();
	Map<String,List<Zzhkppj>> bankMap =  new LinkedHashMap();
	List<Zzhkppj> zzhkppjList = new ArrayList<>();

	String a ="";

	/**
	 * 实体类
	 */
	private Zzhqfdz zzhqfdz = new Zzhqfdz();
	private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
	private ZzhxmSfxx zzhxmSfxx = new ZzhxmSfxx();
	private PaymentVoucherHis paymentVoucherHis = new PaymentVoucherHis();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhqfdzService zzhqfdzService;
	@Autowired
	private ZzhxmJktzsService zzhxmJktzsService;
	@Autowired
	private ZzhxmSfxxService zzhxmSfxxService;
	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private PaymentItemPendingService paymentItemPendingService;
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private ZzhkppjService zzhkppjService;
	@Autowired
	private BilllqService billlqService;
	@Autowired
	private PaymentVoucherService paymentVoucherService;
	@Autowired
	private GenericManager genericManager;
	@Autowired()
	private BillManagerDao billManagerDao;
	@Autowired()
	private BillManagerService billManagerService;
	@Autowired()
	private PaymentVerificationService paymentVerificationService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;


	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;


	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzhxmJktzs){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhxmJktzs.getJfdmwybh()) && (0 < zzhxmJktzs.getJfdmwybh().trim().length())){
				paraMap.put("jfdmwybh", "%" + zzhxmJktzs.getJfdmwybh().trim() + "%");
			}
			if ((null != zzhxmJktzs.getAccountDetail()) && (0 < zzhxmJktzs.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhxmJktzs.getAccountDetail().trim() + "%");
			}
			if ((null != zzhxmJktzs.getJktzsbh()) && (0 < zzhxmJktzs.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhxmJktzs.getJktzsbh().trim() + "%");
			}
			if ((null != zzhxmJktzs.getNfkp()) && (0 < zzhxmJktzs.getNfkp().trim().length())){
				paraMap.put("nfkp", "%" + zzhxmJktzs.getNfkp().trim() + "%");
			}
			if ((null != zzhxmJktzs.getKpzt()) && (0 < zzhxmJktzs.getKpzt().trim().length())){
				paraMap.put("kpzt", "%" + zzhxmJktzs.getKpzt().trim() + "%");
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "";
		final String filter = "id|jfdmwybh|accountDetail|zzhhjdzje|jktzsbh|jftzyje|nfkp|kpzt|zbkp|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhxmJktzsService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}


	/**
	 *	根据缴款通知书编号获取缴款信息
	 */
	public void getJktzxx() throws Exception {
		BigDecimal bval= new BigDecimal("0");
		try{
			ZzhxmJktzs zzhxmJktzs =  zzhxmJktzsService.getByJktzsbh(jktzsbhVal);
			//获取子账户合计到账总金额
			Map<String, Object> paraMap = new HashMap<>();
			paraMap.put("jfdmwybh",zzhxmJktzs.getJfdmwybh());
			List<Zzhqfdz> zzhqfdzsList = zzhqfdzService.findZzhqfdz(paraMap);
			for(Zzhqfdz zzhqfdz1 : zzhqfdzsList){
				bval = bval.add(new BigDecimal(zzhqfdz1.getDbdzje()));
			}
			if(zzhxmJktzs != null){
				this.getResponse().getWriter().println("{\"result\":true,\"jfdmwybh\":\""+zzhxmJktzs.getJfdmwybh()+"\"," +
						"\"accountDetail\":\""+zzhxmJktzs.getAccountDetail()+"\"," +
						"\"jftzyje\":\""+zzhxmJktzs.getJftzyje()+"\"," +
						"\"zzhhjdzje\":\""+bval.toString()+"\"}");
			}else{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 	开票
	 */
	public String initEdit() throws Exception{
		if((null != zzhxmJktzs)&&(null != zzhxmJktzs.getId())){
			zzhxmJktzs = zzhxmJktzsService.getById(zzhxmJktzs.getId());
			Map<String, Object> paramMap = new HashMap<>();
			Map<String, Object> paramMap1 = new HashMap<>();
			String accountDetail = zzhxmJktzs.getAccountDetail();
			String jfdmwybh = zzhxmJktzs.getJfdmwybh();
			paramMap.put("jfdmwybh", jfdmwybh);
			zzhxmsfxxList = zzhxmSfxxService.findZzhxmSfxx(paramMap);
			for(ZzhxmSfxx zzhxmSfxx:zzhxmsfxxList){
				paramMap1.put("sfxmmc", zzhxmSfxx.getSfxmmc());
				paramMap1.put("accountDetail", accountDetail);
				String[] pjzts = {"0","1","3"};
				List pjztList=Arrays.asList(pjzts);
				paramMap1.put("pjzt", pjztList);//已到账
				zzhkppjList = zzhkppjService.findZzhkppjToZzhkp(paramMap1);
				if(CollectionUtils.isNotEmpty(zzhkppjList) || zzhkppjList.size() != 0) {
					bankMap.put(zzhxmSfxx.getSfxmmc(), zzhkppjList);
				}
			}
		}
		return EDIT;
	}

	/**
	 * 	暂不开票
	 */
	public String zwkp() throws Exception{
		try {
            zzhxmJktzs = zzhxmJktzsService.getById(ids);
//            zzhxmJktzs.setKpzt("1");
            zzhxmJktzs.setZbkp("1");
			zzhxmJktzs.setNfqf("1");
            zzhxmJktzsService.update(zzhxmJktzs);
//            this.getResponse().getWriter().println("{\"result\":"+true+"}");
            this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}


	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzhxmJktzs)&&(null != zzhxmJktzs.getId())){
			zzhxmJktzs = zzhxmJktzsService.getById(zzhxmJktzs.getId());
			Map<String, Object> paramMap = new HashMap<>();
			Map<String, Object> paramMap1 = new HashMap<>();
			String accountDetail = zzhxmJktzs.getAccountDetail();
			String jfdmwybh = zzhxmJktzs.getJfdmwybh();
			paramMap.put("jfdmwybh", jfdmwybh);
			zzhxmsfxxList = zzhxmSfxxService.findZzhxmSfxx(paramMap);
			for(ZzhxmSfxx zzhxmSfxx:zzhxmsfxxList){
				paramMap1.put("sfxmmc", zzhxmSfxx.getSfxmmc());
				paramMap1.put("accountDetail", accountDetail);
				String[] pjzts = {"0","1","3"};
				List pjztList=Arrays.asList(pjzts);
				paramMap1.put("pjzt", pjztList);//已到账
				zzhkppjList = zzhkppjService.findZzhkppjToZzhkp(paramMap1);
				if(CollectionUtils.isNotEmpty(zzhkppjList) || zzhkppjList.size() != 0) {
					bankMap.put(zzhxmSfxx.getSfxmmc(), zzhkppjList);
				}
			}
		}
		return VIEW;
	}

	// 更新开票票据号及时间
	public String zzhkpUpdateMsg() {
		if(CollectionUtils.isNotEmpty(zzhkppjList)) {
			for (Zzhkppj zzhkppj : zzhkppjList) {
				if (null == zzhkppj || StringUtils.isBlank(zzhkppj.getYbjksbh())) {
					continue;
				}
				Zzhkppj byId = zzhkppjService.getById(zzhkppj.getId());
				if (null == byId) {
					continue;
				}
				byId.setYbjksbh(zzhkppj.getYbjksbh());
				byId.setKprq(zzhkppj.getKprq());
				// 更新票据号并模拟票据领用发放功能插入billlq、等
				try {
//					zzhkppjService.update(byId);
					//模拟票据领取发放功能
					List<Indeticur>  list = new ArrayList<Indeticur>();
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					String startNo =zzhkppj.getYbjksbh();
					String endNo = zzhkppj.getYbjksbh();
					String uuid = UUID.randomUUID().toString().replaceAll("-", "");
					String no = zzhkppj.getYbjksbh();
					Indeticur indeticur = new Indeticur();
					indeticur.setDelFlag(0);
					indeticur.setIsrece(0);
					indeticur.setNo(no);
					indeticur.setIsprint("0");
					indeticur.setSort(0);
					indeticur.setRkTime(sdf.format(new Date()));
					indeticur.setSequenceID(uuid);

					indeticur.setIsrece(1);
					indeticur.setPerson(this.getLoginUser().getDisplayName());
					indeticur.setState("0");
					indeticur.setZsdw("市收费处");
					list.add(indeticur);
					// 批量插入indeticur然后更新billManager
					billManagerService.batchupdate(list);
					BillManager billManager = new BillManager();
//		billManager.setCount("1");
					billManager.setDeptId(this.getLoginUser().getDept().getId());
					billManager.setDelFlag(0);
					billManager.setEndno(endNo);
					billManager.setRktime(sdf.format(new Date()));
					billManager.setStartno(startNo);
					billManager.setSequentID(uuid);
					billManagerService.save(billManager);

					Billlq billlq = new Billlq();
					billlq.setCount("1");
					billlq.setPerson(this.getLoginUser().getDisplayName());
					billlq.setDeptId(this.getLoginUser().getDept().getId());
					billlq.setZsdw(this.getLoginUser().getDept().getDeptName());
					billlq.setDelFlag(0);
					billlq.setStartno(startNo);
					billlq.setEndno(endNo);
					billlq.setLqtime(sdf.format(new Date()));
					billlqService.save(billlq);
					zzhkppjService.update(byId);
				}catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return RELOAD;
	}



	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 校验票据号
	 * @return
	 */
	public String checkNoValid() throws Exception{
		try{
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("no",printNo);
			Indeticur indeticur = billManagerDao.findIndeticurByNo(paraMap);
			if(null == indeticur){
				this.getResponse().getWriter().println("{\"result\":false}");
			}else if("1".equals(indeticur.getIsprint())){
				this.getResponse().getWriter().println("{\"result\":false}");
			}else {
				this.getResponse().getWriter().println("{\"result\":true}");
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}



	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}
		if ("mod".equalsIgnoreCase(this.flag)){
			try {
				String[] sfxxId = zzhxmSfxx.getId().split(",");
				List<String> sfxxIdList = Arrays.asList(sfxxId);
				ZzhxmSfxx zzhxmSfxxRes = new ZzhxmSfxx();
				for(int i=0;i<sfxxIdList.size();i++){
					ZzhxmSfxx zzhxmSfxx1 = new ZzhxmSfxx();
					String sid = sfxxIdList.get(i).trim();
					zzhxmSfxx1 = zzhxmSfxxService.getById(sid);
					if("城市基础设施配套费".equals(zzhxmSfxx1.getSfxmmc())){
						zzhxmSfxxRes = zzhxmSfxx1;
					}
				}
				if(null  !=  zzhxmSfxxRes.getJfdmwybh()) {
					Map<String, Object> paMap = new HashMap<>();
					paMap.put("jfdmwybh", zzhxmSfxxRes.getJfdmwybh());
					List<Zzhkppj> zzhkppjList = zzhkppjService.findZzhkppj(paMap);

					PaymentItemPending paymentItemPending = new PaymentItemPending();
					for (int i = 0; i < zzhkppjList.size(); i++) {
						Jktzs jktzs1 = new Jktzs();

						//打通一站式收费的配套费征收与原系统配套费征收（先根据收费项目联系单编号即缴款通知书中的电子编号，去PAYMENT_ITEM_PENDING查到受理编号）
						if ("城市基础设施配套费".equals(zzhkppjList.get(i).getSfxmmc())) {
							PaymentItemHis paymentItemHis = new PaymentItemHis();
							Map<String, Object> paramMap1 = new HashMap<>();
							Map<String, Object> paramMap2 = new HashMap<>();
							Map<String, Object> paramMap3 = new HashMap<>();
							Xmxxb xmxxb1 = new Xmxxb();
//						paramMap1.put("dzbh","jk0sf00036");
							//一站式配套费与原系统缴费凭证打通
							paramMap1.put("dzbh", zzhxmSfxxRes.getSfxmlxdbh());
							List<Jktzs> jktzsList = jktzsService.findByAll(paramMap1);
							if (CollectionUtils.isNotEmpty(jktzsList)) {
								jktzs1 = jktzsList.get(0);
								paramMap2.put("slbh", jktzs1.getSlbh());
								List<PaymentItemPending> paymentItemPendingList = paymentItemPendingService.findPaymentItemPending(paramMap2);
								if (CollectionUtils.isNotEmpty(paymentItemPendingList)) {
									paymentItemPending = paymentItemPendingList.get(0);
//									if (new BigDecimal(zzhxmSfxxRes.getYjjemx()).stripTrailingZeros().toPlainString().equals(new BigDecimal(paymentItemPending.getPtyjje()).stripTrailingZeros().toPlainString())) {
										ZzhxmJktzs zzhxmJktzs2 = new ZzhxmJktzs();
										zzhxmJktzs2 = zzhxmJktzsService.getByJfdmwybh(zzhxmSfxxRes.getJfdmwybh());
										paymentItemHis.setDeptId(this.getLoginUserDepartmentId());
										paymentItemHis.setDelFlag(0);
										paymentItemHis.setDwdm(paymentItemPending.getDwdm());
										paymentItemHis.setPrintFlag("YES");
										paymentItemHis.setIsPrintJfpz("0");
										paymentItemHis.setNonTaxStatus("0");
										paymentItemHis.setMjyj(paymentItemPending.getMjyj());//面积依据
										paymentItemHis.setDkxmslh(paymentItemPending.getDkxmslh());//抵扣项目受理号
										paymentItemHis.setDkmj(paymentItemPending.getDkmj());//抵扣面积
										paymentItemHis.setCsmj(paymentItemPending.getCsmj());//测算面积
										paymentItemHis.setPtyjmj(paymentItemPending.getPtyjmj());//配套费应缴面积
										paymentItemHis.setPtymje(paymentItemPending.getPtymje());//配套费应免金额
										paymentItemHis.setPtymmj(paymentItemPending.getPtymmj());//配套费应免面积
										paymentItemHis.setRfyjmj(paymentItemPending.getRfyjmj());//人防应缴面积
										paymentItemHis.setRfyjje(paymentItemPending.getRfyjje());//人防应缴金额
										paymentItemHis.setRfymmj(paymentItemPending.getRfymmj());//人防应免面积
										paymentItemHis.setRfymje(paymentItemPending.getRfymje());//人防应免金额
										paymentItemHis.setXqyjje(paymentItemPending.getXqyjje());//新墙应缴金额
										paymentItemHis.setXqymmj(paymentItemPending.getXqymmj());//新墙应免面积
										paymentItemHis.setXqymje(paymentItemPending.getXqymje());//新墙应免金额
										paymentItemHis.setXqyjmj(paymentItemPending.getXqyjmj());//新墙应缴面积
										paymentItemHis.setByyjmj(paymentItemPending.getByyjmj());//白蚁应缴面积
										paymentItemHis.setByyjje(paymentItemPending.getByyjje());//白蚁应缴金额
										paymentItemHis.setByymmj(paymentItemPending.getByymmj());//白蚁应免面积
										paymentItemHis.setByymje(paymentItemPending.getByymje());//白蚁应免金额
										paymentItemHis.setZymje(paymentItemPending.getZymje());//总应免金额
										paymentItemHis.setWarnFlag(paymentItemPending.getWarnFlag());//催缴标识

										paramMap3.put("slbh", jktzs1.getSlbh());
										List<Xmxxb> xmxxbList = xmxxbService.findXmxxb(paramMap3);
										if (CollectionUtils.isNotEmpty(xmxxbList)) {
											xmxxb1 = xmxxbList.get(0);
											xmxxb1.setIsyjkrk("0");
											xmxxbService.update(xmxxb1);
											paymentItemHis.setXmbzj(xmxxb1.getId());
											String ECN = "PZ" + xmxxb1.getBllb() + xmxxb1.getDwdm().toUpperCase() + genericManager.getSN("dzpz");
											paymentItemHis.setECN(ECN);
										}
										paymentItemHis.setDwmc(zzhxmJktzs2.getJsdwmc());//建设单位名称
										paymentItemHis.setXmmc(zzhxmJktzs2.getGcxmmc());//工程项目名称
										paymentItemHis.setSlbh(jktzs1.getSlbh());//受理编号
										paymentItemHis.setZsdw(paymentItemPending.getZsdw());//征收单位
										paymentItemHis.setPtyjje(zzhxmSfxxRes.getYjjemx());//配套费应缴金额
										paymentItemHis.setPtyjmj(paymentItemPending.getPtyjmj());//配套费应缴面积
										paymentItemHis.setZyjje(zzhxmSfxxRes.getYjjemx());//总应缴金额
										// 2020-9-10 start 插入默认上锁, 在项目解锁列表展示 ------------
										// 解锁过滤条件是金额为零则不判断，不为零时，则加上锁住标志
//										if (!(new BigDecimal(zzhxmSfxxRes.getYjjemx()).stripTrailingZeros().toPlainString().equals(new BigDecimal(paymentItemPending.getPtyjje()).stripTrailingZeros().toPlainString()))) {
											paymentItemHis.setLockFlag("1");
//										}
										// 2020-9-10 end --------------------------------------------
										paymentItemHis.setYzsFlag(1); // 2022-1-17区分一站式还是原配套费系统生成的
										paymentItemHis.setJbr(this.getLoginUser().getDisplayName());
										paymentItemHisService.save(paymentItemHis);

//									}
								}
							}

							//一站式配套费与原系统票据缴销打通
							paymentVoucherHis.setDelFlag(0);
							paymentVoucherHis.setDeptId(this.getLoginUserDepartmentId());
							paymentVoucherHis.setOperator(this.getLoginUser().getDisplayName());
							paymentVoucherHis.setPrintDate(new Date());
							paymentVoucherHis.setAmount(zzhxmSfxxRes.getYjjemx());
							paymentVoucherHis.setSkrzh(zzhxmSfxxRes.getSkrzh());
							paymentVoucherHis.setQhm(zzhxmSfxxRes.getQhm());
							paymentVoucherHis.setSkrkhh(zzhxmSfxxRes.getKhyh());
							paymentVoucherHis.setSrxmmc(zzhxmSfxxRes.getSfxmmc());
							paymentVoucherHis.setXmbm(zzhxmSfxxRes.getFsxmbm());
							paymentVoucherHis.setZsdwbm(zzhxmSfxxRes.getZsdwbm());
							paymentVoucherHis.setZsdw(paymentItemPending.getZsdw());
							ZzhxmJktzs zzhxmJktzs22 = zzhxmJktzsService.getByJfdmwybh(zzhxmSfxxRes.getJfdmwybh());
							if (zzhxmJktzs22 != null) {
								paymentVoucherHis.setPayerName(zzhxmJktzs22.getJsdwmc());
							}
							SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
							String voucherCode = zzhkppjList.get(i).getYbjksbh().trim();
							String pjbz = "";
							pjbz = "关联编号:" + voucherCode + ".";
							paymentVoucherHis.setDestroyStatus(Constant.VOUCHER_DESTROY_STATUS_0);//默认未缴销
							//拼全局验证码
							StringBuffer source = new StringBuffer();
							BigDecimal amountBd = new BigDecimal(zzhxmSfxxRes.getYjjemx());
							String amount = amountBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
							source.append(voucherCode).append(format.format(new Date())).append(zzhxmSfxxRes.getZsdwbm()).append(zzhxmSfxxRes.getSkrqc()).append(zzhxmSfxxRes.getSkrzh()).append(zzhxmSfxxRes.getFsxmbm()).append(amount);
							paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
							paymentVoucherHis.setMessage("上报：成功");
							String validCode = billendnumber.calculateBillMac(source.toString());
							paymentVoucherHis.setValidCode(validCode);//全票面信息校验码
							paymentVoucherHis.setVoucherCode(voucherCode);
							paymentVoucherService.addYzstb(paymentVoucherHis, "1", "1", jktzs1.getSlbh(), pjbz, paymentItemPending, xmxxb1);
						}
					}
				}
				ZzhxmJktzs zzhxmJktzs1 = zzhxmJktzsService.getById(zzhxmJktzs.getId());
				zzhxmJktzs1.setKpzt("1");//改为已开票
				zzhxmJktzs1.setNfqf("1");//改为能清分
				zzhxmJktzsService.update(zzhxmJktzs1);
			}catch(Exception e){
				e.printStackTrace();
				logger.error(e.getMessage());
			}
		}
		return RELOAD;
	}

/*
	public static void main(String[] args) {
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
		//拼全局验证码
		StringBuffer source = new StringBuffer();
		BigDecimal amountBd = new BigDecimal("497970.00");
		String amount = amountBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
		source.append("038042223X").append(format.format(new Date())).append("708002").append("").append("10105901040000062").append("20320301").append(amount);
		String validCode = billendnumber.calculateBillMac(source.toString());
		System.out.println(validCode);
	}*/

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != zzhxmJktzs)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhxmJktzsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Zzhqfdz getZzhqfdz(){
		return this.zzhqfdz;
	}

	public void setZzhqfdz(Zzhqfdz zzhqfdz){
		this.zzhqfdz = zzhqfdz;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getJktzsbhVal() {
		return jktzsbhVal;
	}

	public void setJktzsbhVal(String jktzsbhVal) {
		this.jktzsbhVal = jktzsbhVal;
	}

	public ZzhxmJktzs getZzhxmJktzs() {
		return zzhxmJktzs;
	}

	public void setZzhxmJktzs(ZzhxmJktzs zzhxmJktzs) {
		this.zzhxmJktzs = zzhxmJktzs;
	}

	public ZzhxmSfxx getZzhxmSfxx() {
		return zzhxmSfxx;
	}

	public void setZzhxmSfxx(ZzhxmSfxx zzhxmSfxx) {
		this.zzhxmSfxx = zzhxmSfxx;
	}

	public List<Zzhqfdz> getZzhqfdzsList() {
		return zzhqfdzsList;
	}

	public void setZzhqfdzsList(List<Zzhqfdz> zzhqfdzsList) {
		this.zzhqfdzsList = zzhqfdzsList;
	}

	public List<ZzhxmSfxx> getZzhxmsfxxList() {
		return zzhxmsfxxList;
	}

	public void setZzhxmsfxxList(List<ZzhxmSfxx> zzhxmsfxxList) {
		this.zzhxmsfxxList = zzhxmsfxxList;
	}

	public String getPrintNo() {
		return printNo;
	}

	public void setPrintNo(String printNo) {
		this.printNo = printNo;
	}

	public Map<String, List<Zzhkppj>> getBankMap() {
		return bankMap;
	}

	public void setBankMap(Map<String, List<Zzhkppj>> bankMap) {
		this.bankMap = bankMap;
	}

	public List<Zzhkppj> getZzhkppjList() {
		return zzhkppjList;
	}

	public void setZzhkppjList(List<Zzhkppj> zzhkppjList) {
		this.zzhkppjList = zzhkppjList;
	}
}
