package com.jshx.zzhqfdz.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhqfdz.dao.ZzhqfhzDao;
import com.jshx.zzhqfdz.dao.ZzhqfhzmxDao;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import com.jshx.zzhqfdz.entity.Zzhqfhzlsh;
import com.jshx.zzhqfdz.entity.Zzhqfhzmx;
import com.jshx.zzhqfdz.service.ZzhqfhzService;
import com.jshx.zzhqfdz.service.ZzhqfhzmxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhqfhzmxService")
public class ZzhqfhzmxServiceImpl extends BaseServiceImpl implements ZzhqfhzmxService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhqfhzmxDao")
	private ZzhqfhzmxDao zzhqfhzmxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhqfhzmxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfhzmx getById(String id)
	{
		return zzhqfhzmxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhqfhzmx 信息
	 */
	@Transactional
	public void save(Zzhqfhzmx zzhqfhzmx)
	{
		zzhqfhzmxDao.save(zzhqfhzmx);
	}

	@Transactional
	public void save(Zzhqfhzlsh zzhqfhzlsh)
	{
		zzhqfhzmxDao.save(zzhqfhzlsh);
	}

	/**
	 * 修改信息
	 * @param zzhqfhzmx 信息
	 */
	@Transactional
	public void update(Zzhqfhzmx zzhqfhzmx)
	{
		zzhqfhzmxDao.update(zzhqfhzmx);
	}

	@Transactional
	public void update(Zzhqfhzlsh zzhqfhzlsh)
	{
		zzhqfhzmxDao.update(zzhqfhzlsh);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhqfhzmxDao.findZzhqfhzmx(paraMap);
		zzhqfhzmxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhqfhzmxDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhqfhzmx> findZzhqfhzmx(Map<String, Object> paraMap) {

		return zzhqfhzmxDao.findZzhqfhzmx(paraMap);

	}

	@Override
	public List<Zzhqfhzlsh> findZzhqfhzlsh(Map<String, Object> paraMap) {

		return zzhqfhzmxDao.findZzhqfhzlsh(paraMap);

	}
}
