package com.jshx.zzhgl.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmxxb.dao.XmxxbDao;
import com.jshx.zzhgl.dao.ZzhglDao;
import com.jshx.zzhgl.entity.Zzh;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("zzhglDao")
public class ZzhglDaoImpl extends BaseDaoImpl implements ZzhglDao
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhglByMap", paraMap, page);
	}

	public List<String> findZzh(Map<String,Object> paraMap){
		return this.findListBySqlId("findzzh", paraMap);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhgl(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhglByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzh getById(String id)
	{
		return (Zzh)this.getObjectById(Zzh.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Zzh zzh)
	{
		zzh.setId(null);
		this.saveOrUpdateObject(zzh);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Zzh zzh)
	{
		this.saveOrUpdateObject(zzh);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzh.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzh zzh = (Zzh)this.getObjectById(Zzh.class, id);
		zzh.setDelFlag(1);
		this.saveObject(zzh);
	}

	/**
	 * 更新子账户
	 */
	@Override
	public void activeZzh(Map<String, Object> map) {
		this.executeUpdateBySqlId("activeZzh", map);
	}


}
