package com.jshx.yzscw.yzscwpzgl.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;

import com.jshx.core.utils.StringUtil;
import com.jshx.yzscw.yzscwjzpz.service.YzscwjzpzService;
import com.jshx.yzscw.yzscwpzgl.entity.Yzscwpzgl;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxx;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxxVO;
import com.jshx.yzscw.yzscwpzgl.service.YzscwpzglService;
import com.jshx.yzscw.yzscwkmgl.entity.Yzscwkmgl;
import com.jshx.yzscw.yzscwkmgl.service.YzscwkmglService;
import com.jshx.yzscw.yzscwpzgl.service.YzscwpzglSfxxService;

import com.jshx.yzssfgl.entity.Yzsdicgl;
import com.jshx.yzssfgl.service.YzsdicglService;
import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.struts2.ServletActionContext;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

public class YzscwpzglAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private InputStream excelFile;

	private String fileName;

	private String startTerm;

	private String endTerm;

	private String printId;

	private String pzlx;

	/**
	 * 实体类
	 */
	private Yzscwpzgl yzscwpzgl = new Yzscwpzgl();

	private Yzscwkmgl yzscwkjkm = new Yzscwkmgl();

	private List<Yzscwkmgl> yzscwkjkmList = new ArrayList<>();

	private List<YzscwpzglSfxx> yzscwpzglSfxx = new ArrayList<>();
	private List<YzscwpzglSfxxVO> yzscwpzglSfxxVO = new ArrayList<>();

	private List<Yzsdicgl> yzsdicgls = new ArrayList<>();

	/**
	 * 业务类
	 */
	@Autowired
	private YzscwpzglService yzscwpzglService;

	@Autowired
	private YzscwpzglSfxxService yzscwpzglSfxxService;

	@Autowired
	private YzscwkmglService yzscwkjkmService;

	@Autowired
	private YzscwjzpzService yzscwjzpzService;

	@Autowired
	private YzsdicglService yzsdicglService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private String cpt;

	private String deptCode;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 跳转到凭证箱页面
	 */
	public String pzglInit() {
		return SUCCESS;
	}
	/**
	 * 跳转到关联会计科目页面
	 */
	public String toLinkedKjkm() {
		return SUCCESS;
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(StringUtils.isNotBlank(startTerm)){
			paraMap.put("startTerm", startTerm);
		}else {
//			paraMap.put("startTerm", );
			//获取格式化日期字符串
//			String dateStr = DateTimeFormat.forPattern("yyyy-MM-dd").print(LocalDate.now());
		}
		if(StringUtils.isNotBlank(endTerm)){
			paraMap.put("endTerm", endTerm);
		}else {
//			paraMap.put("endTerm", endTerm);
		}
		if(null != yzscwpzgl.getVoucherStatus()){
			paraMap.put("voucherStatus", yzscwpzgl.getVoucherStatus());
		}
		// 一下为期末结转的条件 start
		if(StringUtils.isNotBlank(yzscwpzgl.getAccountSubject())){
			paraMap.put("accountSubject", yzscwpzgl.getAccountSubject());
		}else {
//
		}
		//包含年度与月度的情况
		if(null != yzscwpzgl.getInterestForMonth()){
			paraMap.put("interestForMonth", yzscwpzgl.getInterestForMonth());
		}else {
//
		}
		//期末结转 end

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(true){

		    //设置查询条件，开发人员可以在此增加过滤条件

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|voucherNumber|voucherStatus|summary|amount|amountCredit|attachmentSum|billStaff|billDate|reviewStaff|reviewDate|bookkeepingStaff|bookkeepingDate|jzpzlx|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}

		pagination = yzscwpzglService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 关联会计科目树
	 */
	public void findKjkmTreeForPzgl() throws Exception {

		Map<String, Object> paraMap = new HashMap<>();
        List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		List<Yzscwkmgl> kmglList = yzscwkjkmService.findYzscwkmgl(paraMap);
        for (Yzscwkmgl yzscwkmgl : kmglList) {
            Map<String, Object> element = new HashMap<>();
            element.put("id", yzscwkmgl.getId());
            element.put("parentId", yzscwkmgl.getParentId());
            element.put("name", yzscwkmgl.getKmmc());
            element.put("state", "open");
            items.add(element);
        }

		JSONArray json = JSONArray.fromObject(items);
		HttpServletResponse response = ServletActionContext
				.getResponse();
		response.setContentType("application/json;charset=UTF-8");
		response.setCharacterEncoding("utf-8");
		response.setHeader("Charset", "utf-8");
		response.setHeader("Cache-Control", "no-cache");
		response.getWriter().print(json.toString());
	}


	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if (null != yzscwpzgl && StringUtils.isNotBlank(yzscwpzgl.getId())) {
			yzscwpzgl = yzscwpzglService.getById(yzscwpzgl.getId());
			Map<String, Object> paraMap = new HashMap<>();
			paraMap.put("pzglId", yzscwpzgl.getId());
			yzscwpzglSfxx = yzscwpzglSfxxService.findYzscwpzglSfxx(paraMap);
		}
		return VIEW;
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		if (null != yzscwpzgl && null != yzscwpzgl.getId()) {
			yzscwpzgl = yzscwpzglService.getById(yzscwpzgl.getId());
			paraMap.put("pzglId", yzscwpzgl.getId());
			paraMap.put("voucherNumber", yzscwpzgl.getVoucherNumber());
			yzscwpzglSfxx = yzscwpzglService.findYzscwpzglSfxx(paraMap);
		}
	    return EDIT;
	}
	/**
	 * 	初始化添加信息
	 */
	public String initAdd() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		// 此处startTerm为选择的所在年月
		if (StringUtils.isBlank(startTerm)) {
			this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "所在年月不可为空!" + "\"}");
		}

//		String yMd = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));

		//
		/*SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
		Date date = format.parse(startTerm);*/
		//查询所在年月的凭证记录数
		paraMap.put("voucherNumber", startTerm +"%");
		List<Yzscwpzgl> pzglList = yzscwpzglService.findYzscwpzgl(paraMap);
		// 有数据
		String jzhTag = "";
		if (CollectionUtils.isNotEmpty(pzglList)) {
			//记字号
			String sequenceNumber = pzglList.get(0).getSequenceNumber();
			String billDate = pzglList.get(0).getBillDate();
			yzscwpzgl.setBillDate(billDate);
			DateTime dateTime = DateTime.parse(billDate);
			int i = dateTime.dayOfMonth().withMaximumValue().dayOfMonth().get();
			endTerm = billDate.substring(0, billDate.lastIndexOf("-")) +"-"+ i;
			jzhTag = (Integer.parseInt(sequenceNumber) + 1) +"";
			while ((jzhTag).length() < 4 ) {
				jzhTag = "0" + jzhTag;
			}
		} else {
			yzscwpzgl.setBillDate(startTerm + "-01");
			DateTime dateTime = DateTime.parse(startTerm);
			int i = dateTime.dayOfMonth().withMaximumValue().dayOfMonth().get();
			endTerm = startTerm + "-" + i;
			jzhTag = "0001";
		}
		yzscwpzgl.setSequenceNumber(jzhTag);
		String userName = this.getLoginUser().getDisplayName();
		yzscwpzgl.setBillStaff(userName);
		//
	    return EDIT;
	}
	/**
	 * 	跳转添加前选择页面
	 */
	public String initBeforeAdd() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("yzssflx", "凭证类型");
		// 添加凭证类型的数据获取到前台下拉框展示选取
		yzsdicgls = yzsdicglService.findYzsdicgl(paraMap);

        return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)){
			if (null != yzscwpzgl) {
				yzscwpzgl.setDelFlag(0);
				//初始化状态
				yzscwpzgl.setVoucherStatus(0);
				//制单日期
				yzscwpzgl.setBillDate(yzscwpzgl.getBillDate());
				yzscwpzgl.setAccountDate(DateTime.parse(yzscwpzgl.getBillDate()).toDate());
				//来自页面手动添加
				yzscwpzgl.setInsertType(1);
//				String dateStr = DateTimeFormat.forPattern("yyyy-MM").print(LocalDate.now());
				//序列号与凭证号
				String dateStr = (yzscwpzgl.getBillDate().substring(0, 7));
				yzscwpzgl.setAboutDate(dateStr);
				yzscwpzgl.setVoucherNumber(dateStr+ "-" +yzscwpzgl.getSequenceNumber());
				if (StringUtils.isNotBlank(yzscwpzgl.getAmountCredit())) {
					String amountCredit = yzscwpzgl.getAmountCredit();
					yzscwpzgl.setAmountCredit(amountCredit.replaceAll(",", ""));
				}
				if (StringUtils.isNotBlank(yzscwpzgl.getAmount())) {
					String amount = yzscwpzgl.getAmount();
					yzscwpzgl.setAmount(amount.replaceAll(",", ""));
				}
				List<YzscwpzglSfxx> sfxxes = new ArrayList<>();
				try {
//					yzscwpzglService.saveAndSfxxByTransactional(yzscwpzgl, sfxxes);
					yzscwpzglService.save(yzscwpzgl);
					//金额相关信息
					for (int i = 0; i < yzscwpzglSfxxVO.size(); i++) {
						if (null == yzscwpzglSfxxVO.get(i)) {
							continue;
						}
						YzscwpzglSfxx sfxx = new YzscwpzglSfxx();
						sfxx.setDelFlag(0);
						sfxx.setVoucherNumber(yzscwpzgl.getVoucherNumber());
						sfxx.setInsertType(1);
						sfxx.setSummary((StringUtils.isNotBlank(yzscwpzgl.getSummary())) ? yzscwpzgl.getSummary() : "");
						sfxx.setPzglId(yzscwpzgl.getId());
						// 借方
						if (Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount()) != 0 && Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmountCredit())==0) {
							/*if (Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount()) > 0) {*/
								// 为正,记为借
								sfxx.setAmount(Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount()) + "");
//								sfxx.setAmountCredit("0");
								// 将会计科目设置到借方
								sfxx.setDebitAccountSubject(yzscwpzglSfxxVO.get(i).getAccountSubject());
//------------------------------ 2019-12-4-- start ------------------------------------------------------------------
								sfxx.setSubjectType("0");
//------------------------------ 2019-12-4-- end --------------------------------------------------------------------
							/*} else {
								// 为负,记为贷
								sfxx.setAmountCredit(Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount()) + "");
								sfxx.setAmount("0");
								// 将会计科目设置贷方
								sfxx.setCreditAccountSubject(yzscwpzglSfxxVO.get(i).getAccountSubject());
							}*/
						// 贷方
						}else if (Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmountCredit()) != 0 && Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount())==0) {
							/*if (Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmountCredit()) > 0) {*/
								// 为正,记为贷
								sfxx.setAmount(Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmountCredit()) + "");
//								sfxx.setAmount("0");
								// 将会计科目设置到贷方
								sfxx.setCreditAccountSubject(yzscwpzglSfxxVO.get(i).getAccountSubject());
//------------------------------ 2019-12-4-- start ------------------------------------------------------------------
								sfxx.setSubjectType("1");
//------------------------------ 2019-12-4-- end --------------------------------------------------------------------
							/*} else {
								// 为负,记为借
								sfxx.setAmount(Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount()) + "");
								sfxx.setAmountCredit("0");
								// 将会计科目设置到借方
								sfxx.setDebitAccountSubject(yzscwpzglSfxxVO.get(i).getAccountSubject());
							}*/
						// 借、贷都为0(此情况一般是客户添加了行,而没有录入数据),跳过处理;
						} else if (Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmountCredit())== 0 && Double.parseDouble(yzscwpzglSfxxVO.get(i).getAmount())== 0 ) {

						// 借、贷都不为0(此情况前台已做处理,理论上不存在),如遇到此种情况则删除插入的pzgl记录,并弹出提示框;
						} else {
							//异常情况
							System.out.println("error");
							List delId = new ArrayList();
							delId.add(yzscwpzgl.getId());
							yzscwpzglService.deleteWithFlag(delId);
							logger.error("借方贷方金额均不为0!");
							throw new RuntimeException("借方贷方金额均不为0!");
						}
						/*
						if (StringUtils.isNotBlank(yzscwpzglSfxxVO.get(i).getAmountCredit()) && StringUtils.isBlank(yzscwpzglSfxxVO.get(i).getAmountCreditMinus())) {
							// 为正,记为贷
							sfxx.setAmountCredit(yzscwpzglSfxxVO.get(i).getAmountCredit());
						}else if (StringUtils.isNotBlank(yzscwpzglSfxxVO.get(i).getAmountCreditMinus()) && StringUtils.isBlank(yzscwpzglSfxxVO.get(i).getAmountCredit())) {
							// 为负,记为贷
							sfxx.setAmountCredit(yzscwpzglSfxxVO.get(i).getAmountCreditMinus());
						} else {
							//异常情况
							System.out.println("error");
							throw new RuntimeException("贷方异常情况2");
						}*/
//						sfxx.setAmount(yzscwpzglSfxxVO.get(i).getAmount());
//						sfxx.setAmountCredit();
						sfxxes.add(sfxx);

					}
					yzscwpzglService.saveSfxxByTransactional(sfxxes);

				}catch (Exception e) {
					if (StringUtils.isNotBlank(yzscwpzgl.getId())) {
						ArrayList<String> list = new ArrayList<>();
						list.add(yzscwpzgl.getId());

						yzscwpzglService.deleteWithFlag(list);

					}
					e.printStackTrace();
//					return RELOAD;
				}
			}
		}else{
			if (null != yzscwpzgl) {
				Yzscwpzgl byId = yzscwpzglService.getById(yzscwpzgl.getId());
				// 原来为空
				if(StringUtils.isBlank(byId.getSummary())){
					// 现在也为空
					if (StringUtils.isBlank(yzscwpzgl.getSummary())) {
//						byId.setSummary("");
					}else {
						// 现在不为空
						byId.setSummary(yzscwpzgl.getSummary());
					}
				} else /*(!byId.getSummary().equalsIgnoreCase(yzscwpzgl.getSummary())) */{
					byId.setSummary(yzscwpzgl.getSummary());
				}
				if (!byId.getAmount().equalsIgnoreCase(yzscwpzgl.getAmount())) {
					byId.setAmount(yzscwpzgl.getAmount());
				}
				if (!byId.getAmountCredit().equalsIgnoreCase(yzscwpzgl.getAmountCredit())) {
					byId.setAmountCredit(yzscwpzgl.getAmountCredit());
				}
				if (!byId.getAttachmentSum().equalsIgnoreCase(yzscwpzgl.getAttachmentSum())) {
					byId.setAttachmentSum(yzscwpzgl.getAttachmentSum());
				}
				if (!byId.getBillDate().equalsIgnoreCase(yzscwpzgl.getBillDate())) {
					byId.setBillDate(yzscwpzgl.getBillDate());
				}
				if (StringUtils.isNotBlank(yzscwpzgl.getAmountCredit())) {
					String amountCredit = yzscwpzgl.getAmountCredit();
					byId.setAmountCredit(amountCredit.replaceAll(",", ""));
				}
				if (StringUtils.isNotBlank(yzscwpzgl.getAmount())) {
					String amount = yzscwpzgl.getAmount();
					byId.setAmount(amount.replaceAll(",", ""));
				}
				// 将sfxx第一条summary赋给pzgl
				String summary = yzscwpzglSfxxVO.get(0).getSummary();
				if (StringUtils.isNotBlank(summary)) {
					byId.setSummary(summary);
				}
				List<YzscwpzglSfxx> sfxxList = new ArrayList<>();
				try {

					for (YzscwpzglSfxxVO sfxx : yzscwpzglSfxxVO) {
						// 修改前
						YzscwpzglSfxx sfxxById = yzscwpzglSfxxService.getById(sfxx.getId());
						/*if (!sfxxById.getSummary().equalsIgnoreCase(yzscwpzgl.getSummary())) {*/
							sfxxById.setSummary(byId.getSummary());
							//原来的值
							BigDecimal bigDOld = new BigDecimal(sfxxById.getAmount());
							//现在的值
							BigDecimal bigDNew = new BigDecimal(sfxx.getAmount());
							if (bigDOld.compareTo(bigDNew) != 0) {
								sfxxById.setAmount(sfxx.getAmount());
							}

							/*//原来的值
							BigDecimal bigCOld = new BigDecimal(sfxxById.getAmount());
							//现在的值
							BigDecimal bigCNew = new BigDecimal(sfxx.getAmount());
							if (bigCOld.compareTo(bigCNew) != 0) {
								sfxxById.setAmount(sfxx.getAmount());
							}*/
							if (null != sfxx.getSummary()) {
								sfxxById.setSummary(sfxx.getSummary());
							}
						/*}*/
						// 借方金额不同
						// 1.修改前为0,改后不为0;	→ 贷方为0;
						/** 贷方金额	→	借方金额 */
						/*if (Double.parseDouble(sfxxById.getAmount())== 0 && Double.parseDouble(sfxx.getAmount()) != 0) {
							// 等价于:	 Double.parseDouble(sfxxById.getAmountCredit())!= 0 && Double.parseDouble(sfxx.getAmountCredit()) == 0
							sfxxById.setAmount(sfxx.getAmount());
							*//*sfxxById.setCreditAccountSubject("");
							sfxxById.setDebitAccountSubject(sfxx.getAccountSubject());*//*
						}
						// 2.修改前为0,修改后为0;	判断是否需要处理贷方金额
						else if (Double.parseDouble(sfxxById.getAmount())== 0 && Double.parseDouble(sfxx.getAmount()) == 0) {
							// 等价于:	Double.parseDouble(sfxxById.getAmountCredit())!= 0 && Double.parseDouble(sfxx.getAmountCredit()) != 0
							if (Double.parseDouble(sfxxById.getAmountCredit()) == Double.parseDouble(sfxx.getAmountCredit())) {
								//相等

							}else {
								//不等
								sfxxById.setAmountCredit(sfxx.getAmountCredit());
							}
						}
						//
						// 3.修改前不为0,修改后为0;	→ 借方为0,贷方不为0;
						*//** 借方金额	→	贷方金额 *//*
						else if (Double.parseDouble(sfxxById.getAmount())!= 0 && Double.parseDouble(sfxx.getAmount()) == 0) {
							// 等价于:	Double.parseDouble(sfxxById.getAmountCredit())== 0 && Double.parseDouble(sfxx.getAmountCredit()) != 0
							sfxxById.setAmountCredit(sfxx.getAmountCredit());
							*//*sfxxById.setDebitAccountSubject("");
							sfxxById.setCreditAccountSubject(sfxx.getAccountSubject());*//*
						}
						// 4.修改前不为0,改后不为0;	→ 比较大小 → 1.相等pass,不修改,2.不相等修改值即可;
						*//** 借方金额	→	判断大小 *//*
						else if (Double.parseDouble(sfxxById.getAmount())!= 0 && Double.parseDouble(sfxx.getAmount()) != 0) {
							// 等价于:	Double.parseDouble(sfxxById.getAmountCredit())== 0 && Double.parseDouble(sfxx.getAmountCredit()) == 0
							if (Double.parseDouble(sfxxById.getAmount()) == Double.parseDouble(sfxx.getAmount())) {
								// 相等
							}else {
								// 不等
								sfxxById.setAmount(sfxx.getAmount());
							}
						}*/
						// 借方

					/*if (!sfxxById.getAmount().equalsIgnoreCase(sfxx.getAmount())) {
						sfxxById.setDebitAccountSubject(sfxx.getDebitAccountSubject());
					}
					if (!sfxxById.getAmountCredit().equalsIgnoreCase(sfxx.getAmountCredit())) {
						sfxxById.setCreditAccountSubject(sfxx.getCreditAccountSubject());
					}
					if (!sfxxById.getAmount().equalsIgnoreCase(sfxx.getAmount())) {
						sfxxById.setAmount(sfxx.getAmount());
					}*/
						sfxxList.add(sfxxById);
					}
					yzscwpzglService.updateAndSfxx(byId, sfxxList);
				} catch (Exception e) {
					logger.error("修改凭证出错!", e.getMessage());
					e.printStackTrace();
				}


			}
		}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (true)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
//			yzscwkmglService.deleteWithFlag(ids);
			String[] idArray = ids.split(",");
			ArrayList<String> list = new ArrayList<>(Arrays.asList(idArray));
			yzscwpzglService.deleteWithFlag(list);
			this.getResponse().getWriter().println("{\"result\":\"true\"}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":\"false\"}");
		}
		return null;
	}

	public String exportExcel() {
	    Map<String, Object> paraMap = new HashMap<>();
		try {
		    if (StringUtils.isNotBlank(flag)){
		        if (flag.equalsIgnoreCase("month")) {
		            paraMap.put("interestForMonth", 0);
                }
                if (flag.equalsIgnoreCase("year")) {
                    paraMap.put("interestForMonth", 2);
                }
            }
            if (StringUtils.isNotBlank(ids)) {
            	List<String> idList = new ArrayList<>();
				String[] idArr = ids.split(",");
				for (int i = 0; i < idArr.length; i++) {
					String s = idArr[i];
					idList.add(s.trim());
				}
				paraMap.put("ids", idList);
			}
            List<Yzscwpzgl> list = yzscwpzglService.findYzscwpzgl(paraMap);
            if (CollectionUtils.isEmpty(list)) {
				return ERROR;
			}
//            list.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            // 声明一个工作薄
            HSSFWorkbook workbook = new HSSFWorkbook();
            // 生成一个表格
            HSSFSheet sheet = workbook.createSheet();
            // 设置Excel样式 start-------------------------------
			HSSFCellStyle cellStyle = workbook.createCellStyle(); // 单元格样式
			Font fontStyle = workbook.createFont(); // 字体样式
//			fontStyle.setBold(true); // 加粗
			fontStyle.setFontName("黑体"); // 字体
			fontStyle.setFontHeightInPoints((short) 11); // 大小
			// 将字体样式添加到单元格样式中
			cellStyle.setFont(fontStyle);
			// 边框，居中
			cellStyle.setAlignment(HorizontalAlignment.CENTER);
			cellStyle.setBorderBottom(BorderStyle.THIN);
			cellStyle.setBorderLeft(BorderStyle.THIN);
			cellStyle.setBorderRight(BorderStyle.THIN);
			cellStyle.setBorderTop(BorderStyle.THIN);
//			cellB2.setCellStyle(cellStyle); // 为B2单元格添加样式
			// 设置Excel样式 end---------------------------------


            // 产生表格标题行
            HSSFRow row = sheet.createRow(0);
			HSSFCell title0 = row.createCell(0);
			title0.setCellValue("序号");
			HSSFCell title1 = row.createCell(1);
			title1.setCellValue("制单日期");
			HSSFCell title2 = row.createCell(2);
			title2.setCellValue("凭证号");
			HSSFCell title3 = row.createCell(3);
			title3.setCellValue("凭证状态");
			HSSFCell title4 = row.createCell(4);
			title4.setCellValue("摘要");
			HSSFCell title5 = row.createCell(5);
			title5.setCellValue("金额");
			HSSFCell title6 = row.createCell(6);
			title6.setCellValue("附单据数");
			HSSFCell title7 = row.createCell(7);
			title7.setCellValue("制单人");
			HSSFCell title8 = row.createCell(8);
			title8.setCellValue("审核人");
			HSSFCell title9 = row.createCell(9);
			title9.setCellValue("记账人");
			/*row.createCell(1).setCellValue("制单日期");
            row.createCell(2).setCellValue("凭证号");
            row.createCell(3).setCellValue("凭证状态");
            row.createCell(4).setCellValue("摘要");
            row.createCell(5).setCellValue("金额");
            row.createCell(6).setCellValue("附单据数");
            row.createCell(7).setCellValue("制单人");
            row.createCell(8).setCellValue("审核人");
            row.createCell(9).setCellValue("记账人");*/
			// 设置样式
			title0.setCellStyle(cellStyle);
			title1.setCellStyle(cellStyle);
			title2.setCellStyle(cellStyle);
			title3.setCellStyle(cellStyle);
			title4.setCellStyle(cellStyle);
			title5.setCellStyle(cellStyle);
			title6.setCellStyle(cellStyle);
			title7.setCellStyle(cellStyle);
			title8.setCellStyle(cellStyle);
			title9.setCellStyle(cellStyle);

            Iterator<Yzscwpzgl> iterator = list.iterator();

            int index = 0;
            while (iterator.hasNext()) {
                index ++;
                Yzscwpzgl pzgl = iterator.next();
				row = sheet.createRow(index);
				HSSFCell cell0 = row.createCell(0);
				cell0.setCellValue(index);
				HSSFCell cell = row.createCell(1);
				cell.setCellValue(pzgl.getBillDate());
				HSSFCell cell2 = row.createCell(2);
				cell2.setCellValue(pzgl.getVoucherNumber());
				HSSFCell cell3 = row.createCell(3);
				if (null == pzgl.getVoucherStatus()) {
				    continue;
                }
				cell3.setCellValue(pzgl.getVoucherStatus()>1?(pzgl.getVoucherStatus()==2?"已记账":"已作废"):(pzgl.getVoucherStatus()==0?"未审核":"未审核"));
				HSSFCell cell4 = row.createCell(4);
				cell4.setCellValue(pzgl.getSummary());
				HSSFCell cell5 = row.createCell(5);
				cell5.setCellValue(pzgl.getAmount());
				HSSFCell cell6 = row.createCell(6);
				cell6.setCellValue(pzgl.getAttachmentSum());
				HSSFCell cell7 = row.createCell(7);
				cell7.setCellValue(pzgl.getBillStaff());
				HSSFCell cell8 = row.createCell(8);
				cell8.setCellValue(pzgl.getReviewStaff());
				HSSFCell cell9 = row.createCell(9);
				cell9.setCellValue(pzgl.getBookkeepingStaff());

				//样式
				cell0.setCellStyle(cellStyle);
				cell.setCellStyle(cellStyle);
				cell2.setCellStyle(cellStyle);
				cell3.setCellStyle(cellStyle);
				cell4.setCellStyle(cellStyle);
				cell5.setCellStyle(cellStyle);
				cell6.setCellStyle(cellStyle);
				cell7.setCellStyle(cellStyle);
				cell8.setCellStyle(cellStyle);
				cell8.setCellStyle(cellStyle);
				cell9.setCellStyle(cellStyle);
            }
            // 设置列自适应宽度
			for (int i = 0; i < 10; i++) {
				sheet.autoSizeColumn(i);
				sheet.setColumnWidth(i,sheet.getColumnWidth(i)*17/10);
			}
            workbook.write(out);
            out.close();
            String excelName = "";
			if (StringUtils.isNotBlank(flag)){
				if (flag.equalsIgnoreCase("month")) {
					excelName = "月度凭证管理";
				} else if (flag.equalsIgnoreCase("year")) {
					excelName = "年度凭证管理";
				} else {
					excelName = "凭证管理";
				}
			}else {
				excelName = "凭证管理";
			}
            fileName = new String(excelName.getBytes(), "iso-8859-1") + ".xls";

            excelFile = new ByteArrayInputStream(out.toByteArray());

			logger.debug("导出凭证管理Excel成功!");
			return "exportExcel";
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	/**
	 * 审核/取消审核
	 *
	 * 取消审核需要清除审核人姓名
	 * @throws IOException
	 */
	public void reviewPzgl() throws IOException {
		if (null != yzscwpzgl && StringUtils.isNotBlank(yzscwpzgl.getId())) {
			try {
				Yzscwpzgl byId = yzscwpzglService.getById(yzscwpzgl.getId());
				byId.setVoucherStatus(yzscwpzgl.getVoucherStatus());
				byId.setReviewStaff(this.getLoginUser().getDisplayName());
				byId.setReviewDate(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").print(DateTime.now()));
				//---------2019-11-4 start-------------
				if (yzscwpzgl.getVoucherStatus()==0) {
					//取消审核
					byId.setReviewStaff("");
				}
				//----------2019-11-4 end--------------
				yzscwpzglService.update(byId);
				this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "操作成功!" + "\"}");
			} catch (Exception e) {
				e.printStackTrace();
				this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "操作失败!" + "\"}");
			}

		} else {
			//批量
			if (StringUtils.isNotBlank(ids)) {
				List<Yzscwpzgl> pzgls = new ArrayList<>();
				try {
					String[] split = ids.split(",");
					for (String id : split) {
						Yzscwpzgl byId = yzscwpzglService.getById(id.trim());
						byId.setVoucherStatus(yzscwpzgl.getVoucherStatus());
						byId.setReviewStaff(this.getLoginUser().getDisplayName());
						byId.setReviewDate(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").print(DateTime.now()));
						//---------2019-11-4 start-------------
						if (yzscwpzgl.getVoucherStatus()==0) {
							//取消审核
							byId.setReviewStaff("");
						}
						//----------2019-11-4 end--------------
						pzgls.add(byId);
//						yzscwpzglService.update(byId);
					}
					yzscwpzglService.updateAll(pzgls);
					this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "操作成功!" + "\"}");
				}catch (Exception e) {
					e.printStackTrace();
					this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "操作失败!" + "\"}");
				}
			}
		}
	}

	/**
	 * 记账/取消记账
	 * @throws IOException
	 */
	public void bookkeepingPzgl() throws IOException {
		if (null != yzscwpzgl && StringUtils.isNotBlank(yzscwpzgl.getId())) {
			try {
				Yzscwpzgl byId = yzscwpzglService.getById(yzscwpzgl.getId());
				byId.setVoucherStatus(yzscwpzgl.getVoucherStatus());
				byId.setBookkeepingStaff(this.getLoginUser().getDisplayName());
				byId.setBookkeepingDate(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").print(DateTime.now()));
				//---------2019-11-4 start-------------
				if (yzscwpzgl.getVoucherStatus()==1) {
					//取消审核
					byId.setBookkeepingStaff("");
				}
				//----------2019-11-4 end--------------
				yzscwpzglService.update(byId);
				// 2019-10-30 报表机制凭证 条件,是否记账;
				yzscwjzpzService.updatePzzt(byId.getId(), yzscwpzgl.getVoucherStatus());

				this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "操作成功!" + "\"}");
			} catch (Exception e) {
				e.printStackTrace();
				this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "操作失败!" + "\"}");
			}
		} else {
			//批量
			if (StringUtils.isNotBlank(ids)) {
				List<Yzscwpzgl> pzgls = new ArrayList<>();
				try {
					String[] split = ids.split(",");
					for (String id : split) {
						Yzscwpzgl byId = yzscwpzglService.getById(id.trim());
						byId.setVoucherStatus(yzscwpzgl.getVoucherStatus());
						byId.setBookkeepingStaff(this.getLoginUser().getDisplayName());
						byId.setBookkeepingDate(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").print(DateTime.now()));
						//---------2019-11-4 start-------------
						if (yzscwpzgl.getVoucherStatus()==1) {
							//取消审核
							byId.setBookkeepingStaff("");
						}
						//----------2019-11-4 end--------------
						pzgls.add(byId);
					}
					yzscwpzglService.updateAll(pzgls);
					// 批量更新机制凭证中的凭证状态
					for (Yzscwpzgl pzgl : pzgls) {
						yzscwjzpzService.updatePzzt(pzgl.getId(), yzscwpzgl.getVoucherStatus());
					}
					this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "操作成功!" + "\"}");
				}catch (Exception e) {
					e.printStackTrace();
					this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "操作失败!" + "\"}");
				}
			}
		}
	}

	/**
	 *
	 * 查询选择会计科目选中的科目
	 */
	public void findAccountNodeAndParent() throws IOException {
		if (StringUtils.isNotBlank(ids)) {
			String nodeName = "";
			try {
				getParents(ids, nodeName);
				nodeName = nodeName.substring(0, nodeName.lastIndexOf("/"));
				this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + nodeName + "\"}");
			} catch (Exception e) {
				e.printStackTrace();
				this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "获取失败!" + "\"}");
			}
		}
	}

	public void getParents(String id, String name) {
		Yzscwkmgl byId = yzscwkjkmService.getById(id.trim());
		if (StringUtils.isNotBlank(byId.getParentId())) {
			name = byId.getKmmc() + "/" + name;
			getParents(byId.getParentId(), name);
		} else {

		}
//		return name;
	}

	/**
	 * 跳转账表
	 * @return
	 */
	public String toAccount() {
//		System.out.println("----------method in-------------");
		if (null != this.getLoginUser()) {
			deptCode = "/ReportServer?reportlet=" + cpt + ".cpt&loginUser="+this.getLoginUser().getDisplayName();
			return SUCCESS;
		} else {
			return "fail";
		}

	}

	/**
	 * 打印机制凭证
	 * @return
	 */
	public String printJzpz() {
		System.out.println("----------method in-------------");
		deptCode = "/ReportServer?reportlet=yzscwjzpz.cpt&printId="+printId;
		return SUCCESS;
	}

	/**
	 * 打印退费机制凭证
	 * @return
	 */
	/*public String printJzpztf() {
		System.out.println("----------method in-------------");
		deptCode = "/ReportServer?reportlet=yzscwjzpztf.cpt&printId="+printId;
		return SUCCESS;
	}*/

/*	public static void main(String[] args) {
		LocalDate firstDay = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
		LocalDate now = LocalDate.now();
		Map<String, Object> map = new HashMap<>();
		LocalDate tempDate = firstDay;
		while (now.compareTo(tempDate)!=0) {
			map.put(tempDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")),1);
			tempDate = tempDate.plusDays(1);
			System.out.println(tempDate.toString());
		}
		System.out.println(map);
	}*/

	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Yzscwpzgl getYzscwpzgl() {
		return yzscwpzgl;
	}

	public void setYzscwpzgl(Yzscwpzgl yzscwpzgl) {
		this.yzscwpzgl = yzscwpzgl;
	}

	public YzscwpzglService getyzscwpzglService() {
		return yzscwpzglService;
	}

	public void setYzscwpzglService(YzscwpzglService yzscwpzglService) {
		this.yzscwpzglService = yzscwpzglService;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

    public InputStream getExcelFile() {
        return excelFile;
    }

    public void setExcelFile(InputStream excelFile) {
        this.excelFile = excelFile;
    }

    public Yzscwkmgl getYzscwkjkm() {
        return yzscwkjkm;
    }

    public void setYzscwkjkm(Yzscwkmgl yzscwkjkm) {
        this.yzscwkjkm = yzscwkjkm;
    }

    public List<Yzscwkmgl> getYzscwkjkmList() {
        return yzscwkjkmList;
    }

    public void setYzscwkjkmList(List<Yzscwkmgl> yzscwkjkmList) {
        this.yzscwkjkmList = yzscwkjkmList;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

	public String getStartTerm() {
		return startTerm;
	}

	public void setStartTerm(String startTerm) {
		this.startTerm = startTerm;
	}

	public String getEndTerm() {
		return endTerm;
	}

	public void setEndTerm(String endTerm) {
		this.endTerm = endTerm;
	}

	public List<YzscwpzglSfxx> getYzscwpzglSfxx() {
		return yzscwpzglSfxx;
	}

	public void setYzscwpzglSfxx(List<YzscwpzglSfxx> yzscwpzglSfxx) {
		this.yzscwpzglSfxx = yzscwpzglSfxx;
	}

	public String getCpt() {
		return cpt;
	}

	public void setCpt(String cpt) {
		this.cpt = cpt;
	}

	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	public String getPrintId() {
		return printId;
	}

	public void setPrintId(String printId) {
		this.printId = printId;
	}

	public String getPzlx() {
		return pzlx;
	}

	public void setPzlx(String pzlx) {
		this.pzlx = pzlx;
	}

	public List<YzscwpzglSfxxVO> getYzscwpzglSfxxVO() {
		return yzscwpzglSfxxVO;
	}

	public void setYzscwpzglSfxxVO(List<YzscwpzglSfxxVO> yzscwpzglSfxxVO) {
		this.yzscwpzglSfxxVO = yzscwpzglSfxxVO;
	}

	public List<Yzsdicgl> getYzsdicgls() {
		return yzsdicgls;
	}

	public void setYzsdicgls(List<Yzsdicgl> yzsdicgls) {
		this.yzsdicgls = yzsdicgls;
	}
}
