package com.jshx.mobile.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.activiti.util.ActivitiVarConstants;
import com.jshx.cjjlb.entity.Cjjlb;
import com.jshx.cjjlb.service.CjjlbService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.dao.JdbcUtil;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.CodeUtil;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.service.JkmxService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.makereport.entity.Makereport;
import com.jshx.mobile.service.MobileManager;
import com.jshx.mobile.utils.DecodeStr;
import com.jshx.mobile.utils.JsonUtil;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRight;
import com.jshx.module.admin.entity.UserRole;
import com.jshx.module.admin.service.CodeService;
import com.jshx.module.admin.service.DeptService;
import com.jshx.module.admin.service.UserLinkedDeptService;
import com.jshx.module.admin.service.UserRoleService;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.service.QtfymxService;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.service.ReturnItemService;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.spjkjl.service.SpjkjlService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

/**
 * 
 * @author 毛颖飞
 */

public class GzlScheduleAction extends BaseAction {

	private String para;

	private String callback;

	private String cpage; // 当前页数

	private String len; // 每页条数

	private String jsonString; // 返回JSON

	private Pagination pagination;
    
	@Autowired()
    private GenericManager genericManager;
	@Autowired
	private UserService userService;
	@Autowired
	private MobileManager mobileManager;
	@Autowired
	private RuntimeService runtimeService;
	@Autowired
	private IdentityService identityService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private JdbcUtil jdbcUtil;
	@Autowired
	private HistoryService historyService;
	@Autowired
	private UserRoleService userRoleService;
	@Autowired
	private ActivitiService activitiService;
	@Autowired
	protected FormService formService;
	@Autowired
	protected RepositoryService repositoryService;
	@Autowired
	protected ProcessEngine processEngine;
	@Autowired
	private DeptService deptService;
	@Autowired
	private UserLinkedDeptService userLinkedDeptService;
	@Autowired
	private CodeService codeService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private PaymentItemPendingService paymentItemPendingService;
	
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private CjjlbService cjjlbService;
	 @Autowired()
	    private ReturnItemService returnItemService;
	  @Autowired
			private CktzsService cktzsService;
	  @Autowired
		private SpjlbService spjlbService;
	    @Autowired
		private QtfymxService qtfymxService;
	    @Autowired
	 		private JkmxService jkmxService;
		@Autowired
		private PaymentItemHisService paymentItemHisService;
		 @Autowired
		    private FawenAttachService fawenAttachService; 
		 @Autowired
			private SpjkjlService spjkjlService;
		 @Autowired
			private DxpzService dxpzService;
		 
	/**
	 * 催缴日志
	 */
	public void queryFlowDataDetail(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Map<String,Object> paraMap = new HashMap<String,Object>();
			Pagination pagination = new Pagination(this.getRequest());
			
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				//
				String slbh = map.get("slbh");
				//测试用数据
//				String slbh = "201705050105sf063";
			   
				paraMap.put("slbh", "%" + slbh + "%");


            	JsonConfig config = new JsonConfig();
        		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
        		Map<String, String> codeMap = new HashMap<String, String>();
        		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
        		
        		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
        		final String filter = "cjrz|createTime|jbr|fhr|fhsj|fhyj|syr|sysj|syyj|";
	             
        		if (filter != null && filter.length() > 1) {
					config.setJsonPropertyFilter(new PropertyFilter() {
						public boolean apply(Object source, String name, Object value) {
							if (filter.indexOf(name + "|") != -1)
								return false;
							else
								return true;
						}
					});
				}
        		pagination = cjjlbService.findByPage(pagination, paraMap);
				List<Cjjlb> lcs=pagination.list;
				
				if(lcs.size()>0){
				
				}
				 
				JSONArray json;
				json = JSONArray.fromObject(pagination.getListOfObject(),
						config);
				String ywinfo=json.toString();
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"total\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"rows\": ");
//				sb.append(JsonUtil.listmapToJsonString(pagination.getList()));
				sb.append(ywinfo);
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
			
		}
	}
	/**
	 * 未缴费列表
	 */
	public void queryVoiceDetail(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Map<String,Object> paraMap = new HashMap<String,Object>();
			Pagination pagination = new Pagination(this.getRequest());
			pagination.setPageNumber(null == map.get("cpage") ? 10 : Integer.parseInt(map.get("cpage")));
			pagination.setPageSize(null == map.get("len") ? 1 : Integer.parseInt(map.get("len")));

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				//或者用户
//				String userId = map.get("userId");
//				Map<String, Object> mapuser = new HashMap<String, Object>();
//				mapuser.put("loginId", userId);
//			    User user =userService.findUserByLoginId(mapuser);
//			    
				String dwdm=map.get("dwdm");
			    if(null!=dwdm&&!"".equals(dwdm)&&!"999".equals(dwdm)){
			    	paraMap.put("dwdm", dwdm);
			    }
                if(null!=map.get("dwmc")&&!"".equals(map.get("dwmc"))){
                	paraMap.put("dwmc", "%" + map.get("dwmc").trim() + "%");
                }
                if(null!=map.get("xmmc")&&!"".equals(map.get("xmmc"))){
                	paraMap.put("xmmc", "%" + map.get("xmmc").trim() + "%");
                }
                if(null!=map.get("isyq")&&!"2".equals(map.get("isyq"))){
                	if("0".equals(map.get("isyq"))){
                		//逾期
                		paraMap.put("isyq",  map.get("isyq").trim() );
                	}else{
                		paraMap.put("isnotyq",  map.get("isyq").trim() );
                	}
                }
//                paraMap.put("isnotyq",  "1" );
			    

            	JsonConfig config = new JsonConfig();
        		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
        		Map<String, String> codeMap = new HashMap<String, String>();
        		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
        		
        		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
				final String filter = "slbh|dwmc|xmmc|mjyj|yqts|";
				if (filter != null && filter.length() > 1) {
					config.setJsonPropertyFilter(new PropertyFilter() {
						public boolean apply(Object source, String name, Object value) {
							if (filter.indexOf(name + "|") != -1)
								return false;
							else
								return true;
						}
					});
				}
				pagination = paymentItemPendingService.findByPage(pagination, paraMap);
				List<PaymentItemPending> lcs=pagination.list;
				
				if(lcs.size()>0){
					for (PaymentItemPending bean : lcs) {
						if(null!=bean.getDyriqi()&&!"".equals(bean.getDyriqi())){
							int riqi=daysBetween(bean.getDyriqi(),new Date());
							if(riqi>30){
								bean.setYqts(String.valueOf(riqi-30));
							}else{
								
								bean.setYqts("0");
							}
						}else{
							bean.setYqts("0");
						}
					}
				}
				 
				JSONArray json;
				json = JSONArray.fromObject(pagination.getListOfObject(),
						config);
				String ywinfo=json.toString();
//				convObjectToJson(pagination, config);
				
				
				
//				pagination = mobileManager.findBySqlId(pagination, paraMap);
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"total\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"rows\": ");
//				sb.append(JsonUtil.listmapToJsonString(pagination.getList()));
				sb.append(ywinfo);
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 未缴费列表详情
	 */
	public void querySMSDetail(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String slbh=map.get("slbh");
			Xmxxb xm=xmxxbService.getBySlbh(slbh);
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", "%" + map.get("slbh") + "%");
			List<PaymentItemPending> lps= paymentItemPendingService.findPaymentItemPending(paraMap);
			PaymentItemPending bean=null;
			if(lps.size()>0){
				bean=lps.get(0);
			}
			
			List<Jktzs> ljks=jktzsService.findByAll(paraMap);
			Jktzs jkbean=null;
			if(ljks.size()>0){
				jkbean=ljks.get(0);
			}
			
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"slbh\":\"");
				sb.append(xm.getSlbh());
				
				sb.append("\",\"xxylb\":\"");
				sb.append(xm.getXxylb());
                
				sb.append("\",\"dwmc\":\"");
				sb.append(xm.getJsdw());

				sb.append("\",\"xmmc\":\"");
				sb.append(xm.getXmmc());
				
				sb.append("\",\"mjyj\":\"");
				sb.append(xm.getMjyj());
				
				sb.append("\",\"bllb\":\"");
				sb.append(tobllbtype(xm.getBllb()));
				
				sb.append("\",\"zclb\":\"");
				sb.append(tozclbype(xm.getZclb()));
				
				sb.append("\",\"zjzmj\":\"");
				sb.append(xm.getZjsmj());
				
				sb.append("\",\"yjmj\":\"");
				sb.append(bean.getPtyjmj());
				
				sb.append("\",\"yjje\":\"");
				sb.append(bean.getPtyjje());
				
				sb.append("\",\"ymmj\":\"");
				sb.append(bean.getPtymmj());
				sb.append("\",\"ymjj\":\"");
				sb.append(bean.getPtymje());
				
				sb.append("\",\"spjssj\":\"");
				sb.append(bean.getDyriqi());
				
				sb.append("\",\"Jktzsbh\":\"");
				sb.append(jkbean.getDzbh());
				
				
				sb.append("\",\"yqts\":\"");
				String yt="0";
				if(null!=bean.getDyriqi()&&!"".equals(bean.getDyriqi())){
					int riqi=daysBetween(bean.getDyriqi(),new Date());
					if(riqi>30){
						yt=String.valueOf(riqi-30);
					}
				}
				sb.append(yt);
				
				sb.append("\"}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
			
			
		}
	}
	
	  /**
     * 签收任务
     *
     * @throws IOException
     * @author YuWeitao
     */
    public void toclaimTask() throws IOException {
    	
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
    	
    	String taskId=map.get("taskId");
    	String userId=map.get("userId");
    	     User user=userService.findUserById(userId);
    	     String loginId=user.getLoginId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        if (null != task) {
            if (StringUtils.isEmpty(task.getAssignee()))
                taskService.claim(task.getId(), loginId);
            TaskFormData tfd = formService.getTaskFormData(taskId);
//            Map<String, Object> mapob = new HashMap<>();
            if (tfd != null) {
                List<FormProperty> formProperties = tfd.getFormProperties();
                List<Map<String, Object>> properties = new ArrayList<>();

                activitiService.getFormProperties(formProperties, properties);
//                mapob.put("tfd", properties);
            }


            // 获取下一步任务信息
            Map<String, FlowNode> nextNodeMap = activitiService.findNextTask(taskId);
            if (nextNodeMap != null && !nextNodeMap.isEmpty()) {
                List<Map<String, Object>> nextSteps = new ArrayList<>();

                activitiService.findNextStep(task, nextNodeMap, nextSteps);
//                mapob.put("nextSteps", nextSteps);
            }
//            mapob.put("result", true);
            
            //签收后重新计算dueDate
            String dueDateString = activitiService.findDueDateExpression(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
		    if(null != dueDateString && !dueDateString.isEmpty() && dueDateString.startsWith("P")){
		    	try {
		    		DateTime claimDate = new DateTime();
					taskService.setDueDate(taskId, claimDate.plus(Period.parse(dueDateString)).toDate());
				} catch (Exception e) {
					// TODO: handle exception
				}
		    }
		    
		    String str = "{ \"message\": \"签到失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"签收成功\",\"code\": \"0\"");
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		    
		    
            } 
        
        
		}
        
    }
    
    /**
     * 详情接口
     */
    public  void  selectxq(){
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String taskId=map.get("taskId");
			
//			String userId=map.get("userId");
//   	     User user=userService.findUserById(userId);
//   	     String loginId=user.getLoginId();
			
			String userId=map.get("userId");
			       
			String slbh=map.get("slbh");
	        
	    	Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey =  processInstance.getBusinessKey();
			
			Map<String, Object> vsp = new HashMap<String, Object>();
			vsp.put("slbh", slbh);
			List<Spjlb> ls = spjlbService.findSpjlball(vsp);
			Spjlb sp =new Spjlb();
			if(ls.size()>0){
		       sp = ls.get(0);
			}
			
	          String procInstanceId = taskService.createTaskQuery().taskId(taskId).singleResult().getProcessInstanceId();
	          List<Comment> commentList = taskService.getProcessInstanceComments(procInstanceId);
	          String ren="";
	          Date   sj=new Date();
	          String yj="";
	          List<Map<String, Object>>  lh=new ArrayList<Map<String, Object>>();
	          HashMap<String, Object> sr=new HashMap<String, Object>();
	          sr.put("mc", "缴费受理");
	          sr.put("ren", sp.getShouliren());
	          sr.put("yj", sp.getSlbz());
	   	     SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
	          sr.put("sj", sdf.format(sp.getSlsj()));
	          if(commentList!=null&&commentList.size()>0){
	              for(Comment comment : commentList){
	            	  HashMap<String, Object> bean=new HashMap<String, Object>();
	            	  HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId(comment.getTaskId()).singleResult();
	            	     if(null!=historicTaskInstance){
	            	    	  User uu=userService.findUserByLoginId(comment.getUserId());
	                          if(null!=uu){
	                        	  ren= uu.getDisplayName() ;
	                          }else{
	                        	  ren=  comment.getUserId();
	                          }
	                          if(null==comment.getFullMessage()){
	                        	  yj= "无" ;
	                          }else{
	                        	  yj=  comment.getFullMessage();
	                        	  sj=comment.getTime();
	                          }
	                          bean.put("mc", historicTaskInstance.getName());
	                          bean.put("ren", ren);
	                          bean.put("yj", yj);
	                   	   
	       			          String sjrq=sdf.format(sj); 
	                          bean.put("sj", sjrq);
	            	     }
	            	     lh.add(bean);
	                   }
	              }
	          lh.add(sr);
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"taskId\":\"");
				sb.append(taskId);
				
				sb.append("\",\"userId\":\"");
				sb.append(userId);
				sb.append("\",\"slbh\":\"");
				sb.append(slbh);
			
				sb.append("\",\"xqlist\":");
				sb.append(JsonUtil.listmap_to_json_string(lh));
				
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			JsonUtil.printJsonString(getResponse(), str);
		}
    }
    
    
    /**
     * 面积修改审核展示
     */
    public  void  toAuditmjxgview(){
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String taskId=map.get("taskId");
			String userId=map.get("userId");

	        
	    	Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey =  processInstance.getBusinessKey();
			Xmxxb xmb = new Xmxxb();
			xmb = xmxxbService.getById(businessKey);
			

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"taskId\":\"");
				sb.append(taskId);
				
				sb.append("\",\"userId\":\"");
				sb.append(userId);
				sb.append("\",\"slbh\":\"");
				sb.append(xmb.getSlbh());
				
				sb.append("\",\"xxylb\":\"");
				sb.append(xmb.getXxylb());
                
				sb.append("\",\"dwmc\":\"");
				sb.append(xmb.getJsdw());

				sb.append("\",\"xmmc\":\"");
				sb.append(xmb.getXmmc());
				
				sb.append("\",\"dsmj\":\"");
				sb.append(xmb.getZjzmjds());
				
				sb.append("\",\"dxmj\":\"");
				sb.append(xmb.getJzmjdx());
				
				sb.append("\",\"ghhzmj\":\"");
				sb.append(xmb.getZjsmj());
				
				sb.append("\",\"jdmj\":\"");
				sb.append(xmb.getYsdmj());
				
				sb.append("\"}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			JsonUtil.printJsonString(getResponse(), str);
		}
    }
    
    /**
     * 面积修改审核操作 --接口
     */
     public void todoAuditmjxg(){
        	DecodeStr der = new DecodeStr();
     		Map<String, String> map = new HashMap<String, String>();
     		map = der.getPostPara(para, callback);
     		if (null == map || map.isEmpty()) {
     			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
     		} else {
     			String taskId=map.get("taskId");
     			String userId=map.get("userId");
     			
     			//意见
     			String comment=map.get("comment");
     			//结果 0通过 1驳回
     			String outcome=map.get("outcome");
     			User u=userService.findUserById(userId);
     			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
    			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
    					.processInstanceId(task.getProcessInstanceId()).singleResult();
    			String businessKey = processInstance.getBusinessKey();
    			Xmxxb xmb = new Xmxxb();
    			xmb = xmxxbService.getById(businessKey);

    			Map<String, Object> vsp = new HashMap<String, Object>();
    			vsp.put("slbh", xmb.getSlbh());
    			List<Spjlb> ls = spjlbService.findSpjlball(vsp);
    			Spjlb sp = ls.get(0);

    			activitiService.addComment(task, u.getLoginId(), comment);
    			Map<String, Object> variables = new HashMap<String, Object>();
    		
    				// 受理审核
    				variables.put("tgjfsh", "0");
    				// 直接打印
    				if ("0".equals(xmb.getIsdikou()) && "0".equals(xmb.getBllb()) &&  islcbysfc(xmb.getDwdm()))
    				{
    					sp.setZjdyjks("0");

    					// 符合直接打印条件
    					xmb.setZjdyjks("0");
    					// 获取单位平方的金额,算出应缴金额
    					String danjia = (String) Constant.CONSTANT_MAP.get("ptf");
    					String tem = SysPropertiesUtil.jinehuoqu(xmb.getZjsmj(), danjia);
    					xmb.setYjmj(xmb.getZjsmj());
    					xmb.setYjje(tem);

    					PaymentItemPending dj = new PaymentItemPending();
//    					dj.setDeptId(this.getLoginUserDepartmentId());
    					dj.setDeptId(u.getDept().getId());
    					dj.setDelFlag(0);
    					dj.setDwdm(xmb.getDwdm());
    					dj.setCsmj(xmb.getZjsmj());
    					dj.setPtfbz((String) Constant.CONSTANT_MAP.get("ptf"));
    					dj.setXmbzj(xmb.getId());
    					dj.setDwmc(xmb.getJsdw());
    					dj.setSlbh(xmb.getSlbh());
    					dj.setMjyj(xmb.getMjyj());
    					dj.setZsdw(xmb.getZsdw());
    					dj.setXmmc(xmb.getXmmc());
    					dj.setPtyjmj(xmb.getYjmj());
    					dj.setPtyjje(xmb.getYjje());
    					dj.setZyjje(dj.getPtyjje());
    					dj.setZymje("0");
    					dj.setIsqitalx("0");
    					dj.setWarnFlag("0");
    					Jktzs jk = new Jktzs();
    					// 催缴记录
    					jk.setBeizhu("");
    					// 电子编号规则
    					String dz = genericManager.getSN("dzjk");
						String tempYear = DateTime.now().getYear() + "";
    					dz = tempYear + "jk" + xmb.getBllb() + xmb.getDwdm() + dz;
    					jk.setDzbh(dz);
    					// 带回滚的保存
    					paymentItemPendingService.zjdyxg(dj, xmb, jk);
    					
    					
    				}
    				sp.setSlshr(u.getDisplayName());
    				sp.setSlshsj(new Date());
    				sp.setSlshbz(comment);
    			spjlbService.update(sp);
    			taskService.complete(taskId, variables);
     			
     	    
     			String str = "{ \"message\": \"办理失败\",\"code\": \"1000\"}";
     			try {
     				StringBuilder sb = new StringBuilder();
     				sb.append("{ \"message\": \"办理成功\",\"code\": \"0\"");
     				sb.append(",\"taskId\":\"");
     				sb.append(taskId);
     				
     				sb.append("\",\"userId\":\"");
     				sb.append(userId);
     		
     				sb.append("\"}");
     				str = sb.toString();
     				System.out.println("传输到手机端：" + str);
     			} catch (Exception e) {
     				e.printStackTrace();
     			}
     			
     			JsonUtil.printJsonString(getResponse(), str);
     		}
     }
     
    
    
    
    /**
     * 催缴展示
     */
    public void toAuditcjview(){
     	DecodeStr der = new DecodeStr();
    		Map<String, String> map = new HashMap<String, String>();
    		map = der.getPostPara(para, callback);
    		if (null == map || map.isEmpty()) {
    			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
    		} else {
    			String taskId=map.get("taskId");
    			String userId=map.get("userId");
    
    	        
    	    	Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
    			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
    			String businessKey =  processInstance.getBusinessKey();
    			Cjjlb cjjlb=cjjlbService.getById(businessKey);
    			
    			
    			Map<String, Object> paraMap = new HashMap<String, Object>();
    			paraMap.put("xmbzj", cjjlb.getXmxxbzj() );
    			List<Cktzs> li=cktzsService.findByall1(paraMap);
    			  Cktzs cktzs=new Cktzs();
    			  if(li.size()>0){
    				  cktzs=li.get(0);
    			  }
    			  
    			  List<Jktzs> jls=             jktzsService.findByAll(paraMap);
    			  Jktzs bean=new Jktzs();
    			  String tzjfsj="";
    			  if(jls.size()>0){
    				  bean=jls.get(0);
    				  tzjfsj=bean.getDyriqi().toString();
    			  }
//    	        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
//    	        ActionContext.getContext().put("outcomeList", outcomeList);
//    	        Map<String, String> paramMap = new HashMap<String, String>();
//    			paramMap.put("bizrowid", xmxxb.getId());
//    			paramMap.put("xmType", "项目解锁");
//    			List<FawenAttach> attach= fawenAttachService.queryAttachListByTempleId(paramMap);
    			
    	          String procInstanceId = taskService.createTaskQuery().taskId(taskId).singleResult().getProcessInstanceId();
    	          List<Comment> commentList = taskService.getProcessInstanceComments(procInstanceId);
    	          String fhr="";
    	          String fhyj="";
    	          if(commentList!=null&&commentList.size()>0){
    	              for(Comment comment : commentList){
    	            	  HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId(comment.getTaskId()).singleResult();
    	            	     if(null!=historicTaskInstance&&"催缴复核".equals(historicTaskInstance.getName())){
    	            	    	  User uu=userService.findUserByLoginId(comment.getUserId());
    	                          if(null!=uu){
    	                        	  fhr= uu.getDisplayName() ;
    	                          }else{
    	                        	  fhr=  comment.getUserId();
    	                          }
    	                          if(null==comment.getFullMessage()){
    	                        	  fhyj= "无" ;
    	                          }else{
    	                        	  fhyj=  comment.getFullMessage();
    	                          }
    	            	     }
    	                   }
    	              }
    			   String jfri="";
    			   if(cktzs!=null){
    				   
    				   SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
    			          jfri=sdf.format(cktzs.getCreateTime());  
    			   }
    			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
    			try {
    				StringBuilder sb = new StringBuilder();
    				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
    				sb.append(",\"taskId\":\"");
    				sb.append(taskId);
    				
    				sb.append("\",\"userId\":\"");
    				sb.append(userId);
    				sb.append("\",\"slbh\":\"");
    				sb.append(cktzs.getSlbh());
    				
    				sb.append("\",\"xxylb\":\"");
    				sb.append(cktzs.getXxbbh());
                    
    				sb.append("\",\"dwmc\":\"");
    				sb.append(cktzs.getDwmc());

    				sb.append("\",\"xmmc\":\"");
    				sb.append(cktzs.getXmmc());
    				sb.append("\",\"jsdd\":\"");
    				sb.append(cktzs.getXmdd());
    				
    				sb.append("\",\"zjsmj\":\"");
    				sb.append(cktzs.getZjzmj());
    				
    				sb.append("\",\"yjmj\":\"");
    				sb.append(cktzs.getJfmj());
    				
    				sb.append("\",\"yjje\":\"");
    				sb.append(cktzs.getJfje());
    				
    				sb.append("\",\"ymmj\":\"");
    				sb.append(cktzs.getMjmj());
    				
    				sb.append("\",\"ymje\":\"");
    				sb.append(cktzs.getMjje());
    				
    				sb.append("\",\"tzjfsj\":\"");
    				sb.append(tzjfsj);
    				
    				sb.append("\",\"jfdqrq\":\"");
    				sb.append(jfri);
    				
    				sb.append("\",\"cjrz\":\"");
    				sb.append(cjjlb.getCjrz());
    				
    				sb.append("\",\"jbr\":\"");
    				sb.append(cjjlb.getJbr());
    				
    				sb.append("\",\"fhr\":\"");
    				sb.append(fhr);
    				
    				sb.append("\",\"fhyj\":\"");
    				sb.append(fhyj);
    			
    				sb.append("\"}");
    				str = sb.toString();
    				System.out.println("传输到手机端：" + str);
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    			
    			JsonUtil.printJsonString(getResponse(), str);
    		}
        	
    }
    
   /**
    * 催缴审阅操作 
    */
    public void todoAuditcj(){
    	
       	DecodeStr der = new DecodeStr();
    		Map<String, String> map = new HashMap<String, String>();
    		map = der.getPostPara(para, callback);
    		if (null == map || map.isEmpty()) {
    			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
    		} else {
    			String taskId=map.get("taskId");
    			String userId=map.get("userId");
    			//意见
    			String comment=map.get("comment");
    			//结果 0通过 1驳回
    			String outcome=map.get("outcome");
    	  
    			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
    			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
    			String businessKey =  processInstance.getBusinessKey();
    			Cjjlb cjjlb=cjjlbService.getById(businessKey);
    			cjjlb.setSyyj(comment);
    			cjjlb.setSysj(new Date());
    			User u=userService.findUserById(userId);
    			cjjlb.setSyr(u.getDisplayName());
    			cjjlbService.update(cjjlb);
    			activitiService.addComment(task, u.getLoginId(), comment);
    			   Map<String, Object> variables = new HashMap<String, Object>();
    		          if("0".equals(outcome)){
    		        	//确认
    		         	variables.put("sypd", "0");
    		          }else{
    		         	 //退回
    		         	variables.put("sypd", "1");
    		          }
    			taskService.complete(taskId,variables);
    			
    	    
    			String str = "{ \"message\": \"办理失败\",\"code\": \"1000\"}";
    			try {
    				StringBuilder sb = new StringBuilder();
    				sb.append("{ \"message\": \"办理成功\",\"code\": \"0\"");
    				sb.append(",\"taskId\":\"");
    				sb.append(taskId);
    				
    				sb.append("\",\"userId\":\"");
    				sb.append(userId);
    		
    				sb.append("\"}");
    				str = sb.toString();
    				System.out.println("传输到手机端：" + str);
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    			
    			JsonUtil.printJsonString(getResponse(), str);
    		}
        	
    	
    	
    }
    
    
    /**
     * 征收流程展示页面(审核,审定,批准)
     */
    public void todozslcview(){
    	
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String taskId=map.get("taskId");
			String userId=map.get("userId");
			

			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
					.processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey = processInstance.getBusinessKey();
			Xmxxb xmxxb = new Xmxxb();
			xmxxb = xmxxbService.getById(businessKey);

			Map<String, Object> paraMap = new HashMap<String, Object>();
			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}
			List<Spjkjl> listsp = spjkjlService.findSpjkjlall(paraMap);
			Spjkjl sp = new Spjkjl();
			if (listsp.size() > 0)
			{
				sp = listsp.get(0);
			}
			Map<String, String> vm = new HashMap<String, String>();
			vm.put("bizrowid", businessKey);
			vm.put("xmType", "缴费受理");
			vm.put("attachType", "核准信息一览表");
			List<FawenAttach> attach = fawenAttachService.queryAttachListByTempleId(vm);
			String hzxxylb="";
			String hzxxylbmc="";
			if(attach.size()>0){
				hzxxylb=attach.get(0).getAttachpath();
				hzxxylbmc=attach.get(0).getAttachname();
			}
			
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"taskId\":\"");
				sb.append(taskId);
				
				sb.append("\",\"userId\":\"");
				sb.append(userId);
				sb.append("\",\"slbh\":\"");
				sb.append(xmxxb.getSlbh());
				
				sb.append("\",\"xxylb\":\"");
				sb.append(xmxxb.getXxylb());
                
				sb.append("\",\"dwmc\":\"");
				sb.append(xmxxb.getJsdw());

				sb.append("\",\"xmmc\":\"");
				sb.append(xmxxb.getXmmc());
				sb.append("\",\"jsdd\":\"");
				sb.append(xmxxb.getJsdd());
				
				sb.append("\",\"mjyj\":\"");
				sb.append(xmxxb.getMjyj());
				sb.append("\",\"bllb\":\"");
				sb.append(tobllbtype(xmxxb.getBllb()));
				sb.append("\",\"zclb\":\"");
				sb.append(tozclbype(xmxxb.getZclb()));
				
				sb.append("\",\"zjsmj\":\"");
				sb.append(xmxxb.getZjsmj());
				
				String yjmj="";
				String yjje="";
				String ymmj="";
				String ymje="";
				
				if("0".equals(xmxxb.getZjdyjks())){
					yjmj=xmxxb.getYjmj();
					yjje=xmxxb.getYjje();
				}else{
					yjmj=sp.getPtyjmj();
					yjje=sp.getPtyjje();
					 if("1".equals(xmxxb.getBllb())){
						 ymmj=sp.getPtymmj();
						ymje=sp.getPtymje();		 
					 }
				}
				
				sb.append("\",\"yjmj\":\"");
				sb.append(yjmj);
				
				sb.append("\",\"yjje\":\"");
				sb.append(yjje);
				
				sb.append("\",\"ymmj\":\"");
				sb.append(ymmj);
				
				sb.append("\",\"ymje\":\"");
				sb.append(ymje);
				
				sb.append("\",\"hzxxylb\":\"");
				sb.append(hzxxylb);
				sb.append("\",\"hzxxylbmc\":\"");
				sb.append(hzxxylbmc);
		
				sb.append("\"}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			JsonUtil.printJsonString(getResponse(), str);
		}
    	
    }
    
    
    /**
     * 审核,审定,批准操作接口
     */
    public  void  todlzslc(){
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String taskId=map.get("taskId");
			String userId=map.get("userId");
			//意见
			String comment=map.get("comment");
			//结果 0通过 1驳回
			String caozuo=map.get("outcome");
			
			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
					.processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey = processInstance.getBusinessKey();
			Xmxxb xmb = new Xmxxb();
			xmb = xmxxbService.getById(businessKey);
            User u=userService.findUserById(userId);
            String lcm=task.getName();
            //缴费审核-----------------------------------------------------------------------------------------------------
			if("缴费审核".equals(lcm)){
			Map<String, Object> vsp = new HashMap<String, Object>();
			vsp.put("slbh", xmb.getSlbh());
			List<Spjlb> ls = spjlbService.findSpjlball(vsp);
			Spjlb sp = ls.get(0);
			sp.setSdr(u.getDisplayName());
			sp.setSdsj(new Date());
			sp.setSdbz(comment);

			activitiService.addComment(task, u.getLoginId(), comment);
			Map<String, Object> variables = new HashMap<String, Object>();
			if ("0".equals(caozuo))
			{
				// 确认
				variables.put("isjfsd", "0");
			}
			else
			{
				sp.setIsdyspb("0");
				// 退回
				variables.put("isjfsd", "1");
			}
			spjlbService.update(sp);
			taskService.complete(taskId, variables);
			}

			//缴费审定---------------------------------------------------------------------------------------------------------------
			if("缴费审定".equals(lcm)){
				Map<String, Object> vsp = new HashMap<String, Object>();
				vsp.put("slbh", xmb.getSlbh());
				List<Spjlb> ls = spjlbService.findSpjlball(vsp);
				Spjlb spjl = ls.get(0);
				spjl.setShr(u.getDisplayName());
				spjl.setShsj(new Date());
				
				if("0".equals(caozuo)&&"1".equals(xmb.getBllb())&&"sf".equals(xmb.getDwdm())){
					comment="经审核,该项目符合配套费减免政策规定,减免额度核算准确。请委领导批示。";
				}
				spjl.setShbz(comment);

				activitiService.addComment(task, u.getLoginId(), comment);
				Map<String, Object> variables = new HashMap<String, Object>();
				if ("0".equals(caozuo))
				{
					// 确认
					if ("0".equals(xmb.getBllb()) && islcbysfc(xmb.getDwdm()))
					{

						// 审批表,流程结束时间
						spjl.setLcjssj(new Date());
						// 收费处,直接缴费 无批准
						variables.put("isjfsh", "2");

						if ("1".equals(xmb.getZjdyjks()))
						{
							// 入代缴款库,打印缴款通知书
							Map<String, Object> paraMap = new HashMap<String, Object>();
							if ((null != xmb.getSlbh()) && (0 < xmb.getSlbh().trim().length()))
							{
								paraMap.put("slbh", "%" + xmb.getSlbh().trim() + "%");
							}
							List<Spjkjl> listsp = spjkjlService.findSpjkjlall(paraMap);
							Spjkjl sp = new Spjkjl();
							if (listsp.size() > 0)
							{
								sp = listsp.get(0);
							}
							// 删除相同paymentItemPendingService
							PaymentItemPending dj = new PaymentItemPending();
							dj.setCsmj(xmb.getZjsmj());
							dj.setDwdm(xmb.getDwdm());
							dj.setPtfbz(sp.getPtfbz());
							dj.setDeptId(u.getDept().getId());
							dj.setDelFlag(0);
							dj.setXmbzj(xmb.getId());
							dj.setSlbh(xmb.getSlbh());
							dj.setMjyj(xmb.getMjyj());
							dj.setZsdw(xmb.getZsdw());
							dj.setXmmc(xmb.getXmmc());
							dj.setPtyjmj(sp.getPtyjmj());
							dj.setPtyjje(sp.getPtyjje());
							dj.setDwmc(xmb.getJsdw());
							dj.setWarnFlag("0");
							if (!"".equals(sp.getPtymmj()) && null != sp.getPtymmj())
							{
								dj.setPtymmj(sp.getPtymmj());
								dj.setPtymje(sp.getPtymje());
							}
							if ("1".equals(xmb.getIsdikou()))
							{
								dj.setDkmj(sp.getDkmj());
								dj.setDkxmslh(sp.getDkxmslh());
							}

							if (null != sp.getIsqitalx() && "1".equals(sp.getIsqitalx()))
							{
								isweikou(dj, sp);
								String zyjje = SysPropertiesUtil.add(dj.getRfyjje(), dj.getByyjje());
								zyjje = SysPropertiesUtil.add(zyjje, dj.getXqyjje());
								zyjje = SysPropertiesUtil.add(zyjje, dj.getPtyjje());
								dj.setZyjje(zyjje);
								String zymje = SysPropertiesUtil.add(dj.getRfymje(), dj.getByymje());
								zymje = SysPropertiesUtil.add(zymje, dj.getXqymje());
								zymje = SysPropertiesUtil.add(zymje, dj.getPtymje());
								dj.setZymje(zymje);
								dj.setIsqitalx("1");
							}
							else
							{
								dj.setZyjje(dj.getPtyjje());
								dj.setZymje(dj.getPtymje());
								dj.setIsqitalx("0");
							}

							// 审批通过
							xmb.setIssptg("0");
							xmb.setYjmj(dj.getPtyjmj());
							xmb.setYjje(dj.getPtyjje());
							// 批量保存可回滚
							Jktzs jk = new Jktzs();

							// 催缴记录
							jk.setBeizhu("");
							// 电子编号规则
							String dz = genericManager.getSN("dzjk");
							String tempYear = DateTime.now().getYear() + "";
							dz = tempYear + "jk" + xmb.getBllb() + xmb.getDwdm() + dz;
							jk.setDzbh(dz);
							// 带回滚的保存
							paymentItemPendingService.czgl(dj, xmb, jk);
							//短信功能
							String neirong=xmb.getSlbh()+"-"+xmb.getXmmc()+"已办结，可打印缴款通知";
							String phones=dxpzService.findbyywbm("001",xmb.getDwdm());
							if(!"".equals(phones)){
//								CommonAction.send(neirong, phones, u.getDept().getId(),u.getDisplayName());
								CommonAction.sendNewMessage(neirong, phones, u.getDept().getId(),u.getDisplayName());
							}
						}
						else
						{
							// 直接打印通知书审批通过
							xmb.setIssptg("0");
							xmxxbService.update(xmb);
						}

						// 应缴面积等于0,直接进入已交款库
						Map<String, Object> yjwu = new HashMap<String, Object>();
						yjwu.put("slbh", xmb.getSlbh());
						List<PaymentItemPending> lpays = paymentItemPendingService.findPaymentItemPending(yjwu);
						if (lpays.size() > 0)
						{
							PaymentItemPending djkys = lpays.get(0);
							if (Double.valueOf(djkys.getZyjje()) == 0)
							{
								zjjrjk(djkys, xmb,u.getDept().getId());
							}
						}

					}
					else
					{
						variables.put("isjfsh", "0");
					}
				}
				else
				{
					// 退回 审定或复核
					if (islcbysfc(xmb.getDwdm())||isxianlin(xmb.getDwdm()))
					{
						variables.put("isjfsh", "3");
					}
					else
					{
						spjl.setIsdyspb("0");
						variables.put("isjfsh", "1");
					}
				}
				spjlbService.update(spjl);
				taskService.complete(taskId, variables);
				
				
			}
			
			//缴费批准-------------------------------------------------------------------------------------
			if("缴费批准".equals(lcm)){
				Map<String, Object> vsp = new HashMap<String, Object>();
				vsp.put("slbh", xmb.getSlbh());
				List<Spjlb> ls = spjlbService.findSpjlball(vsp);
				Spjlb spjl = ls.get(0);
				spjl.setPzr(u.getDisplayName());
				spjl.setPzsj(new Date());
				spjl.setPzbz(comment);

				activitiService.addComment(task, u.getLoginId(), comment);
				Map<String, Object> variables = new HashMap<String, Object>();
				if ("0".equals(caozuo))
				{
					spjl.setLcjssj(new Date());
					// 确认
					variables.put("isjfpz", "0");
					if ("1".equals(xmb.getZjdyjks()))
					{
						// 入代缴款库,打印缴款通知书
						Map<String, Object> paraMap = new HashMap<String, Object>();
						if ((null != xmb.getSlbh()) && (0 < xmb.getSlbh().trim().length()))
						{
							paraMap.put("slbh", "%" + xmb.getSlbh().trim() + "%");
						}
						List<Spjkjl> listsp = spjkjlService.findSpjkjlall(paraMap);
						Spjkjl sp = new Spjkjl();
						if (listsp.size() > 0)
						{
							sp = listsp.get(0);
						}
						// 删除相同
						PaymentItemPending dj = new PaymentItemPending();
						Map<String, Object> paraMap1 = new HashMap<String, Object>();
						if ((null != xmb.getSlbh()) && (0 < xmb.getSlbh().trim().length()))
						{
							paraMap1.put("slbh", "%" + xmb.getSlbh().trim() + "%");
						}
						List<PaymentItemPending> dlist = paymentItemPendingService.findPaymentItemPending(paraMap1);
						if (dlist.size() > 0)
						{
							for (PaymentItemPending be : dlist)
							{
								paymentItemPendingService.delete(be.getId());
							}
						}
						dj.setPtfbz(sp.getPtfbz());
						dj.setDwdm(xmb.getDwdm());
						dj.setDeptId(u.getDept().getId());
						dj.setDelFlag(0);
						dj.setCsmj(xmb.getZjsmj());
						dj.setXmbzj(xmb.getId());
						dj.setSlbh(xmb.getSlbh());
						dj.setMjyj(xmb.getMjyj());
						dj.setZsdw(xmb.getZsdw());
						dj.setXmmc(xmb.getXmmc());
						dj.setPtyjmj(sp.getPtyjmj());
						dj.setPtyjje(sp.getPtyjje());
						dj.setDwmc(xmb.getJsdw());
						dj.setWarnFlag("0");
						if (!"".equals(sp.getPtymmj()) && null != sp.getPtymmj())
						{
							dj.setPtymmj(sp.getPtymmj());
							dj.setPtymje(sp.getPtymje());
						}
						if ("1".equals(xmb.getIsdikou()))
						{
							dj.setDkmj(sp.getDkmj());
							dj.setDkxmslh(sp.getDkxmslh());
						}

						if (null != sp.getIsqitalx() && "1".equals(sp.getIsqitalx()))
						{
							isweikou(dj, sp);
							String zyjje = SysPropertiesUtil.add(dj.getRfyjje(), dj.getByyjje());
							zyjje = SysPropertiesUtil.add(zyjje, dj.getXqyjje());
							zyjje = SysPropertiesUtil.add(zyjje, dj.getPtyjje());
							dj.setZyjje(zyjje);
							String zymje = SysPropertiesUtil.add(dj.getRfymje(), dj.getByymje());
							zymje = SysPropertiesUtil.add(zymje, dj.getXqymje());
							zymje = SysPropertiesUtil.add(zymje, dj.getPtymje());
							dj.setZymje(zymje);
							dj.setIsqitalx("1");
						}
						else
						{
							dj.setZyjje(dj.getPtyjje());
							dj.setZymje(dj.getPtymje());
							dj.setIsqitalx("0");
						}
						// 审批通过
						xmb.setIssptg("0");
						xmb.setYjmj(dj.getPtyjmj());
						xmb.setYjje(dj.getPtyjje());
						//后加的...
						xmb.setYmmj(dj.getPtymmj());
						xmb.setYmje(dj.getPtymje());
						Jktzs jk = new Jktzs();
						// 催缴记录
						jk.setBeizhu("");
						// 电子编号规则
						String dz = genericManager.getSN("dzjk");
						String tempYear = DateTime.now().getYear() + "";
						dz = tempYear + "jk" + xmb.getBllb() + xmb.getDwdm() + dz;
						jk.setDzbh(dz);
						// 带回滚的保存
						paymentItemPendingService.czgl(dj, xmb, jk);
						String neirong=xmb.getSlbh()+"-"+xmb.getXmmc()+"已办结，可打印缴款通知";
						String phones=dxpzService.findbyywbm("001",xmb.getDwdm());
						if(!"".equals(phones)){
//							CommonAction.send(neirong, phones, u.getDept().getId(),u.getDisplayName());
							CommonAction.sendNewMessage(neirong, phones, u.getDept().getId(),u.getDisplayName());
						}
					}
					else
					{
						// 审批通过
						xmb.setIssptg("0");
						xmxxbService.update(xmb);
					}

					// 应缴面积等于0,直接进入已交款库
					Map<String, Object> yjwu = new HashMap<String, Object>();
					yjwu.put("slbh", xmb.getSlbh());
					List<PaymentItemPending> lpays = paymentItemPendingService.findPaymentItemPending(yjwu);
					if (lpays.size() > 0)
					{
						PaymentItemPending djkys = lpays.get(0);
						if (Double.valueOf(djkys.getZyjje()) == 0)
						{
							zjjrjk(djkys, xmb,u.getDept().getId());
						}
					}

				}
				else
				{
					// 退回
					variables.put("isjfpz", "1");
				}
				spjlbService.update(spjl);
				taskService.complete(taskId, variables);
				
			}
			
			
			
			
			
		
			String str = "{ \"message\": \"操作失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"操作成功\",\"code\": \"0\"");
				sb.append(",\"taskId\":\"");
				sb.append(taskId);
				sb.append("\",\"userId\":\"");
				sb.append(userId);
				sb.append("\",\"slbh\":\"");
				sb.append(xmb.getSlbh());
			
				sb.append("\"}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			JsonUtil.printJsonString(getResponse(), str);
		}
    }



    /**
     * 解锁展示
     */
    public void toAuditjsview(){
     	DecodeStr der = new DecodeStr();
    		Map<String, String> map = new HashMap<String, String>();
    		map = der.getPostPara(para, callback);
    		if (null == map || map.isEmpty()) {
    			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
    		} else {
    			String taskId=map.get("taskId");
    			String userId=map.get("userId");
    			
    			Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
    	        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
    	        String businessKey =  processInstance.getBusinessKey();
    	        PaymentItemHis paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
    	        Xmxxb xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
    	        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
    	        ActionContext.getContext().put("outcomeList", outcomeList);
    	        Map<String, String> paramMap = new HashMap<String, String>();
    			paramMap.put("bizrowid", xmxxb.getId());
    			paramMap.put("xmType", "项目解锁");
    			List<FawenAttach> attach= fawenAttachService.queryAttachListByTempleId(paramMap);
    			
    	          String procInstanceId = taskService.createTaskQuery().taskId(taskId).singleResult().getProcessInstanceId();
    	          List<Comment> commentList = taskService.getProcessInstanceComments(procInstanceId);
    	          String fhr="";
    	          String fhyj="";
    	          if(commentList!=null&&commentList.size()>0){
    	              for(Comment comment : commentList){
    	            	  HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId(comment.getTaskId()).singleResult();
    	            	     if(null!=historicTaskInstance&&"解锁复核".equals(historicTaskInstance.getName())){
    	            	    	  User uu=userService.findUserByLoginId(comment.getUserId());
    	                          if(null!=uu){
    	                        	  fhr= uu.getDisplayName() ;
    	                          }else{
    	                        	  fhr=  comment.getUserId();
    	                          }
    	                          if(null==comment.getFullMessage()){
    	                        	  fhyj= "无" ;
    	                          }else{
    	                        	  fhyj=  comment.getFullMessage();
    	                          }
    	            	     }
    	                   }
    	              }
    			
    			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
    			try {
    				StringBuilder sb = new StringBuilder();
    				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
    				sb.append(",\"taskId\":\"");
    				sb.append(taskId);
    				
    				sb.append("\",\"userId\":\"");
    				sb.append(userId);
    				sb.append("\",\"slbh\":\"");
    				sb.append(xmxxb.getSlbh());
    				sb.append("\",\"zsdw\":\"");
    				sb.append(xmxxb.getZsdw());
    				
    				sb.append("\",\"xxylb\":\"");
    				sb.append(xmxxb.getXxylb());
                    
    				sb.append("\",\"dwmc\":\"");
    				sb.append(xmxxb.getJsdw());

    				sb.append("\",\"xmmc\":\"");
    				sb.append(xmxxb.getXmmc());
    				sb.append("\",\"jsdd\":\"");
    				sb.append(xmxxb.getJsdd());
    				
    				sb.append("\",\"zjsmj\":\"");
    				sb.append(xmxxb.getZjsmj());
    				
    				sb.append("\",\"yjmj\":\"");
    				sb.append(paymentItemHis.getPtyjmj());
    				
    				sb.append("\",\"yjje\":\"");
    				sb.append(paymentItemHis.getPtyjje());
    				
    				sb.append("\",\"ymmj\":\"");
    				sb.append(paymentItemHis.getPtymmj());
    				
    				sb.append("\",\"ymje\":\"");
    				sb.append(paymentItemHis.getPtymje());
    				
    				sb.append("\",\"dzrq\":\"");
    				sb.append(paymentItemHis.getCreateTime());
    				
    				sb.append("\",\"jbyj\":\"");
    				sb.append(paymentItemHis.getOperatorComment());
    				
    				sb.append("\",\"jbr\":\"");
    				sb.append(paymentItemHis.getOperator().getDisplayName());
    				
    				sb.append("\",\"fhr\":\"");
    				sb.append(fhr);
    				
    				sb.append("\",\"fhyj\":\"");
    				sb.append(fhyj);
    				List<Map<String,Object>> list=new ArrayList<>();
    				if(attach!=null&&attach.size()>0){
    					for(FawenAttach  att: attach){
    						Map<String,Object> attachMap=new HashMap<>();
    						attachMap.put("fjAddr", att.getAttachpath());
    						attachMap.put("attachname", att.getAttachname());
    						list.add(attachMap);
    					}
    				}
    				sb.append("\",\"fjlist\":");
    				sb.append(JsonUtil.listmap_to_json_string(list));
    				sb.append("}");
    				str = sb.toString();
    				System.out.println("传输到手机端：" + str);
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    			
    			JsonUtil.printJsonString(getResponse(), str);
    		}
        	
    }
    
    
    /**
     * 解锁展示 逾期未交
     */
    public void toyqxqview(){
     	DecodeStr der = new DecodeStr();
    		Map<String, String> map = new HashMap<String, String>();
    		map = der.getPostPara(para, callback);
    		if (null == map || map.isEmpty()) {
    			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
    		} else {
    			String slbh=map.get("slbh");
    			String userId=map.get("userId");
    			 Xmxxb x = xmxxbService.getBySlbh(slbh);
    		
    	        Map<String, Object> paraMap = new HashMap<String, Object>();
//    	        paraMap.put("slbh", "%" + slbh.trim() + "%");
    	        paraMap.put("isjk", "%" + "0".trim() + "%");
    	        paraMap.put("dwmc", "%" + x.getJsdw().trim() + "%");
    	        List<Cktzs> lcs= cktzsService.findByall(paraMap);
    	           Cktzs ck=new Cktzs();
    	           //isok等于0,不存在逾期,isok=1存在逾期
    	           String isok="0";
    	           
    	           String zsdw="";
    	           String xmmc="";
    	           String yjje="";
    	           String tzjfsj="";
    	           String dqsj="";
    	           String slbhsss="";
    	           if(lcs.size()>0){
    	        	   isok="1";
    	        	   ck=lcs.get(0);
    	        	   Xmxxb xmxxb = xmxxbService.getBySlbh(ck.getSlbh());
    	        	     Map<String, Object> paraMap1 = new HashMap<String, Object>();
    	        	     paraMap1.put("slbh", ck.getSlbh());
    	        	     List<Jktzs> ljsks=            jktzsService.findByAll(paraMap1);
    	        	     if(ljsks.size()>0){
    	        	    	 tzjfsj= ljsks.get(0).getDyriqi().toString();
    	        	     }
    	        	   zsdw=xmxxb.getZsdw();
    	        	   xmmc=xmxxb.getXmmc();
    	        	   slbhsss=xmxxb.getSlbh();
    	        	   yjje=ck.getJfje();
//    	        	   dqsj=ck.getCreateTime().toString();
    	        	   SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
    	        	   dqsj=sdf.format(ck.getCreateTime()); 
    	           }
    			
    	           
    			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
    			try {
    				StringBuilder sb = new StringBuilder();
    				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
    				
    				sb.append(",\"isok\":\"");
    				sb.append(isok);
    				
    				sb.append("\",\"zsdw\":\"");
    				sb.append(zsdw);
                    
    				sb.append("\",\"slbh\":\"");
    				sb.append(slbhsss);
    				
    			
    				sb.append("\",\"xmmc\":\"");
    				sb.append(xmmc);
    				
    				
    				
    				sb.append("\",\"yjje\":\"");
    				sb.append(yjje);
    				
    				sb.append("\",\"tzjfsj\":\"");
    				sb.append(tzjfsj);
    				
    				sb.append("\",\"dqsj\":\"");
    				sb.append(dqsj);
    				
    				sb.append("\"}");
    				str = sb.toString();
    				System.out.println("传输到手机端：" + str);
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    			
    			JsonUtil.printJsonString(getResponse(), str);
    		}
        	
    }
    
    /**
     * 解锁操作
     */
    public  void todoAuditjs(){
       	DecodeStr der = new DecodeStr();
    		Map<String, String> map = new HashMap<String, String>();
    		map = der.getPostPara(para, callback);
    		if (null == map || map.isEmpty()) {
    			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
    		} else {
    			String taskId=map.get("taskId");
    			String userId=map.get("userId");
    			//意见
    			String comment=map.get("comment");
    			//结果 0通过 1驳回
    			String outcome=map.get("outcome");
    			if("0".equals(outcome)){
    				outcome="通过";
    			}else{
    				outcome="驳回";
    			}
    			
    	  
    	            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
    	            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
    	            String businessKey =  processInstance.getBusinessKey();
    	            User user=userService.findUserById(userId);
    	            activitiService.addComment(task, user.getLoginId(), comment);
    	            //状态改为无锁状态
    	            if(Constant.OUTCOME_PASS.equals(outcome)){
    	            	PaymentItemHis	paymentItemHis = paymentItemHisService.getByXmbId(businessKey);
    	            	paymentItemHis.setLockFlag(Constant.STATUS_LOCK_2);
    	            	paymentItemHisService.update(paymentItemHis);
    	            }
    	            Map<String, Object> variables = new HashMap<String, Object>();
    	            variables.put("outcome", outcome);
    	            taskService.complete(taskId, variables);
    	            
    	            
    	            
    	            
    	    
    			String str = "{ \"message\": \"办理失败\",\"code\": \"1000\"}";
    			try {
    				StringBuilder sb = new StringBuilder();
    				sb.append("{ \"message\": \"办理成功\",\"code\": \"0\"");
    				sb.append(",\"taskId\":\"");
    				sb.append(taskId);
    				
    				sb.append("\",\"userId\":\"");
    				sb.append(userId);
    		
    				sb.append("\"}");
    				str = sb.toString();
    				System.out.println("传输到手机端：" + str);
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
    			
    			JsonUtil.printJsonString(getResponse(), str);
    		}
        	
    	
    	
    }
    
    
    /**
     * 项目退件流程显示
     */
    public void toTerminateProcessCheck() {
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String taskId=map.get("taskId");
			String userId=map.get("userId");
	         Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
	         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	         String businessKey =  processInstance.getBusinessKey();
	          Xmxxb xmxxb = xmxxbService.getById(businessKey);
	          ReturnItem returnItem = returnItemService.getByXmbzj(businessKey);
	      	
	          String type = Constant.STATUS_RETURN_0.equals(returnItem.getReturnStatus())?"挂起":"作废";
	          User applyUser = userService.findUserById(returnItem.getCreateUserID());
	          String applyUserName = "用户不存在，请管理员核实";
	          if(null!=applyUser){
	         	 applyUserName = applyUser.getDisplayName();
	          }
		
	          String procInstanceId = taskService.createTaskQuery().taskId(taskId).singleResult().getProcessInstanceId();

	          List<Comment> commentList = taskService.getProcessInstanceComments(procInstanceId);
	          String fhr="";
	          String fhyj="";
	      
	          if(commentList!=null&&commentList.size()>0){
	              for(Comment comment : commentList){
	            	  HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId(comment.getTaskId()).singleResult();
	            	     if(null!=historicTaskInstance&&"退件复核".equals(historicTaskInstance.getName())){
	            	    	  User uu=userService.findUserByLoginId(comment.getUserId());
	                          if(null!=uu){
	                        	  fhr= uu.getDisplayName() ;
	                          }else{
	                        	  fhr=  comment.getUserId();
	                          }
	                          if(null==comment.getFullMessage()){
	                        	  fhyj= "无" ;
	                          }else{
	                        	  fhyj=  comment.getFullMessage();
	                          }
	            	     }
	                   }
	              }
			
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"taskId\":\"");
				sb.append(taskId);
				
				sb.append("\",\"userId\":\"");
				sb.append(userId);
				sb.append("\",\"slbh\":\"");
				sb.append(xmxxb.getSlbh());
				
				sb.append("\",\"xxylb\":\"");
				sb.append(xmxxb.getXxylb());
                
				sb.append("\",\"dwmc\":\"");
				sb.append(xmxxb.getJsdw());

				sb.append("\",\"xmmc\":\"");
				sb.append(xmxxb.getXmmc());
				
				sb.append("\",\"bllb\":\"");
				sb.append(tobllbtype(xmxxb.getBllb()));
				
				sb.append("\",\"tjlb\":\"");
				sb.append(type);
				
				sb.append("\",\"tjyy\":\"");
				sb.append(returnItem.getTjyy());
				
				sb.append("\",\"jbr\":\"");
				sb.append(applyUserName);
				
				sb.append("\",\"jbsj\":\"");
				sb.append(returnItem.getCreateTime());
				
				sb.append("\",\"fhr\":\"");
				sb.append(fhr);
				
				sb.append("\",\"fhyj\":\"");
				sb.append(fhyj);
				sb.append("\"}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			JsonUtil.printJsonString(getResponse(), str);
		}
    	
    	
    
     }
    
    
    
    /**
     * 项目退件流程操作
     */
    public void toAudit() {
    	DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String taskId=map.get("taskId");
			String userId=map.get("userId");
			//意见
			String comment=map.get("comment");
			//结果 0通过 1驳回
			String outcome=map.get("outcome");
			if("0".equals(outcome)){
				outcome="通过";
			}else{
				outcome="驳回";
			}
			
//	         Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
//	         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
//	         String businessKey =  processInstance.getBusinessKey();
//	          Xmxxb xmxxb = xmxxbService.getById(businessKey);
//	          ReturnItem returnItem = returnItemService.getByXmbzj(businessKey);
	          
	          Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
	            User user=userService.findUserById(userId);
	            activitiService.addComment(task, user.getLoginId(), comment);
	            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	            String businessKey = processInstance.getBusinessKey();
	            ReturnItem returnItem = returnItemService.getByXmbzj(businessKey);
	            Xmxxb xmxxb = xmxxbService.getById(businessKey);
	          
	            if (Constant.OUTCOME_PASS.equals(outcome)){
		            //审核通过后终止相关流程
		            runtimeService.deleteProcessInstance(returnItem.getProcessInsId(), "人工终止");
		            if(Constant.STATUS_RETURN_0.equals(returnItem.getReturnStatus())){//退件挂起审核中
		            	//挂起相关逻辑代码
		            	xmxxb.setZclb("");
		            	xmxxb.setBllb("");
		            	xmxxb.setJzdwdz("");
		            	xmxxb.setBxzd2("");
		            	xmxxb.setIsdikou("");
//		            	if("6".equals(xmxxb.getHfsz())){
//		            		xmxxb.setZsdw("");
//		            		xmxxb.setDwdm("");
//		            	}
		            	
		            	xmxxb.setDkslbh("");
		            	xmxxb.setDkmj("");
		            	xmxxb.setLcjk("0");
		            	xmxxb.setZjsmj(xmxxb.getYsdmj());
		                xmxxb.setSjcsje("");
		            	returnItem.setReturnStatus(Constant.STATUS_RETURN_2);
		            	returnItem.setPrintFlag(Constant.PRINT_FLAG_0);
		            	// TODO
		            	String No = "TJ" + xmxxb.getBllb() + xmxxb.getDwdm().toUpperCase() + genericManager.getSN("dztj");
		            	returnItem.setTjdbh(No);
		            	xmxxb.setIstj("1");
		            	xmxxb.setYjje("");
		            	xmxxb.setYjmj("");
		            	//挂起删除,作废不删除
		                Map<String, Object> parap = new HashMap<String, Object>();
			            parap.put("slbh", xmxxb.getSlbh());
			            List<Spjlb> listspjlb=spjlbService.findSpjlball(parap);
			            List<Jkmx> jkmxs=jkmxService.findall(parap);
			            List<Qtfymx> qt=qtfymxService.findall(parap);
			            if(null!=listspjlb&&listspjlb.size()>0){
			            	for (Spjlb spjlb : listspjlb) {
			            		spjlbService.deleteWithFlag(spjlb.getId());
							}
			            }
			            if(null!=jkmxs&&jkmxs.size()>0){
			            	for (Jkmx jkbean : jkmxs) {
			            		jkmxService.deleteWithFlag(jkbean.getId());
			            	}
			            }
			        	if(null!=qt&&qt.size()>0){
		         			for (Qtfymx qtfymx : qt) {
		         				qtfymxService.deleteWithFlag(qtfymx.getId());
		         			}
		         		}
		            	
		            }else if(Constant.STATUS_RETURN_1.equals(returnItem.getReturnStatus())){//退件作废审核中
		            	//作废相关逻辑代码
		            	returnItem.setReturnStatus(Constant.STATUS_RETURN_3);
		            	returnItem.setPrintFlag(Constant.PRINT_FLAG_0);
		            	String xmbbh=xmxxb.getXxylb()+"(作废)";
		            	xmxxb.setXxylb(xmbbh);
		            	xmxxb.setIstj("2");
		            	 Map<String, Object> parap = new HashMap<String, Object>();
				            parap.put("slbh", xmxxb.getSlbh());
				            List<Spjlb> listspjlb=spjlbService.findSpjlball(parap);
				            if(null!=listspjlb&&listspjlb.size()>0){
				            	for (Spjlb spjlb : listspjlb) {
				            		spjlb.setXxbbh(xmbbh);
				            		spjlbService.update(spjlb);
								}
				            }
				            
				            
		            }
		            
		 
		            //直接缴费项目
		            if("0".equals(xmxxb.getZjdyjks())){
		            	xmxxb.setZjdyjks("");
		            	Map<String, Object> vad = new HashMap<String, Object>();
		         		vad.put("slbh", xmxxb.getSlbh());
		         		List<PaymentItemPending> lis=paymentItemPendingService.findPaymentItemPending(vad);
		         		List<Jktzs> jktzs=jktzsService.findByAll(vad);
		         		List<Cktzs> lck=cktzsService.findByall(vad);
		         		if(null!=lis&&lis.size()>0){
		         			for (PaymentItemPending asd : lis) {
		         				paymentItemPendingService.delete(asd.getId());
							}
		         		 }
		         		if(null!=jktzs&&jktzs.size()>0){
		         			for (Jktzs jktbean : jktzs) {
		         				jktzsService.deleteWithFlag(jktbean.getId());
							}
		         			
		         		}
		         		if(null!=lck&&lck.size()>0){
		         			for (Cktzs cktzs : lck) {
		         				cktzsService.deleteWithFlag(cktzs.getId());
							}
		         		}
		         	
		            }
		            
		            
		            xmxxbService.update(xmxxb);
		            returnItemService.update(returnItem);
	            }
	            Map<String, Object> variables = new HashMap<String, Object>();
	            variables.put("outcome", outcome);
	            taskService.complete(taskId, variables);
	            
	            
	            
	            
	            
	    
			String str = "{ \"message\": \"办理失败\",\"code\": \"1000\"}";
			try {
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"办理成功\",\"code\": \"0\"");
				sb.append(",\"taskId\":\"");
				sb.append(taskId);
				
				sb.append("\",\"userId\":\"");
				sb.append(userId);
		
				sb.append("\"}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			JsonUtil.printJsonString(getResponse(), str);
		}
    	
    	
    
     }
    
    
    
	
	  /**  
	     * 计算两个日期之间相差的天数  
	     * @param smdate 较小的时间 
	     * @param bdate  较大的时间 
	     * @return 相差天数 
	     * @throws ParseException  
	     */    
	    public int daysBetween(Date smdate,Date bdate) throws ParseException    
	    {    
	       SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
	       smdate=sdf.parse(sdf.format(smdate));  
	       bdate=sdf.parse(sdf.format(bdate));  
	        Calendar cal = Calendar.getInstance();    
	      cal.setTime(smdate);    
	        long time1 = cal.getTimeInMillis();                 
	        cal.setTime(bdate);    
	        long time2 = cal.getTimeInMillis();         
	        long between_days=(time2-time1)/(1000*3600*24);  
	            
	       return Integer.parseInt(String.valueOf(between_days));           
	    } 

		private boolean islcbysfc(String dwdm){
//			if("sf".equals(dwdm)||"pk".equals(dwdm)||"nb".equals(dwdm)||"ql".equals(dwdm)||"rj".equals(dwdm)||"jn".equals(dwdm)||"pz".equals(dwdm)||"ls".equals(dwdm)||"gl".equals(dwdm)||"qh".equals(dwdm)||"xw".equals(dwdm)){
				if("sf".equals(dwdm)||"ql".equals(dwdm)){
				return true;
			}
			return false;
		}
		private void isweikou(PaymentItemPending dj, Spjkjl sp)
		{
			dj.setRfyjmj(sp.getRfyjmj());
			dj.setRfyjje(sp.getRfyjje());
			dj.setRfymmj(sp.getRfymmj());
			dj.setRfymje(sp.getRfymje());

			dj.setByyjmj(sp.getByyjmj());
			dj.setByyjje(sp.getByyjje());
			dj.setByymmj(sp.getByymmj());
			dj.setByymje(sp.getByymje());

			dj.setXqyjmj(sp.getXqyjmj());
			dj.setXqyjje(sp.getXqyjje());
			dj.setXqymmj(sp.getXqymmj());
			dj.setXqymje(sp.getXqymje());

		}
        
		/**
		 * 总应缴费用为0的项目
		 * @param djkys
		 */
		private void zjjrjk(PaymentItemPending djkys, Xmxxb xmb,String DepartmentId)
		{
			PaymentItemHis yjk = new PaymentItemHis();
			yjk.setDeptId(DepartmentId);
			yjk.setDelFlag(0);
			yjk.setPtyjje("0");
			yjk.setPrintFlag("YES");
			yjk.setXmbzj(djkys.getXmbzj());
			yjk.setSlbh(djkys.getSlbh());
			yjk.setDwmc(djkys.getDwmc());
			yjk.setXmmc(djkys.getXmmc());
			yjk.setMjyj(djkys.getMjyj());
			yjk.setDkxmslh(djkys.getDkxmslh());
			yjk.setZsdw(djkys.getZsdw());
			yjk.setDwdm(djkys.getDwdm());
			yjk.setDkmj(djkys.getDkmj());
			yjk.setCsmj(djkys.getCsmj());
			yjk.setPtyjmj(djkys.getPtyjmj());
			yjk.setPtyjje(djkys.getPtyjje());
			yjk.setPtymje(djkys.getPtymje());
			yjk.setPtymmj(djkys.getPtymmj());
			yjk.setRfyjmj(djkys.getRfyjmj());
			yjk.setRfyjje(djkys.getRfyjje());
			yjk.setRfymmj(djkys.getRfymmj());
			yjk.setRfymje(djkys.getRfymje());
			yjk.setXqyjje(djkys.getXqyjje());
			yjk.setXqymmj(djkys.getXqymmj());
			yjk.setXqymje(djkys.getXqymje());
			yjk.setXqyjmj(djkys.getXqyjmj());
			yjk.setByyjmj(djkys.getByyjmj());
			yjk.setByyjje(djkys.getByyjje());
			yjk.setByymmj(djkys.getByymmj());
			yjk.setByymje(djkys.getByymje());
			yjk.setZymje(djkys.getZymje());
			yjk.setZyjje(djkys.getZyjje());
			String ECN = "PZ" + xmb.getBllb() + xmb.getDwdm().toUpperCase() + genericManager.getSN("dzpz");
			yjk.setECN(ECN);
			// yjk.setPrintFlag(djkys.getp);
			// yjk.setAccountbankIdZ(djkys.get);
			// yjk.setWarnFlag(djkys.get);
			yjk.setLockFlag(Constant.STATUS_LOCK_1);
			yjk.setIsPrintJfpz("0");//默认缴费凭证未打印
			yjk.setYzsFlag(2);
			paymentItemPendingService.delete(djkys.getId());
			yjk.setJbr(this.getLoginUser().getDisplayName());
			paymentItemHisService.save(yjk);
			xmb.setIsyjkrk("0");
			xmxxbService.update(xmb);
		}
		/**
		 * 跟仙林相同的处理流程
		 */
		
		private boolean isxianlin(String dwdm){
			if("xl".equals(dwdm)||"nb".equals(dwdm)){
				return true;
			}
			return false;
		}
		
		
		
		/**
		 * 办理类别
		 * @return
		 */
		private String tobllbtype(String bllb){
			if("1".equals(bllb)){
				return "减免";
			}
			return "直接缴费";
		}
		
		/**
		 * 项目来源(面积依据)
		 * @return
		 */
		private String tomjyjtype(String mjyj){
			if("001".equals(mjyj)){
				return "规划(正常)";
			}
			if("002".equals(mjyj)){
				return "房产测绘(超建面积)";
			}
			if("003".equals(mjyj)){
				return "交易登记(紫金科创)";
			}
			if("004".equals(mjyj)){
				return "房改办(经营用房)";
			}
			if("005".equals(mjyj)){
				return "规划(变更)";
			}
			return "";
		}
		/**
		 * 政策类别
		 * @return
		 */
		private String tozclbype(String zclb){
			if("001".equals(zclb)){
				return "宁政规字[2016]5号";
			}
			if("002".equals(zclb)){
				return "办文单";
			}
			if("003".equals(zclb)){
				return "会议纪要";
			}
		
			return "";
		}
		
		
	public String getPara() {
		return para;
	}

	public void setPara(String para) {
		this.para = para;
	}

	public String getCallback() {
		return callback;
	}

	public void setCallback(String callback) {
		this.callback = callback;
	}

	public Pagination getPagination() {
		return pagination;
	}

	public void setPagination(Pagination pagination) {
		this.pagination = pagination;
	}

	public String getJsonString() {
		return jsonString;
	}

	public void setJsonString(String jsonString) {
		this.jsonString = jsonString;
	}

	public String getCpage() {
		return cpage;
	}

	public void setCpage(String cpage) {
		this.cpage = cpage;
	}

	public String getLen() {
		return len;
	}

	public void setLen(String len) {
		this.len = len;
	}

}
