package com.jshx.mobile.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;

import javax.imageio.ImageIO;

import org.apache.commons.io.FileUtils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

public class ImgCompress {
	private File file = null; // 文件对象
	private String inputDir; // 输入图路径
	private String outputDir; // 输出图路径
	private String inputFileName; // 输入图文件名
	private String outputFileName; // 输出图文件名
	private int outputWidth = 100; // 默认输出图片宽
	private int outputHeight = 100; // 默认输出图片高
	private boolean proportion = true; // 是否等比缩放标记(默认为等比缩放)
	
	public ImgCompress() { // 初始化变量
		inputDir = "";
		outputDir = "";
		inputFileName = "";
		outputFileName = "";
		outputWidth = 100;
		outputHeight = 100;
	}
	
	public void setInputDir(String inputDir) {
		this.inputDir = inputDir;
	}
	
	public void setOutputDir(String outputDir) {
		this.outputDir = outputDir;
	}
	
	public void setInputFileName(String inputFileName) {
		this.inputFileName = inputFileName;
	}
	
	public void setOutputFileName(String outputFileName) {
		this.outputFileName = outputFileName;
	}
	
	public void setOutputWidth(int outputWidth) {
		this.outputWidth = outputWidth;
	}
	
	public void setOutputHeight(int outputHeight) {
		this.outputHeight = outputHeight;
	}
	
	public void setWidthAndHeight(int width, int height) {
		this.outputWidth = width;
		this.outputHeight = height;
	}
	
	/*
	 * 获得图片大小 插入参数String path：图片路径
	 */
	public long getPicSize(String path) {
		file = new File(path);
		return file.length();
	}
	
	// 图片处理
	public String compressPic() {
		try {
			// 获得源文件
			file = new File(inputDir + inputFileName);
			if (!file.exists()) {
				return "";
			}
			Image img = ImageIO.read(file);
			// 判断图片格式是否正确
			if (img == null || img.getWidth(null) == -1) {
				System.out.println(" can't read,retry!" + "<BR>");
				return "no";
			}
			else {
				int newWidth;
				int newHeight;
				// 判断是否是等比缩放
				if (this.proportion == true) {
					// 为等比缩放计算输出的图片宽度及高度
					double rate1 = ((double) img.getWidth(null)) / (double) outputWidth + 0.1;
					double rate2 = ((double) img.getHeight(null)) / (double) outputHeight + 0.1;
					// 根据缩放比率大的进行缩放控制
					double rate = rate1 > rate2 ? rate1 : rate2;
					newWidth = (int) ((img.getWidth(null)) / rate);
					newHeight = (int) ((img.getHeight(null)) / rate);
				}
				else {
					newWidth = outputWidth; // 输出的图片宽度
					newHeight = outputHeight; // 输出的图片高度
				}
				BufferedImage tag = new BufferedImage(newWidth, newHeight,
						BufferedImage.TYPE_INT_RGB);
				/*
				 * Image.SCALE_SMOOTH 的缩略算法 生成缩略图片的平滑度的 优先级比速度高 生成的图片质量比较好 但速度慢
				 * 
				 */
				tag.getGraphics().drawImage(
						img.getScaledInstance(newWidth, newHeight, Image.SCALE_SMOOTH), 0, 0, null);
				FileOutputStream out = new FileOutputStream(outputDir + outputFileName);
				// JPEGImageEncoder可适用于其他图片类型的转换
				JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
				encoder.encode(tag);
				tag.flush();
				out.close();
				
			}
		}
		catch (IOException ex) {
			ex.printStackTrace();
		}
		return "ok";
	}
	
	public String compressPic(String inputDir, String outputDir, String inputFileName,
			String outputFileName) {
		// 输入图路径
		this.inputDir = inputDir;
		// 输出图路径
		this.outputDir = outputDir;
		// 输入图文件名
		this.inputFileName = inputFileName;
		// 输出图文件名
		this.outputFileName = outputFileName;
		return compressPic();
	}
	
	// 在linux上执行获取视频的截屏的函数
	// public static String screenShot(String inputDir, String outputDir, String
	// inputFileName,
	// String outputFileName) {
	// String[] cmd = {"ffmpeg -i"+ inputDir+inputFileName+" -t 0.001 -f image2
	// pic.jpg};
	//
	// //执行Shell命令
	//
	// Runtime.getRuntime().exec(cmd);
	// }
	
	// 视频缩略图截取
	// inFile 输入文件(包括完整路径)
	// outFile 输出文件(可包括完整路径)
	public static boolean transfer(String inFile, String outFile) {
		String command = "ffmpeg -i " + inFile
				+ " -y -f image2 -t 00:00:01 -s 176x144 " + outFile;
		try {
			Runtime rt = Runtime.getRuntime();
			Process proc = rt.exec(command);
			InputStream stderr = proc.getErrorStream();
			InputStreamReader isr = new InputStreamReader(stderr);
			BufferedReader br = new BufferedReader(isr);
			String line = null;
			while ((line = br.readLine()) != null)
				System.out.println(line);
		}
		catch (Throwable t) {
			t.printStackTrace();
			return false;
		}
		return true;
	}
	
	public String compressPic(String inputDir, String outputDir, String inputFileName,
			String outputFileName, int width, int height, boolean gp) {
		// 输入图路径
		this.inputDir = inputDir;
		// 输出图路径
		this.outputDir = outputDir;
		// 输入图文件名
		this.inputFileName = inputFileName;
		// 输出图文件名
		this.outputFileName = outputFileName;
		// 设置图片长宽
		setWidthAndHeight(width, height);
		// 是否是等比缩放 标记
		this.proportion = gp;
		return compressPic();
	}
	
	public static void main(String[] args) throws Exception {
		// ImgCompress mypic = new ImgCompress();
		// mypic.compressPic("D:/img/1347145597592/", "f:/", "1.jpg", "2.jpg",
		// 120, 120, true);
		Collection<File> fileCol = FileUtils.listFiles(new File("D:/images/"), new String[] { "jpg" },
				true);
		int i = 0;
		for (File imgFile : fileCol) {
			imgFile.lastModified();
			String path = imgFile.getPath();
			String ppath = imgFile.getParent();
			
			if (!path.toLowerCase().endsWith("s.jpg")) {
				ImgCompress mypic = new ImgCompress();
				i = i + 1;
				System.out.println(i + "  path=" + path + "     ppath=" + ppath + "   rpath="
						+ imgFile.getName().replaceAll(".jpg", "s.jpg"));
				mypic.compressPic(ppath + "/", ppath + "/", imgFile.getName(), imgFile.getName()
						.replaceAll(".jpg", "s.jpg"), 120, 120, true);
				// Thread.sleep(200);
			}
		}
	}
}
