package com.jshx.jsdwinfo.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jsdwinfo.entity.Jsdwinfo;
import com.jshx.jsdwinfo.dao.JsdwinfoDao;

@Component("jsdwinfoDao")
public class JsdwinfoDaoImpl extends BaseDaoImpl implements JsdwinfoDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJsdwinfoByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findJsdwinfo(Map<String, Object> paraMap){
		return this.findListByHqlId("findJsdwinfoByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jsdwinfo getById(String id)
	{
		return (Jsdwinfo)this.getObjectById(Jsdwinfo.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jsdwinfo jsdwinfo)
	{
		jsdwinfo.setId(null);
		this.saveOrUpdateObject(jsdwinfo);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jsdwinfo jsdwinfo)
	{
		this.saveOrUpdateObject(jsdwinfo);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Jsdwinfo.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Jsdwinfo jsdwinfo = (Jsdwinfo)this.getObjectById(Jsdwinfo.class, id);
		jsdwinfo.setDelFlag(1);
		this.saveObject(jsdwinfo);
	}
}
