package com.jshx.hisxljfjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxljfjlb.entity.Hisxljfjlb;
import com.jshx.hisxljfjlb.dao.HisxljfjlbDao;

@Component("hisxljfjlbDao")
public class HisxljfjlbDaoImpl extends BaseDaoImpl implements HisxljfjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxljfjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxljfjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxljfjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxljfjlb getById(String id)
	{
		return (Hisxljfjlb)this.getObjectById(Hisxljfjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxljfjlb hisxljfjlb)
	{
		hisxljfjlb.setId(null);
		this.saveOrUpdateObject(hisxljfjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxljfjlb hisxljfjlb)
	{
		this.saveOrUpdateObject(hisxljfjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxljfjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxljfjlb hisxljfjlb = (Hisxljfjlb)this.getObjectById(Hisxljfjlb.class, id);
		hisxljfjlb.setDelFlag(1);
		this.saveObject(hisxljfjlb);
	}
}
