package com.jshx.hisxljbxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxljbxxb.entity.Hisxljbxxb;
import com.jshx.hisxljbxxb.dao.HisxljbxxbDao;

@Component("hisxljbxxbDao")
public class HisxljbxxbDaoImpl extends BaseDaoImpl implements HisxljbxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxljbxxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxljbxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxljbxxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxljbxxb getById(String id)
	{
		return (Hisxljbxxb)this.getObjectById(Hisxljbxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxljbxxb hisxljbxxb)
	{
		hisxljbxxb.setId(null);
		this.saveOrUpdateObject(hisxljbxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxljbxxb hisxljbxxb)
	{
		this.saveOrUpdateObject(hisxljbxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxljbxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxljbxxb hisxljbxxb = (Hisxljbxxb)this.getObjectById(Hisxljbxxb.class, id);
		hisxljbxxb.setDelFlag(1);
		this.saveObject(hisxljbxxb);
	}
}
