package com.jshx.hissfddfs.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissfddfs.entity.Hissfddfs;
import com.jshx.hissfddfs.dao.HissfddfsDao;

@Component("hissfddfsDao")
public class HissfddfsDaoImpl extends BaseDaoImpl implements HissfddfsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHissfddfsByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHissfddfs(Map<String, Object> paraMap){
		return this.findListByHqlId("findHissfddfsByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissfddfs getById(String id)
	{
		return (Hissfddfs)this.getObjectById(Hissfddfs.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hissfddfs hissfddfs)
	{
		hissfddfs.setId(null);
		this.saveOrUpdateObject(hissfddfs);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hissfddfs hissfddfs)
	{
		this.saveOrUpdateObject(hissfddfs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hissfddfs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hissfddfs hissfddfs = (Hissfddfs)this.getObjectById(Hissfddfs.class, id);
		hissfddfs.setDelFlag(1);
		this.saveObject(hissfddfs);
	}
}
