package com.jshx.elicense.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.elicense.dao.ELicenseDao;
import com.jshx.elicense.dao.ELicenseFileDao;
import com.jshx.elicense.entity.ELicense;
import com.jshx.elicense.entity.ELicenseFile;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("eLicenseFileDao")
public class ELicenseFileDaoImpl extends BaseDaoImpl implements ELicenseFileDao {
    @Override
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
        return this.findPageByHqlId("findELicenseFileByMap", paraMap, page);
    }

    @Override
    public List findELicenseFileList(Map<String, Object> paraMap) {
        return this.findListByHqlId("findELicenseFileByMap", paraMap);
    }

    @Override
    public ELicenseFile getById(String id) {
        return (ELicenseFile) this.getObjectById(ELicenseFile.class, id);
    }

    @Override
    public void save(ELicenseFile model) {
        model.setId(null);
        this.saveOrUpdateObject(model);
    }

    @Override
    public void update(ELicenseFile model) {
        this.saveOrUpdateObject(model);
    }

    @Override
    public void delete(String id) {
        this.removeObjectById(ELicense.class, id);
    }

    @Override
    public void deleteWithFlag(String id) {
        ELicenseFile model = (ELicenseFile)this.getObjectById(ELicenseFile.class, id);
        model.setDelFlag(1);
        this.saveObject(model);
    }
}
