package com.jshx.billManager.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.billManager.dao.BillManagerDao;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;

@Service("billManagerService")
public class BillManagerServiceImpl extends BaseServiceImpl implements BillManagerService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("billManagerDao")
	private BillManagerDao billManagerDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return billManagerDao.findByPage(page, paraMap);
	}
	@Override
	public List findByIndeticurPage(Map<String, Object> paraMap) {
		return billManagerDao.findByIndeticurPage(paraMap);
	}
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public BillManager getById(String id)
	{
		return billManagerDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(BillManager billManager)
	{
		billManagerDao.save(billManager);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(BillManager billManager)
	{
		billManagerDao.update(billManager);
	}
	@Transactional
	public void update(Indeticur indeticur)
	{
		billManagerDao.update(indeticur);
	}
	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=billManagerDao.findBillManager(paraMap);
		
		billManagerDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    billManagerDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public void save(Indeticur model) {
		billManagerDao.save(model);
		
	}

	@Override
	public String findNo(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return billManagerDao.findNo(paraMap);
	}

	@Override
	public int findcountByMap(Map<String, Object> paraMap) {
		return billManagerDao.findcountByMap(paraMap);
	}

	@Override
	public Indeticur findIndeticurByNo(Map<String, Object> paraMap) {
		return billManagerDao.findIndeticurByNo(paraMap);
	}
	@Override
	public Indeticur getIndeticurById(String id) {
		return billManagerDao.getIndeticurById(id);
	}
	@Override
	public void batchupdate(List<Indeticur> list) {
		billManagerDao.batchupdate(list);
	}
	@Override
	public Pagination findByIndeticurPage(Pagination page, Map<String, Object> paraMap) {
		return billManagerDao.findByIndeticurPage(page,paraMap);
	}

	

	

	
}
