<%@page language="java" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/common/header.jsp"%>
<%@ taglib uri="/WEB-INF/tld/edp.tld" prefix="code"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<c:set var="curr_path" value="查看部门"></c:set>
<html>
<head>
	<title>查看部门</title>
	<%@include file="/common/jsLib.jsp"%>
	<script src="${ctx}/webResources/js/calendar.js"></script>
</head>

<body class="pages_right" style="overflow: auto">
<div class="submitdata" style="width: 300">
	<table width=100% border=0 cellspacing=0 cellpadding=0>
		<tr height="22px">
			<th style="width:30%">上级部门</th>
			<td style="width:70%">${dept.parentDept.deptName }</td>
		</tr>
		<tr height="22px">
			<th>部门编号</th>
			<td>${dept.deptCode}</td>
		</tr>
		<tr height="22px">
			<th>部门名称</th>
			<td>${dept.deptName }</td>
		</tr>
		<tr>
		    <th>部门类型</th>
		    <td>
		        <code:getItemText itemValue="${dept.deptTypeCode}" codeId="${codeId[0]}"></code:getItemText>
		    </td>
		</tr>
		<c:if test="${not empty dept.linkedDeptTypeCode }">
		<tr>
		    <th>关联部门类型</th>
		    <td>
		        <code:getItemText itemValue="${dept.linkedDeptTypeCode}" codeId="${codeId[0]}"></code:getItemText>
		    </td>
		</tr>
		</c:if>
		<tr style="display:none">
		    <th>部门所属区域</th>
		    <td>
		        <c:if test="${not empty dept.areaCode }"><code:getItemText itemValue='${dept.areaCode}' codeId='${codeId[1]}'></code:getItemText></c:if>
		    </td>
		</tr>
		<tr height="22px" style="display:none">
			<th>数据访问</th>
			<td>
			 	<c:if test="${empty dept.isPublic or dept.isPublic == '1'}"> 公开访问</c:if>
				<c:if test="${dept.isPublic =='0'}"> 不公开访问</c:if>
			</td>
		</tr>
		<tr height="22px">
			<th>是否独立部门</th>
			<td>
			   <c:if test="${dept.needSubFlow == '1'}">是</c:if>
			   <c:if test="${empty dept.needSubFlow or dept.needSubFlow =='0'}"> 否</c:if>
			</td>
		</tr>
		<c:if test="${dept.deptTypeCode=='03'}">
		<!-- 会员专有信息 -->
		<tr height="22px">
			<th>开通日期</th>
			<td>
			   <fmt:formatDate value="${dept.openDate}" type="date" pattern="yyyy.MM.dd"/>
			</td>
		</tr>
		<tr height="22px">
			<th>有效期限</th>
			<td>
			   <fmt:formatDate value="${dept.expirationDate}" type="date" pattern="yyyy.MM.dd"/>
			</td>
		</tr>
		<tr height="22px">
			<th>用户数</th>
			<td>
			   ${dept.userLimitedNumber}
			</td>
		</tr>
		<c:if test="${needApproval}">
		<tr height="22px">
			<th>是否需要审批</th>
			<td>
			   <c:if test="${dept.needApproval==0}">否</c:if>
			   <c:if test="${dept.needApproval==1}">是</c:if>
			</td>
		</tr>
		</c:if>
		</c:if>
		<tr height="22px">
			<th>同级排序</th>
			<td>${dept.sortSQ}</td>
		</tr>
		<tr>
						<th>
							扩展信息
							<font color="red">*</font>
						</th>
						<td>
						    ${dept.deptExtendInfo.info}
						</td>
					</tr>
		<tr height="22px">
			<td style="text-align: center;" valign="middle" colspan="4">
				<a href="###" class="easyui-linkbutton" onclick="parent.close_win()" iconCls="icon-back">关闭</a>
			</td>
		</tr>		
	</table>
</div>
</body>
</html>