package com.jshx.leavedemo.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.leavedemo.entity.LeaveDemo;
import com.jshx.leavedemo.dao.LeaveDemoDao;

@Component("leaveDemoDao")
public class LeaveDemoDaoImpl extends BaseDaoImpl implements LeaveDemoDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findLeaveDemoByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findLeaveDemo(Map<String, Object> paraMap){
		return this.findListByHqlId("findLeaveDemoByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public LeaveDemo getById(String id)
	{
		return (LeaveDemo)this.getObjectById(LeaveDemo.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(LeaveDemo leaveDemo)
	{
		leaveDemo.setId(null);
		this.saveOrUpdateObject(leaveDemo);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(LeaveDemo leaveDemo)
	{
		this.saveOrUpdateObject(leaveDemo);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(LeaveDemo.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		LeaveDemo leaveDemo = (LeaveDemo)this.getObjectById(LeaveDemo.class, id);
		leaveDemo.setDelFlag(1);
		this.saveObject(leaveDemo);
	}
}
