package com.jshx.activiti.listener;

import com.jshx.activiti.util.ActivitiVarConstants;
import com.jshx.module.admin.entity.User;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.task.IdentityLink;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Set;

/**
 * 设置在运行时设置的任务办理或候选人
 * <p>
 * Created by chenjian on 16/4/29.
 */
public class AssigneeListener extends AbstractListener implements TaskListener {

    /**
     * 创建者所在部门占位符
     */
    private static final String CREATOR_DEPT = "creatorDept";


    @Override
    public void notify(DelegateTask delegateTask) {

        initService();
        String instsnaceid = delegateTask.getProcessInstanceId();
        List<HistoricIdentityLink> list = historyService.getHistoricIdentityLinksForProcessInstance(delegateTask.getProcessInstanceId());
        String creator = null;
        if (!list.isEmpty()) {
            creator = list.get(0).getUserId();
        } else {
            List<IdentityLink> identityLinks = runtimeService.getIdentityLinksForProcessInstance(delegateTask.getProcessInstanceId());
            creator = identityLinks.get(0).getUserId();
        }

        String taskName = delegateTask.getTaskDefinitionKey();

        String taskAssign = (String) runtimeService.getVariable(delegateTask.getExecutionId(), taskName + ActivitiVarConstants.TASK_ASSIGNEE);
        if (StringUtils.isNotEmpty(taskAssign)) {
            delegateTask.setAssignee(taskAssign);
        }

        Set<IdentityLink> identityLinkSet = delegateTask.getCandidates();
        for (IdentityLink identityLink : identityLinkSet) {
            String taskCandidateGroup = identityLink.getGroupId();
            if (StringUtils.isNoneBlank(taskCandidateGroup)) {
                if (taskCandidateGroup.indexOf(CREATOR_DEPT) != -1) {
                    User user = userService.findUserByLoginId(creator);
                    taskCandidateGroup = taskCandidateGroup.replace(CREATOR_DEPT, user.getDeptCode());
                    delegateTask.addCandidateGroup(taskCandidateGroup);
                }
            }
        }
        List<String> taskCandidateUsers = (List<String>) runtimeService.getVariable(delegateTask.getExecutionId(), taskName + ActivitiVarConstants.TASK_CANDIDATE_USERS);
        if (taskCandidateUsers != null && !taskCandidateUsers.isEmpty()) {
            delegateTask.addCandidateUsers(taskCandidateUsers);
        }
        List<String> taskCandidateGroups = (List<String>) runtimeService.getVariable(delegateTask.getExecutionId(), taskName + ActivitiVarConstants.TASK_CANDIDATE_GROUPS);
        if (taskCandidateGroups != null && !taskCandidateGroups.isEmpty()) {
            for (String taskCandidateGroup : taskCandidateGroups) {
                if (taskCandidateGroup.indexOf(CREATOR_DEPT) != -1) {
                    User user = userService.findUserByLoginId(creator);
                    taskCandidateGroup = taskCandidateGroup.replace(CREATOR_DEPT, user.getDeptCode());
                }
                delegateTask.addCandidateGroup(taskCandidateGroup);
            }

        }
    }
}
