<%@page language="java" pageEncoding="UTF-8"%>
<%@include file="/common/header.jsp"%>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Activiti已办任务</title>
<%@include file="/common/jsLib.jsp"%>
<style>
.form-text {
	border: 1px solid #6fc6df;
	border-radius: 3px;
	width: 90%;
	margin-top: 2px;
	height: 24px;
	line-height: 26px;
}
</style>

<script type="text/javascript">
function reloadDate(){
	doQuery();
}
function close_win(){
	$("#newWindow").window("close");
}
function doQuery(){
	var queryParams = {
		"assignee" : $("#assignee").val(),
		"taskName" : $("#taskName").val(),				
		"startDate" :$("#startDate").val(),
		"endDate" :$("#endDate").val()
	};        	
	$('#pagination').datagrid('options').queryParams = queryParams;
	$('#pagination').datagrid('clearSelections');
	$("#pagination").datagrid('load'); 
}

function view(row_Id){
	   var dt=new Date();
   	var urldz="/jsp/spjlb/spjlbViewzhgzl.action?spjlb.id="+row_Id+"&dt="+dt.getTime();
       parent.addTab("zx", "项目详情",urldz); 
   	
}

$(function(){
	$('#pagination').datagrid($.extend(dg_cm_pp,{
		title:'已办任务',
		url:'findDoneTaskList.action',
		columns:[[
				  {field:'id',title:'任务编号',width:fixWidth(0.07)},
		          {field:'name',title:'任务名称',width:fixWidth(0.12)},
				  {field:'procDefName',title:'流程名称',width:fixWidth(0.12)},
				  {field: 'projectName', title: '项目名称', width: fixWidth(0.20)},
                  {field: 'slbh', title: '受理编号', width: fixWidth(0.15), formatter: function (value, rec){
                  	return "<a href='#' onclick=\"view('" + rec.businessKey + "')\"><font style='color:blue'>"+value+"</font></a>";
                  }},
			      //{field:'businessKey',title:'业务Key',width:fixWidth(0.12)},
		          {field:'startTime',title:'开始时间',width:fixWidth(0.12)},
		          {field:'endTime',title:'结束时间',width:fixWidth(0.13)},
// 		          {field:'deleteReason',title:'完结类别',width:fixWidth(0.12)},
		          {field:'op',title:'操作',width:fixWidth(0.2),formatter:function(value,rec){
// 		          		return "<a href='#' class='btn_01_mini' onclick=\"LookupTask('"+rec.id+"')\">查看<b></b></a>&nbsp;<a href='#' class='btn_01_mini' onclick=\"withDraw('"+rec.id+"')\">收回<b></b></a>";
		          		return "<a href='#' class='btn_01_mini' onclick=\"LookupTask('"+rec.id+"')\">查看<b></b></a>&nbsp;";
				  }}						  						  
		        ]]
	}));
});

function LookupTask(taskId){
    window.currTaskId = taskId;
	$.ajax({
		url: "${ctx}/jsp/activiti/lookupDoneTask.action",
        data: {
            taskId: taskId
        },
        dataType: "json",
        type: "post",
        success: function(data){
            if(data){
            	showForm(data);
            }else{
                $.messager.alert("错误", "查询出错");
            }
        },
        error: function(){
            $.messager.alert("错误", "查询出错");
        }
	});
}
function showForm(data){
	$("#form").empty();
    $("#taskWindow").window({"title": data.taskName});
    var row ="<div style='width: 98%;height: 20px;margin: 0px;'>流程："+data.procName+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>任务："+data.taskName+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>起始时间："+data.startTime+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>结束时间："+data.endTime+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>签收时间："+data.claimTime+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>任务描述："+data.description+"</div>";
	    //row+="<div style='width: 98%;height: 20px;margin: 0px;'>任务发起人："+data.owner+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>任务处理人："+data.assignee+"</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>持续时间："+data.duration+"分钟</div>";
	    row+="<div style='width: 98%;height: 20px;margin: 0px;'>完结类别："+data.deleteReason+"</div>";
    $("#form").html(row);
   
    $(".Wdate").bind("click", function() {
        WdatePicker();
    });
    $(".Wdate").addClass("form-text");
    $("#taskWindow").window("open");
}

function withDraw(taskId){
    window.currTaskId = taskId;
	$.ajax({
		url: "${ctx}/jsp/activiti/withDraw.action",
        data: {
            taskId: taskId
        },
        dataType: "json",
        type: "post",
        success: function(data){
            if(data.result){
            	$.messager.alert("成功", "收回成功");
            	doQuery();
            }else{
                $.messager.alert("提示", "不可收回");
            }
        },
        error: function(){
            $.messager.alert("错误", "收回出错");
        }
	});
}
			
</script>
</head>

<body>
	<div class="page_content">
		<div class="box_01 submitdata">
			<div class="inner12px">
				<form name="myform" method="post">
					<div class="cell boxBmargin12">
						<table>
							<%--<tr>
								<th width="15%">处理人：</th>
								<td width="35%"><input type="text" id="Assignee" name="Assignee"></td>--%>
							<tr>
								<th width="15%">任务处理时间</th>
								<td width="35%"><input name="startDate" size="20"
													   id="startDate" value="" type="text" class="Wdate"
													   onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',maxDate:'#F{$dp.$D(\'endDate\')}'})">
									-<input name="endDate" id="endDate" size="20" value=""
											type="text" class="Wdate"
											onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'#F{$dp.$D(\'startDate\')}'})">
								</td>
								<th width="15%">任务名称：</th>
								<td width="35%"><input type="text" id="taskName" name="taskName"></td>
							</tr>
							<tr>
								<td colspan="4">
									<div class="btn_area_setc">
										<a href="###" class="btn_01" onclick="doQuery()">查询<b></b></a>
										<a href="###" class="btn_01" onclick="clear_form(document.myform);">清空<b></b></a>
									</div>									
								</td>
							</tr>									
						</table>
					</div>
					<div id="pagination"></div>
				</form>
			</div>
		</div>
	</div>
    <div id="taskWindow" class="easyui-window"  title="" data-options="modal:true,closed:true" style="width:400px;height:300px;padding:5px;">
       <div class="easyui-layout" data-options="fit:true">
           <div id="form"></div>
           <div data-options="region:'south',border:false" style="text-align:right;padding:5px 0 0;">
               <a class="easyui-linkbutton" data-options="iconCls:'icon-cancel'" href="javascript:void(0)" onclick='$("#taskWindow").window("close");' style="width:80px">关闭</a>
           </div>
       </div>
   </div>
</body>
</html>