FS.ReportManagerAddon = FS.Plugin.ReportManagerAddon;

/**
 * Coder: Sean
 * Date: 13-10-29
 * Time: 下午2:31
 */
FS.REPORTMGR = FSRM = {
    _WD: {
        reportCoverConfigPanelWD: "reportCoverConfigPanel"
    },
    CONSTS: {
        //对应EntryConstants.java
        FOLDER: '0',
        FILE: '1',
        REPORTLET: '2',
        URL: '3',
        ANALYSIS: '4',
        PROCESS: '5',
        FASTQUERY: '6',
        REPORTPROCESS: '8',
        PROCESSTYPE: {
            1: FR.i18nText("FS-Report-RP_TaskMgr"),
            2: FR.i18nText("FS-Report-RP_ProcessMgr"),
            3: FR.i18nText("FS-Report-RP_MyTask")
        }
    },
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_reportmgr.css', 'css');
        this.createTabPane(renderer);
        FSRM.Control.initData();
    },

    createTabPane: function (render) {
        var self = this;
        this.renderEl = render;
        var resizeFns = [
            function (container, width, height) {

            }, function (container, width, height) {
                //限制最小缩放尺寸
                width = width < 500 ? 500 : width;
                height = height < 300 ? 300 : height;
                //调整封面设置面板尺寸
                container.getWidgetByName(FSRM._WD.reportCoverConfigPanelWD).doResize({
                    width: width,
                    height: height - 70
                });
                var right_panel_width = width - 245;
                var panel_height = height - 120;
                $("#fs-mobile-dir-cover-container").height(panel_height);
                self.mobileDirCoverPane.doResize({
                    width: 245,
                    height: panel_height
                });
                self.mobileEntryCoverPane.doResize({
                    width: right_panel_width,
                    height: panel_height
                });
                $("#fs-mobile-cover-upload-tip").width(width - 280);
            }
        ];
        this.tabPane = new FS.LTabPane({
            width: '100%',
            height: '100%',
            style: 'blue',
            marginLeft: 0,
            renderEl: render,
            items: [
                this.reportTab(),
                this.reportCoverTabConfig()
            ],
            initAfterActions: [
                function () {
                    self.dirMgrInit();
                    $('.fs_reportmgr_cpt_icon').attr('title', FR.i18nText("FS-Report-Add_Cpt"));
                    $('.fs_reportmgr_link_icon').attr('title', FR.i18nText("FS-Report-Add_Link"));
                    $('.fs_reportmgr_rp_icon').attr('title', FR.i18nText("FS-Report-RP_AddLabel"));
                    this.getWidgetByName("cptMgrPane").panelBody.css('overflow', 'auto');
                }, function () {
                    FSRM.Control.getFolderData();
                    self.createMobileDirCoverPane();
                    if (self.dirCovers.length > 0) {
                        self.dirCovers[0].click();
                    } else {
                        self.createMobileEntryCoverPane();
                    }
                }
            ],
            opAfterActions: [
                function () {

                }, function () {
                    resizeFns[1](this, render.width(), render.height());
                }
            ]
        });
        //bug:73449这边加hidden有何意图，先去掉了
        //this.renderEl.css("overflow", "hidden");
        this.renderEl.data("onResize", function (width, height) {
            var tabIdx = self.tabPane.getSelectedIndex();
            if (tabIdx !== null) {
                resizeFns[tabIdx](self.tabPane, width, height);
            }
        });
    },

    /**
     * 目录管理面板
     */
    reportTab: function () {
        var self = this;
        var dirMgrPane = {
            type: 'panel',
            doSize: true,
            y: 75,
            x: 40,
            width: 236,
            height: 450,
            title: FR.i18nText("FS-Report-Directory_Management"),
            border: true,
            contentHtml: $('<div/>').addClass('fs_reportmgr_dir_panel_content'),
            tools: [{
                //添加目录按钮及其事件
                iconCls: 'fs-module-add-white',
                width: 24,
                height: 24,
                handler: function () {
                    if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0]) {
                        FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Do_Select_Dir"));
                        return;
                    }
                    $(this).removeClass('fs_reportmgr_add_icon_white_click');
                    var title = FR.i18nText("FS-Report-Add_Directory");
                    var onOK = function () {
                        var dirname = addDirDialog.getWidgetByName("nameText").getValue();
                        var description = addDirDialog.getWidgetByName("descriptionText").getValue();
                        var mobileDeviceConfig = FSRM._makeMobileDeviceConfig(
                            addDirDialog.getWidgetByName("deviceCheckboxGroup").getValue()
                        );
                        if (!self.DIR._checkValid(dirname, true)) {
                            return;
                        }
                        self.DIR._addFolder(dirname, description, mobileDeviceConfig);
                    };
                    var onCancel = function () {
                    };
                    var data = {};
                    data.parentMobileConfig = self.DIR.getParentMobileConfig();
                    var addDirDialog = self.createDirDialog(title, onOK, onCancel, data);
                    addDirDialog.setVisible(true);
                    addDirDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                        FSRM._makeMobileConfigCheckboxValue(data.parentMobileConfig)
                    );
                }
            }
            ]
        };
        var tools = [
            {
                //模板添加ICON及其事件
                iconCls: 'fs_reportmgr_cpt_icon',
                width: 21,
                height: 21,
                hover: [function () {
                    $(this).addClass('fs_reportmgr_cpt_icon_hover');
                }, function () {
                    $(this).removeClass('fs_reportmgr_cpt_icon_hover');
                }],
                handler: {
                    mousedown: function () {
                        $(this).addClass('fs_reportmgr_cpt_icon_click');
                    },
                    mouseleave: function () {
                        $(this).removeClass('fs_reportmgr_cpt_icon_hover');
                        $(this).removeClass('fs_reportmgr_cpt_icon_click');
                    },
                    mouseup: function () {
                        $(this).removeClass('fs_reportmgr_cpt_icon_click');
                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Dir_Selected"));
                            return;
                        }

                        var title = FR.i18nText("FS-Report-Add_Cpt");
                        var onOK = function () {
                            return self.DIR._addOrEditCpt(null, null, true);
                        };
                        var onCancel = function () {
                        };
                        var data = {}; //编辑dialog的初始数据
                        data.parentMobileConfig = self.DIR.getParentMobileConfig();
                        self.cptDialog = self.createCptDialog(title, onOK, onCancel, data);
                        self.cptDialog.setVisible(true);
                        self.cptDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                            FSRM._makeMobileConfigCheckboxValue(data.parentMobileConfig)
                        );
                    }
                }
            },
            {
                //链接添加ICON及其事件
                iconCls: 'fs_reportmgr_link_icon',
                width: 21,
                height: 21,
                hover: [function () {
                    $(this).addClass('fs_reportmgr_link_icon_hover');
                }, function () {
                    $(this).removeClass('fs_reportmgr_link_icon_hover');
                }],
                handler: {
                    mousedown: function () {
                        $(this).addClass('fs_reportmgr_link_icon_click');
                    },
                    mouseleave: function () {
                        $(this).removeClass('fs_reportmgr_link_icon_hover');
                        $(this).removeClass('fs_reportmgr_link_icon_click');
                    },
                    mouseup: function () {
                        $(this).removeClass('fs_reportmgr_link_icon_click');
                        if (!FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0] || FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0].pId === "0-2") {
                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Dir_Selected"));
                            return;
                        }
                        var title = FR.i18nText("FS-Report-Add_Link");
                        var onOK = function () {
                            return self.DIR._addOrEditLink(null, null, true);
                        };
                        var onCancel = function () {
                        };
                        var data = {}; //编辑dialog的初始数据
                        data.parentMobileConfig = self.DIR.getParentMobileConfig();
                        self.linkDialog = self.createLinkDialog(title, onOK, onCancel, data);
                        self.linkDialog.setVisible(true);
                        self.linkDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                            FSRM._makeMobileConfigCheckboxValue(data.parentMobileConfig)
                        );
                    }
                }
            }
        ];
        var reportMgrAddon = FS.Plugin.ReportManagerAddon;
        if (reportMgrAddon) {
            $.each(reportMgrAddon, function (i, m) {
                if ($.isFunction(m)) {
                    m.apply(self, [tools]);
                }
            });
        }
        //节点管理面板
        var cptMgrPane = {
            type: 'panel',
            widgetName: 'cptMgrPane',
            doSize: true,
            border: true,
            title: FR.i18nText("FS-Module-Node_Manager"),
            x: 301,
            y: 75,
            width: 602,
            height: 450,
            tools: tools,
            contentHtml: this.cptMgrInit()
        };
        return {
            title: FR.i18nText("FS-Module-Report_Manager"),
            content: {
                type: 'absolute',
                scrollable: true,
                width: '100%',
                height: '100%',
                top: 15,
                left: 20,
                items: [dirMgrPane, cptMgrPane]
            }
        }
    },

    /**
     * 报表封面
     */
    reportCoverTabConfig: function () {
        return {
            title: FR.i18nText('FS-Mobile-Report_Cover'),
            content: {
                type: 'panel',
                widgetName: FSRM._WD.reportCoverConfigPanelWD,
                doSize: true,
                width: this.renderEl.width(),
                height: this.renderEl.height() - 70,
                closeAfterAction: false,
                contentWidget: {
                    type: 'tablepane',
                    vgap: 8,
                    colSize: [40, 80, 245, 245],
                    rowSize: ['fill', 28],
                    items: [
                        [
                            null, null,
                            $('<div/>').attr("id", "fs-mobile-dir-cover-container").height(
                                this.renderEl.height() - 120
                            ).append(
                                $('<div/>').attr("id", "fs-mobile-dir-cover-pane")
                                    .addClass("fs-mobile-cover-pane")
                            ),
                            $('<div/>').append(
                                $('<div/>').attr("id", "fs-mobile-entry-cover-pane")
                                    .addClass("fs-mobile-cover-pane")
                            )
                        ], [
                            {}, {
                                type: 'quickbutton',
                                style: 'blue',
                                text: FR.i18nText("FS-Frame-Simple_Save"),
                                handler: function () {
                                    if (!FSRM.Control.coverData) {
                                        return;
                                    }
                                    var completeFn = function (res, status) {
                                        if (status === 'success') {
                                            FR.Msg.toast(FR.i18nText("FS-Generic-Simple_Successfully"));
                                            FSRM.Control.initEntryCoverId();
                                        }
                                    };
                                    var config = {
                                        url: FR.servletURL + '?op=fs_main&cmd=set_report_cover',
                                        type: 'POST',
                                        data: FSRM.Control.coverData
                                    };
                                    //保存封面设置
                                    FS.Async.ajax(config, completeFn);
                                }
                            }, null,
                            $('<div/>').addClass("fr-fileupload-tooltip").height(21).append(
                                $('<span/>').attr(
                                    "id", "fs-mobile-cover-upload-tip"
                                ).addClass("fr-fileupload-tooltipspan").width(
                                    this.renderEl.width() - 280
                                ).css("text-align", "center").text(
                                    FR.i18nText("FS-Mobile-Report_Cover_Upload_ToolTip")
                                )
                            )
                        ]
                    ]
                }
            }
        }
    },

    /**
     * 移动端一级目录封面设置
     */
    createMobileDirCoverPane: function () {
        this.mobileDirCoverPane = FR.createWidget({
            renderEl: $("#fs-mobile-dir-cover-pane"),
            type: 'panel',
            width: 245,
            height: this.renderEl.height() - 120,
            doSize: true,
            contentWidget: {
                type: 'tablepane',
                colSize: ['fill'],
                rowSize: [5, 'auto'],
                scrollable: true,
                items: [
                    $('<div/>').height(5),
                    this._createMobileDirCoverItems()
                ]
            }
        })
    },

    /**
     * 移动端报表及链接封面设置
     */
    createMobileEntryCoverPane: function (idx, folderId) {
        var rows = this._createMobileEntryCoverRows(idx, folderId);
        this.mobileEntryCoverPane = FR.createWidget({
            renderEl: $("#fs-mobile-entry-cover-pane"),
            type: 'panel',
            width: this.renderEl.width() - 245,
            height: this.renderEl.height() - 120,
            doSize: true,
            contentWidget: {
                type: 'tablepane',
                colSize: ['fill'],
                rowSize: rows[0],
                scrollable: true,
                items: rows[1]
            }
        })
    },

    _createMobileDirCoverItems: function () {
        var self = this;
        var dirs = [];
        if (FSRM.Control.folderData.length > 0) {
            dirs = FSRM.Control.folderData[0].ChildNodes;
        }
        this.dirCovers = [];
        $.each(dirs, function (idx, dir) {
            var cover = self._createCoverItem(idx, dir, true);
            if (cover) {
                self.dirCovers.push(cover);
            }
        });
        return [this.dirCovers]
    },

    _createMobileEntryCoverRows: function (idx, folderId) {
        var coverRows = [$('<div/>').height(5)];
        var coverRowSize = [5];
        if (folderId === null || folderId === undefined) {
            return [coverRowSize, coverRows]
        }
        var self = this;
        //先读取缓存数据
        var folders = FSRM.Control.folderEntries[idx];
        if (!folders) {
            folders = FS.Sync.ajax({
                url: FR.servletURL + '?op=fs_main&cmd=get_cover_sub_entries',
                type: 'POST',
                data: {folderID: folderId}
            });
            FSRM.Control.folderEntries[idx] = folders;
        }
        $.each(folders, function (i, folder) {
            var subDir = folder.folder;
            var entries = folder.entry;
            if (!subDir || subDir.mobileDeviceConfig > 1) {
                if (subDir) {
                    coverRows.push(self._createMobileCoverSubDirTitle(subDir.text));
                    coverRowSize.push('auto');
                }
                if (entries !== null) {
                    coverRows.push(self._createMobileEntryCoverItems(entries));
                    coverRowSize.push('auto');
                }
            }
        });
        return [coverRowSize, coverRows];
    },

    _createMobileEntryCoverItems: function (entries) {
        var self = this;
        var rowCovers = [];
        $.each(entries, function (idx, entry) {
            var cover = self._createCoverItem(idx, entry, false);
            if (cover !== null) {
                rowCovers.push(cover);
            }
        });
        return [rowCovers]
    },

    _createCoverItem: function (idx, entry, isDirCover) {
        var self = this;
        var $cover = $('<div class="fs-mobile-report-cover"/>');
        $cover = isDirCover ? $cover : $cover.addClass('fs-mobile-custom-cover');
        var coverId = entry.mobileCoverId;
        //缓存中entry对应的封面id
        var isFromCache = false;
        if (FSRM.Control.coverData && entry.nodeicon) {
            var cacheCoverId;
            if (entry.nodeicon == "cpt") {
                cacheCoverId = FSRM.Control.coverData.report[entry.id];
                if (cacheCoverId) {
                    coverId = cacheCoverId;
                    isFromCache = true;
                }
            } else if (entry.nodeicon == "url") {
                cacheCoverId = FSRM.Control.coverData.link[entry.id];
                if (cacheCoverId) {
                    coverId = cacheCoverId;
                    isFromCache = true;
                }
            }
        }
        if (!coverId) {
            coverId = String.fromCharCode(Math.floor(Math.random() * 26) + "a".charCodeAt(0));
            ;
            isFromCache = true;
        }
        var attachUrl = isFromCache ? "?op=fr_attach&cmd=ah_image&isAdjust=false&id=" : "?op=fs_main&cmd=get_report_cover&id=";
        var coverUrl = FR.servletURL + (coverId.length < 2 ?
                "?op=resource&resource=/com/fr/fs/resources/images/mobile/cover/" + coverId + ".png" : attachUrl + coverId);
        var coverImg = $('<img class="fs-mobile-report-cover-img"/>').attr("src", coverUrl).appendTo($cover),
            toolMask;
        $cover.append(
            $('<div class="fs-mobile-report-cover-title"/>').append($('<span/>').text(entry.text))
        );
        $cover.mouseover(function () {
            if (!toolMask) {
                var uploadBtn = $('<div/>').addClass("fs-mobile-cover-upload-icon");
                new FR.MultiFileEditor({
                    renderEl: uploadBtn,
                    maxlength: 1,
                    accept: '.png.jpg.gif',
                    height: 24,
                    width: 24,
                    hideFileList: true,
                    showViewImage: false,
                    listeners: [{
                        eventName: "afteredit",
                        action: function () {
                            var attachId = this.getValue().attach_id;
                            var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachId + '&isAdjust=false');
                            coverImg.attr('src', url);
                            $('td', this.element).remove();
                            //设置缓存配置
                            FSRM.Control.setEntryCoverId(entry, attachId, isDirCover);
                        }
                    }]
                });
                $('img', uploadBtn).remove();

                var resetBtn = $('<div/>').addClass("fs-mobile-cover-reset-icon").attr("title", FR.i18nText("FS-Mobile-Report_Cover_Reset"))
                    .click(function () {
                        //生成随机封面图ID
                        var newImgId = entry.mobileCoverId;
                        while (newImgId == entry.mobileCoverId) {
                            //ID: a-z
                            newImgId = String.fromCharCode(Math.floor(Math.random() * 26) + "a".charCodeAt(0));
                        }
                        coverImg.attr("src", FR.servletURL + "?op=resource&resource=/com/fr/fs/resources/images/mobile/cover/" + newImgId + ".png");
                        FSRM.Control.setEntryCoverId(entry, newImgId, isDirCover);
                    });
                toolMask = $('<div/>').addClass("fs-mobile-report-cover-tool-mask")
                    .append(uploadBtn).append(resetBtn).click(function (e) {
                        //屏蔽目录切换
                        if (e && e.stopPropagation) {
                            e.stopPropagation();
                        } else if (window.event) {
                            window.event.cancelBubble = true;
                        }
                    }).appendTo($cover);
            }
            toolMask.show();
        }).mouseout(function () {
            if (toolMask) {
                toolMask.hide();
            }
        });
        if (isDirCover) {
            var dirCover = $('<div/>').addClass("fs-mobile-dir-cover-container")
                .click(function () {
                    if (self.selectedCover) {
                        self.selectedCover.removeClass("fs-mobile-dir-cover-container-selected");
                    }
                    dirCover.addClass("fs-mobile-dir-cover-container-selected");
                    self.selectedCover = dirCover;
                    $("#fs-mobile-entry-cover-pane").empty();
                    self.createMobileEntryCoverPane(idx, entry.id);
                }).append($cover);
            return dirCover;
        } else {
            return $cover;
        }
    },

    _createMobileCoverSubDirTitle: function (title) {
        return $('<div/>').addClass("fs-mobile-report-sub-dir-title").append($('<span/>').text(title));
    },

    DIR: {
        //File
        _editFile: function (id, sortindex) {
            if (!this._isFileValid()) {
                return false;
            }
            var file = this._getFileDialogValue(id);
            if (!file) {
                return false;
            }
            if (sortindex) {
                file.sortindex = sortindex;
            }

            var completeFn = function (res, status) {
                var item = FR.jsonDecode(res.responseText);
                //DOM操作
                var tName = 'file';
                var catalogWidths = [156, 340];
                var data = [item.text, item.path, item.id];
                var originaldata = item;
                if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                    $('.fs_reportmgr_table_' + tName).show();
                }
                FS.REPORTMGR.addTableData(tName, catalogWidths, -1, data, originaldata);
            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: "fr_schedule",
                    cmd: "se_setfilename",
                    setScheduleFileName: file
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        },

        _isFileValid: function () {
            var name = FS.REPORTMGR.fileDialog.getWidgetByName("nameText").getValue();
            if (!name) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Enter_File_Name"));
                return false;
            }
            return true;
        },

        _getFileDialogValue: function (id) {
            var name = FS.REPORTMGR.fileDialog.getWidgetByName("nameText").getValue();
            var path = FS.REPORTMGR.fileDialog.getWidgetByName("fileposition").getValue();
            var description = FS.REPORTMGR.fileDialog.getWidgetByName("descriptionText").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);

            var file = {parentId: pd, description: description, path: path, text: name};
            if (id != null && id != undefined) {
                file.id = id;
            }
            return file;
        },

        //Link
        _addOrEditLink: function (id, sortindex, isAdd, coverId) {
            var self = this;
            if (!this._isLinkValid()) {
                return false;
            }
            var url = this._getLinkDialogValue(id);
            if (!url) {
                return false;
            }
            if (sortindex) {
                url.sortindex = sortindex;
            }
            url.mobileCoverId = isAdd === true ? FSRM._makeMobileCoverRandomId() : coverId;
            url.parentDeviceConfig = self.getParentMobileConfig();
            var completeFn = function (res, status) {
                var jason = res.responseText;
                if (jason == "-1") {
                    //没有权限
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                    return;
                }
                var item = FR.jsonDecode(jason);
                //DOM操作
                var tName = 'link';
                var catalogWidths = [156, 340];
                var hyperLinkIndex = 1;
                var data = [item.text, item.url, item.id];
                var originaldata = item;
                if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                    $('.fs_reportmgr_table_' + tName).show();
                }
                FS.REPORTMGR.addTableData(tName, catalogWidths, hyperLinkIndex, data, originaldata);
            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: "fs_entry",
                    cmd: "addurl",
                    urlJason: url
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        },

        _isLinkValid: function () {
            var path = FS.REPORTMGR.linkDialog.getWidgetByName("pathText").getValue();
            var name = FS.REPORTMGR.linkDialog.getWidgetByName("nameText").getValue();
            if (!path) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Input_Link_URL"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Input_Link_Name"));
                return false;
            }
            return true;
        },

        _getLinkDialogValue: function (id) {
            var path = FS.REPORTMGR.linkDialog.getWidgetByName("pathText").getValue();
            var name = FS.REPORTMGR.linkDialog.getWidgetByName("nameText").getValue();
            var description = FS.REPORTMGR.linkDialog.getWidgetByName("descriptionText").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);
            var mobileDeviceConfig = FSRM._makeMobileDeviceConfig(
                FSRM.linkDialog.getWidgetByName("deviceCheckboxGroup").getValue()
            );

            var url = {
                parentId: pd,
                description: description,
                url: path,
                text: name,
                mobileDeviceConfig: mobileDeviceConfig
            };
            if (id != null && id != undefined) {
                url.id = id;
            }
            return url;
        },

        //Cpt
        _addOrEditCpt: function (id, sortindex, isAdd, coverId) {
            var self = this;
            if (!this._isCptValid()) {
                return false;
            }
            var report = this._getCptDialogValue(id);
            if (!report) {
                return false;
            }
            if (sortindex) {
                report.sortindex = sortindex;
            }
            report.mobileCoverId = isAdd === true ? FSRM._makeMobileCoverRandomId() : coverId;
            report.parentDeviceConfig = self.getParentMobileConfig();
            var completeFn = function (res) {
                var jason = res.responseText;
                if (jason == "-1") {
                    //没有权限
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                    return;
                }
                var item = FR.jsonDecode(jason);
                //DOM操作
                var tName = 'report';
                var catalogWidths = [156, 161, 100, 80];
                var hyperLinkIndex = 1;
                var showType = (item.showType === "2" ? FR.i18nText("FS-Generic-Simple_Preview") : (item.showType === "0" ? FR.i18nText("FS-Generic-Face_Write") : FR.i18nText("FS-Report-Simple_Analysis")));
                var hasParameters = (item.transmitParameters ? FR.i18nText("FS-Report-Has_Parameter") : FR.i18nText("FS-Generic-Simple_None"));
                var data = [item.text, item, showType, hasParameters, item.id];
                var originaldata = item;
                if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                    $('.fs_reportmgr_table_' + tName).show();
                }
                FS.REPORTMGR.addTableData(tName, catalogWidths, hyperLinkIndex, data, originaldata);

            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: "fs_entry",
                    cmd: "addreport",
                    reportJason: report
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        },

        _isCptValid: function () {
            var path = FS.REPORTMGR.cptDialog.getWidgetByName("pathCombo").getValue().join('/');
            var name = FS.REPORTMGR.cptDialog.getWidgetByName("nameText").getValue();
            var showtype = FS.REPORTMGR.cptDialog.getWidgetByName("typeRadioGroup").getValue();
            if (!path) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Input_Cpt_Path"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Input_Cpt_Name"));
                return false;
            }
            if (showtype === "") {
                FR.Msg.alert(FR.i18nText("FS-Report-Choose_ViewType"));
                return false;
            }
            return true;
        },

        _getCptDialogValue: function (id) {
            var path = FS.REPORTMGR.cptDialog.getWidgetByName("pathCombo").getValue().join('/');
            var name = FS.REPORTMGR.cptDialog.getWidgetByName("nameText").getValue();
            var description = FS.REPORTMGR.cptDialog.getWidgetByName("descriptionText").getValue();
            var showType = FS.REPORTMGR.cptDialog.getWidgetByName("typeRadioGroup").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);
            var mobileDeviceConfig = FSRM._makeMobileDeviceConfig(
                FSRM.cptDialog.getWidgetByName("deviceCheckboxGroup").getValue()
            );
            var transmitParameters = FS.REPORTMGR.cptDialog.getWidgetByName("paraSetGrid").getData();
            var report = {
                parentId: pd,
                description: description,
                path: path,
                text: name,
                showType: showType,
                mobileDeviceConfig: mobileDeviceConfig,
                transmitParameters: transmitParameters
            };
            if (id != null && id != undefined) {
                report.id = id;
            }
            return report;
        },

        //ReportProcess
        _addOrEditRP: function (id, sortindex) {
            if (!this._isRPValid()) {
                return false;
            }
            var rp = this._getRPDialogValue(id);
            if (!rp) {
                return false;
            }
            if (sortindex) {
                rp.sortindex = sortindex;
            }
            var completeFn = function (res, status) {
                var jason = res.responseText;
                if (jason == "-1") {
                    //没有权限
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                    return;
                }
                var item = FR.jsonDecode(jason);
                //DOM操作
                var tName = 'rp';
                var catalogWidths = [156, 340];
                var data = [item.text, item.processType, item.id];
                var originaldata = item;
                if ($('.fs_reportmgr_table_content_' + tName).children().length <= 0) {
                    $('.fs_reportmgr_table_' + tName).show();
                }
                FS.REPORTMGR.addTableData(tName, catalogWidths, 1, data, originaldata);
            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: "fs_entry",
                    cmd: "addreportprocess",
                    processJason: rp
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        },

        _isRPValid: function () {
            var label = FS.REPORTMGR.rpDialog.getWidgetByName("LABELCOMBO").getValue();
            var name = FS.REPORTMGR.rpDialog.getWidgetByName("RPNAME").getValue();
            if (!label) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-RP_SelectLabel"));
                return false;
            }
            if (!name) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-RP_InputName"));
                return false;
            }
            return true;
        },

        _getRPDialogValue: function (id) {
            var label = FS.REPORTMGR.rpDialog.getWidgetByName("LABELCOMBO").getValue();
            var text = FS.REPORTMGR.rpDialog.getWidgetByName("RPNAME").getValue();
            var description = FS.REPORTMGR.rpDialog.getWidgetByName("RPDESCRIPTION").getValue();
            var pd = this.dirTabletree.getSelectedNodes()[0].id.substr(1);
            var rp = {
                parentId: pd,
                processType: label,
                text: text,
                description: description
            };
            if (id != null && id != undefined) {
                rp.id = id;
            }
            return rp;
        },

        _makeZTreeData: function (treedata, result, parentMobileConfig) {
            if (!result) {
                result = [];
            }
            if (parentMobileConfig == null || parentMobileConfig == undefined) {
                parentMobileConfig = 7;
            }
            for (var i = 0, len = treedata.length; i < len; i++) {
                var item = treedata[i];
                var zitem = {};
                zitem.name = item.localeKey ? FR.i18nText(item.localeKey) : item.text;
                zitem.parentMobileConfig = parentMobileConfig;
                zitem.mobileDeviceConfig = item.mobileDeviceConfig;
                zitem.mobileCoverId = item.mobileCoverId ? item.mobileCoverId : FSRM._makeMobileCoverRandomId();
                if (item.ChildNodes && item.ChildNodes.length > 0) {
                    this._makeZTreeData(item.ChildNodes, result, item.mobileDeviceConfig & parentMobileConfig);
                }
                zitem.id = item.id;
                zitem.pId = item.parentId;
                zitem.open = true;
                zitem.description = item.description;
                zitem.sortindex = item.sortindex;
                result.push(zitem);
            }
            return result;
        },

        _getReportData: function (reports) {
            var result = [];
            for (var i = 0, len = reports.length; i < len; i++) {
                var report = reports[i];
                var showType = (report.showType === "2" ? FR.i18nText("FS-Generic-Simple_Preview") : (report.showType === "0" ? FR.i18nText("FS-Generic-Face_Write") : FR.i18nText("FS-Report-Simple_Analysis")));
                var hasParameters = (report.transmitParameters ? FR.i18nText("FS-Report-Has_Parameter") : FR.i18nText("FS-Generic-Simple_None"));
                var reportdata = [report.text, report, showType, hasParameters, report.id];
                result.push(reportdata);
            }
            return result;
        },

        _getLinkData: function (urls) {
            var result = [];
            for (var i = 0, len = urls.length; i < len; i++) {
                var url = urls[i];
                var urldata = [url.text, url.url, url.id];
                result.push(urldata);
            }
            return result;
        },

        _getBIData: function (bireports) {
            var result = [];
            for (var i = 0, len = bireports.length; i < len; i++) {
                var file = bireports[i];
                var filedata = [file.text, {reportName: file.reportName, reportId: file.reportId}, file.id];
                result.push(filedata);
            }
            return result;
        },

        _getRPData: function (rps) {
            var result = [];
            for (var i = 0, len = rps.length; i < len; i++) {
                var rp = rps[i];
                var rpdata = [rp.text, rp.processType, rp.id];
                result.push(rpdata);
            }
            return result;
        },

        _getFileData: function (files) {
            var result = [];
            for (var i = 0, len = files.length; i < len; i++) {
                var file = files[i];
                var filedata = [file.text, file.path, file.id];
                result.push(filedata);
            }
            return result;
        },

        _initFileData: function (files) {
            if (!files) {
                files = [];
            }
            var reports = [];
            var urls = [];
            var ads = [];
            var outfiles = [];
            var processes = [];
            var queryProcesses = [];
            var reportProcesses = [];
            for (var i = 0, len = files.length; i < len; i++) {
                var file = files[i];
                var type = file.type;
                if (file.url != null) {
                    urls.push(file);
                } else if (file.tdname != null) {
                    ads.push(file);
                } else if (type === FS.REPORTMGR.CONSTS.REPORTLET) {
                    reports.push(file);
                } else if (type === FS.REPORTMGR.CONSTS.FILE) {
                    outfiles.push(file);
                } else if (type === FS.REPORTMGR.CONSTS.PROCESS) {
                    processes.push(file);
                } else if (type === FS.REPORTMGR.CONSTS.FASTQUERY) {
                    queryProcesses.push(file);
                } else if (type === FS.REPORTMGR.CONSTS.REPORTPROCESS) {
                    reportProcesses.push(file);
                } else {
                    $.each(FS.Plugin.EntrySupporter, function (index, value) {
                        if (value.acceptTypeByNumber(type)) {
                            value.update(file);
                        }
                    });
                }
            }

            var reportsdata = this._getReportData(reports);
            FS.REPORTMGR.reportTable.popTableData(reportsdata, reports);
            var linkdata = this._getLinkData(urls);
            FS.REPORTMGR.LinkTable.popTableData(linkdata, urls);
            var filedata = this._getFileData(outfiles);
            FS.REPORTMGR.fileTable.popTableData(filedata, outfiles);

            var rpdata = this._getRPData(reportProcesses);
            FS.REPORTMGR.rpTable.popTableData(rpdata, reportProcesses);

            $.each(FS.Plugin.EntrySupporter, function (index, value) {
                value.populate();
            });
        },

        _showFiles: function (e, treeId, treeNode) {
            /**
             * wei : TODO 这里还有前面获取目录的地方，都没必要再往后台发请求，在登录FS
             * 获取目录树信息后，就已经有这些数据了，只需要在更新/添加/删除时更改下缓存就好了。
             */
            //如果是根目录，直接return
            if (!treeNode.getParentNode()) {
                FS.REPORTMGR.DIR._initFileData();
                return;
            }
            var nodeid = treeNode.id;
            var completeFn = function (res, status) {
                if (!res.responseText) {
                    return;
                }
                var files = FR.jsonDecode(res.responseText);
                FS.REPORTMGR.DIR._initFileData(files);
            };
            var config = {
                url: FR.servletURL + '?op=fs_entry&cmd=getfiles',
                type: 'POST',
                data: {folderID: nodeid}
            };
            FS.Async.ajax(config, completeFn);
        },

        _checkValid: function (dirName, isAdd) {
            if (!dirName) {
                FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Input_Folder_Name"));
                return false;
            }
            var dirTabletree = FS.REPORTMGR.DIR.dirTabletree;
            var selectedNode = dirTabletree.getSelectedNodes()[0];
            var siblings;
            if (isAdd === true) {
                siblings = selectedNode.children || [];
            } else {
                //修改
                siblings = selectedNode.getParentNode() ? (selectedNode.getParentNode().children || []) : [];
            }
            for (var i = 0, len = siblings.length; i < len; i++) {
                var node = siblings[i];
                if (node.name === dirName && node != selectedNode) {
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-Simple_Named") + dirName + FR.i18nText("FS-Report-Folder_Already_Exist"));
                    return false;
                }
            }
            return true;
        },

        getParentMobileConfig: function () {
            var self = this;
            var selectedNode = self.dirTabletree.getSelectedNodes()[0];
            return selectedNode.mobileDeviceConfig & selectedNode.parentMobileConfig;
        },

        _editFolder: function () {
            var dirTabletree = FS.REPORTMGR.DIR.dirTabletree;
            var selectedNode = dirTabletree.getSelectedNodes()[0];
            var dirName = this.getWidgetByName("nameText").getValue();
            var description = this.getWidgetByName("descriptionText").getValue();
            var mobileDeviceConfig = FSRM._makeMobileDeviceConfig(
                this.getWidgetByName("deviceCheckboxGroup").getValue()
            );
            if (!FS.REPORTMGR.DIR._checkValid(dirName, false)) {
                return;
            }
            var folder = {};
            var parentId = selectedNode.pId.substr(1);
            if (parentId == null && parentId == undefined) {
                parentId = -1;
            }
            if (selectedNode.id != null && selectedNode.id != undefined) {
                folder.id = selectedNode.id;
            }
            folder.parentId = parentId;
            folder.text = dirName;
            folder.hasChildren = true;
            folder.isexpand = true;
            folder.complete = true;
            folder.description = description;
            folder.sortindex = selectedNode.sortindex;
            folder.mobileDeviceConfig = mobileDeviceConfig;
            folder.parentDeviceConfig = selectedNode.getParentNode().parentMobileConfig;
            folder.mobileCoverId = selectedNode.mobileCoverId;
            var completeFn = function (res) {
                if (res.responseText == "-1") {
                    //没有权限
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                    return;
                }
                selectedNode.name = dirName;
                selectedNode.description = description;
                selectedNode.mobileDeviceConfig = mobileDeviceConfig;
                dirTabletree.updateNode(selectedNode);
                if (selectedNode.isParent) {
                    $.each(selectedNode.children, function (idx, childNode) {
                        FSRM.DIR._editChildNodeMobileConfig(childNode, selectedNode);
                    })
                }
            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: "fs_entry",
                    cmd: "editfolder",
                    folderJason: folder
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        },

        _editChildNodeMobileConfig: function (node, parent) {
            var self = this;
            node.parentMobileConfig = parent.mobileDeviceConfig & parent.parentMobileConfig;
            if (node.isParent) {
                $.each(node.children, function (idx, childNode) {
                    self._editChildNodeMobileConfig(childNode, node);
                })
            }
        },

        _addFolder: function (dirname, description, mobileDeviceConfig) {
            var self = this;
            var selectedNode = this.dirTabletree.getSelectedNodes()[0];
            var folder = {};
            var parentId = selectedNode.pId.substr(1);
            if (FR.isEmpty(parentId)) {
                parentId = -1;
            }
            folder.parentId = selectedNode.id.substr(1);
            folder.text = dirname;
            folder.description = description;
            folder.mobileDeviceConfig = mobileDeviceConfig;
            if (selectedNode.getParentNode() != null) {
                folder.parentDeviceConfig = selectedNode.getParentNode().parentMobileConfig;
            } else {
                var rootNode = FSRM.DIR.dirTabletree.getTreeObj().getNodes()[0];
                folder.parentDeviceConfig = rootNode.parentMobileConfig;
            }
            folder.mobileCoverId = FSRM._makeMobileCoverRandomId();
            var completeFn = function (res) {
                if (res.responseText == "-1") {
                    //没有权限
                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                    return;
                }
                var newnode = FR.jsonDecode(res.responseText);
                var node = {};
                node.id = newnode.id;
                node.name = dirname;
                node.pId = selectedNode.id;
                node.description = description;
                node.mobileDeviceConfig = mobileDeviceConfig;
                node.parentMobileConfig = selectedNode.mobileDeviceConfig;
                node.mobileCoverId = folder.mobileCoverId;
                node.open = true;
                self.dirTabletree.addSingleNode(selectedNode, node, selectedNode.open);
            };
            var config = {
                url: FR.servletURL,
                data: {
                    op: "fs_entry",
                    cmd: "addfolder",
                    folderJason: folder
                },
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        },

        _createTableTree: function (zTreedata) {
            var self = this;
            var dirMgrSetting = {
                view: {
                    showIcon: false  //不显示每个节点前的ICON
                },
                data: {
                    simpleData: {
                        enable: true,
                        idKey: "id",
                        pidKey: "pId",
                        rootPId: "0-2"
                    }
                },
                callback: {
                    onClick: this._showFiles
                }
            };
            //目录管理tabletree
            this.dirTabletree = new FS.TableTree({
                treeID: 'dirmgrTableTree',
                renderEl: $('.fs_reportmgr_dir_panel_content'),
                setting: dirMgrSetting,
                height: '100%',
                width: '100%',
                fit: true,
                alwaysShowTools: false,
                Nodes: zTreedata,
                itemHoverCls: 'fs_reportmgr_tabletree_item_hover',
                tools: [
                    {
                        iconCls: 'fs-module-edit-white',
                        hoverCls: 'fs-module-edit-white-over',
                        rootToolHide: true,
                        //编辑按钮事件
                        onToolClick: function (e) {
                            var title = FR.i18nText("FS-Report-Edit_Directory");
                            var onOK = self._editFolder;
                            var onCancel = function () {
                            };
                            var nodeID = $(this).data('nodeID'); //编辑dialog的初始数据
                            var preEditNode = self.dirTabletree.getNodeById(nodeID);
                            var parentNode = preEditNode.getParentNode();
                            self.dirTabletree.selectNode(preEditNode);
                            var data = {
                                parentMobileConfig: parentNode.mobileDeviceConfig & parentNode.parentMobileConfig
                            };
                            var editDirDialog = FS.REPORTMGR.createDirDialog(title, onOK, onCancel, data);
                            editDirDialog.setVisible(true);
                            editDirDialog.getWidgetByName("nameText").setValue(preEditNode.name);
                            editDirDialog.getWidgetByName("descriptionText").setValue(preEditNode.description);
                            editDirDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                                FSRM._makeMobileConfigCheckboxValue(preEditNode.mobileDeviceConfig & data.parentMobileConfig)
                            );
                            e.stopEvent();
                        }
                    },
                    {
                        rootToolHide: true,
                        iconCls: 'fs-module-delete-white',
                        hoverCls: 'fs-module-delete-white-over',
                        //删除按钮事件
                        onToolClick: function (e) {
                            var nodeID = $(this).data('nodeID');
                            var preDeleteNode = self.dirTabletree.getNodeById(nodeID);
                            self.dirTabletree.selectNode(preDeleteNode);
                            FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + '?', function (result) {
                                if (result) {
                                    //先向后台请求删除数据，请求成功再在web端删除
                                    var folderId = self.dirTabletree.getSelectedNodes()[0].id;

                                    var completeFn = function (result) {
                                        if (result == "-1") {
                                            //没有权限
                                            FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                                            return;
                                        }
                                        var selectedNode = self.dirTabletree.getSelectedNodes()[0];
                                        self.dirTabletree.removeSelectedNodes();
                                        var root = self.dirTabletree.getTreeObj().getNodes()[0];
                                        self.dirTabletree.selectNode(root);
                                        FS.REPORTMGR.tabPane.getWidgetByName("cptMgrPane").panelBody.children().hide();
                                    };
                                    var config = {
                                        url: FR.servletURL,
                                        type: 'POST',
                                        data: {
                                            op: "fs_entry",
                                            cmd: "removefolder",
                                            folderId: folderId
                                        }
                                    };
                                    FS.Async.ajax(config, completeFn);
                                }
                            });
                            e.stopEvent();
                        }
                    }
                ]
            });
            this.dirTabletree.sortable(this.sortDir);
        },

        sortDir: function (beforeDragNode, afterDragNode, beforeDragIndex, afterDragIndex) {

            var beforeDragID = beforeDragNode.id;
            var beforeIndex = beforeDragIndex;
            var afterIndex = afterDragIndex;

            FS.Async.ajax({
                url: FR.servletURL + "?op=fs_entry&cmd=modifyforfoldersort",
                type: 'POST',
                data: {sortid: beforeDragID, sortindex: afterDragIndex}
            });
        },

        //根据选中的node，在左侧目录展示报表
        _selectFolder: function (selectedNode) {
            while (selectedNode.pId.substr(1) !== "-1") {
                selectedNode = selectedNode.getParentNode();
            }
            var treeFolderItem = FS.navigationBar.getItemByFolderID(selectedNode.id);
            var reportTree = treeFolderItem._createTreeContent();
            treeFolderItem.bar.removeSelect();
            treeFolderItem.select();
        },

        initData: function () {
            var self = this;
            var completeFn = function (res, status) {
                if (status === 'success') {
                    var treedata = FR.jsonDecode(res.responseText);
                    var zTreedata = self._makeZTreeData(treedata);
                    self._createTableTree(zTreedata);
                    var root = self.dirTabletree.getTreeObj().getNodes()[0];
                    self.dirTabletree.selectNode(root);
                }
            };
            var config = {
                url: FR.servletURL + '?op=fs_entry&cmd=getfolder',
                type: 'POST'
            };
            FS.Async.ajax(config, completeFn);
        }
    },

    //目录管理面板内容初始化
    dirMgrInit: function () {
        this.DIR.initData();
    },

    //目录管理面板内容初始化
    cptMgrInit: function () {
        var catalogs = [FR.i18nText("FS-Generic-WF_Name"), FR.i18nText("FS-Report-Using_Templates"), FR.i18nText("FS-Report-Simple_Way"), FR.i18nText("FS-Report-Parameter_Binding")];
        var catalogWidths = [156, 161, 100, 80];
        var tName = 'report';
        var hyperLinkIndex = 1; //具有超链接的列号
        this.reportTable = this.createTable(catalogs, catalogWidths, tName, hyperLinkIndex).hide();

        catalogs = [FR.i18nText("FS-Generic-WF_Name"), FR.i18nText("FS-Report-Link_Address")];
        catalogWidths = [156, 340];
        tName = 'link';
        this.LinkTable = this.createTable(catalogs, catalogWidths, tName, hyperLinkIndex).hide();

        catalogs = [FR.i18nText("FS-Generic-WF_Name"), FR.i18nText("FS-Generic-Simple_Layout")];
        catalogWidths = [156, 340];
        tName = 'file';
        this.fileTable = this.createTable(catalogs, catalogWidths, tName, -1).hide();

        catalogs = [FR.i18nText("FS-Generic-WF_Name"), FR.i18nText("FS-Generic-Simple_Label")];
        catalogWidths = [156, 300];
        tName = 'rp';
        this.rpTable = this.createTable(catalogs, catalogWidths, tName, 1).hide();

        var children = [this.reportTable, this.LinkTable, this.fileTable, this.rpTable];
        var self = this;
        $.each(FS.Plugin.EntrySupporter, function (index, value) {
            var el = value.ui.apply(self, [hyperLinkIndex]);
            children.push(el);
        });
        return children;
    },
    //新建各个表，没有对应数据的隐藏起来
    createTable: function (catalogs, catalogWidths, tName, hyperLinkIndex) {
        var self = this;
        var tableCls = 'fs_reportmgr_table_' + tName;
        var catalogCls = 'fs_reportmgr_table_catalog';
        var contentCls = 'fs_reportmgr_table_content_' + tName;
        var foldCls = 'fs_reportmgr_fold_opts';
        var table = $('<div/>').addClass(tableCls);
        //菜单DIV
        var catalogDiv = $('<div/>').addClass(catalogCls);
        for (var i = 0; i < catalogs.length; i++) {
            $('<div/>').text(catalogs[i])
                .css({width: catalogWidths[i], 'float': 'left'})
                .appendTo(catalogDiv);
        }
        var fold = $('<div/>').addClass(foldCls)
            .attr('content', contentCls)
            .addClass(foldCls + '_unfold')
            .appendTo(catalogDiv);
        catalogDiv.appendTo(table);
        fold.click(function () {
            var content = $(this).attr('content');
            if ($(this).hasClass(foldCls + '_fold')) {
                //$('.' + content).css({display:'block'});
                $('.' + content).slideDown('fast');
                $(this).removeClass(foldCls + '_fold').addClass(foldCls + '_unfold');
            } else {
                //$('.' + content).css({display:'none'});
                $('.' + content).slideUp('fast');
                $(this).removeClass(foldCls + '_unfold').addClass(foldCls + '_fold');
            }
        });

        //内容
        var contentDiv = $('<div/>').addClass(contentCls);
        //数据载入
        contentDiv.appendTo(table);

        var popTableData = function (data, originaldata) {
            contentDiv.empty();
            if (data.length > 0) {
                table.show();
            } else {
                table.hide();
            }

            for (var i = 0; i < data.length; i++) {
                self.addTableData(tName, catalogWidths, hyperLinkIndex, data[i], originaldata[i]);
            }
            self.makeTableSortable(contentDiv, contentCls, tName);
        };

        $.extend(table, {
            popTableData: popTableData
        });

        this.makeTableSortable(contentDiv, contentCls, tName);
        return table;
    },

    makeTableSortable: function (table, contentCls, tName) {
        var self = this;
        var beforeDrag = 0;
        var afterDrag = 0;
        var beforeDragID;
        var itemcls = "div.fs_reportmgr_table_content_line";
        table.sortable({
            nested: false,
            handler: itemcls,
            delay: 200,
            itemSelector: itemcls,
            placeholder: '<div style="height: 25px"/>',
            containerSelector: contentCls,
            onDrag: function ($item, position, _super, event) {
                position.left = 0;
                _super($item, position);
                beforeDrag = $(itemcls, table).index($item[0]);
                beforeDragID = $item.attr(tName + 'id');
            },
            onDrop: function ($item, container, _super, event) {
                afterDrag = $(itemcls, table).index($item[0]);
                if ((beforeDrag != afterDrag) && (beforeDrag >= 0) && (afterDrag >= 0)) {
                    //wei : 拖拽后同时刷新op=fs左侧展示的报表。
                    var completeFn = function () {
                        //更新下cache里的顺序
                        var selectedNode = FS.REPORTMGR.DIR.dirTabletree.getSelectedNodes()[0];
                    };
                    var config = {
                        url: FR.servletURL + "?op=fs_entry&cmd=modifyforsort",
                        type: 'POST',
                        data: {sortid: beforeDragID, sortindex: afterDrag}
                    };
                    FS.Async.ajax(config, completeFn);
                }
                _super($item);
            }
        });
    },

    //向表中添加一行数据,如果插入数据与之前具有相同id则修改之前那条数据
    addTableData: function (tName, catalogWidths, hyperLinkIndex, data, originaldata) {
        var self = this;
        var tableCls = 'fs_reportmgr_table_' + tName;
        var contentCls = 'fs_reportmgr_table_content_' + tName;
        var lineCls = 'fs_reportmgr_table_content_line';
        var contentDiv = $('.' + contentCls);
        var lineDiv = $('<div/>').addClass(lineCls).data('tCls', tableCls);
        var j = 0;
        for (var len = catalogWidths.length; j < len; j++) {
            var $oneDataDiv = $('<div/>').css({
                width: catalogWidths[j],
                'float': 'left'
            }).appendTo(lineDiv);
            //添加超链接
            if (hyperLinkIndex === j) {
                this.addHyperLink(tName, data[j], $oneDataDiv);
            } else {
                $oneDataDiv.text(FS.getShowText(data[j], 132, 12, 'SimSun')).attr('title', data[j]);
            }
        }
        //根据ID判断是否已经插入过该条数据，如果已存在，则为编辑事件
        var id = data[j];
        if (id) {
            var $find = $('.' + lineCls + '[' + tName + 'id=' + id + ']');
            if ($find && $find.length > 0) {
                $find.after(lineDiv);
                $find.remove();
            } else {
                lineDiv.appendTo(contentDiv);
            }
            lineDiv.attr(tName + 'id', id);
        }
        //编辑按钮和删除按钮
        var deleteDiv = $('<div/>').addClass('fs-module-delete-white')
            .attr('title', FR.i18nText("FS-Generic-Simple_Remove")).css({'display': 'none', float: 'right'})
            .hover(function () {
                $(this).addClass('fs-module-delete-white-hover');
            }, function () {
                $(this).removeClass('fs-module-delete-white-hover');
            }).click(function () {
                //删除按钮的点击事件
                var preDeleteDiv = $(this);
                FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + '?', function (result) {
                    if (result) {
                        var entryid = preDeleteDiv.parent().attr(tName + 'id');
                        var completeFn = function (res, status) {
                            if (status === 'success') {
                                if (res.responseText == "-1") {
                                    //没有权限
                                    FR.Msg.alert(FR.i18nText("FS-Generic-Simple_Alert"), FR.i18nText("FS-Report-No_Folder_Edit_Privilege"));
                                    return;
                                }
                                //DOM上的删除操作
                                var $table = $('.' + preDeleteDiv.parent().data('tCls'));
                                preDeleteDiv.parent().remove();
                                if ($table.find('.' + contentCls).children().length <= 0) {
                                    $table.hide();
                                }
                            }
                        };
                        var config = {
                            url: FR.servletURL + "?op=fs_entry&cmd=removereport",
                            type: 'POST',
                            data: {entryIds: entryid}
                        };
                        FS.Async.ajax(config, completeFn);
                    }
                });
            });
        var editDiv = $('<div/>').addClass('fs-module-edit-white')
            .attr('title', FR.i18nText("FS-Generic-Simple_Edit")).css({'display': 'none', float: 'right'})
            .data('tName', tName)
            .hover(function () {
                $(this).addClass('fs-module-edit-white-hover');
            }, function () {
                $(this).removeClass('fs-module-edit-white-hover');
            }).click(function () {
                //编辑按钮的点击事件
                var type = $(this).data('tName');
                if (type === 'link') {
                    //链接编辑事件
                    var title = FR.i18nText("FS-Report-Edit_Link");
                    var data = FR.clone(originaldata);
                    data.parentMobileConfig = self.DIR.getParentMobileConfig();
                    var onOK = function () {
                        return self.DIR._addOrEditLink(data.id.substr(1), data.sortindex, false, data.mobileCoverId);
                    };
                    var onCancel = function () {
                    };
                    self.linkDialog = self.createLinkDialog(title, onOK, onCancel, data);
                    self.linkDialog.setVisible(true);
                    self.linkDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                        FSRM._makeMobileConfigCheckboxValue(data.parentMobileConfig & data.mobileDeviceConfig)
                    );
                } else if (type === 'report') {
                    //模板编辑事件
                    var title = FR.i18nText("FS-Report-Edit_Cpt");
                    var data = FR.clone(originaldata);
                    data.parentMobileConfig = self.DIR.getParentMobileConfig();
                    var onOK = function () {
                        return self.DIR._addOrEditCpt(data.id.substr(1), data.sortindex, false, data.mobileCoverId);
                    };
                    var onCancel = function () {
                    };
                    self.cptDialog = self.createCptDialog(title, onOK, onCancel, data);
                    self.cptDialog.setVisible(true);
                    self.cptDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                        FSRM._makeMobileConfigCheckboxValue(data.parentMobileConfig & data.mobileDeviceConfig)
                    );
                } else if (type === 'file') {
                    var title = FR.i18nText("FS-Report-Edit_File");
                    var data = FR.clone(originaldata);
                    var onOK = function () {
                        return self.DIR._editFile(data.id.substr(1), data.sortindex);
                    };
                    var onCancel = function () {

                    };
                    self.fileDialog = self.createFileDialog(title, onOK, onCancel, data);
                    self.fileDialog.setVisible(true);
                } else if (type === 'rp') {
                    var title = FR.i18nText("FS-Report-RP_EditLabel");
                    var data = FR.clone(originaldata);
                    var onOK = function () {
                        return self.DIR._addOrEditRP(data.id.substr(1), data.sortindex);
                    };
                    var onCancel = function () {

                    };
                    self.rpDialog = self.createRPDialog(title, onOK, onCancel, data);
                    self.rpDialog.setVisible(true);
                } else {
                    var editors = FS.Plugin.DirectoryContentEditor;
                    for (var i = 0, len = editors.length; i < len; i++) {
                        var editor = editors[i];
                        if (editor.acceptTypeByString(type)) {
                            editor.action.apply(self, [originaldata]);
                        }
                    }
                }
            });
        lineDiv.hover(function () {
            $(this).addClass('fs_reportmgr_table_content_line_hover');
            editDiv.show();
            deleteDiv.show();
        }, function () {
            $(this).removeClass('fs_reportmgr_table_content_line_hover');
            editDiv.hide();
            deleteDiv.hide();
        });
        deleteDiv.appendTo(lineDiv);
        editDiv.appendTo(lineDiv);
    },
    //添加超链接
    addHyperLink: function (tName, data, obj) {
        var $oneDataDiv = obj;
        var url = '#';
        //模板链接
        if (tName === 'report') {
            var report = data;
            var ps = report.path.split("/");
            var reportName = ps[ps.length - 1];
            var parameters = {}, tps = report.transmitParameters;
            //模板类型，好像只有这个属性能用来判断是.cpt还是.frm。老版本这里没考虑。
            if (report.nodeicon === 'cpt') {
                $.extend(parameters, {reportlet: report.path});
            } else if (report.nodeicon === 'frm') {
                $.extend(parameters, {formlet: report.path});
            }
            //预览方式op
            if (report.showType === '0') {
                $.extend(parameters, {op: 'write'});
            } else if (report.showType === '1') {
                parameters.op = 'view';
            }
            //url参数
            for (var index = 0, len = tps ? tps.length : 0; index < len; index++) {
                parameters[tps[index].name] = tps[index].value;
            }
            url = FR.buildServletUrl(parameters);
            $('<a target="_blank" href=' + url + '/>')
                .text(FS.getShowText(reportName, 140, 12, 'SimSun'))
                .attr('title', reportName)
                .appendTo($oneDataDiv);
        }
        //地址链接
        else if (tName === 'link') {
            var address = data;
            //地址解析
            if (address.match(/[a-zA-Z]+:\/\/[^\s]*/)) {
                url = address;
            } else {
                url = FR.server + '/' + address;
            }
            $('<a target="_blank" href=' + encodeURI(url) + '/>')
                .text(FS.getShowText(address, 320, 12, 'SimSun'))
                .attr('title', address)
                .appendTo($oneDataDiv);
        }
        //数据上报(暂不做超链接)
        else if (tName === 'rp') {
            var tdname = FS.REPORTMGR.CONSTS.PROCESSTYPE[data];
            $('<a/>').text(FS.getShowText(tdname, 280, 12, 'SimSun'))
                .attr('title', tdname)
                .appendTo($oneDataDiv);
        } else {
            var editors = FS.Plugin.DirectoryContentEditor;
            for (var i = 0, len = editors.length; i < len; i++) {
                var editor = editors[i];
                if (editor.acceptTypeByString(tName)) {
                    editor.hyperlink.apply(this, [$oneDataDiv, data]);
                }
            }
        }
    },

    _getMobileCheckBoxWidth: function() {
        return Math.max(200, 3 * (42 + Math.max(FR.i18nTextWidth("FS-Report-Devices_PC"),
                Math.max(FR.i18nTextWidth("FS-Report-Devices_Tablet"),
                    FR.i18nTextWidth("FS-Report-Devices_Phone")))));
    },

    _createMobileCheckBoxItems: function (parentConfig) {
        var items = [
            {value: "1", text: FR.i18nText("FS-Report-Devices_PC")},
            {value: "2", text: FR.i18nText("FS-Report-Devices_Tablet")},
            {value: "4", text: FR.i18nText("FS-Report-Devices_Phone")}
        ];
        if (parentConfig === null) {
            return;
        }
        var config = FSRM._makeMobileConfigCheckboxValue(parentConfig).split(',');
        $.each(items, function (idx, item) {
            if (config.indexOf(item.value) < 0) {
                item.disabled = true;
            }
        });
        return items;
    },
    //目录dialog
    createDirDialog: function (title, okCallback, cancelCallback, data) {
        var self = this;
        var hGap = 10;//标签和文本框之间的间隙
        var labelWidth = parseInt(FR.i18nText("FS-Report-Create_Dir_Dialog_Label_width") || 58);

        var dirDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
            onOK: function () {
                okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            animate: false,
            width: self._getMobileCheckBoxWidth() + 100,
            height: 251,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-WF_Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 130,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 16
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Simple_Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'textarea',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        x: hGap + labelWidth,
                        y: 47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Report-Simple_Device"),
                        textalign: 'right',
                        widgetName: 'reportDevice',
                        height: 21,
                        width: labelWidth,
                        x: 0,
                        y: 142
                    },
                    {
                        type: 'fscheckboxgroup',
                        columnsInRow: 3,
                        items: self._createMobileCheckBoxItems(data.parentMobileConfig),
                        height: 21,
                        width: self._getMobileCheckBoxWidth(),
                        value: "1,2,4",
                        widgetName: 'deviceCheckboxGroup',
                        x: hGap + labelWidth - 5,
                        y: 141
                    }
                ]
            }
        });
        return dirDialog;
    },
    //链接dialog
    createLinkDialog: function (title, okCallback, cancelCallback, data) {
        var self = this;
        var hGap = 10, labelWidth = parseInt(FR.i18nText("FS-Report-Add_Template_Width") || 58);
        var linkDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            animate: false,
            width: self._getMobileCheckBoxWidth() + 100,
            height: 291,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Report-Link_Path"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'pathText',
                        x: hGap + labelWidth,
                        y: 16
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-WF_Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Simple_Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 78
                    },
                    {
                        type: 'textarea',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        x: hGap + labelWidth,
                        y: 78
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Report-Simple_Device"),
                        textalign: 'right',
                        widgetName: 'reportDevice',
                        height: 21,
                        width: labelWidth,
                        x: 0,
                        y: 173
                    },
                    {
                        type: 'fscheckboxgroup',
                        columnsInRow: 3,
                        items: self._createMobileCheckBoxItems(data.parentMobileConfig),
                        height: 21,
                        width: self._getMobileCheckBoxWidth(),
                        value: "1,2,4",
                        widgetName: 'deviceCheckboxGroup',
                        x: hGap + labelWidth - 5,
                        y: 172
                    }
                ]
            }
        });
        if (data.url) {
            linkDialog.getWidgetByName("pathText").setValue(data.url);
            linkDialog.getWidgetByName("nameText").setValue(data.text);
            linkDialog.getWidgetByName("descriptionText").setValue(data.description);
            linkDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                FSRM._makeMobileConfigCheckboxValue(data.mobileDeviceConfig)
            );
        }
        return linkDialog;
    },

    //文件dialog
    createFileDialog: function (title, okCallback, cancelCallback, data) {
        var self = this;
        var fileDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 320,
            height: 300,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Report-File_Name"),
                        height: 21,
                        width: FR.i18nTextWidth("FS-Report-File_Name", 6.5) + 6,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 185,
                        widgetName: 'nameText',
                        x: Math.max(68, FR.i18nTextWidth("FS-Generic-Simple_Layout", 6.5) + 16),
                        y: 16
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Simple_Description"),
                        height: 21,
                        width: 58,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'textarea',
                        height: 85,
                        width: 185,
                        widgetName: 'descriptionText',
                        x: Math.max(68, FR.i18nTextWidth("FS-Generic-Simple_Layout", 6.5) + 16),
                        y: 47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Simple_Layout"),
                        height: 21,
                        width: Math.max(58, FR.i18nTextWidth("FS-Generic-Simple_Layout", 6.5) + 6),
                        textalign: 'right',
                        x: 0,
                        y: 141
                    },
                    {
                        type: 'textarea',
                        height: 85,
                        width: 185,
                        widgetName: 'fileposition',
                        x: Math.max(68, FR.i18nTextWidth("FS-Generic-Simple_Layout", 6.5) + 16),
                        disabled: true,
                        y: 141
                    }
                ]
            }
        });
        if (data) {
            fileDialog.getWidgetByName("nameText").setValue(data.text);
            fileDialog.getWidgetByName("fileposition").setValue(data.path);
            fileDialog.getWidgetByName("descriptionText").setValue(data.description);
        }
        return fileDialog;
    },

    //模板dialog
    createCptDialog: function (title, okCallback, cancelCallback, data) {
        var self = this;
        var hGap = 10, labelWidth = parseInt(FR.i18nText("FS-Report-Add_Template_Width") || 58);
        var cptDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 500,
            height: 400,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: 'absolute',
                widgetName: 'cptAbsolute',
                scrollable: true,
                items: [
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Report-Simple_Path"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 16
                    },
                    {
                        width: 280,
                        height: 21,
                        widgetUrl: FR.servletURL + "?op=fs_entry&cmd=get_user_reports&form=true&file=cpt,frm&serverID=" + FS.serverID,
                        type: 'treecombobox',
                        returnFullPath: true,
                        x: hGap + labelWidth,
                        widgetName: 'pathCombo',
                        selectLeafOnly: true,
                        y: 16,
                        listeners: [{
                            eventName: 'afteredit',
                            action: function () {
                                var path = this.getValue();
                                var reportName = path[path.length - 1];
                                if (reportName) {
                                    //Sean: 若是表单，则只能选择预览一种类型
                                    if (reportName.endWith('.frm')) {
                                        cptDialog.getWidgetByName("typeRadioGroup").setValue('2');
                                        cptDialog.getWidgetByName("typeRadioGroup").setEnable(false);
                                        cptDialog.getWidgetByName("reportType").setEnable(false);
                                    } else {
                                        cptDialog.getWidgetByName("typeRadioGroup").setEnable(true);
                                        cptDialog.getWidgetByName("reportType").setEnable(true);
                                    }
                                    //截去文件扩展名
                                    cptDialog.getWidgetByName("nameText").setValue(
                                        reportName.substr(0, reportName.length - 4));
                                    cptDialog.getWidgetByName("paraSetGrid").reportletPath = path.join('/');
                                }

                            }
                        }]
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-WF_Name"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 47
                    },
                    {
                        type: 'text',
                        height: 21,
                        width: 280,
                        widgetName: 'nameText',
                        x: hGap + labelWidth,
                        y: 47
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Simple_Description"),
                        height: 21,
                        width: labelWidth,
                        textalign: 'right',
                        x: 0,
                        y: 78
                    },
                    {
                        type: 'textarea',
                        height: 85,
                        width: 280,
                        widgetName: 'descriptionText',
                        x: hGap + labelWidth,
                        y: 78
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Report_Type"),
                        textalign: 'right',
                        widgetName: 'reportType',
                        height: 21,
                        width: labelWidth,
                        x: 0,
                        y: 173
                    },
                    {
                        type: 'radiogroup',
                        assureSelect: true,
                        columnsInRow: 3,
                        items: [
                            {value: '0', text: FR.i18nText("FS-Generic-Face_Write")},
                            {value: '1', text: FR.i18nText("FS-Report-Simple_Analysis")},
                            {value: '2', text: FR.i18nText("FS-Generic-Simple_Preview")}
                        ],
                        height: 21,
                        width: 200,
                        value: '2',
                        widgetName: 'typeRadioGroup',
                        x: hGap + labelWidth,
                        y: 173
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Report-Simple_Device"),
                        textalign: 'right',
                        widgetName: 'reportDevice',
                        height: 21,
                        width: labelWidth,
                        x: 0,
                        y: 204
                    },
                    {
                        type: 'fscheckboxgroup',
                        columnsInRow: 3,
                        items: self._createMobileCheckBoxItems(data.parentMobileConfig),
                        height: 21,
                        width: 200,
                        value: "1,2,4",
                        widgetName: 'deviceCheckboxGroup',
                        x: hGap + labelWidth - 5,
                        y: 203
                    },
                    {
                        type: 'llabel',
                        value: FR.i18nText("FS-Generic-Parameter_Setting"),
                        textalign: 'right',
                        height: 30,
                        width: labelWidth,
                        x: 0,
                        y: 235
                    },
                    {
                        type: "parametergrid",
                        widgetName: "paraSetGrid",
                        width: 385,
                        x: hGap + labelWidth,
                        y: 235
                    }
                ]
            }
        });
        this.reportTreeDiv = $('<div/>').addClass('fs_reportmgr_treewrap').appendTo(cptDialog.win.$contentPane).hide();
        cptDialog.getWidgetByName('cptAbsolute').doLayout();
        //编辑目录时有初始数据
        if (data.path) {
            cptDialog.getWidgetByName("pathCombo").setValue(data.path);
            cptDialog.getWidgetByName("nameText").setValue(data.text);
            cptDialog.getWidgetByName("descriptionText").setValue(data.description);
            cptDialog.getWidgetByName("typeRadioGroup").setValue(data.showType);
            cptDialog.getWidgetByName("deviceCheckboxGroup").setValue(
                FSRM._makeMobileConfigCheckboxValue(data.mobileDeviceConfig)
            );
            cptDialog.getWidgetByName("paraSetGrid").popData(data.transmitParameters);
        }
        // 调整部分组件的宽度
        this.fixBtnGroupWidth(cptDialog.getWidgetByName("typeRadioGroup"));
        this.fixBtnGroupWidth(cptDialog.getWidgetByName("deviceCheckboxGroup"));
        return cptDialog;
    },

    // 根据字符个数调整按钮组的宽度
    fixBtnGroupWidth: function(widget) {
        var maxWidth = 0;
        var buttonNumber = widget.buttonArray.length;
        for (var i = 0; i < buttonNumber; i++) {
            var buttonTextLength = FR.byteLength(widget.buttonArray[i].element[0].innerText);
            if (buttonTextLength > maxWidth) {
                maxWidth = buttonTextLength;
            }
        }
        widget.element.css("width", (maxWidth * 6 + 34) * buttonNumber + "px");
        // 设置内层 span 的宽度
        for (var i = 0; i < buttonNumber; i++) {
            $(widget.element[0].children[i]).css("left", (maxWidth * 6 + 34) * i + "px");
            $(widget.element[0].children[i]).css("width", (maxWidth * 6 + 34) + "px");
        }
    },

    //数据上报Dialog
    createRPDialog: function (title, okCallback, cancelCallback, data) {
        var rpDialog = new FR.Dialog({
            title: title,
            text4OK: FR.i18nText("FS-Generic-Simple_OK"),
            text4Cancel: FR.i18nText("FS-Generic-Simple_Cancel"),
            onOK: function () {
                return okCallback.apply(this);
            },
            onCancel: function () {
                cancelCallback.apply(this);
            },
            destroyOnClose: true,
            width: 400,
            height: 300,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: {
                type: "tablelayout",
                widgetName: "RPTABLE",
                columnSize: [60, 10, 250],
                rowSize: [10, 21, 21, 85],
                vgap: 10,
                items: [
                    [
                        {el: $('<div/>')}
                    ],
                    [
                        {el: {type: "llabel", value: FR.i18nText("FS-Generic-Simple_Label"), textalign: "right"}},
                        {el: $('<div/>')},
                        {
                            el: {
                                type: "combo", widgetName: "LABELCOMBO", directEdit: false, items: [
                                    {text: FS.REPORTMGR.CONSTS.PROCESSTYPE[1], value: 1},
                                    {text: FS.REPORTMGR.CONSTS.PROCESSTYPE[2], value: 2},
                                    {text: FS.REPORTMGR.CONSTS.PROCESSTYPE[3], value: 3}
                                ], listeners: [{
                                    eventName: FR.Events.AFTEREDIT,
                                    action: function () {
                                        var label = this.getText();
                                        rpDialog.getWidgetByName('RPNAME').setValue(label);
                                    }
                                }], width: 185
                            }
                        }
                    ],
                    [
                        {el: {type: "llabel", value: FR.i18nText("FS-Generic-WF_Name"), textalign: "right"}},
                        {el: $('<div/>')},
                        {el: {type: "text", widgetName: "RPNAME", width: 185}}
                    ],
                    [
                        {
                            el: {
                                type: "vertical", hgap: 0, vgap: 0, items: [
                                    {
                                        el: {
                                            type: 'llabel',
                                            value: FR.i18nText("FS-Generic-Simple_Description"),
                                            textalign: "right"
                                        }, height: 21
                                    }
                                ]
                            }
                        },
                        {el: $('<div/>')},
                        {el: {type: 'textarea', widgetName: "RPDESCRIPTION"}}
                    ]
                ]
            }
        });
        rpDialog.getWidgetByName('RPTABLE').doLayout();
        //编辑目录时有初始数据
        if (data) {
            rpDialog.getWidgetByName("LABELCOMBO").setValue(data.processType);
            rpDialog.getWidgetByName("RPNAME").setValue(data.text);
            rpDialog.getWidgetByName("RPDESCRIPTION").setValue(data.description);
        }
        return rpDialog;
    },

    _makeMobileDeviceConfig: function (checkBoxConfig) {
        var cfgs = checkBoxConfig.split(',');
        var config = 0;
        $.each(cfgs, function (idx, cfg) {
            config += parseInt(cfg);
        });
        return config;
    },

    _makeMobileConfigCheckboxValue: function (config) {
        var cfgs = config.toString(2).split("");
        var checkBoxConfig = [];
        $.each(cfgs.reverse(), function (idx, cfg) {
            if (cfg == "1") {
                checkBoxConfig.push(1 << idx);
            }
        });
        return checkBoxConfig.join(",")
    },

    /**
     * 生成内置随机报表封面ID
     * @private
     */
    _makeMobileCoverRandomId: function () {
        //ID: a-z
        return String.fromCharCode(Math.floor(Math.random() * 26) + "a".charCodeAt(0));
    },

    Control: {

        /**
         * 初始化数据
         */
        initData: function () {
            //目录信息
            this.folderData = null;
            //目录子节点缓存
            this.folderEntries = [];
        },

        /**
         * 获取目录信息
         */
        getFolderData: function () {
            var self = this;
            self.folderData = FS.Sync.ajax({
                url: FR.servletURL + '?op=fs_entry&cmd=getfolder',
                type: 'POST'
            });
        },

        /**
         * 缓存图片封面设置
         * @param entry   封面设置项
         * @param coverId 封面图片ID
         * @param isDir   是否为目录
         */
        setEntryCoverId: function (entry, coverId, isDir) {
            var self = this;
            if (!self.coverData) {
                self.initEntryCoverId();
            }
            if (coverId == entry.mobileCoverId) {
                return;
            }
            if (entry.mobileCoverId) {
                if (entry.mobileCoverId.length > 1) {
                    self.coverData.del.push(entry.mobileCoverId);
                }
            }
            entry.mobileCoverId = coverId;
            if (isDir) {
                self.coverData.folder[entry.id] = coverId;
            } else if (entry.nodeicon == "cpt" || entry.nodeicon == "frm") {
                self.coverData.report[entry.id] = coverId;
            } else if (entry.nodeicon == "url") {
                self.coverData.link[entry.id] = coverId;
            } else if (entry.type == FSRM.CONSTS.REPORTPROCESS) {//reportprocess
                self.coverData.processType[entry.id] = coverId;
            } else {
                $.each(FS.Plugin.EntrySupporter, function (index, value) {
                    if (value.acceptTypeByNumber(entry.type)) {
                        var config = value.fillCoverData();
                        if (!self.coverData[config.name]) {
                            self.coverData[config.name] = {};
                        }
                        self.coverData[config.name][entry.id] = coverId;
                    }
                });
            }
        },

        initEntryCoverId: function () {
            this.coverData = {
                //目录封面变更
                folder: {},
                //报表及表单封面变更
                report: {},
                //链接封面变更
                link: {},
                //处理类型封面变更
                processType: {},
                //变更后需要删除的自定义图片
                del: []
            };
        }
    }
};
